package jp.osoite.tomu.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.xml.bind.JAXBException;
import jp.osoite.tomu.jaxb.object.TomuMessage;
import jp.osoite.tomu.jaxb.util.TomuMessagePrinter;
import jp.osoite.tomu.jaxb.util.TomuMessageType;
import jp.osoite.tomu.request.DefaultQueryPublisher;
import jp.osoite.tomu.xmpp.core.MessageReceiver;

public final class PublisherTest {

    public static void main(String[] args) throws IOException, JAXBException {
        System.out.println("---DefaultQueryPublisher Test---");
        DefaultQueryPublisher publisher = new DefaultQueryPublisher();
        publisher.start(new MessageReceiver() {

            @Override
            public void receive(TomuMessage tomuMsg) {
                if (tomuMsg.getType().equals(TomuMessageType.RESPONSE)) {
                    TomuMessagePrinter.print(tomuMsg, true);
                }
            }
        });
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        String line;
        while ((line = reader.readLine()) != null) {
            if (line.equals("STOP")) {
                break;
            }
            publisher.sendQuery();
            System.out.println(">> send Query to " + publisher.getTomuAccount());
        }
        reader.close();
    }
}
