package jp.osoite.tomu.request;

import java.io.File;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import jp.osoite.tomu.jaxb.object.Head;
import jp.osoite.tomu.jaxb.object.Query;
import jp.osoite.tomu.jaxb.object.Request;
import jp.osoite.tomu.jaxb.object.TomuMessage;
import jp.osoite.tomu.jaxb.util.HeadBuilder;
import jp.osoite.tomu.jaxb.util.JAXBConverter;
import jp.osoite.tomu.jaxb.util.RequestBuilder;
import jp.osoite.tomu.jaxb.util.TomuMessagePrinter;
import jp.osoite.tomu.jaxb.util.TomuMessageType;
import jp.osoite.tomu.upload.jaxb.config.XmppSetting;
import jp.osoite.tomu.xmpp.core.MessageReceiver;
import jp.osoite.tomu.xmpp.core.XMPPManager;
import jp.osoite.tomu.xmpp.core.XMPPSetting;

/**
 *
 * @author shima
 */
public final class DefaultQueryPublisher {

    private XMPPSetting setting;
    private String connetingAccount;
    private XMPPManager xmppManager;
    private List<Query> queryList;
    private volatile long seqNumber;
    private volatile boolean isRunning;

    public DefaultQueryPublisher() throws JAXBException {
        seqNumber = 0;
        initialSetting();
    }

    private void initialSetting() throws JAXBException {
        JAXBContext jaxbc = JAXBContext.newInstance("jp.osoite.tomu.upload.jaxb.config");
        Unmarshaller unmConf = jaxbc.createUnmarshaller();
        XmppSetting xmppSetting = (XmppSetting) unmConf.unmarshal(new File("./configs/PublisherXMPPSetting.xml"));
        connetingAccount = xmppSetting.getConnection();
        setting = new XMPPSetting(xmppSetting.getAccount(),
                xmppSetting.getPass(),
                xmppSetting.getHost(),
                xmppSetting.getPort().intValue(),
                xmppSetting.getService());
        Request prepReq = new PreparedRequest(new File("./configs/PreparedQuery.xml")).getRequest();
        queryList = prepReq.getQuery();
    }

    public String getTomuAccount() {
        return connetingAccount;
    }

    public void start(MessageReceiver recv) {
        if (!isRunning) {
            isRunning = true;
            xmppManager = new XMPPManager(setting);
            xmppManager.login();
            xmppManager.addAccount(connetingAccount);
            xmppManager.addMessageReceiver(recv);
        }
    }

    public void stop() {
        if (isRunning) {
            isRunning = false;
            xmppManager.logoff();
        }
    }

    public void addQuery(Query q){
        queryList.add(q);
    }

    public void sendQuery() throws JAXBException {
        Head head = HeadBuilder.build(
                System.currentTimeMillis(),
                seqNumber++, connetingAccount, setting.getAccount());
        RequestBuilder builder = new RequestBuilder(head);
        for (Query q : queryList) {
            builder.addQuery(q);
        }
        xmppManager.send(connetingAccount, JAXBConverter.convertToXml(builder.getTomuMessage()));
    }
}
