package jp.osoite.tomu.main;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Locale;
import jp.osoite.tomu.jaxb.object.TomuMessage;
import jp.osoite.tomu.jaxb.util.TomuMessagePrinter;
import jp.osoite.tomu.xmpp.core.MessageReceiver;
import jp.osoite.tomu.xmpp.core.XMPPManager;
import jp.osoite.tomu.xmpp.core.XMPPSetting;

/**
 *
 * @author shima
 */
public class TomuCommandPrompt {

    private XMPPManager manager;
    private static final boolean FULL_PRINT = false;
    private volatile boolean isRunning;
    private static final String HELP = "help";
    private static final String WHOAMI = "whoami";
    private static final String USERS = "users";
    private static final String PING = "ping";
    private static final String LOGIN = "login";
    private static final String LOGOFF = "logoff";
    private static final String EXIT = "exit";

    public TomuCommandPrompt(XMPPManager xmppmanager) {
        this.manager = xmppmanager;
        manager.addMessageReceiver(new MessageReceiver() {

            @Override
            public void receive(String message) {
                if (message.contains("[Ping]")) {
                    System.out.println(message);
                    String account = message.substring(message.indexOf("#") + 1);
                    manager.send(account, " * Hello, " + manager.getSetting().getAccount() + " received your ping message.");
                }
            }

            @Override
            public void receive(TomuMessage tomuMsg) {
                TomuMessagePrinter.print(tomuMsg, FULL_PRINT);
            }
        });
    }

    public void start() {
        if (!isRunning) {
            new Thread() {

                @Override
                public void run() {
                    isRunning = true;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
                    System.out.println("=== Welcome to Tomu Command Prompt ! ===");
                    System.out.println("* help: show commands reference");
                    while (isRunning) {
                        try {
                            System.out.println(">>> Ready to input");
                            swichCommand(reader.readLine());
                        } catch (IOException e) {
                        }
                    }
                }
            }.start();
        }
    }

    private void swichCommand(String cmd) {
        if (isRunning) {
            int colonIndex = cmd.indexOf(":");
            String operator = "";
            String operand = "";
            if (colonIndex > 0) {
                operator = cmd.substring(0, colonIndex).trim().toLowerCase(Locale.ENGLISH);
                if (colonIndex + 1 < cmd.length()) {
                    operand = cmd.substring(colonIndex + 1, cmd.length());
                }
                if (operator.equals(HELP)) {
                    printHelp();
                } else if (operator.equals(WHOAMI)) {
                    printStatus();
                } else if (operator.equals(USERS)) {
                    printUsers();
                } else if (operator.equals(PING)) {
                    sendPing();
                } else if (operator.equals(LOGIN)) {
                    login(operand);
                } else if (operator.equals(LOGOFF)) {
                    logoff();
                } else if (operator.equals(EXIT)) {
                    logoff();
                    System.exit(-1);
                }
            }
        } else {
            System.out.println("is not running. please do run().");
        }
    }

    private void printHelp() {
        System.out.println(" * << Command Refference >>");
        System.out.println(" * help: show commands reference");
        System.out.println(" * whoami: show my XMPP account");
        System.out.println(" * users: show users list");
        System.out.println(" * ping: send ping");
        System.out.println(" * login:[account]#[pass] login via [account]");
        System.out.println(" * login:1(～4) TomuCore debug account login");
        System.out.println(" * logoff: logoff this XMPP session");
        System.out.println(" * exit: shutdown TomuCore system");
    }

    private void printStatus() {
        System.out.println(" * << " + manager.getSetting().getAccount() + " >>");
    }

    private void printUsers() {
        List<String> users = manager.getUserList();
        System.out.println(" * << User List >>");
        System.out.println(" * Num of Entry : " + users.size());
        int seq = 1;
        for (String user : users) {
            System.out.println(" * " + (seq++) + ": " + user + "  Available:" + manager.checkOnline(user));
        }
    }

    private void sendPing() {
        manager.sendToAll(" * [Ping] This is a ping message from #" + manager.getSetting().getAccount());
    }

    private void login(String operand) {
        if (operand.length() == 1) {
            try {
                int num = Integer.parseInt(operand);
                if (1 <= num && num <= 4) {
                    XMPPSetting newSetting = new XMPPSetting("tomuxmpp" + num + "@gmail.com", "osoiteTomu");
                    isRunning = manager.relogin(newSetting);
                }
            } catch (Exception e) {
                System.out.println(" * Worng operand : " + operand);
            }
        } else if (operand.contains("#")) {
            String account = operand.substring(0, operand.indexOf("#"));
            String pass = operand.substring(operand.indexOf("#") + 1, operand.length());
            manager.logoff();
            XMPPSetting newSetting = new XMPPSetting(account, pass);
            isRunning = manager.relogin(newSetting);
        } else {
            System.out.println(" * Worng operand : " + operand);
        }
        if (isRunning) {
            printStatus();
        }
    }

    private void logoff() {
        System.out.println("--- See ya ---");
        manager.logoff();
    }
}
