package jp.osoite.tomu.jaxb.util;

import java.util.List;
import jp.osoite.tomu.jaxb.object.Head;
import jp.osoite.tomu.jaxb.object.Query;
import jp.osoite.tomu.jaxb.object.Result;
import jp.osoite.tomu.jaxb.object.SensorData;
import jp.osoite.tomu.jaxb.object.TomuMessage;
import jp.osoite.tomu.jaxb.object.Value;
import jp.osoite.tomu.util.TimeConverter;

/**
 * 
 * @author shima
 */
public final class TomuMessagePrinter {

    private static long SEQ = 0;

    private TomuMessagePrinter() {
    }

    public static synchronized void print(TomuMessage mes, boolean all) {
        System.out.println("=========(Print: " + (++SEQ) + ")=========");
        printHead(mes.getHead());
        System.out.println("MessageType : " + mes.getType());
        if (all) {
            System.out.println("= = = = = = = = = = = = = =");
            String type = mes.getType();
            if (type.equals(TomuMessageType.REQUEST.toString())) {
                printRequest(mes.getRequest().getQuery());
            } else if (type.equals(TomuMessageType.RESPONSE.toString())) {
                printResponse(mes.getResponse().getResult());
            } else if (type.equals(TomuMessageType.SOURCE_UPLOAD.toString())) {
                printSourceUpload(mes.getUpload().getSensorData());
            }
        }
    }

    private static void printHead(Head head) {
        System.out.println("MsgID : " + head.getMsgId());
        System.out.println("MsgSeq : " + head.getMsgSeq());
        System.out.println("MsgDest : " + head.getDestID());
        System.out.println("MsgSRC : " + head.getSrcID());
    }

    private static void printRequest(List<Query> list) {
        for (Query q : list) {
            System.out.println("Query ID < " + q.getQueryId() + " >");
            System.out.println("SensorType : " + q.getSensorType());
            System.out.println("(lat, lon) : (" + q.getLatitude() + ", " + q.getLongitude() + ")");
            System.out.println("Radius (" + q.getRadius().getUnit() + ") : " + q.getRadius().getValue());
            System.out.println("ResultNumber : " + q.getResultNumberRange());
        }
    }

    private static void printResponse(List<Result> list) {
        for (Result r : list) {
            System.out.println("Query ID < " + r.getQueryId() + " >");
            List<SensorData> dataList = r.getSensorData();
            System.out.println(">>>>>>>");
            for (SensorData s : dataList) {
                System.out.println("Distance (" + s.getDistance().getUnit() + ") : " + s.getDistance().getValue());
                printSensorData(s);
            }
        }
    }

    private static void printSourceUpload(List<SensorData> list) {
        for (SensorData s : list) {
            printSensorData(s);
        }
    }

    private static void printSensorData(SensorData s) {
        System.out.println("SensorType : " + s.getSensorType());
        System.out.println("SensorID : " + s.getSensorID());
        System.out.println("SensedTime : " + TimeConverter.convertToString(s.getSensedTime().longValue()));
        System.out.println("(lat, lon) : (" + s.getLatitude() + ", " + s.getLongitude() + ")");
        List<Value> valList = s.getValues().getValue();
        System.out.println("---<Values>---");
        for (Value v : valList) {
            System.out.println(v.getId() + " : " + v.getValue());
        }
    }
}
