package jp.osoite.tomu.jaxb.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import jp.osoite.tomu.jaxb.object.Distance;

import jp.osoite.tomu.jaxb.object.SensorData;
import jp.osoite.tomu.jaxb.object.Value;
import jp.osoite.tomu.jaxb.object.Values;

/**
 *
 * @author shima
 */
public final class SensorDataBuilder {

    private SensorData data;
    private List<Value> valList;

    public SensorDataBuilder(String sensorType, long sensorId, long sensedTime, double lat, double lon) {
        data = new SensorData();
        data.setSensorType(sensorType);
        data.setSensorID(BigInteger.valueOf(sensorId));
        data.setSensedTime(BigInteger.valueOf(sensedTime));
        data.setLatitude(BigDecimal.valueOf(lat));
        data.setLongitude(BigDecimal.valueOf(lon));
        Values vals = new Values();
        data.setValues(vals);
        valList = vals.getValue();
    }

    public SensorData getSensorData() {
        return data;
    }

    public void setDistance(double val, String unit) {
        Distance dist = new Distance();
        dist.setUnit(unit);
        dist.setValue(BigDecimal.valueOf(val));
        data.setDistance(dist);
    }

    public void addValue(String columnName, String value) {
        Value added = new Value();
        added.setId(columnName);
        added.setValue(value);
        valList.add(added);
    }
}
