package jp.osoite.tomu.jaxb.util;

import java.math.BigInteger;
import java.util.List;

import jp.osoite.tomu.jaxb.object.Head;
import jp.osoite.tomu.jaxb.object.Response;
import jp.osoite.tomu.jaxb.object.Result;
import jp.osoite.tomu.jaxb.object.SensorData;
import jp.osoite.tomu.jaxb.object.TomuMessage;

/**
 *
 * @author shima
 */
public final class ResponseBuilder {

    private TomuMessage mes;
    private Response resp;

    public ResponseBuilder(Head head) {
        mes = new TomuMessage();
        mes.setType(TomuMessageType.RESPONSE);
        mes.setHead(head);
        resp = new Response();
        mes.setResponse(resp);
    }

    public TomuMessage getTomuMessage() {
        return mes;
    }

    public void addResult(int queryId, List<SensorData> list) {
        Result currentResult = new Result();
        currentResult.setQueryId(BigInteger.valueOf(queryId));
        for (SensorData data : list) {
            currentResult.getSensorData().add(data);
        }
        resp.getResult().add(currentResult);
    }
}
