package jp.osoite.tomu.jaxb.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import jp.osoite.tomu.database.TomuAnnotation;

import jp.osoite.tomu.jaxb.object.Query;
import jp.osoite.tomu.jaxb.object.Radius;

/**
 *
 * @author shima
 */
public final class QueryBuilder {

    private Query query;

    public QueryBuilder(int queryId, String sensorType) {
        query = new Query();
        query.setQueryId(BigInteger.valueOf(queryId));
        query.setSensorType(sensorType);
        setLocation(0, 0);
        setRadius(0, TomuAnnotation.UNIT_M);
        setResultNumberRange(0);
    }

    public void setLocation(double lat, double lon) {
        query.setLatitude(BigDecimal.valueOf(lat));
        query.setLongitude(BigDecimal.valueOf(lon));
    }

    public void setRadius(int rad, String unit) {
        Radius radius = new Radius();
        radius.setValue(BigInteger.valueOf(rad));
        radius.setUnit(unit);
        query.setRadius(radius);
    }

    public void setResultNumberRange(int range) {
        query.setResultNumberRange(BigInteger.valueOf(range));
    }

    public Query getQuery() {
        return query;
    }
}
