package jp.osoite.tomu.jaxb.util;

import java.math.BigInteger;

import jp.osoite.tomu.jaxb.object.Head;

/**
 *
 * @author shima
 */
public final class HeadBuilder {

    private HeadBuilder() {
    }

    public static Head build(long id, long seq, String dest, String src) {
        Head head = new Head();
        head.setMsgId(BigInteger.valueOf(id));
        head.setMsgSeq(BigInteger.valueOf(seq));
        head.setDestID(dest);
        head.setSrcID(src);
        return head;
    }

    public static Head buildReturnHead(Head srcHead) {
        Head head = new Head();
        head.setMsgId(srcHead.getMsgId());
        head.setMsgSeq(srcHead.getMsgSeq().add(BigInteger.ONE));
        head.setDestID(srcHead.getSrcID());
        head.setSrcID(srcHead.getDestID());
        return head;
    }
}
