package jp.osoite.tomu.itree;

import java.util.ArrayList;
import java.util.List;
import java.util.TimerTask;
import jp.osoite.tomu.itree.list.LinList;
import jp.osoite.tomu.itree.list.SortedLinList;
import jp.osoite.tomu.itree.util.Node;

public class PeriodicDeleteTask extends TimerTask {

    private ITreeCore itree;
    private NodeDeleteListener listener = null;

    public void setCurrentITree(ITreeCore it) {
        this.itree = it;
    }

    public void setNodeDeleteListener(NodeDeleteListener lis) {
        this.listener = lis;
    }

    public ITreeCore getCurrentITree() {
        return itree;
    }

    public void run() {
        if (itree.num_of_data != 0) {
            List<Long> deleteId = new ArrayList<Long>();

            float root_mbr[] = new float[itree.dimension * 2];
            LinList matchNodes = new LinList();

            try {
                root_mbr = ((Node) itree.root_ptr).get_mbr();
            } catch (NullPointerException e) {
                System.err.println(e.getMessage());
            }

            // LinList for storing result of a query.
            SortedLinList res = new SortedLinList();
            // rangeQuery using root_mbr
            itree.rangeQuery(root_mbr, res, matchNodes);

            ITDataNode matchNode = null;
            for (int i = 0; i < matchNodes.get_num(); i++) {
                ArrayList<Integer> matchData = new ArrayList<Integer>();

                for (int j = 0; j < ((ITDataNode) matchNodes.get(i)).get_num(); j++) {
                    matchNode = (ITDataNode) matchNodes.get(i);

                    ITDataNode tmpNode = (ITDataNode) matchNodes.get(i);
                    // ----- NodeDeleteListener ----------
                    long id = tmpNode.data[j].id;
                    deleteId.add(id);
                    // -----------------------------------
                    if (tmpNode.data[j].time_of_delete + itree.getWindowTime() < System.currentTimeMillis()) {
                        matchData.add(j);
                    }
                }

                if (matchNode != null) {
                    for (int k = 0; k < matchData.size(); k++) {
                        matchNode.data[matchData.get(k)] = null;
                    }

                    // Removing null data node.
                    for (int l = 0; l < matchData.size(); l++) {
                        for (int m = 0; m < matchNode.num_entries + 1; m++) {
                            if (matchNode.data[m] == null) {
                                for (int n = m; n < matchNode.num_entries + 1; n++) {
                                    matchNode.data[n] = matchNode.data[n + 1];
                                }
                            }
                        }
                    }
                    matchNode.num_entries = matchNode.num_entries - matchData.size();
                    matchNode.set_num(matchNode.num_entries);
                    matchNode.dirty = true;
                    itree.set_num(itree.get_num() - matchData.size());
                }

                if (matchNode.num_entries == 0) {
                    matchNode.delete();
                }

                if(listener != null){
                    listener.delete(deleteId);
                }
            }
        }
    }
}
