package jp.osoite.tomu.itree;
////////////////////////////////////////////////////////////////////////
// ITree Interface
////////////////////////////////////////////////////////////////////////

public interface ITree {

    /**
     * The method insert a sensor based on sensorID and range of the sensor into ITree.
     * A sensorID is a long Object.
     * A range of a sensor is represented by a upper-right point(dobule lat_1, double lon_1) 
     * and lower-left point(double lat_2, double lon_2).
     */
    public boolean insert(long sensorID, double lat_1, double lon_1, double lat_2, double lon_2);

    /**
     * The method insert a sensor based on sensorID and range of the sensor into ITree.
     * A sensorID is a long Object.
     * A range of a sensor is represented by a upper-right point(dobule lat_1, double lon_1) 
     * and lower-left point(double lat_2, double lon_2).
     * A time of birth describes a sensed time of a data.
     */
    public boolean insert(long sensorID, double lat_1, double lon_1, double lat_2, double lon_2, long time_of_birth);

    /**
     * The method checks whether the sensor of the sensorID is available in the ITree.
     * A sensorID is a logn Object.
     */
    public boolean isAvailableSensorID(long sensorID);

    /**
     * The method searchs sensors based on a specified range(double lat_1, double lon_1, double lat_2, double lon_2)
     * and returns a string object as a CSV format.
     *�? This is a debug method, then is going to move the util.
     */
    public String searchAndPrint(double lat_1, double lon_1, double lat_2, double lon_2);

    /**
     * The method searchs sensors based on a specified range(double lat_1, double lon_1, double lat_2, double lon_2)
     * and returns the results as the array of long objects.
     */
    public long[] search(double lat_1, double lon_1, double lat_2, double lon_2);

    /**
     * The method returns all sensorID that the ITree manages as the array of long objects.
     */
    public long[] getAllElements();

    /**
     * The method prints all sensorID that the ITree manages to stdout.
     * This is a debug method, then is going to move the util.
     */
    public void printTree();

    /**
     * The method deletes a sensor from the ITree based on a specified a sensorID of the sensor.
     */
    public boolean delete(long sensorID);

    /**
     *  The method deletes all sensors from the ITree.
     */
    public void deleteAll();

    /**
     * The method returns just the number of sensors in the ITree.
     * This is a debug method, then is going to move the util.
     */
    public int countNumber();

    /**
     * The method sets windowTime to delete a node automatically.
     */
    public void setWindowTime(long windowTime);

    /**
     * The method gets windowTime to delete a node automatically.
     */
    public long getWindowTime();
}
