package jp.osoite.tomu.database;

import java.util.Locale;
import jp.osoite.tomu.util.PatternMatcher;

/**
 *
 * @author shima
 */
public final class TomuAnnotation {

    public enum AnnotationType {
        DATABASE, SENSOR_TYPE, UNIT, NOT_DEFAULT_ANNOT
    }

    public enum Default {

        TYPE_INT,
        TYPE_BIGINT,
        TYPE_DOUBLE,
        TYPE_TIMESTAMP,
        TYPE_TEXT,
        TYPE_ANY,
        UNIT_M,
        UNIT_KM
    }
    public static final String TYPE_INT = "int";
    public static final String TYPE_BIGINT = "bigint";
    public static final String TYPE_DOUBLE = "double";
    public static final String TYPE_TIMESTAMP = "timestamp";
    public static final String TYPE_TEXT = "text";
    public static final String TYPE_ANY = "any";
    public static final String UNIT_M = "m";
    public static final String UNIT_KM = "km";
    private static final String[] LIST = {
        TYPE_INT,
        TYPE_BIGINT,
        TYPE_DOUBLE,
        TYPE_TIMESTAMP,
        TYPE_TEXT,
        TYPE_ANY,
        UNIT_M,
        UNIT_KM
    };

    public static boolean isDefaultAnnotation(String annot) {
        String lowerCaseAnnot = annot.toLowerCase(Locale.ENGLISH);
        lowerCaseAnnot = PatternMatcher.remove(lowerCaseAnnot, "\\((.+?)\\)");
        for (String defAnnot : LIST) {
            if (lowerCaseAnnot.equals(defAnnot)) {
                return true;
            }
        }
        return false;
    }

    public static AnnotationType getAnnotationType(String annot) {
        String lowerCaseAnnot = annot.toLowerCase(Locale.ENGLISH);
        for (int i = 0; i < LIST.length; i++) {
            if (lowerCaseAnnot.equals(LIST[i])) {
                switch (i) {
                    case 0:
                    case 1:
                    case 2:
                    case 3:
                    case 4:
                        return AnnotationType.DATABASE;
                    case 5:
                        return AnnotationType.SENSOR_TYPE;
                    case 6:
                    case 7:
                        return AnnotationType.UNIT;
                }
            }
        }
        return AnnotationType.NOT_DEFAULT_ANNOT;
    }

}
