package jp.osoite.tomu.database;

import java.sql.Timestamp;

/**
 *
 * @author shima
 */
public final class TimestampSpan {

    private Timestamp begin;
    private Timestamp end;

    public static final long SECOND = 1000;
    public static final long MINUTE = 60000;
    public static final long HOUR = 3600000;

    public TimestampSpan() {
        long current = System.currentTimeMillis();
        begin = new Timestamp(current);
        end = new Timestamp(current - HOUR);
    }

    public TimestampSpan(long begin, long end){
        this.begin = new Timestamp(begin);
        this.end = new Timestamp(end);
    }

    public Timestamp getBegin() {
        return begin;
    }

    public Timestamp getEnd() {
        return end;
    }

}
