package jp.osoite.tomu.database;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import jp.osoite.tomu.main.jaxb.table.Element;
import jp.osoite.tomu.main.jaxb.table.Table;

/**
 *
 * @author shima
 */
public final class TableBuilder {

    private static final String CREATE_SQL = "CREATE TABLE IF NOT EXISTS ";

    private TableBuilder() {
    }

    public static void createSensorTable(Table tableElement, Statement stat) throws SQLException {
        StringBuilder builder = new StringBuilder(CREATE_SQL);
        builder.append(tableElement.getName()).append(" (`").append(DefaultColumn.DATA_ID).append("` bigint NOT NULL PRIMARY KEY, `").append(DefaultColumn.SENSOR_ID).append("` bigint NOT NULL, `").append(DefaultColumn.SENSED_TIME).append("` timestamp NOT NULL, `").append(DefaultColumn.LATITUDE).append("` double NOT NULL, `").append(DefaultColumn.LONGITUDE).append("` double NOT NULL");
        List<Element> elementList = tableElement.getElement();
        for (Element elm : elementList) {
            String type = elm.getType();
            TomuAnnotation.AnnotationType annotType = TomuAnnotation.getAnnotationType(type);
            if (annotType == TomuAnnotation.AnnotationType.DATABASE) {
                builder.append(", `").append(elm.getValue()).append("` ").append(type);
            }
        }
        builder.append(")");
        synchronized (stat) {
            stat.execute(builder.toString());
        }
    }
}
