package jp.osoite.tomu.database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.sql.SQLException;
import jp.osoite.tomu.main.TomuSetting;

/**
 *
 * @author shima
 */
public final class DatabaseConnectionManager {

    private Statement defaultStatement;
    private Connection defaultConnection;
    private ThreadLocal<Connection> connectionHolder;
    private String url;
    private String user;
    private String pass;

    public DatabaseConnectionManager(TomuSetting setting) throws ClassNotFoundException, SQLException {
        Class.forName(setting.getDatabaseDriver());
        url = setting.getDatabaseUrl();
        user = setting.getDatabaseUser();
        pass = setting.getDatabasePass();
        defaultConnection = DriverManager.getConnection(url, user, pass);
        defaultStatement = defaultConnection.createStatement();
        connectionHolder = new ThreadLocalImple();
    }

    private class ThreadLocalImple extends ThreadLocal<Connection> {

        @Override
        public Connection initialValue() {
            try {
                return DriverManager.getConnection(url, user, pass);
            } catch (SQLException ex) {
                return defaultConnection;
            }
        }
    }

    public Statement getDefaultStatement() {
        return defaultStatement;
    }

    public Connection getDefaultConnection() {
        return defaultConnection;
    }

    public Connection getThreadLocalConnection() {
        return connectionHolder.get();
    }

    public void close() throws SQLException {
        defaultConnection.close();
    }

    @Override
    @SuppressWarnings("FinalizeDeclaration")
    protected void finalize() throws Throwable {
        try {
            defaultConnection.close();
        } finally {
            super.finalize();
        }
    }
}
