package jp.osoite.tomu.xmpp.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Locale;
import javax.xml.bind.JAXBException;
import jp.osoite.tomu.net.xmpp.XMPPDeamonRunnable;
import jp.osoite.tomu.xml.jaxb.object.TomuMessage;
import jp.osoite.tomu.xml.jaxb.util.JAXBConverter;
import jp.osoite.tomu.xml.jaxb.util.TomuMessagePrinter;
import jp.osoite.tomu.xml.jaxb.util.builder.DummyTomuMessageFactory;
import jp.osoite.tomu.xml.jaxb.util.builder.DummyTomuMessageFactory.DummyMessageType;
import jp.osoite.tomu.xmpp.core.MessageReceiver;
import jp.osoite.tomu.xmpp.core.RequestSfeerMinimumSQL;
import jp.osoite.tomu.xmpp.core.XMPPManager;
import jp.osoite.tomu.xmpp.core.XMPPManagersFactory;
import org.jivesoftware.smack.RosterEntry;

/**
 *
 * @author shima
 */
public class TomuCommandPrompt {

    private XMPPManager manager;
    private XMPPSetting setting;
    private volatile boolean isRunning;
    private static final String HELP = "help";
    private static final String WHOAMI = "whoami";
    private static final String USERS = "users";
    private static final String PING = "ping";
    private static final String LOGIN = "login";
    private static final String LOGOFF = "logoff";
    private static final String TO = "to";
    private static final String ADD_USER = "adduser";
    private static final String RM_USER = "rmuser";
    private static final String SFEER_DEBUG = "sfeerdebug";
    private static final String SFEER_LV1 = "sfeerlv1";
    private static final String SFEER_LV2 = "sfeerlv2";
    private static final String SFEER_LV3 = "sfeerlv3";
    private MessageReceiver receiv;

    public TomuCommandPrompt(XMPPManager xmppmanager, MessageReceiver receiv) {
        this.setting = xmppmanager.getSetting();
        manager = xmppmanager;
        isRunning = false;
        this.receiv = receiv;
    }

    public TomuCommandPrompt(XMPPSetting setting) {
        this.setting = setting;
        manager = new XMPPManager(setting, new DefaultCommandReceiver());
        isRunning = false;
    }

    public void run() {
        try {
            isRunning = manager.login();
        } catch (Exception e) {
            isRunning = false;
        }
        if (isRunning) {
            new Thread() {

                public void run() {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
                    System.out.println("=== Welcome to Tomu Command Prompt ! ===");
                    while (isRunning) {
                        try {
                            System.out.println(">>> Ready to input");
                            swichCommand(reader.readLine());
                        } catch (IOException e) {
                        }
                    }
                }
            }.start();
        } else {
            System.out.println(" >>> ERROR");
        }
    }

    public void stop() {
        isRunning = false;
    }

    private void swichCommand(String cmd) {
        if (isRunning) {
            int colonIndex = cmd.indexOf(":");
            String operator = "";
            String operand = "";
            if (colonIndex > 0) {
                operator = cmd.substring(0, colonIndex).trim().toLowerCase(Locale.ENGLISH);
                if (colonIndex + 1 < cmd.length()) {
                    operand = cmd.substring(colonIndex + 1, cmd.length());
                }
                if (operator.equals(HELP)) {
                    printHelp();
                } else if (operator.equals(WHOAMI)) {
                    printStatus();
                } else if (operator.equals(USERS)) {
                    printUsers();
                } else if (operator.equals(PING)) {
                    sendPing();
                } else if (operator.equals(LOGIN)) {
                    login(operand);
                } else if (operator.equals(LOGOFF)) {
                    logoff();
                } else if (operator.equals(TO)) {
                    sendMessage(operand);
                } else if (operator.equals(SFEER_DEBUG)) {
                    if (operand.equals("off")) {
                        RequestSfeerMinimumSQL.setPhotoSearchDebugMode(false);
                        System.out.println(" * [OFF] Sfeer Debug Mode");
                    } else {
                        RequestSfeerMinimumSQL.setPhotoSearchDebugMode(true);
                        System.out.println(" * Sfeer Debug Mode");
                    }
                } else if (operator.equals(SFEER_LV1)) {
                    setSfeerEmergency(1, true);
                } else if (operator.equals(SFEER_LV2)) {
                    setSfeerEmergency(2, true);
                } else if (operator.equals(SFEER_LV3)) {
                    setSfeerEmergency(3, true);
                }
            }
        } else {
            System.out.println("is not running. please do run().");
        }
    }

    private void printHelp() {
        System.out.println(" * << Command Refference >>");
        System.out.println(" * help:  コマンドリファレンスを表示します．");
        System.out.println(" * whoami:  自身の情報を表示します．");
        System.out.println(" * users:  他のユーザリストを表示します．");
        System.out.println(" * ping:  pingを送信します．");
        System.out.println(" * login:[account]#[pass]  指定したアカウントでログインします．");
        System.out.println(" * login:1(～4)  番号に対応したアカウントでログインします．");
        System.out.println(" * logoff:  ログオフします．");
        System.out.println(" * to:[account]#[messageType]  指定したアカウントにTomuMessageを投げます．");
        System.out.println(" * to:all#[messageType]  全員にTomuMessageを投げます．");
        System.out.println(" * [messageType]  appsresp, appsreq, initresp, initreq, upload");
        System.out.println(" * sfeerdebug:  Sfeerデバッグコマンド．");
        System.out.println(" * sfeerlv1:  Sfeer緊急コマンドLv1．写真のアップロードを4方向のみにします．");
        System.out.println(" * sfeerlv2:  Sfeer緊急コマンドLv2．写真のアップロードを1枚のみにします．");
        System.out.println(" * sfeerlv3:  Sfeer緊急コマンドLv3．写真のアップロードを停止します．");
        //System.out.println(" * adduser:[account]  新しいユーザを追加します．");
        //System.out.println(" * rmuser:[account]  指定したユーザを削除します．");
    }

    private void printStatus() {
        System.out.println(" * << " + setting.getAccount() + " >>");
    }

    private void printUsers() {
        Collection<RosterEntry> entries = manager.getUserList();
        System.out.println(" * << User List >>");
        System.out.println(" * Num of Entry : " + entries.size());
        int seq = 1;
        for (RosterEntry entry : entries) {
            String address = entry.getUser();
            System.out.println(" * " + (seq++) + ": " + entry.getUser() + "  Available:" + manager.isAvailable(address));
        }
    }

    private void sendPing() {
        manager.sendToAll(" * [Ping] This is a ping message from #" + setting.getAccount());
    }

    private void login(String operand) {
        if (operand.length() == 1) {
            try {
                int num = Integer.parseInt(operand);
                if (1 <= num && num <= 4) {
                    manager.logoff();
                    setting = new XMPPSetting("tomuxmpp" + num + "@gmail.com", "osoiteTomu");
                    manager = XMPPManagersFactory.getInstance().getXMPPManager(XMPPDeamonRunnable.DEF_TOMU_NUM);
                    isRunning = manager.login(setting);
                }
            } catch (Exception e) {
                System.out.println(" * Worng operand : " + operand);
            }
        } else if (operand.contains("#")) {
            String account = operand.substring(0, operand.indexOf("#"));
            String pass = operand.substring(operand.indexOf("#") + 1, operand.length());
            manager.logoff();
            setting = new XMPPSetting(account, pass);
            manager = XMPPManagersFactory.getInstance().getXMPPManager(XMPPDeamonRunnable.DEF_TOMU_NUM);
            isRunning = manager.login(setting);
        } else {
            System.out.println(" * Worng operand : " + operand);
        }
        if (isRunning) {
            printStatus();
        }
    }

    private void setSfeerEmergency(int level, boolean flag) {
        RequestSfeerMinimumSQL.setSfeerEmergency(flag, level);
        System.out.println(" * Sfeer Emergency Mode : Level." + level + " !!");
    }

    private void logoff() {
        System.out.println("--- See ya ---");
        manager.logoff();
    }

    private void sendMessage(String operand) {
        String account = operand.substring(0, operand.indexOf("#"));
        String type = operand.substring(operand.indexOf("#") + 1, operand.length());

        TomuMessage mes = null;
        if (type.equals("appsresp")) {
            mes = DummyTomuMessageFactory.getAppsResponse(DummyMessageType.RANDOM);
        } else if (type.equals("appsreq")) {
            mes = DummyTomuMessageFactory.getSfeerRequest();
        } else if (type.equals("initresp")) {
            mes = DummyTomuMessageFactory.getSfeerInitResponse(3);
        } else if (type.equals("initreq")) {
            mes = DummyTomuMessageFactory.getSfeerInitRequest(3);
        } else if (type.equals("upload")) {
            mes = DummyTomuMessageFactory.getSourceUpload(DummyMessageType.RANDOM);
        } else {
            System.out.println(" * Worng operand : " + operand);
            return;
        }
        try {
            if (account.equals("all")) {
                manager.sendToAll(JAXBConverter.convertToXml(mes));
            } else {
                manager.send(account, JAXBConverter.convertToXml(mes));
            }
            System.out.println(" * Send TomuMessage to " + account);
        } catch (JAXBException ex) {
            ex.printStackTrace();
        }
    }

    private class DefaultCommandReceiver extends MessageReceiver {

        @Override
        public void receive(String message) {
            if (message.contains("[Ping]")) {
                System.out.println(message);
                String account = message.substring(message.indexOf("#") + 1);
                manager.send(account, " * Hello, " + setting.getAccount() + " received your ping message.");
            } else {
                try {
                    TomuMessage tomuMsg = JAXBConverter.convertToObj(message);
                    TomuMessagePrinter.print(tomuMsg);
                } catch (JAXBException ex) {
                    System.out.println(message);
                }
            }
        }
    }
}
