package jp.osoite.tomu.database.core;

/**
 *
 * @author shima
 */
public class DatabaseConnectionSetting {

    public enum Driver {

        POSTGRES, MYSQL
    }
    private static final String MYSQL_DNAME = "com.mysql.jdbc.Driver";
    private static final String MYSQL_BASE_URL = "jdbc:mysql:";
    private static final String POSTGRES_DNAME = "org.postgresql.Driver";
    private static final String POSTGRES_BASE_URL = "jdbc:postgresql:";

    private String url;
    private String dbName;
    private String user;
    private String pass;
    private String jdbcDriver;

    public DatabaseConnectionSetting(String url, String user, String pass, Driver jdbcDriver) {
        this.url = url;
        this.user = user;
        this.pass = pass;
        if (jdbcDriver == Driver.MYSQL) {
            this.jdbcDriver = MYSQL_DNAME;
        } else if (jdbcDriver == Driver.POSTGRES) {
            this.jdbcDriver = POSTGRES_DNAME;
        }
    }

    public String getJdbcDriver() {
        return jdbcDriver;
    }

    public String getPass() {
        return pass;
    }

    public String getUrl() {
        return url;
    }

    public String getUser() {
        return user;
    }
}
