package jp.osoite.tomu.database.core;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.security.krb5.Config;

/**
 *
 * @author shima
 */
public class DatabaseConnectionManager {
    
    private DatabaseConnectionSetting setting;
    private Statement statement = null;
    private java.sql.Connection dbCon = null;

    public DatabaseConnectionManager(DatabaseConnectionSetting setting){
        this.setting = setting;
    }

    public void connect(){

    }


    private void init_db_connection() throws Exception {
        INIT:
        {
            try {
                Class.forName(JDBC_DRIVER);
                String url = DATABASE_URL + DATABASE_NAME;
                // Get a connection to the database for given user/password
                dbCon = DriverManager.getConnection(url, DATABASE_USER, DATABASE_PASSWORD);
                // Display URL and connection information
                System.out.println("URL: " + url);
                System.out.println("Connection: " + dbCon);
            } catch (Exception e) {
                System.err.println("setUp caught " + e);
                System.err.println("Make sure that mySQL is installed properly \n" + "and has a Test database accessible via the \n" + "default administrator settings on localhost:3306\n");
                throw e;
            }
        } //end init
    }



    private void create_data_dbs() {
        // Create a table with three columns:
        // spotId    padded to 20 chars identifier for SPOT
        // timestamp YYYY-MM-DD hh:mm:ss string when reading was taken
        // reading   light sensor reading (4 is simply the display
        //           width but an unsigned smallint can store any value
        //           from 0 to 65535)
        CREATEDATABASE:
        {
            long defTimer = System.currentTimeMillis();
            
            /*
            String createSQLStmtforSpotDataTable = "CREATE TABLE IF NOT EXISTS " + SPOT_DATA_TABLE_NAME +
            "(`counter` bigint(20) NOT NULL auto_increment," +
            "`sensorid` char(20) NOT NULL," +
            "`timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP," +
            "`timer` long NOT NULL ," + //default"+defTimer+"
            "`light` int(11) ," + //NOT NULL
            "`temp` double ," +
            "`ax` double ," +
            "`ay` double ," +
            "`az` double ," +
            "`movement` int(11) ," +
            "`battery` double ," +
            "`frequency` int(11) ," +//NOT NULL
            "PRIMARY KEY  (`counter`))" +
            " ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1";
             */
            try {
                String createSQLStmtforSpotDataTable = MySQLDBStatisticsHelper.getSQLStmt2CreateDataTable(SPOT_DATA_TABLE_NAME);
                //System.out.println(createSQLStmtforSpotDataTable);
                getStatement().executeUpdate(createSQLStmtforSpotDataTable);
                System.out.println("PEDESTRIAN_DATA_TABLE_NAME" + PEDESTRIAN_DATA_TABLE_NAME);
                
            } catch (SQLException e) {

                System.out.println(e.getMessage());
                System.out.println("No data Table creation.");
                e.printStackTrace();
            }
            try {
                String createSQLStmtforPedestrianDataTable = PedestrianDBHelper.getSQLStmtCreateTable(PEDESTRIAN_DATA_TABLE_NAME);
                //System.out.println("==============================");
                System.out.println(createSQLStmtforPedestrianDataTable);
                //System.out.println("==============================");
                getStatement().executeUpdate(createSQLStmtforPedestrianDataTable);
            } catch (SQLException e) {
                System.out.println(e.getMessage());
                System.out.println("Ped No data Table creation.");
                e.printStackTrace();
            }
            try {
                System.out.println(Kito2DBHelper.getSQLStmtCreateTable(KITO2_DATA_TABLE_NAME));
                getStatement().executeUpdate(Kito2DBHelper.getSQLStmtCreateTable(KITO2_DATA_TABLE_NAME));
            } catch (SQLException e) {
                System.out.println(e.getMessage());
                System.out.println("Kito2No data Table creation.");
                e.printStackTrace();
            }
            try {
                //System.out.println(TScanDBHelper.getSQLStmtCreateTable(TSCAN_DATA_TABLE_NAME));
                System.out.println(TScanDBHelper.getSQLCreateDB(TSCAN_DATA_TABLE_NAME));
                getStatement().executeUpdate(TScanDBHelper.getSQLCreateDB(TSCAN_DATA_TABLE_NAME));
            } catch (SQLException e) {
                System.out.println(e.getMessage());
                System.out.println("No data Table creation.");
                e.printStackTrace();
            }
        } //end create db
    }

    private void dbSetUp() throws Exception {

        init_db_connection();

        try {
            statement = dbCon.createStatement();
        } catch (Exception e) {
            System.err.println("dbSetUp stmt: caught " + e.getMessage());
            throw e;
        }

        try {
            drop_previous_dbs();
        } catch (Exception e) {
            System.err.println("dbSetUp drop: caught " + e.getMessage());
            throw e;
        }

        try {
            create_data_dbs();
        } catch (Exception e) {
            System.err.println("dbSetUp createdb :caught" + e.getMessage());
            throw e;
        }

        try {
            create_stat_db();
        } catch (Exception e) {
            System.err.println("dbSetUp create stat : caught " + e.getMessage());
            throw e;
        }

        //statement.executeUpdate("describe "+SPOT_DATA_TABLE_NAME);

        System.out.println("setUp completed successfully");

    }

    public void savingData2AutoTxt(String sensorname) throws Exception {

        System.out.println(">DB2AUTO" + MySQLDBStatisticsHelper.getSQLStmt9AutoSaving(sensorname));
        ResultSet rs = null;
        rs = getStatement().executeQuery(MySQLDBStatisticsHelper.getSQLStmt9AutoSaving(sensorname));
    }

    public void savingData2Txt(String sensorname) throws Exception {

        //for tatebayashi
        /*
        System.out.println(">DB2TXT" + MySQLDBStatisticsHelper.getSQLStmt9BkupHumanFile(sensorname));
        ResultSet rs = null;
        rs = statement.executeQuery(MySQLDBStatisticsHelper.getSQLStmt9BkupHumanFile(sensorname));
         */

        ResultSet rs2 = null;
        String PED_TABLE_NAME = "data_ped";
        System.out.println(">DB2HumanTXT:" + PedestrianDBHelper.getSQLStmt9BkupHumanFile(sensorname, PED_TABLE_NAME));
        rs2 = getStatement().executeQuery(PedestrianDBHelper.getSQLStmt9BkupHumanFile(sensorname, PED_TABLE_NAME));

        System.out.println("saving is done");

        //ResultSet rs3 = null;
        //rs2 = statement.executeQuery(PedestrianDBHelper.getSQLStmt9BkupHumanFileColums(PED_TABLE_NAME));

    }

    private List receiveReqFromSfeerServer(RequestSfeerWrapper reqsfeer) throws SQLException {

        List<UploadKito2Wrapper> kito2ResultList = new ArrayList<UploadKito2Wrapper>();
        ResultSet rs = statement.executeQuery("select * from " + KITO2_DATA_TABLE_NAME);
        //KITO2_DATA_TABLE_NAME,reqsfeer.getLocationList().

        //ResultSet rs = getStatement().executeQuery(Kito2DBHelper.getKiot2SortedSmt();

        /*
        SELECT * FROM kito2 ORDER BY SQRT(POWER(((139 - longitude)/180*3.141592)
        COS((35 + latitude) / 2 / 180 * 3.141592), 2) + POWER((35 -
        latitude)/180*3.141592, 2)) ASC LIMIT 100;
         * */

        TomuMessage res_tomumsgobj;
        UploadKito2Wrapper ukw;



        while (rs.next()) {
            try {
                JAXBConstructor constructor = new JAXBConstructor(TomuMessageType.SOURCE_UPLOAD);
                constructor.setHeader("dest@hoge.com", "src@hoge.com", System.currentTimeMillis());
                constructor.setSequence(System.currentTimeMillis());
                constructor.addKitokitoData(rs.getLong("sensorid"), rs.getInt("compass"), JAXBConstructor.getLocation(rs.getDouble("longitude"), rs.getDouble("latitude"), 0), rs.getInt("dpi"), rs.getString("url"), rs.getString("thumbnail_url"), TimeConverter.convertToLong(rs.getString("timestamp")));
                res_tomumsgobj = constructor.build();

                ukw = new UploadKito2Wrapper(res_tomumsgobj);

                kito2ResultList.add(ukw);

                System.out.println("url:" + ukw.getThumbnailUrl());
                System.out.println("latitude:" + Double.toString(ukw.getLatitude()));
                System.out.println("longitude:" + Double.toString(ukw.getLongitude()));
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        /*
        Kito2Comparator kito2Comparator = new Kito2Comparator(35, 139);
        //Kito2Comparator kito2Comparator = new Kito2Comparator(ukw.getLatitude(), ukw.getLongitude());
        Collections.sort(kito2ResultList, kito2Comparator);

        for (UploadKito2Wrapper value : kito2ResultList) {
        System.out.println("lat: " + value.getLatitude());
        System.out.println("lon: " + value.getLongitude());
        }
         */
        return kito2ResultList;

    }

    public void receiveKito2wobjFromSensorSource(UploadKito2Wrapper kito2obj) throws Exception {

        long startTimer = 0L;
        startTimer = System.currentTimeMillis();

        /* */
        System.out.println("SensorId : " + kito2obj.getSensorId());
        System.out.println("timestamp : " + kito2obj.getSensedTime());
        System.out.println("compass : " + kito2obj.getCompass());
        System.out.println("latitude : " + kito2obj.getLatitude());
        System.out.println("longitude : " + kito2obj.getLongitude());
        System.out.println("dpi : " + kito2obj.getDpi());
        System.out.println("url : " + kito2obj.getImageUrl());
        System.out.println("thumbnail_url : " + kito2obj.getThumbnailUrl());
        /* */

        //String insertStmtStrPed = "";
        //" PedestrianDBHelper.getPEDSQLInsertStmt((PedestrianFlowValue) kito2wobj, this.PEDESTRIAN_DATA_TABLE_NAME);"

        String insertKito2Str = Kito2DBHelper.getKito2SQLInsertStmt(kito2obj, KITO2_DATA_TABLE_NAME);

        try {
            getStatement().executeUpdate(insertKito2Str);
        } catch (BatchUpdateException b) {

            System.err.println("Update counts of successful commands: " + b);
            int[] updateCounts = b.getUpdateCounts();
            for (int i = 0; i < updateCounts.length; i++) {
                System.err.print(updateCounts[i] + "  ");
            }
            System.err.println("");

        } catch (SQLException e) {

            System.err.println("Caught " + e + " while storing kito2 vals: " + insertKito2Str);
            e.printStackTrace();

        } catch (Exception e) {

            System.err.println("Caught " + e
                    + " while reading kito2 samples.");
            e.printStackTrace();

        }

        //statement.executeUpdate(insertStmtStrPed);
        System.out.println(">>> \"data_kito2\" table inserted\n");

    }

    public void receivePerFlowValFromSensorSource(PedestrianFlowValue psvalue) throws Exception {

        long startTimer = 0L;
        startTimer = System.currentTimeMillis();
        if (psvalue instanceof PedestrianFlowValue) {

            String insertStmtStrPed = PedestrianDBHelper.getPEDSQLInsertStmt((PedestrianFlowValue) psvalue, this.PEDESTRIAN_DATA_TABLE_NAME);

            getStatement().executeUpdate(insertStmtStrPed);
            System.out.println(">>> \"data_ped\" table inserted\n");
        }
    }

    public void receiveDataFromSunSpot(SensorVals sval) throws Exception {
        int sampleCnt = 0;
        long startTimer = 0L;

        //System.out.println("Sampling for " + (SAMPLING_DURATION/1000) + " seconds ...\n");
        startTimer = System.currentTimeMillis();

        /*
        String  insertStmtStr="INSERT INTO " + SPOT_DATA_TABLE_NAME +
        "(sensorid,timestamp,timer,light,temp,ax,ay,az,movement,battery)" +
        " VALUES(\'" + sval.getSensorName() + "\',\'"+ sval.getTimeStamp()+ "\',\'"+sval.getInternalCounter()
        + "\',\'" + sval.getLightSensorVal()
        + "\',\'" + sval.getTempSensorVal()
        + "\',\'" + sval.getAccelX()
        + "\',\'" + sval.getAccelY()
        + "\',\'" + sval.getAccelZ()
        + "\',\'" + sval.getAllMovementbyInteger()
        + "\',\'" + sval.getRemainingBattery()
        + "\')";
         */

        //
        String insertStmtStr = sval.getSQLInsertStmt(SPOT_DATA_TABLE_NAME);

        System.out.println(">DB");
        try {
            getStatement().executeUpdate(insertStmtStr);
            sampleCnt++;
        } catch (BatchUpdateException b) {
            System.err.println("Update counts of successful commands: " + b);
            int[] updateCounts = b.getUpdateCounts();
            for (int i = 0; i < updateCounts.length; i++) {
                System.err.print(updateCounts[i] + "  ");
            }
            System.err.println("");
        } catch (SQLException e) {
            System.err.println("Caught " + e + " while storing sensor vals: " + insertStmtStr);
            throw e;
        } catch (Exception e) {
            System.err.println("Caught " + e
                    + " while reading sensor samples.");
            throw e;
        }
        if (Config.getInstance().isSTASTICS_CALC_ENABLE()) {
            statisticsUpdate(sval);
        }

    }

    public void collectDataFromOutside(String id2, String ts2, int val2) throws Exception {

        String id = null;
        String ts = null;
        int val = 0;

        id = id2;
        ts = ts2;
        val = val2;

        int sampleCnt = 0;
        long startTimer = 0L;

        /*
        System.out.println("Sampling for " + (SAMPLING_DURATION/1000) +
        " seconds ...\n[Each * indicates one sample, ! implies" +
        " radio timed out waiting for a sample]");
         *
         * */
        startTimer = System.currentTimeMillis();
        //dg = rCon.newDatagram(rCon.getMaximumLength());

        // Main data collection loop
        try {
            // Read sensor sample received over the radio
            //rCon.receive(dg);

            /*//tailor
            id = dg.readUTF();  // read sender's Id
            ts = dg.readUTF();  // read time stamp for the reading
            val = dg.readInt(); // read the sensor value
             */
            System.out.println("*");
            getStatement().executeUpdate("INSERT INTO " + SPOT_DATA_TABLE_NAME
                    + "(spotId,timestamp,reading)"
                    + " VALUES(\'" + id + "\',\'" + ts + "\'," + val + ")");
            sampleCnt++;
        } catch (SQLException e) {
            System.err.println("Caught " + e
                    + " while storing sensor sample <"
                    + "\'" + id + "\',\'" + ts + "\'," + val + ">");
            throw e;
        } catch (Exception e) {
            System.err.println("Caught " + e
                    + " while reading sensor samples.");
            throw e;
        }


        System.out.println("\nDone! Collected " + sampleCnt + " samples.");
    }

    public void analyzeData() throws Exception {
        ResultSet rs = null;
        String id = null;
        String ts = null;
        int val = 0;

        try {
            // Display all results
            rs = getStatement().executeQuery("SELECT * "
                    + "from " + SPOT_DATA_TABLE_NAME
                    + " ORDER BY timestamp");
            System.out.println("Collected sensor readings:");
            System.out.println("\t+--------------------------------------"
                    + "-----------------+");
            System.out.println("\t|      spotId       \t      timestamp  "
                    + " \treading |");
            System.out.println("\t+--------------------------------------"
                    + "-----------------+");
            while (rs.next()) {
                id = rs.getString("spotId");
                ts = rs.getString("timestamp");
                val = rs.getInt("reading");
                System.out.println("\t " + id + "\t" + ts + "\t   " + val);
            }
            System.out.println("\t+--------------------------------------"
                    + "-----------------+");

            // Print the spotId and timestamp corresponding to the highest val
            rs = getStatement().executeQuery("SELECT * "
                    + "from " + SPOT_DATA_TABLE_NAME
                    + " ORDER BY reading DESC LIMIT 1");
            while (rs.next()) {
                id = rs.getString("spotId");
                ts = rs.getString("timestamp");
                val = rs.getInt("reading");
                System.out.println("\tMax: " + val
                        + " (recorded by SPOT " + id + " at " + ts + ")");
            }

            // Print the spotId and timestamp corresponding to the lowest val
            rs = getStatement().executeQuery("SELECT * "
                    + "from " + SPOT_DATA_TABLE_NAME
                    + " ORDER BY reading ASC LIMIT 1");
            while (rs.next()) {
                id = rs.getString("spotId");
                ts = rs.getString("timestamp");
                val = rs.getInt("reading");
                System.out.println("\tMin: " + val
                        + " (recorded by SPOT " + id + " at " + ts + ")");
            }

            // Print the average sensor reading across all samples
            rs = getStatement().executeQuery("SELECT AVG(reading) AS avg FROM "
                    + SPOT_DATA_TABLE_NAME);
            while (rs.next()) {
                val = rs.getInt("avg");
                System.out.println("\tAvg: " + val);
            }
        } catch (Exception e) {
            System.err.println("Caught " + e + " in analyzeData()");
            throw e;
        }
    }

    public void tearDown() throws Exception {

        if (dbCon != null) {
            dbCon.close();

        }
        //if (rCon != null) rCon.close();
        //    System.exit(0);
    }

    /**
     * Start up the host application.
     *
     * @param args any command line arguments
     */
    public static void main(String[] args) throws Exception {
        //DatabaseDemoHostApplication app = new DatabaseDemoHostApplication();
        //DatabaseHostModule.getInstance()
        //app.run();
    }

    private void drop_previous_dbs() {
        // Delete the data collection table if left over
        // from a previous run. If no table exists, an
        // exception will be thrown.
        DROPDB:
        {
            if (FLAG_DROP_TABLE) {
                try {
                    getStatement().executeUpdate("DROP TABLE if exists " + SPOT_DATA_TABLE_NAME);
                    
                } catch (SQLException e) {
                    System.out.println(e.getMessage());
                    System.out.println("No existing table to delete.");
                }
                try {
                    getStatement().executeUpdate("DROP TABLE if exists " + PEDESTRIAN_DATA_TABLE_NAME);
                    
                } catch (SQLException e) {
                    System.out.println(e.getMessage());
                    System.out.println("No existing table to delete.");
                }
                try {
                    getStatement().executeUpdate("DROP TABLE if exists " + KITO2_DATA_TABLE_NAME);
                    
                } catch (SQLException e) {
                    System.out.println(e.getMessage());
                    System.out.println("No existing table to delete.");
                }
                try {
                    getStatement().executeUpdate("DROP TABLE if exists " + TSCAN_DATA_TABLE_NAME);
                    System.out.println("TSCAN_DATA_TABLE_NAME:Existing table deleted.");
                } catch (SQLException e) {
                    System.out.println(e.getMessage());
                    System.out.println("No existing table to delete.");
                }

                try {
                    getStatement().executeUpdate(MySQLDBStatisticsHelper.getSQLStmt5DropStatistics());
                    System.out.println("delated. Statistics");
                } catch (SQLException e) {
                    System.out.println(e.getMessage());
                    System.out.println("No existing table to delete.");
                }
            }//if end
        }
        // Create a table with three columns:
        // spotId    padded to 20 chars identifier for SPOT
        // timestamp YYYY-MM-DD hh:mm:ss string when reading was taken
        // reading   light sensor reading (4 is simply the display
        //           width but an unsigned smallint can store any value
        //           from 0 to 65535)
    }

    

    private void statisticsUpdate(SensorVals sval) throws SQLException {


        try {
            getStatement().executeUpdate(MySQLDBStatisticsHelper.getSQLStmt2DropView("v"));
        } catch (SQLException ex) {
            Logger.getLogger(DatabaseConnectionManager.class.getName()).log(Level.SEVERE, null, ex);
        }

        try {
            //statement.clearBatch();
            //statement.addBatch(MySQLDBStatisticsHelper.getStmtStatistics1());
            //int [] updateCounts = statement.executeBatch();
            //statement.executeQuery(MySQLDBStatisticsHelper.getStmtQuery1(2));

            getStatement().executeUpdate(MySQLDBStatisticsHelper.getSQLStmt3CreateViewLimited(sval.getSensorName(), NUMBER_OF_STANDALISATION));

            getStatement().executeQuery(MySQLDBStatisticsHelper.getSQLStmtQuery4VariableSetting());
            getStatement().executeUpdate(MySQLDBStatisticsHelper.getSQLStmt7insertStatistics(1));

            //System.out.println("^^^^^^^^^^^^^^^^^^^\n"+MySQLDBStatisticsHelper.getSQLStmt8select1Statistics(sval.getSensorName()));



        } catch (SQLException ex) {
            Logger.getLogger(DatabaseConnectionManager.class.getName()).log(Level.SEVERE, null, ex);
        }


    }

    public double processStasticsOnDB(String sensorname,
            GuiSmallObj lightsmallobj,
            GuiSmallObj movementsmallobj,
            GuiSmallObj tempsmallobj) {

        double d = 0;
        try {

            //System.out.println("^^^^^^^^^^^^^^^^^^^\n"+MySQLDBStatisticsHelper.getSQLStmt8select1Statistics(sensorname));
            ResultSet rs = getStatement().executeQuery(MySQLDBStatisticsHelper.getSQLStmt8select1Statistics(sensorname));

            while (rs.next()) {
                lightsmallobj.setLowband((int) Math.floor(rs.getDouble("light_low_band")));
                lightsmallobj.setHighband((int) Math.ceil(rs.getDouble("light_high_band")));
                lightsmallobj.setAve((int) rs.getDouble("lightavg"));

                movementsmallobj.setLowband((int) Math.floor(rs.getDouble("movement_low_band")));
                movementsmallobj.setHighband((int) Math.ceil(rs.getDouble("movement_high_band")));
                movementsmallobj.setAve((int) rs.getDouble("movementavg"));

                //System.out.println("rs.getDoubletemp_low_band"+rs.getDouble("temp_low_band"));
                //System.out.println("rs.getDoubletemp_high_band"+rs.getDouble("temp_high_band"));
                tempsmallobj.setLowband((int) Math.floor(rs.getDouble("temp_low_band")) * 10);
                tempsmallobj.setHighband((int) Math.ceil(rs.getDouble("temp_high_band")) * 10);
                tempsmallobj.setAve((int) rs.getDouble("tempavg") * 10);
                /*
                tempsmallobj.setLowband((int)Math.floor(rs.getDouble("temp_low_band")));
                tempsmallobj.setHighband((int)Math.ceil(rs.getDouble("temp_high_band")));
                tempsmallobj.setAve((int)rs.getDouble("tempavg"));
                 * */

            }


        } catch (SQLException ex) {
            Logger.getLogger(DatabaseConnectionManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        return d;
    }

    /**
     * @return the statement
     */
    public Statement getStatement() {
        return statement;
    }

    public Connection getConnection() {
        return this.dbCon;
    }
}
