package jp.osoite.tomu.xml.jaxb.wrapper;

import java.util.ArrayList;
import java.util.List;
import jp.osoite.tomu.xml.jaxb.object.TScanSensorData;
import jp.osoite.tomu.xml.jaxb.object.TomuMessage;

/**
 *
 * @author shima
 */
public class UploadTScanWrapper extends TomuMessageWrapper {

    private List<TScanValue> valueList;

    public UploadTScanWrapper(TomuMessage tomuMsg){
        super(tomuMsg);
        valueList = new ArrayList<TScanValue>();
        List<TScanSensorData> list = tomuMsg.getUpload().getSensorSourceDataSet().getTScanSensorData();
        for(TScanSensorData data : list){
            valueList.add(new TScanValue(data));
        }
    }

    public List<TScanValue> getTScanValueList(){
        return valueList;
    }
}
