package jp.osoite.tomu.xml.jaxb.wrapper;

import jp.osoite.tomu.xml.jaxb.object.StaticSensorData;
import jp.osoite.tomu.xml.jaxb.object.TomuMessage;
import jp.osoite.tomu.xml.jaxb.util.SensorType;

/**
 *
 * @author shima
 */
public class UploadCo2Wrapper extends TomuMessageWrapper {

    private StaticSensorData ssd;

    public UploadCo2Wrapper(TomuMessage msg) {
        super(msg);
        ssd = msg.getUpload().getSensorSourceDataSet().getStaticSensorData().get(0);
    }

    public SensorType getType() {
        return SensorType.CO2;
    }

    public long getSensorId() {
        return ssd.getStaticSensorID().longValue();
    }

    public long getSensedTime() {
        return ssd.getSensedTime().longValue();
    }

    public double getCo2(){
        return ssd.getValue().getCO2Value().doubleValue();
    }
}
