package jp.osoite.tomu.xml.jaxb.wrapper;

import jp.osoite.tomu.xml.jaxb.object.TScanSensorData;

/**
 *
 * @author shima
 */
public class TScanValue {

    private long sensedTime;
    private String tscanId;
    private double temperature;
    private double humidity;
    private int lqi;
    private int voltage;
    private int hashValue = -1;

    TScanValue(TScanSensorData data) {
        sensedTime = data.getSensedTime().longValue();
        tscanId = data.getTScanID();
        temperature = data.getTempValue().doubleValue();
        humidity = data.getHumValue().doubleValue();
        lqi = data.getLqi().intValue();
        voltage = data.getVoltage().intValue();
    }

    public TScanValue(String id, long time, double temp, double humi, int lqi, int vol) {
        tscanId = id;
        sensedTime = time;
        temperature = temp;
        humidity = humi;
        this.lqi = lqi;
    }

    public double getHumidity() {
        return humidity;
    }

    public int getLqi() {
        return lqi;
    }

    public long getSensedTime() {
        return sensedTime;
    }

    public double getTemperature() {
        return temperature;
    }

    public String getTscanId() {
        return tscanId;
    }

    public int getVoltage() {
        return voltage;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof TScanValue)) {
            return false;
        }
        TScanValue val = (TScanValue) obj;
        if (sensedTime != val.sensedTime) {
            return false;
        }
        if (!tscanId.equals(val.tscanId)) {
            return false;
        }
        if (temperature != val.temperature) {
            return false;
        }
        if (humidity != val.humidity) {
            return false;
        }
        if (lqi != val.lqi) {
            return false;
        }
        if (voltage != val.voltage) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = hashValue;
        if (result == -1) {
            result = 17;
            result = 31 * result + (int) (sensedTime ^ (sensedTime >>> 32));
            result = 31 * result + tscanId.hashCode();
            long tempLong = Double.doubleToLongBits(temperature);
            result = 31 * result + (int) (tempLong ^ (tempLong >>> 32));
            tempLong = Double.doubleToLongBits(humidity);
            result = 31 * result + (int) (tempLong ^ (tempLong >>> 32));
            result = 31 * result + lqi;
            result = 31 * result + voltage;
            hashValue = result;
        }
        return result;
    }
}
