package jp.osoite.tomu.xml.jaxb.util.builder;

import jp.osoite.tomu.xml.jaxb.object.TomuMessage;
import jp.osoite.tomu.xml.jaxb.util.InitializeException;
import jp.osoite.tomu.util.TimeConverter;
import jp.osoite.tomu.xml.jaxb.util.TomuMessageType;

/**
 *
 * @author shima
 */
public class UploadTScanBuilder {

    private static final int LEAF_ID_LOWER = 6;
    private static final int LEAF_ID_UPPER = 8;
    private static final int LQI = 12;
    private static final int VOLTAGE = 14;
    private static final int TEMPERATURE_LOWER = 16;
    private static final int TEMPERATURE_UPPER = 18;
    private static final int HUMIDITY_LOWER = 20;
    private static final int HUMIDITY_UPPER = 22;
    private JAXBConstructor cnst;

    /**
     * コンストラクタ
     * @param dest 送信先アドレス
     * @param src 発信元アドレス
     * @param msgId メッセージID
     * @param msgSeq メッセージシーケンス番号
     */
    public UploadTScanBuilder(String dest, String src, long msgId, long msgSeq) {
        cnst = new JAXBConstructor(TomuMessageType.SOURCE_UPLOAD);
        cnst.setHeader(dest, src, msgId);
        cnst.setSequence(msgSeq);
    }

    public void setTScanValue(String pureData) {
        compile(pureData);
    }

    private void compile(String dataLine) {
        int tIndex = dataLine.indexOf("T");
        long sensedTime = 0;
        if (tIndex > -1) {
            sensedTime = TimeConverter.convertToLong(dataLine.substring(tIndex + 1));
        } else {
            sensedTime = System.currentTimeMillis();
        }
        try {
            String leafID = getData(dataLine, LEAF_ID_UPPER);
            leafID = leafID + getData(dataLine, LEAF_ID_LOWER);

            int lqi = Integer.parseInt(getData(dataLine, LQI), 16);
            int vol = Integer.parseInt(getData(dataLine, VOLTAGE), 16);

            String strTemperature = getData(dataLine, TEMPERATURE_UPPER);
            strTemperature = strTemperature + getData(dataLine, TEMPERATURE_LOWER);
            double temp = (Integer.parseInt(strTemperature, 16) - 3960) / 100.0;
            String strHumidity = getData(dataLine, HUMIDITY_UPPER);
            strHumidity = strHumidity + getData(dataLine, HUMIDITY_LOWER);
            int humiTmp = Integer.parseInt(strHumidity, 16);
            double hum = (0.0367 * humiTmp) - (0.0000015955 * humiTmp * humiTmp) - 2.0468;

            cnst.addTScanData(leafID, sensedTime, temp, hum, lqi, vol);
        } catch (Exception e) {
        }
    }

    private String getData(String dataLine, int type) {
        return dataLine.substring(type, type + 2);
    }

    /**
     * TScanアップロード用データのTomuMessageを構築します．
     * @return TomuMessageオブジェクト
     */
    public TomuMessage build() {
        TomuMessage mes = null;
        try {
            mes = cnst.build();
        } catch (InitializeException ex) {
        }
        return mes;
    }
}
