package jp.osoite.tomu.xml.jaxb.util.builder;

import java.util.ArrayList;
import java.util.List;
import jp.osoite.tomu.xml.jaxb.object.Area;
import jp.osoite.tomu.xml.jaxb.object.Location;
import jp.osoite.tomu.xml.jaxb.object.TimeSpan;
import jp.osoite.tomu.xml.jaxb.object.TomuMessage;
import jp.osoite.tomu.xml.jaxb.util.TomuMessageType;

/**
 * Sfeerサーバに対するInitRequestメッセージを構築します．
 * @author shima
 */
public class SfeerInitRequestBuilder {

    private JAXBConstructor cnst;
    private List<Area> areas;

    /**
     * コンストラクタ
     * @param dest 送信先ID
     * @param src 送信元ID
     * @param msgId メッセージID
     */
    public SfeerInitRequestBuilder(String dest, String src, long msgId) {
        cnst = new JAXBConstructor(TomuMessageType.APPS_INIT_REQUEST);
        cnst.setHeader(dest, src, msgId);
        areas = new ArrayList<Area>();
    }

    /**
     * Sfeerサーバ用のInitRequestメッセージを構築します．
     * @return TomuMessageオブジェクト
     */
    public TomuMessage build() {
        cnst.addSfeerInitMessage(areas);
        try {
            return cnst.build();
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * 各エリアの初期化情報を追加します．
     * @param id エリアID
     * @param lat 緯度
     * @param lon 経度
     * @param radius 半径
     * @param begin 開始時刻
     * @param end 末端時刻
     */
    public void addArea(int id, double lat, double lon, int radius, long begin, long end) {
        Location loc = JAXBConstructor.getLocation(lon, lat, radius);
        TimeSpan span = JAXBConstructor.getTimeSpan(begin, end);
        areas.add(JAXBConstructor.getRequestArea(id, loc, span));
    }

}
