package jp.osoite.tomu.xml.jaxb.util.builder;

import java.util.ArrayList;
import java.util.List;
import jp.osoite.tomu.xml.jaxb.util.*;
import java.util.Random;
import jp.osoite.tomu.xml.jaxb.object.*;

/**
 * 適当な値が割り振られたTomuMessageオブジェクトを作成します．
 * @author shima
 */
public final class DummyTomuMessageFactory {

    private static Random random = new Random();

    public enum DummyMessageType {

        TEMP, CO2, PEDESTRIAN, HUMIDITY, IMAGE, RANDOM
    }

    private DummyTomuMessageFactory() {
    }

    private static JAXBConstructor init(TomuMessageType type) {
        JAXBConstructor constructor = new JAXBConstructor(type);
        constructor.setHeader("dest@hoge.com", "src@hoge.com", System.currentTimeMillis());
        constructor.setSequence(System.currentTimeMillis());
        return constructor;
    }

    /**
     * APPS_RESPONSEメッセージを取得します
     * @return TomuMessageメッセージ
     */
    public static TomuMessage getAppsResponse(DummyTomuMessageFactory.DummyMessageType type) {
        try {
            JAXBConstructor constructor = init(TomuMessageType.APPS_RESPONSE);
            switch (type) {
                case TEMP:
                    constructor.addTemperatureData(random.nextDouble(), System.currentTimeMillis(), System.currentTimeMillis());
                    break;
                case CO2:
                    constructor.addCo2Data(random.nextDouble(), System.currentTimeMillis(), System.currentTimeMillis());
                    break;
                case HUMIDITY:
                    constructor.addHumidityData(random.nextDouble(), System.currentTimeMillis(), System.currentTimeMillis());
                    break;
                case PEDESTRIAN:
                    constructor.addStreetPedestrianData(System.currentTimeMillis(), random.nextInt(30), JAXBConstructor.getChief(random.nextInt(360), random.nextInt(20), random.nextDouble(), random.nextInt(360), random.nextInt(20), random.nextDouble()), System.currentTimeMillis(), System.currentTimeMillis());
                    break;
                case IMAGE:
                    constructor.addImageData("Hoge Camera", random.nextInt(360), JAXBConstructor.getLocation(random.nextDouble(), random.nextDouble(), 0), "http://hoge/hoge.jpg", "http://hoge/hoge_thumb.jpg", System.currentTimeMillis());
                    break;
                case RANDOM:
                    setRandomAppsResponse(constructor, random.nextInt(12));
                    break;
            }
            return constructor.build();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static void setRandomAppsResponse(JAXBConstructor constructor, int switchNum) {
        if (0 <= switchNum && switchNum < 4) {
            constructor.addTemperatureData(random.nextDouble(), System.currentTimeMillis(), System.currentTimeMillis());
            constructor.addCo2Data(random.nextDouble(), System.currentTimeMillis(), System.currentTimeMillis());
        } else if (4 <= switchNum && switchNum < 8) {
            constructor.addTemperatureData(random.nextDouble(), System.currentTimeMillis(), System.currentTimeMillis());
            constructor.addStreetPedestrianData(System.currentTimeMillis(), random.nextInt(30), JAXBConstructor.getChief(random.nextInt(360), random.nextInt(20), random.nextDouble(), random.nextInt(360), random.nextInt(20), random.nextDouble()), System.currentTimeMillis(), System.currentTimeMillis());
        } else {
            constructor.addImageData("Hoge Camera", random.nextInt(360), JAXBConstructor.getLocation(random.nextDouble(), random.nextDouble(), 0), "http://hoge/hoge.jpg", "http://hoge/hoge_thumb.jpg", System.currentTimeMillis());
        }
    }

    /**
     * SOURCE_UPLOADメッセージを取得します
     * @return TomuMessageメッセージ
     */
    public static TomuMessage getSourceUpload(DummyTomuMessageFactory.DummyMessageType type) {
        try {
            JAXBConstructor constructor = init(TomuMessageType.SOURCE_UPLOAD);
            switch (type) {
                case TEMP:
                    constructor.addTemperatureData(random.nextDouble(), System.currentTimeMillis(), System.currentTimeMillis());
                    constructor.setFrequency(System.currentTimeMillis());
                    break;
                case PEDESTRIAN:
                    constructor.addStreetPedestrianData(System.currentTimeMillis(), random.nextInt(30), JAXBConstructor.getChief(random.nextInt(360), random.nextInt(20), random.nextDouble(), random.nextInt(360), random.nextInt(20), random.nextDouble()), System.currentTimeMillis(), System.currentTimeMillis());
                    constructor.setFrequency(System.currentTimeMillis());
                    break;
                case HUMIDITY:
                    constructor.addHumidityData(random.nextDouble(), System.currentTimeMillis(), System.currentTimeMillis());
                    constructor.setFrequency(System.currentTimeMillis());
                    break;
                case CO2:
                    constructor.addCo2Data(random.nextDouble(), System.currentTimeMillis(), System.currentTimeMillis());
                    constructor.setFrequency(System.currentTimeMillis());
                    break;
                case IMAGE:
                    return getKitokitoUpload();
                case RANDOM:
                    setRandomSourceUpload(constructor, random.nextInt(12));
                    break;
            }
            return constructor.build();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static void setRandomSourceUpload(JAXBConstructor constructor, int switchNum) {
        if (0 <= switchNum && switchNum < 3) {
            constructor.addTemperatureData(random.nextDouble(), System.currentTimeMillis(), System.currentTimeMillis());
            constructor.setFrequency(System.currentTimeMillis());
        } else if (3 <= switchNum && switchNum < 6) {
            constructor.addStreetPedestrianData(System.currentTimeMillis(), random.nextInt(30), JAXBConstructor.getChief(random.nextInt(360), random.nextInt(20), random.nextDouble(), random.nextInt(360), random.nextInt(20), random.nextDouble()), System.currentTimeMillis(), System.currentTimeMillis());
            constructor.setFrequency(System.currentTimeMillis());
        } else if (6 <= switchNum && switchNum < 9) {
            constructor.addCo2Data(random.nextDouble(), System.currentTimeMillis(), System.currentTimeMillis());
            constructor.setFrequency(System.currentTimeMillis());
        } else {
            constructor.addKitokitoData(System.currentTimeMillis(), random.nextInt(360), JAXBConstructor.getLocation(random.nextDouble(), random.nextDouble(), 0), random.nextInt(1000), "http://hoge/hoge.jpg", "http://hoge/hoge_thumb.jpg", System.currentTimeMillis());
        }
    }

    /**
     * きときとサーバからのSOURCE_UPLOADメッセージを取得します．
     * @return TomuMessageメッセージ
     */
    public static TomuMessage getKitokitoUpload() {
        try {
            JAXBConstructor constructor = init(TomuMessageType.SOURCE_UPLOAD);
            constructor.addKitokitoData(System.currentTimeMillis(), random.nextInt(360), JAXBConstructor.getLocation(random.nextDouble(), random.nextDouble(), 0), random.nextInt(1000), "http://hoge/hoge.jpg", "http://hoge/hoge_thumb.jpg", System.currentTimeMillis());
            return constructor.build();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * SfeerサーバからのAPPS_REQUESTメッセージを取得します．
     * @return TomuMessageメッセージ
     */
    public static TomuMessage getSfeerRequest() {
        try {
            long id = System.currentTimeMillis();
            List<Long> ids = new ArrayList<Long>();
            for (int i = 0; i < 4; i++) {
                ids.add(id + 100 * i);
            }
            Location loc = JAXBConstructor.getLocation(10.1, 20.2, 30);
            List<Location> locationList = new ArrayList<Location>();
            locationList.add(loc);
            TemperatureSet tSet = JAXBConstructor.getTemperatureSet(ids);
            PedestrianSet pSet = JAXBConstructor.getPedestrianSet(ids);
            ImageSet iSet = JAXBConstructor.getImageSet(locationList);
            JAXBConstructor constructor = init(TomuMessageType.APPS_REQUEST);
            constructor.addSfeerServerRequestData(tSet, pSet, iSet);
            return constructor.build();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * SfeerサーバからのAPPS_INIT_REQUESTメッセージを取得します．
     * @param idNum エリアIDの個数
     * @return TomuMessageメッセージ
     */
    public static TomuMessage getSfeerInitRequest(int idNum) {
        try {
            long time = System.currentTimeMillis();
            List<Area> areas = new ArrayList<Area>();
            for (int i = 0; i < idNum; i++) {
                TimeSpan span = JAXBConstructor.getTimeSpan(time, time + 10000);
                Location loc = JAXBConstructor.getLocation(random.nextDouble(), random.nextDouble(), random.nextInt());
                areas.add(JAXBConstructor.getRequestArea(i, loc, span));
            }
            JAXBConstructor constructor = init(TomuMessageType.APPS_INIT_REQUEST);
            constructor.addSfeerInitMessage(areas);
            return constructor.build();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * SfeerサーバからのAPPS_INIT_RESPONSEメッセージを取得します．
     * @param idNum エリアIDの個数
     * @return TomuMessageメッセージ
     */
    public static TomuMessage getSfeerInitResponse(int idNum) {
        try {
            long time = System.currentTimeMillis();
            List<Area> areas = new ArrayList<Area>();
            for (int i = 0; i < idNum; i++) {
                double[] arry = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble()};
                InitTemperature initTemp = JAXBConstructor.getInitTemperature(time, random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble(), JAXBConstructor.getFiveMinuteTempData(arry));
                InitPedestrian initPed = JAXBConstructor.getInitPedestrian(time, random.nextInt(), random.nextInt(), random.nextDouble());
                areas.add(JAXBConstructor.getResponseArea(i, initTemp, initPed));
            }
            JAXBConstructor constructor = init(TomuMessageType.APPS_INIT_RESPONSE);
            constructor.addSfeerInitMessage(areas);
            return constructor.build();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}