/*
 * Decompiled with CFR 0.152.
 */
package jp.osoite.tomu.spot.send;

import com.sun.spot.io.j2me.radiogram.RadiogramConnection;
import com.sun.spot.peripheral.Spot;
import com.sun.spot.sensorboard.EDemoBoard;
import com.sun.spot.sensorboard.io.IScalarInput;
import com.sun.spot.sensorboard.peripheral.ISwitch;
import com.sun.spot.sensorboard.peripheral.ISwitchListener;
import com.sun.spot.sensorboard.peripheral.ITemperatureInput;
import com.sun.spot.sensorboard.peripheral.ITriColorLED;
import com.sun.spot.util.Utils;
import java.io.IOException;
import javax.microedition.io.Connector;
import javax.microedition.io.Datagram;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;
import jp.osoite.tomu.spot.send.AccelerometerSingleton;
import jp.osoite.tomu.spot.send.BatterySingleton;

public class Sender
extends MIDlet
implements ISwitchListener {
    private double PERIOD_SEC = 10.0;
    private boolean isEnagySavingMode = false;
    public static final int MAX_LED_ST = 120;
    public static final int MAX_RAIDO_POWER = 31;
    public static final byte MSG_TYPE = 1;
    private static final int LED_PORT_NUM_SENDING = 5;
    private static final int LED_PORT_NUM_SENDING_E = 1;
    private static final int LED_BLINK_TIMER = 3;
    private static final int RCON_HOST_PORT = 67;
    private ISwitch sw1;
    private ISwitch sw2;
    private ITriColorLED[] leds;
    private RadiogramConnection rCon = null;
    private Datagram dg = null;
    private ITemperatureInput tempSensor;
    private IScalarInput lightSensor;
    private int counter = 0;
    private int skipFlag;
    private boolean sendagain = false;

    private void ledsBlink() {
        this.ledsBlink(120, 120, 120);
    }

    public void ledsBlink(int r, int g, int b) {
        int j;
        if (r > 120 || g > 120 || b > 120) {
            r %= 120;
            g %= 120;
            b %= 120;
        } else if (r < 5 && g < 5 && b < 5) {
            g = 10;
        }
        Utils.sleep((long)5L);
        for (j = 0; j < 7; ++j) {
            this.leds[j].setRGB(r, g, b);
            this.leds[j].setOn();
        }
        Utils.sleep((long)25L);
        for (j = 0; j < 7; ++j) {
            this.leds[j].setOff();
        }
        Utils.sleep((long)25L);
    }

    public void setups() {
        this.leds = EDemoBoard.getInstance().getLEDs();
        this.ledsBlink();
        Spot.getInstance().getRadioPolicyManager().setOutputPower(31);
        try {
            this.monitorSwitches();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.showPeriodinLEDS();
        this.tempSensor = EDemoBoard.getInstance().getADCTemperature();
        this.lightSensor = EDemoBoard.getInstance().getLightSensor();
        try {
            this.rCon = (RadiogramConnection)Connector.open((String)"radiogram://broadcast:67");
            this.dg = this.rCon.newDatagram(this.rCon.getMaximumLength());
        }
        catch (Exception e) {
            System.err.println("Caught " + e + " in connection initialization.");
            System.exit(1);
        }
        int colorR = 0;
        int colorB = 0;
        int colorG = 15;
        this.leds[5].setRGB(colorR, colorG, colorB);
        this.leds[1].setRGB(0, 30, 0);
    }

    protected void startApp() throws MIDletStateChangeException {
        this.setups();
        float moving = 0.0f;
        float movingmin = 0.0f;
        float movingmax = 0.0f;
        float movingPre = 0.0f;
        float battRemain = 0.0f;
        float accelx = 0.0f;
        float accely = 0.0f;
        float accelz = 0.0f;
        float tiltx = 0.0f;
        float tilty = 0.0f;
        float tiltz = 0.0f;
        try {
            accelx = AccelerometerSingleton.getInstance().getAccelX();
            accely = AccelerometerSingleton.getInstance().getAccelY();
            accelz = AccelerometerSingleton.getInstance().getAccelZ();
            tiltx = AccelerometerSingleton.getInstance().getTiltX();
            tilty = AccelerometerSingleton.getInstance().getTiltY();
            tiltz = AccelerometerSingleton.getInstance().getTiltZ();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        String ourAddress = System.getProperty("IEEE_ADDRESS");
        long loopStartTimer = 0L;
        float tempVal = 0.0f;
        float tempValPre = 0.0f;
        int lightVal = 0;
        int lightValPre = 0;
        try {
            tempValPre = this.tempSensor.getValue();
            lightValPre = this.lightSensor.getValue();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        System.out.println("Starting sensor sampler application on " + ourAddress + " ...");
        int dur = 0;
        int PERIOD_SAMPLELING_MILLS = (int)(this.PERIOD_SEC * 1000.0);
        int skiptimer = 0;
        dur = PERIOD_SAMPLELING_MILLS;
        while (true) {
            try {
                while (true) {
                    loopStartTimer = System.currentTimeMillis();
                    lightVal = (this.lightSensor.getValue() + lightValPre) / 2;
                    accelx = AccelerometerSingleton.getInstance().getAccelX();
                    accely = AccelerometerSingleton.getInstance().getAccelY();
                    accelz = AccelerometerSingleton.getInstance().getAccelZ();
                    tiltx = AccelerometerSingleton.getInstance().getTiltX();
                    tilty = AccelerometerSingleton.getInstance().getTiltY();
                    tiltz = AccelerometerSingleton.getInstance().getTiltZ();
                    try {
                        tempVal = (float)this.tempSensor.getCelsius();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    this.skipFlag = 0;
                    if (this.isEnagySavingMode) {
                        moving = 1.0f * this.abs(accelx) + this.abs(accely) + this.abs(accelz) + this.abs(tiltx) + 1.0f * this.abs(tilty) + this.abs(tiltz);
                        if (movingmin > moving) {
                            movingmin = moving;
                        } else if (movingmax < moving) {
                            movingmax = moving;
                        }
                    }
                    if (this.isEnagySavingMode) {
                        if ((double)this.abs(movingmax - movingmin) < 0.025) {
                            this.skipFlag += 100;
                        }
                        if (skiptimer < 10) {
                            this.skipFlag += 5;
                        }
                        if ((double)this.abs(lightVal - lightValPre) < 8.0 || lightVal > 350) {
                            this.skipFlag += 10;
                        }
                        if ((double)this.abs(tempVal - tempValPre) < 0.49 || tempVal > 47.0f) {
                            this.skipFlag += 20;
                        }
                    }
                    System.out.println("skipFlag=" + this.skipFlag);
                    if (this.skipFlag == 135 && !this.sendagain) {
                        this.leds[1].setOn();
                        ++skiptimer;
                        Utils.sleep((long)3L);
                        this.leds[1].setOff();
                    } else {
                        this.leds[5].setOn();
                        if (this.isEnagySavingMode) {
                            movingmin = movingPre;
                            movingmax = movingPre;
                        }
                        battRemain = BatterySingleton.getInstance().getAvailableCapacity();
                        this.dg.reset();
                        this.dg.writeByte(1);
                        this.dg.writeInt(this.counter);
                        ++this.counter;
                        this.dg.writeShort(lightVal);
                        this.dg.writeFloat(battRemain);
                        this.dg.writeFloat(tempVal);
                        this.dg.writeFloat(accelx);
                        this.dg.writeFloat(accely);
                        this.dg.writeFloat(accelz);
                        this.dg.writeFloat(tiltx);
                        this.dg.writeFloat(tilty);
                        this.dg.writeFloat(tiltz);
                        this.dg.writeInt(PERIOD_SAMPLELING_MILLS + skiptimer);
                        try {
                            this.rCon.send(this.dg);
                        }
                        catch (Exception e) {
                            System.err.println("Caught " + e + " while collecting/sending sensor sampling.");
                        }
                        skiptimer = 0;
                        this.sendagain = 0 < this.skipFlag && this.skipFlag < 100;
                        Utils.sleep((long)3L);
                    }
                    this.leds[5].setOff();
                    lightValPre = (lightVal + lightValPre) / 2;
                    tempValPre = tempVal;
                    dur = (int)((long)PERIOD_SAMPLELING_MILLS - (System.currentTimeMillis() - loopStartTimer));
                    if (dur < 250) {
                        System.out.println("the period is too shord to communicate dur" + dur);
                    }
                    if (this.isEnagySavingMode) {
                        PERIOD_SAMPLELING_MILLS = (int)(this.PERIOD_SEC * 1000.0);
                        movingPre = moving;
                    }
                    Utils.sleep((long)dur);
                }
            }
            catch (Exception e) {
                System.err.println("Caught " + e + " while collecting/sending sensor sampling.");
                continue;
            }
            break;
        }
    }

    public void switchPressed(ISwitch sw) {
        int switchNum = sw == this.sw1 ? 1 : 2;
        System.out.println("Switch " + switchNum + " closed.");
        if (sw == this.sw1) {
            if (this.PERIOD_SEC > 0.5) {
                this.PERIOD_SEC -= 0.5;
                this.ledsBlink(120, 0, 0);
            }
        } else {
            this.PERIOD_SEC += 0.5;
            this.ledsBlink(0, 120, 0);
        }
    }

    public void switchReleased(ISwitch sw) {
        int switchNum = sw == this.sw1 ? 1 : 2;
        System.out.println("Switch " + switchNum + " opened.");
    }

    private void showPeriodinLEDS() {
        for (int i = (int)(this.PERIOD_SEC + 0.5); i > 0; --i) {
            this.ledsBlink();
        }
    }

    private float abs(float x) {
        if (x < 0.0f) {
            return x * -1.0f;
        }
        return x;
    }

    private void monitorSwitches() throws IOException {
        this.sw1 = EDemoBoard.getInstance().getSwitches()[0];
        this.sw2 = EDemoBoard.getInstance().getSwitches()[1];
        this.sw1.addISwitchListener((ISwitchListener)this);
        this.sw2.addISwitchListener((ISwitchListener)this);
        System.out.println("Please press switch 1(-) or 2(+) during the next 10 seconds");
        Utils.sleep((long)10000L);
        System.out.println("Time's up.");
        this.sw1.removeISwitchListener((ISwitchListener)this);
        System.out.println("configlation end");
    }

    protected void pauseApp() {
    }

    protected void destroyApp(boolean arg0) throws MIDletStateChangeException {
    }
}

