#include <windows.h>
#include "File.h"

//////////////////////////////////////////////////////////////////////
// dtor
//////////////////////////////////////////////////////////////////////

File::~File()
{
	Close();
}

//////////////////////////////////////////////////////////////////////
// Open
//////////////////////////////////////////////////////////////////////

BOOL File::Open(LPCTSTR pFileName, DWORD nMode, DWORD nShareMode, DWORD nOpenMode)
{
	hFile = CreateFile(pFileName, nMode, nShareMode, NULL, 
						nOpenMode, FILE_ATTRIBUTE_NORMAL, NULL);
	if (hFile == INVALID_HANDLE_VALUE) return FALSE;

	if ((nSize = SetFilePointer(hFile, 0, NULL, FILE_END)) == 0xFFFFFFFF) {
		Close();
		return FALSE;
	}
	if (SetFilePointer(hFile, 0, NULL, FILE_BEGIN) == 0xFFFFFFF) {
		Close();
		return FALSE;
	}
	return TRUE;
}

//////////////////////////////////////////////////////////////////////
// Close
//////////////////////////////////////////////////////////////////////

void File::Close()
{
	if (hFile != INVALID_HANDLE_VALUE) {
		CloseHandle(hFile);
		hFile = INVALID_HANDLE_VALUE;
	}
}

//////////////////////////////////////////////////////////////////////
// Seek
//////////////////////////////////////////////////////////////////////

BOOL File::Seek(DWORD nPos)
{
	if (SetFilePointer(hFile, nPos, NULL, FILE_BEGIN) == 0xFFFFFFFF) return FALSE;
	return TRUE;
}

//////////////////////////////////////////////////////////////////////
// Get file pointer
//////////////////////////////////////////////////////////////////////

DWORD File::CurrentPos()
{
	return SetFilePointer(hFile, 0, NULL, FILE_CURRENT);
}

//////////////////////////////////////////////////////////////////////
// Read file
//////////////////////////////////////////////////////////////////////

BOOL File::Read(LPBYTE pBuf, LPDWORD pSize)
{
	DWORD n = *pSize;
	if (!ReadFile(hFile, pBuf, n, pSize, NULL)) return FALSE;
	return TRUE;
}

//////////////////////////////////////////////////////////////////////
// Write file
//////////////////////////////////////////////////////////////////////

BOOL File::Write(const LPBYTE pBuf, DWORD nSize)
{
	DWORD n;
	if (!WriteFile(hFile, pBuf, nSize, &n, NULL)) return FALSE;
	return TRUE;
}

//////////////////////////////////////////////////////////////////////
// Write string as Unicode
//////////////////////////////////////////////////////////////////////

BOOL File::WriteUnicodeString(LPCWSTR p)
{
	DWORD len = wcslen(p);
	return Write((LPBYTE)p, len * sizeof(WCHAR));
}

//////////////////////////////////////////////////////////////////////
// Set EOF
//////////////////////////////////////////////////////////////////////

BOOL File::SetEOF()
{
	return SetEndOfFile(hFile);
}