/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.io.converters;

import java.sql.Time;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.ddlutils.DdlUtilsException;
import org.apache.ddlutils.io.converters.ConversionException;
import org.apache.ddlutils.io.converters.SqlTypeConverter;

public class TimeConverter
implements SqlTypeConverter {
    private Pattern _timePattern;
    private Calendar _calendar;

    public TimeConverter() {
        try {
            this._timePattern = Pattern.compile("(?:\\d{4}\\-\\d{2}\\-\\d{2}\\s)?(\\d{2})(?::(\\d{2}))?(?::(\\d{2}))?(?:\\..*)?");
        }
        catch (PatternSyntaxException ex) {
            throw new DdlUtilsException(ex);
        }
        this._calendar = Calendar.getInstance();
        this._calendar.setLenient(false);
    }

    @Override
    public Object convertFromString(String textRep, int sqlTypeCode) throws ConversionException {
        if (sqlTypeCode != 92) {
            return textRep;
        }
        if (textRep != null) {
            Matcher matcher = this._timePattern.matcher(textRep);
            int hours = 0;
            int minutes = 0;
            int seconds = 0;
            if (matcher.matches()) {
                int numGroups = matcher.groupCount();
                try {
                    hours = Integer.parseInt(matcher.group(1));
                    if (numGroups >= 2 && matcher.group(2) != null) {
                        minutes = Integer.parseInt(matcher.group(2));
                    }
                    if (numGroups >= 3 && matcher.group(3) != null) {
                        seconds = Integer.parseInt(matcher.group(3));
                    }
                }
                catch (NumberFormatException ex) {
                    throw new ConversionException("Not a valid time : " + textRep, ex);
                }
                this._calendar.clear();
                try {
                    this._calendar.set(11, hours);
                    this._calendar.set(12, minutes);
                    this._calendar.set(13, seconds);
                    return new Time(this._calendar.getTimeInMillis());
                }
                catch (IllegalArgumentException ex) {
                    throw new ConversionException("Not a valid time : " + textRep, ex);
                }
            }
            throw new ConversionException("Not a valid time : " + textRep);
        }
        return null;
    }

    @Override
    public String convertToString(Object obj, int sqlTypeCode) throws ConversionException {
        String result = null;
        if (obj != null) {
            if (!(obj instanceof Time)) {
                throw new ConversionException("Expected object of type java.sql.Time, but instead received " + obj.getClass().getName());
            }
            result = obj.toString();
        }
        return result;
    }
}

