/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.io;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ddlutils.dynabean.SqlDynaBean;
import org.apache.ddlutils.dynabean.SqlDynaClass;
import org.apache.ddlutils.io.ConverterConfiguration;
import org.apache.ddlutils.io.DataWriterException;
import org.apache.ddlutils.io.DdlUtilsXMLException;
import org.apache.ddlutils.io.PrettyPrintingXmlWriter;
import org.apache.ddlutils.io.converters.ConversionException;
import org.apache.ddlutils.io.converters.SqlTypeConverter;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Table;

public class DataWriter
extends PrettyPrintingXmlWriter {
    private static final int MAX_ATTRIBUTE_LENGTH = 255;
    private final Log _log = LogFactory.getLog(DataWriter.class);
    private ConverterConfiguration _converterConf = new ConverterConfiguration();

    public DataWriter(OutputStream output) throws DataWriterException {
        this(output, "UTF-8");
    }

    public DataWriter(OutputStream output, String encoding) throws DataWriterException {
        super(output, encoding);
    }

    public DataWriter(Writer output, String encoding) throws DataWriterException {
        super(output, encoding);
    }

    @Override
    protected void throwException(Exception baseEx) throws DdlUtilsXMLException {
        throw new DataWriterException(baseEx);
    }

    public ConverterConfiguration getConverterConfiguration() {
        return this._converterConf;
    }

    @Override
    public void writeDocumentStart() throws DdlUtilsXMLException {
        super.writeDocumentStart();
        this.writeElementStart(null, "data");
        this.printlnIfPrettyPrinting();
    }

    @Override
    public void writeDocumentEnd() throws DdlUtilsXMLException {
        this.writeElementEnd();
        this.printlnIfPrettyPrinting();
        super.writeDocumentEnd();
    }

    public void write(SqlDynaBean bean) throws DataWriterException {
        SqlDynaClass dynaClass = (SqlDynaClass)bean.getDynaClass();
        Table table = dynaClass.getTable();
        HashMap<String, String> subElements = new HashMap<String, String>();
        try {
            this.indentIfPrettyPrinting(1);
            this.writeElementStart(null, table.getName());
            int idx = 0;
            while (idx < table.getColumnCount()) {
                Column column = table.getColumn(idx);
                Object value = bean.get(column.getName());
                SqlTypeConverter converter = this._converterConf.getRegisteredConverter(table, column);
                String valueAsText = null;
                if (converter == null) {
                    if (value != null) {
                        valueAsText = value.toString();
                    }
                } else {
                    valueAsText = converter.convertToString(value, column.getTypeCode());
                }
                if (valueAsText != null) {
                    if (valueAsText.length() > 255 || this.analyzeText(valueAsText, null)) {
                        subElements.put(column.getName(), valueAsText);
                    } else {
                        this.writeAttribute(null, column.getName(), valueAsText);
                    }
                }
                ++idx;
            }
            if (!subElements.isEmpty()) {
                ArrayList cutPoints = new ArrayList();
                for (Map.Entry entry : subElements.entrySet()) {
                    String content = entry.getValue().toString();
                    this.printlnIfPrettyPrinting();
                    this.indentIfPrettyPrinting(2);
                    this.writeElementStart(null, entry.getKey().toString());
                    cutPoints.clear();
                    boolean writeBase64Encoded = this.analyzeText(content, cutPoints);
                    if (writeBase64Encoded) {
                        this.writeAttribute(null, "base64", "true");
                        try {
                            this.writeCData(new String(Base64.encodeBase64((byte[])content.getBytes()), this.getEncoding()));
                        }
                        catch (UnsupportedEncodingException ex) {
                            throw new DataWriterException(ex);
                        }
                    } else if (cutPoints.isEmpty()) {
                        this.writeCData(content);
                    } else {
                        int lastPos = 0;
                        Iterator cutPointIt = cutPoints.iterator();
                        while (cutPointIt.hasNext()) {
                            int curPos = (Integer)cutPointIt.next();
                            this.writeCData(content.substring(lastPos, curPos));
                            lastPos = curPos;
                        }
                        if (lastPos < content.length()) {
                            this.writeCData(content.substring(lastPos));
                        }
                    }
                    this.writeElementEnd();
                }
                this.printlnIfPrettyPrinting();
                this.indentIfPrettyPrinting(1);
            }
            this.writeElementEnd();
            this.printlnIfPrettyPrinting();
        }
        catch (ConversionException ex) {
            throw new DataWriterException((Throwable)((Object)ex));
        }
    }

    private boolean analyzeText(String text, List cutPoints) {
        ArrayList<Integer> tmpCutPoints = cutPoints == null ? null : new ArrayList<Integer>();
        int numChars = text.length();
        int numFoundCDataEndChars = 0;
        int charPos = 0;
        while (charPos < numChars) {
            char c = text.charAt(charPos);
            if (c < ' ' && c != '\n' && c != '\r' && c != '\t') {
                return true;
            }
            if (cutPoints != null) {
                if (c == ']' && (numFoundCDataEndChars == 0 || numFoundCDataEndChars == 1)) {
                    ++numFoundCDataEndChars;
                } else if (c == '>' && numFoundCDataEndChars == 2) {
                    tmpCutPoints.add(new Integer(charPos));
                    numFoundCDataEndChars = 0;
                } else {
                    numFoundCDataEndChars = 0;
                }
            }
            ++charPos;
        }
        if (cutPoints != null) {
            cutPoints.addAll(tmpCutPoints);
        }
        return false;
    }

    public void write(Iterator beans) throws DataWriterException {
        while (beans.hasNext()) {
            DynaBean bean = (DynaBean)beans.next();
            if (bean instanceof SqlDynaBean) {
                this.write((SqlDynaBean)bean);
                continue;
            }
            this._log.warn((Object)("Cannot write normal dyna beans (type: " + bean.getDynaClass().getName() + ")"));
        }
    }

    public void write(Collection beans) throws DataWriterException {
        this.write(beans.iterator());
    }
}

