/*
 * VacationList.h - TaskJuggler
 *
 * Copyright (c) 2001, 2002, 2003, 2004 by Chris Schlaeger <cs@kde.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * $Id$
 */

#ifndef _VacationList_h_
#define _VacationList_h_

#include <q3ptrlist.h>
//Added by qt3to4:
#include <Q3PtrCollection>

#include "VacationInterval.h"

class Interval;

/**
 * @short A list of vacations.
 * @author Chris Schlaeger <cs@kde.org>
 */
class VacationList : public Q3PtrList<VacationInterval>
{
public:
    VacationList() { setAutoDelete(true); }
    virtual ~VacationList() {}

    typedef Q3PtrListIterator<VacationInterval> Iterator;

    void add(const QString& name, const Interval& i);
    void add(VacationInterval* vi);
    bool isVacation(time_t date) const;
    const QString vacationName(time_t date) const;

protected:
    virtual int compareItems(Q3PtrCollection::Item i1, Q3PtrCollection::Item i2);
} ;

#endif
