/*
 * Copyright (c) 2007, 2008 University of Tsukuba
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the University of Tsukuba nor the names of its
 *    contributors may be used to endorse or promote products derived from
 *    this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
/*
 * Copyright (c) 2010-2012 Yuichi Watanabe
 */

#include <core/initfunc.h>
#include <core/msg.h>
#include <core/spinlock.h>
#include <core/printf.h>
#include "constants.h"
#include "current.h"
#include "panic.h"
#include "process.h"
#include "thread.h"
#include "vmmcall.h"

static volatile int send, receive;
static spinlock_t dbgsh_lock = SPINLOCK_INITIALIZER;
static spinlock_t dbgsh_lock2 = SPINLOCK_INITIALIZER;
static bool stopped;
static tid_t tid;
static bool initialized;

static int
dbgsh_ttyin_msghandler (int m, int c)
{
	int tmp;

	if (m == 0) {
	retry:
		send = 0;
		while (receive == -1 || send != -1) {
			spinlock_lock (&dbgsh_lock2);
			stopped = true;
			thread_will_stop ();
			spinlock_unlock (&dbgsh_lock2);
			schedule ();
		}
		tmp = receive;
		receive = -1;
		if (tmp == 0)
			goto retry;
		return tmp;
	}
	return 0;
}

static int
dbgsh_ttyout_msghandler (int m, int c)
{
	if (m == 0) {
		if (c == 0)
			c = ' ';
		send = c;
		while (receive == -1 || send != -1) {
			spinlock_lock (&dbgsh_lock2);
			stopped = true;
			thread_will_stop ();
			spinlock_unlock (&dbgsh_lock2);
			schedule ();
		}
		receive = -1;
	}
	return 0;
}

static void
dbgsh_thread (void *arg)
{
	int shell, ttyin, ttyout;

	msgregister ("dbgsh_ttyin", dbgsh_ttyin_msghandler);
	msgregister ("dbgsh_ttyout", dbgsh_ttyout_msghandler);
	ttyin = msgopen ("dbgsh_ttyin");
	ttyout = msgopen ("dbgsh_ttyout");
	for (;;) {
		shell = newprocess ("shell");
		if (ttyin < 0 || ttyout < 0 || shell < 0)
			panic ("dbgsh_thread");
		msgsenddesc (shell, ttyin);
		msgsenddesc (shell, ttyout);
		msgsendint (shell, 0);
		msgclose (shell);
		schedule ();
	}
}

static void
dbgsh (void)
{
	ulong rbx;
	int input;

	spinlock_lock (&dbgsh_lock);
	if (!initialized) {
		tid = thread_new (dbgsh_thread, NULL, PAGESIZE);
		initialized = true;
	}
	spinlock_unlock (&dbgsh_lock);
	current->vmctl.read_general_reg (GENERAL_REG_RBX, &rbx);
	input = (int)rbx;
	if (input != -1) {
		receive = input;
		send = -1;
		spinlock_lock (&dbgsh_lock2);
		if (stopped)
			thread_wakeup (tid);
		spinlock_unlock (&dbgsh_lock2);
	}
	current->vmctl.write_general_reg (GENERAL_REG_RAX, (ulong)send);
}

static void
vmmcall_dbgsh_init (void)
{
	send = receive = -1;
	initialized = false;
	stopped = false;
	vmmcall_register ("dbgsh", dbgsh);
}

INITFUNC ("vmmcal0", vmmcall_dbgsh_init);
