/*
 * Copyright (c) 2011 Yuichi Watanabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of Yuichi Watanabe nor the names of its
 *    contributors may be used to endorse or promote products derived from
 *    this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
/*
 * Copyright (c) 2010-2012 Yuichi Watanabe
 */

#ifndef _CORE_APIC_H
#define _CORE_APIC_H

#include <core/cpu.h>
#include <core/types.h>
#include <io/io.h>
#include "pcpu.h"

#define apic_g2v(gphys) \
	(void *)((char *)apic_virt_base + ((gphys) - APIC_BASE_ADDRESS))

extern void *apic_virt_base;

static inline void
apic_write32(phys_t offset, u32 val)
{
	write32(apic_virt_base + offset, val);
}

static inline u32
apic_read32(phys_t offset)
{
	return read32(apic_virt_base + offset);
}

void apic_send_init(apic_id_t dest);
void apic_wait_for_idle(void);
apic_id_t apic_read_id(void);
void apic_start_ap(phys_t apinit_addr);
void apic_broadcast_nmi(void);
bool apic_check_apic_interrupt(vector_t vector);
void apic_write_eoi(void);
u32 apic_read_icrh(void);
void apic_send_ipi(vector_t vector, apic_id_t dest);

#endif
