/*
 * Copyright (c) 2007, 2008 University of Tsukuba
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the University of Tsukuba nor the names of its
 *    contributors may be used to endorse or promote products derived from
 *    this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
/*
 * Copyright (c) 2010-2012 Yuichi Watanabe
 */

#ifndef __CORE_TYPES_H
#define __CORE_TYPES_H

#define NULL			((void *)0)

typedef signed char		i8;
typedef signed short int	i16;
typedef signed int		i32;
typedef signed long long int	i64;
typedef unsigned char		u8;
typedef unsigned short int	u16;
typedef unsigned int		u32;
typedef unsigned long long int	u64;
typedef volatile unsigned char		vu8;
typedef volatile unsigned short int	vu16;
typedef volatile unsigned int		vu32;
typedef volatile unsigned long long int	vu64;
typedef unsigned int		uint;
typedef unsigned long int	ulong;
typedef ulong			virt_t;
typedef u32			phys32_t;
typedef u64			phys_t;
typedef u64			size_t;
typedef u64			off_t;
typedef u16			ioport_t;
typedef enum {
	false = 0,
	true = 1,
} bool;
union mem {
	u8 byte;
	u16 word;
	u32 dword;
	u64 qword;
};

typedef union {
	u8 byte;
	u16 word;
	u32 dword;
	u64 qword;
	u8 bytes[8];
	u16 words[4];
	u32 dwords[2];
} core_mem_t;

#endif
