package net.takemix.testok.activity;

import net.takemix.testok.PFConstants;
import net.takemix.testok.R;
import net.takemix.testok.Testok;
import net.takemix.testok.db.TestokDataBaseHelper.QuestionType;
import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.Window;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemSelectedListener;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.TextView;

public class SettingStudyActivity extends Activity implements OnItemSelectedListener, View.OnClickListener {
    private static final String TAG = "SettingStudyActivity";

    private Testok testok;

    private Spinner sQuestionType;
    private EditText etMaxLv;
    private EditText etMinLv;
    private EditText etTime;
    private EditText etQuestionCount;
    private Button bStart;
    private ArrayAdapter<QuestionType> myQTAdapter;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        Log.i(TAG, "onCreate - IN");

        requestWindowFeature(Window.FEATURE_NO_TITLE);
        setContentView(R.layout.settingstudy);

        testok = (Testok)getApplication();

        this.myQTAdapter = new ArrayAdapter<QuestionType>(this, android.R.layout.simple_spinner_item);
        this.myQTAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        this.myQTAdapter.add(QuestionType.QT_READING_INCOMPLETE_SENTENCES);
        this.myQTAdapter.add(QuestionType.QT_EXTRA_FLASHCARD);

        this.sQuestionType = (Spinner)findViewById(R.id.settingstudy_questionTypeSpinner);
        this.sQuestionType.setAdapter(this.myQTAdapter);
        this.sQuestionType.setOnItemSelectedListener(this);

        this.etMaxLv = (EditText)findViewById(R.id.settingstudy_maxLevelEditText);
        this.etMaxLv.setText(this.testok.level.getMaxLevel().toString());
        this.etMinLv = (EditText)findViewById(R.id.settingstudy_minLevelEditText);
        this.etMinLv.setText(this.testok.level.getMinLevel().toString());
        this.etTime = (EditText)findViewById(R.id.settingstudy_timeEditText);
        this.etMaxLv.setText(this.testok.studyTime.toString());
        this.etQuestionCount = (EditText)findViewById(R.id.settingstudy_questionCountEditText);

        this.bStart = (Button)findViewById(R.id.startSettingStudyButton);
        this.bStart.setOnClickListener(this);
        this.bStart.setText(R.string.settingstudy_button);

        TextView tv;
        tv = (TextView)findViewById(R.id.settingstudy_questionTypeTextView);
        tv.setText(R.string.settingstudy_type);
        tv = (TextView)findViewById(R.id.settingstudy_levelTextView);
        tv.setText(R.string.settingstudy_level);
        tv = (TextView)findViewById(R.id.settingstudy_timeTextView);
        tv.setText(R.string.settingstudy_time);
        tv = (TextView)findViewById(R.id.settingstudy_questionCountTextView);
        tv.setText(R.string.settingstudy_count);
        tv = (TextView)findViewById(R.id.settingstudy_markTextView);
        tv.setText(R.string.settingstudy_mark);

        Log.i(TAG, "onCreate - OUT");
    }

    public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
    }

    public void onNothingSelected(AdapterView<?> arg0) {
    }

    public void onClick(View v) {
        if(v == this.bStart) {
            Log.i(TAG, "onClick - IN [bStart]");

            int maxLv;
            int minLv;
            int time;
            int count;
            try {
                maxLv = Integer.valueOf(this.etMaxLv.getText().toString());
            } catch (NumberFormatException nfe) {
                maxLv = PFConstants.maxLevel;
            }
            try {
                minLv = Integer.valueOf(this.etMinLv.getText().toString());
            } catch (NumberFormatException nfe) {
                minLv = PFConstants.minLevel;
            }
            try {
                time = Integer.valueOf(this.etTime.getText().toString());
            } catch (NumberFormatException nfe) {
                time = -1;
            }
            try {
                count = Integer.valueOf(this.etQuestionCount.getText().toString());
            } catch (NumberFormatException nfe) {
                count = -1;
            }

            this.testok.setQuestionPref(
                    (QuestionType)this.sQuestionType.getSelectedItem(),
                    maxLv,
                    minLv,
                    time,
                    count);

            Intent intent = new Intent(getApplicationContext(), net.takemix.testok.activity.QuestionActivity.class);
            startActivity(intent);

            finish();
        }
        Log.i(TAG, "onClick - OUT");
    }
}
