/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.validation.springmodules;

import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.ValidatorResources;

import jp.terasoluna.fw.validation.springmodules.CommonsValidatorEx;
import jp.terasoluna.fw.validation.springmodules.DefaultBeanValidatorEx;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.validation.springmodules.DefaultBeanValidatorEx}
 * NX̃eXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * Spring-ModulesDefaultBeanValidatorۃNXB
 * <p>
 * 
 * @see jp.terasoluna.fw.validation.springmodules.DefaultBeanValidatorEx
 */
public class DefaultBeanValidatorExTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * 
     * @param args
     *            java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(DefaultBeanValidatorExTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception
     *             ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception
     *             ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name
     *            ̃eXgP[X̖OB
     */
    public DefaultBeanValidatorExTest(String name) {
        super(name);
    }

    /**
     * testCleanupValidator01() <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FA,E <br>
     * <br>
     * ͒lF() validator:CommonsValidatorExCX^X<br>
     * (O) validator.getValidatorException():ValidatorExceptionCX^X<br>
     * 
     * <br>
     * ҒlF(ԕω) O:ValidatorExceptioniterasoluna-spring-validator)<br>
     * EO]ValidatorException(commons)<br>
     * 
     * <br>
     * validatorValidatorExceptionݒ肳ĂꍇA^COɃbvăX[邱Ƃ̃eXgB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testCleanupValidator01() throws Exception {
        // O
        ValidatorResources resources = new ValidatorResources();
        CommonsValidatorEx commonsValidatorEx = new CommonsValidatorEx(
                resources, null);
        ValidatorException validatorException = new ValidatorException();
        UTUtil.setPrivateField(commonsValidatorEx, "validatorException",
                validatorException);

        DefaultBeanValidatorEx defaultBeanValidatorEx = new DefaultBeanValidatorEx();
        try {
            // eXg{
            defaultBeanValidatorEx.cleanupValidator(commonsValidatorEx);
            fail();
        } catch (jp.terasoluna.fw.validation.springmodules.ValidatorException e) {
            // 
            assertSame(validatorException, e.getCause());
        }
    }

    /**
     * testCleanupValidator02() <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FA,E <br>
     * <br>
     * ͒lF() validator:CommonsValidatorExCX^X<br>
     * (O) validator.getValidatorException():null<br>
     * 
     * <br>
     * ҒlF <br>
     * validatorValidatorExceptionݒ肳ĂȂꍇAOX[ɏI邱Ƃ̃eXgB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testCleanupValidator02() throws Exception {
        // O
        ValidatorResources resources = new ValidatorResources();
        CommonsValidatorEx commonsValidatorEx = new CommonsValidatorEx(
                resources, null);
        UTUtil.setPrivateField(commonsValidatorEx, "validatorException", null);

        DefaultBeanValidatorEx defaultBeanValidatorEx = new DefaultBeanValidatorEx();
        try {
            // eXg{
            defaultBeanValidatorEx.cleanupValidator(commonsValidatorEx);
        } catch (jp.terasoluna.fw.validation.springmodules.ValidatorException e) {
            // 
            fail();
        }
    }

    /**
     * testCleanupValidator03() <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FA,E <br>
     * <br>
     * ͒lF() validator:CommonsValidatorExȊÕCX^X<br>
     * 
     * <br>
     * ҒlF <br>
     * validatorvalidatorCommonsValidatorExCX^XłȂꍇAOX[ɏI邱Ƃ̃eXgB
     * <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testCleanupValidator03() throws Exception {
        // O
        ValidatorResources resources = new ValidatorResources();
        Validator validator = new Validator(resources);

        DefaultBeanValidatorEx defaultBeanValidatorEx = new DefaultBeanValidatorEx();
        try {

            defaultBeanValidatorEx.cleanupValidator(validator);
        } catch (jp.terasoluna.fw.validation.springmodules.ValidatorException e) {
            // 
            fail();
        }
    }

}
