/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.taglib;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * <p>
 *  tH[}bgďóA邢̓XNveBOϐƂĒ`
 *  JX^^O߂̒ۊNXB
 *  </p>
 * <p>
 *  ̐؂oAg̃tH[}bgsJX^^ÕNX
 *  ̊NXpč쐬B(<code>TERASOLUNA</code> ̒񋟂
 *  <code>fmtx</code> JX^^OCu)
 * </p>
 * <p>
 *  ̃NXɂătH[}bgꂽ񂪁AX|X֏o͂
 *  ̂A邢̓XNveBOϐɃZbĝ̈Ⴂ́A
 *  <code>id</code> ̗LŌ肳B
 * </p>
 * <p>
 *  tH[}bgΏۂƂȂ镶́Aȉ̗D揇Ō肳B
 * </p>
 * <ol>
 *  <li><code>value</code> w肳Ăꍇɂ́A
 *      ̎w肳ꂽtH[}bgB
 *  <li><code>name</code>  <code>bean</code>w肳Ăꍇɂ́A
 *      ̎w肳ꂽ <code>bean</code> ̃CX^X́A
 *      <code>property</code> Ŏw肳ꂽvpeBtH[}bgB
 * </ol>
 * <p>
 *  A<code>name</code> w肳ĂƂɁA
 *  <code>property</code> w肳ĂȂꍇɂ́A<code>name</code>
 *  ŎCX^X̒li<code>toString()</code> \bh
 *  ԂIuWFNg̕\jAtH[}bg̑ΏۂƂȂB
 * </p>
 * <p>
 *  <code>name</code> Ŏw肳ꂽ <code>bean</code> ȂƂ
 *  JX^^O̓́A<code>ignore</code> ɂČ肳B
 *  <code>ignore</code> truełꍇɂ́A
 *  <code>bean</code> ȂƂɂ͒PɖAo͂Ȃ
 *  i<code>id</code> w肳Ăꍇɂ́AXNveBOϐ
 *  ZbgȂjB
 * </p>
 * <p>
 *  <code>ignore</code> falseiftHgjłꍇɂ́A
 *  <code>name</code> w肳ꂽbeanȂƂɂ
 *  <code>JspException</code> B
 * </p>
 * <p>
 *  <code>bean</code> ̌ΏۂƂāA<code>scope</code>
 *  w肷邱ƂłB
 *  <code>scope</code> w肵Ȃꍇɂ́A
 *  <code>javax.servlet.jsp.PageContext</code> NX
 *  <code>findAttribute()</code> \bȟŌB
 * </p>
 * <p>
 *  <code>id</code> w肳ꂽꍇɂ́AtH[}bgꂽo
 *  ɁA<code>id</code> Ŏw肳ꂽϐ̃XNveBOϐɃZbg
 *  B
 * </p>
 * <p>
 *  <code>filter</code>  <code>true</code>iftHgj
 *  Ƃɂ́Ao͂ۂɁA<code>HTML</code> ꕶi
 *  <code>org.apache.struts.util.ResponceUtils</code> NX
 *  <code>filter()</code> \bhŏ́B
 *  u&lt;vAu&gt;vAu&amp;vAu&quot;v̂S)GXP[vB
 *  XNveBOϐɃZbgꍇɂ́A<code>filter</code> ͖
 *  AtH[}bgꂽ񂪂̂܂܃XNveBOϐɃZbg
 *  B
 * </p>
 * <p>
 *  <code>replaceSpToNbsp</code><code>true</code>iftHgj
 *  Ƃɂ́Ao͂ۂɁA1ByteR[h̃Xy[XipXy[Xj
 *  ݂ꍇu&amp;nbsp;vɕϊB
 *  XNveBOϐɃZbgꍇɂ́A<code>replaceSpToNbsp</code> ͖
 *  AtH[}bgꂽ񂪂̂܂܃XNveBOϐɃZbg
 *  
 * </p>
 * <p>
 *  {@link StringFormatterTagBase} NXpTuNXł́A
 *  ۂɕ̃tH[}bgsۃ\bh <code>doFormat()</code>
 *  B
 * </p>
 *
 * <br>
 *
 * <h5>^OT|[g鑮</h5>
 * <p>
 *  <code>StringFormatterTagBase</code> ł́Aȉ̑T|[gB
 * </p>
 * <div align="center">
 *  <table width="90%" border="1">
 *   <tr>
 *    <td> <b></b> </td>
 *    <td> <b>ftHg</b> </td>
 *    <td> <b>K{</b> </td>
 *    <td> <b>s</b> </td>
 *    <td> <b>Lq</b> </td>
 *   </tr>
 *   <tr>
 *    <td> id </td>
 *    <td> - </td>
 *    <td> C </td>
 *    <td> false </td>
 *    <td align="left">
 *     tH[}bgo͂ɁAXNveBOϐ
 *     ɃZbgۂɎw肷BtH[}bgꂽXNveBO
 *     ϐɃZbgꍇɂ́A<code>filter</code> ̎wɊւ炸HTML
 *     ꕶ̓GXP[vȂB
 *    </td>
 *   </tr>
 *   <tr>
 *    <td> filter </td>
 *    <td>true</td>
 *    <td> - </td>
 *    <td> C </td>
 *    <td align="left">
 *     tH[}bgꂽo͂ۂɁA<code>HTML</code> ꕶ
 *     GXP[v邩ǂw肷BA<code>id</code> 
 *     w肳Ăꍇɂ́AB
 *    </td>
 *   </tr>
 *   <tr>
 *    <td> ignore </td>
 *    <td>false</td>
 *    <td> - </td>
 *    <td> C </td>
 *    <td align="left">
 *     <code>name</code> Ŏw肵 bean
 *     ȂƂɖ邩ǂw肷B<code>false</code> 
 *     w肷ƁA<code>bean</code> ȂƂ
 *     <code>JspException</code>B
 *    </td>
 *   </tr>
 *   <tr>
 *    <td> name </td>
 *    <td> - </td>
 *    <td> - </td>
 *    <td> C </td>
 *    <td align="left">
 *     tH[}bgΏۂ̕vpeBɎ
 *     <code>bean</code> ̖OB<code>property</code> w肳
 *     ȂƂɂ́A<code>name</code> Ŏw肳ꂽCX^X
 *     \ <code>toString()</code> \bhŕԂ镶j
 *     tH[}bg̑ΏۂƂȂB<code>value</code>
 *     w肳Ăꍇɂ́AB
 *    </td>
 *   </tr>
 *   <tr>
 *    <td> property </td>
 *    <td> - </td>
 *    <td> - </td>
 *    <td> C </td>
 *    <td align="left"><code>name</code> Ŏw肳ꂽ <code>bean</code>
 *     ɂăANZXvpeB̖OB<code>value</code> 
 *     w肳Ăꍇɂ͖B
 *    </td>
 *   </tr>
 *   <tr>
 *    <td> scope </td>
 *    <td>i<code>findAttribute()</code>\bȟj</td>
 *    <td> - </td>
 *    <td> C </td>
 *    <td align="left"><code>name</code> Ŏw肳ꂽ <code>bean</code>
 *     ۂ̃XR[vB
 *    </td>
 *   </tr>
 *   <tr>
 *    <td> value </td>
 *    <td>Ȃ</td>
 *    <td> - </td>
 *    <td> C </td>
 *    <td align="left">tH[}bg镶B<code>value</code> 
 *     w肵ꍇɂ́A<code>name</code> A <code>property</code>
 *     ͖B
 *    </td>
 *   </tr>
 *   <tr>
 *    <td> <code>replaceSpToNbsp</code> </td>
 *    <td> - </td>
 *    <td> <code>false</code> </td>
 *    <td> <code>true</code> </td>
 *    <td align="left">
 *     ̑trueɃZbgA
 *     w肵beanvpeB̒l1ByteR[h̃Xy[X݂ꍇ
 *     <code>&amp;nbsp;</code>ɒuB
 *     ɂ邽߂ɂ́ȂɖI false ZbgKvB
 *     A<code>id</code> w肳Ăꍇɂ́AB
 *     </td>
 *   </tr>
 *  </table>
 * </div>
 *
 * <br>
 *
 * <h5>JX^^ÕXNveBOϐ</h5>
 * <p>
 *  <code>StringFormatterTagBase</code> ł͈ȉ̕ϐT|[gB
 * </p>
 * <div align="center">
 * <table width="90%" border="1">
 *  <tr>
 *   <td> <b>XNveBOϐ</b> </td>
 *   <td> <b>^</b> </td>
 *   <td> <b>ϐ̗p\͈</b> </td>
 *   <td> <b>Lq</b> </td>
 *  </tr>
 *  <tr>
 *   <td>JX^^O<code>id</code>Ŏw肳ꂽO</td>
 *   <td><code>java.lang.String</code></td>
 *   <td>Jn^Oȍ~</td>
 *   <td align="left">
 *    ̃JX^^Oŏo͂AXNveBOϐ ݒ肷ꍇ̕ϐB
 *   </td>
 *  </tr>
 * </table>
 * </div>
 *
 * @see jp.terasoluna.fw.web.taglib.LeftTag
 * @see jp.terasoluna.fw.web.taglib.RTrimTag
 * @see jp.terasoluna.fw.web.taglib.LTrimTag
 * @see jp.terasoluna.fw.web.taglib.TrimTag
 *
 */
public abstract class StringFormatterTagBase extends TagSupport {

    /**
     * ONX
     */
    private static Log log = LogFactory.getLog(StringFormatterTagBase.class);
    
    /**
     * ̃y[Wŗpł悤ɂ邽߂̃XNveBOϐ̖OB
     *
     */
    protected String id = null;

    /**
     * XNveBOϐ̖O擾B
     *
     * @return XNveBOϐ
     */
    @Override
    public String getId() {
        return this.id;
    }

    /**
     * XNveBOϐ̖Oݒ肷B
     *
     * @param id XNveBOϐ
     */
    @Override
    public void setId(String id) {
        this.id = id;
    }

    /**
     * o͒HTMLꕶtB^[邩ǂBftHgtrueB
     *
     */
    protected boolean filter = true;

    /**
     * o͒HTMLꕶtB^[邩ǂ擾B
     *
     * @return o͒HTMLꕶtB^[ꍇtrue
     */
    public boolean getFilter() {
        return this.filter;
    }

    /**
     * o͒HTMLꕶtB^[邩ǂݒ肷B
     *
     * @param filter o͒HTMLꕶtB^[ꍇtrue
     */
    public void setFilter(boolean filter) {
        this.filter = filter;
    }

    /**
     * beanȂƂɁAPɖio͂ȂjǂB
     * Ȃꍇɂ́AO𓊂BftHgfalseiO𓊂jB
     */
    protected boolean ignore = false;

    /**
     * beanȂꍇɖ邩ǂ擾B
     *
     * @return ꍇtrue
     */
    public boolean getIgnore() {
        return this.ignore;
    }

    /**
     * beanȂꍇɖ邩ǂݒ肷B
     *
     * @param ignore ꍇtrue
     */
    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    /**
     * tH[}bgΏۂ̃f[^܂bean̖OB
     *
     */
    protected String name = null;

    /**
     * tH[}bgΏۂ̃f[^܂bean̖O擾B
     *
     * @return bean̖O
     */
    public String getName() {
        return this.name;
    }

    /**
     * tH[}bgΏۂ̃f[^܂bean̖Oݒ肷B
     *
     * @param name bean̖O
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * w肳ꂽbeanɂăANZXvpeB̖OB
     *
     */
    protected String property = null;

    /**
     * w肳ꂽbeanɂăANZXvpeB擾B
     *
     * @return vpeB
     */
    public String getProperty() {
        return this.property;
    }

    /**
     * w肳ꂽbeanɂăANZXvpeBݒ肷B
     *
     * @param property vpeB
     */
    public void setProperty(String property) {
        this.property = property;
    }

    /**
     * w肳ꂽbeanXR[v
     *
     */
    protected String scope = null;

    /**
     * w肳ꂽbeanXR[v擾B
     *
     * @return XR[v
     */
    public String getScope() {
        return this.scope;
    }

    /**
     * w肳ꂽbeanXR[vݒ肷B
     *
     * @param scope XR[v
     */
    public void setScope(String scope) {
        this.scope = scope;
    }

    /**
     * tH[}bgΏۂ̒lij
     *
     */
    protected String value = null;

    /**
     * tH[}bgΏۂ̒l擾B
     *
     * @return tH[}bgΏۂ̒l
     */
    public String getValue() {
        return this.value;
    }

    /**
     * tH[}bgΏۂ̒lݒ肷B
     *
     * @param value tH[}bgΏۂ̒l
     */
    public void setValue(String value) {
        this.value = value;
    }

    /**
     * <p>
     *  pXy[X <code>&amp;nbsp;</code> ƒuB
     * </p>
     */
    protected boolean replaceSpToNbsp = true;

    /**
     * <p>
     *  <code>replaceSpToNbsp</code>  <code>get</code> \bh
     * </p>
     *
     * @return replaceSpToNbsp
     *   pXy[X <code>&amp;nbsp;</code> ϊtO
     */
    public boolean getReplaceSpToNbsp() {
        return this.replaceSpToNbsp;
    }

    /**
     * <p>
     *  <code>replaceSpToNbsp</code>  <code>set</code> \bh
     * </p>
     *
     * @param replaceSpToNbsp
     *   pXy[X <code>&amp;nbsp;</code> ϊtO
     */
    public void setReplaceSpToNbsp(boolean replaceSpToNbsp) {
        this.replaceSpToNbsp = replaceSpToNbsp;
    }

    /**
     * ^O]JnɌĂ΂郁\bhB
     *
     * @return w
     * @throws JspException ^O]ɃG[
     */
    @Override
    public int doStartTag() throws JspException {

        Object value = this.value;
        if (value == null) {
            // beanȂĂꍇɂ́AvꂽbeanbNAbv
            // Ȃꍇɂ́A^[
            if (ignore) {
                if (TagUtil.lookup(pageContext, name, scope) == null) {
                    return SKIP_BODY;  // o͂Ȃ
                }
            }

            // vꂽvpeB̒lbNAbv
            value = TagUtil.lookup(pageContext, name, property, scope);
            if (value == null) {
                return SKIP_BODY;  // o͂Ȃ
            }
        }

        // tH[}bg
        String output = doFormat(value.toString());

        if (id != null) {
            // idw肳ĂƂɂ́AXNveBOϐƂėpł
            // 悤Ƀy[WXR[vɃZbgB
            pageContext.setAttribute(id, output);
        } else {
            // idw肳ĂȂƂɂ́AvpeB̒lC^Ƀvg
            // BK؂ɃtB^B
            if (filter) {
                output = TagUtil.filter(output);
            }

            // pXy[X&nbsp;ɒu
            StringReader sr = null;
            BufferedReader br = null;
            String line = null;
            try {
                sr = new StringReader(output);
                br = new BufferedReader(sr);
                StringBuilder sbuf = new StringBuilder();
                StringBuilder strBuf = new StringBuilder();
                int index = 0;
                while ((line = br.readLine()) != null) {
                     // pXy[X&nbsp;ɒu
                    if (replaceSpToNbsp && !"".equals(line)) {
                        strBuf.setLength(0);
                        char ch = line.charAt(0);
                        int i = 0;
                        for (i = 0; i < line.length(); i++) {
                            ch = line.charAt(i);
                            // pXy[XłꍇA"&nbsp;"ɕϊ܂B
                            if (ch == ' ') {
                                strBuf.append("&nbsp;");
                            } else {
                                strBuf.append(ch);
                            }
                        }
                        line = strBuf.toString();
                    }
                    sbuf.append(line);
                    ++index;
                }
                output = sbuf.toString();
            } catch (IOException e) {
                if (log.isWarnEnabled()) {
                    log.warn("StringReader IO error : " + e);
                }
            } finally {
                if (sr != null) {
                    sr.close();
                }
                try {
                    if (br != null) {
                        br.close();
                    }
                } catch (IOException e1) {
                    if (log.isWarnEnabled()) {
                        log.warn("StringReader close error : " + e1);
                    }
                }
            }

            TagUtil.write(pageContext, output);
        }

        return SKIP_BODY;
    }

    /**
     * ׂẴAP[gꂽ
     */
    @Override
    public void release() {
        super.release();
        id = null;
        filter = true;
        ignore = false;
        name = null;
        property = null;
        scope = null;
        value = null;
        replaceSpToNbsp = true;
    }

    /**
     * ̃tH[}bgsۃ\bhB
     * TuNXŃI[o[ChB
     *
     * @param s tH[}bgΏە
     * @return tH[}bgꂽ
     */
    protected abstract String doFormat(String s);

}
