/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.taglib;

/**
 * <p>
 *  ̍[w肳ꂽ̕؂o <code>left</code>
 *  ^O̎NXB
 * </p>
 *
 * <p>
 *  {@link jp.terasoluna.fw.util.StringUtil} NX
 * <code>substring()</code> \bhɂāA̍[w肳ꂽ
 * ؂oB
 * </p>
 *
 * <br>
 *
 * <h5>^OT|[g鑮</h5>
 * <p> {@link StringFormatterTagBase} QƁB</p>
 *
 * <br>
 *
 * <h5>JX^^ÕXNveBOϐ</h5>
 * <p>
 *  {@link StringFormatterTagBase} QƁB<br>
 *  ȉÃNXŒǉꂽXNveBOϐ
 * </p>
 *
 * <p><div align="center">
 * <table width="90%" border="1">
 *  <tr>
 *   <th></th>
 *   <th>ftHg</th>
 *   <th>s</th>
 *   <th>Lq</th>
 *  </tr>
 *  <tr>
 *   <td> length </td>
 *   <td> - </td>
 *   <td> <code>true</code> </td>
 *   <td align="left">
 *    tH[}bgΏۂ̕񂩂؂oB
 *   </td>
 *  </tr>
 * </table>
 * </div></p>
 *
 * <br>
 *
 * <h5>gp@</h5>
 * <p>
 *  <code>&quot;form0001&quot;</code> bean
 *  <code>&quot;field001&quot;</code> vpeB̒lAT؂o
 *  o͂ɂ́Aȉ̂悤ɋLqB
 * </p>
 *
 * <p><code><pre>
 *  &lt;t:left name="form0001"
 *             property="field001"
 *             length="5" /&gt;
 * </pre></code></p>
 *
 * <p>
 *  L beañvpeBAJX^^Oŏo͂ɃXNveBOϐ
 *  <code>&quot;cut&quot;</code>փZbgꍇɂ́Aȉ̂悤ɋLqB
 * </p>
 *
 * <p><code><pre>
 *  &lt;t:left id="cut"
 *             name="form0001"
 *             property="field001"
 *             length="5" /&gt;
 * </pre></code></p>
 *
 * <p>
 *  w蕶؂oƂȂ镶AbeanoɁA
 *  JX^^O <code>value</code>
 *  ɂĎw肷ꍇɂ́Aȉ̂悤ɋLqB
 * </p>
 *
 * <p><code><pre>
 *  &lt;t:left value="w蕶؂oO̕  "
 *             length="5" /&gt;
 * </pre></code></p>
 *
 * @see jp.terasoluna.fw.web.taglib.StringFormatterTagBase
 *
 */
public class LeftTag extends StringFormatterTagBase {

    /**
     * VAo[WID
     */
    private static final long serialVersionUID = 220591418239073704L;

    /**
     * ؂o̒B
     *
     */
    protected int length = 0;

    /**
     * ؂o̒擾B
     *
     * @return ؂o̒
     */
    public int getLength() {
        return this.length;
    }

    /**
     * ؂o̒ݒ肷B
     *
     * @param length ؂o̒
     */
    public void setLength(int length) {
        this.length = length;
    }

    /**
     * ׂẴAP[gꂽB
     */
    @Override
    public void release() {
        super.release();
        length = 0;
    }

    /**
     * w肳ꂽ̍[ <code>lenth</code> Ŏw肳ꂽ
     * 擾B
     *
     * @param s tH[}bgΏۂ̕
     * @return ؂oꂽ
     */
    @Override
    protected String doFormat(String s) {
        return s.length() > length ? s.substring(0, length) : s;
    }

}
