/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.plugins;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Map;

import javax.servlet.ServletException;

import jp.terasoluna.fw.service.thin.BLogicIO;
import jp.terasoluna.fw.service.thin.BLogicProperty;
import jp.terasoluna.fw.service.thin.BLogicResources;
import jp.terasoluna.fw.util.ClassLoadException;
import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

import org.apache.commons.digester.xmlrules.XmlLoadException;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.impl.ModuleConfigImpl;
import org.xml.sax.SAXException;

/**
 * {@link jp.terasoluna.fw.web.struts.plugins.BLogicIOPlugIn} NX
 * ubN{bNXeXgB
 *
 * <p>
 * <h4>yNX̊Tvz</h4>
 * rWlXWbNo͂̐ݒ[hvOCB <br>
 * StrutsPlugIn@\gpAT[ubgɃrWlXWbNo͂
 * ݒǂݍ݁AT[ubgReLXgɕۑB<br>
 * <br>
 * OF<br>
 * init()\bh́AinitResources()AinitParser()̎B<br>
 * OŎw肷xmlt@Ci[Ă邱ƂOłB<br>
 * ܂AServletAModuleConfigƂ̑̃W[
 * nullł邱Ƃ͂肦ȂB
 * <p>
 *
 * @see jp.terasoluna.fw.web.struts.plugins.BLogicIOPlugIn
 */
public class BLogicIOPlugInTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     *
     * @param args
     *            java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(BLogicIOPlugInTest.class);
    }

    /**
     * BLogicIOPlugInB
     */
    private BLogicIOPlugIn plugin = null;

    /**
     * sB
     *
     * @throws Exception
     *             ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();

        // BLogicIOPlugInCX^X
        plugin = new BLogicIOPlugIn();

        UTUtil.setPrivateField(BLogicIOPlugIn.class, "digester", null);
    }

    /**
     * IsB
     *
     * @throws Exception
     *             ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     *
     * @param name
     *            ̃eXgP[X̖OB
     */
    public BLogicIOPlugInTest(String name) {
        super(name);
    }

    /**
     * testInit01()
     * <br><br>
     *
     *  (ُn)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() servlet:not null<br>
     *         () config:W[()=""<br>
     *         () rulesiDigester[t@Cj:null<br>
     *         () blogic-ioiƖWbNo͏}bsO`t@Cj:"BLogicIOPlugInTest-blogic-io.xml"<br>
     *         () mapperStriƖWbNo͏񔽉fNXj:null<br>
     *         () digester:null<br>
     *
     * <br>
     * ҒlF(ԕω) O:ServletException<br>
     *                    bvOFXmlLoadException<br>
     *                    ftHg̃[t@C݂ȂׁAO<br>
     *         (ԕω) O:O<br>
     *                    G[OF""<br>
     *                    OFXmlLoadException<br>
     *         (ԕω) digesterRules:"/WEB-INF/blogic-io-rules.xml"<br>
     *
     * <br>
     * Digester̃[t@Cw肳ĂȂꍇAT[ubgReLXg̃\[Xɂ̓ftHg̃[t@Co^Ă邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testInit01() throws Exception {
        // eXgf[^ݒ
        // BLogic`̃[t@C
        UTUtil.setPrivateField(plugin, "digesterRules", null);
        // BLogic`t@C
        UTUtil.setPrivateField(plugin, "resources", BLogicIOPlugInTest.class
                .getResource("BLogicIOPlugInTest-blogic-io.xml").getPath());

        // }bp[NX
        UTUtil.setPrivateField(plugin, "mapperStr", null);

        // ANVT[ubg쐬
        BLogicIOPlugIn_ActionServletStub01 servlet = new BLogicIOPlugIn_ActionServletStub01();

        // W[ݒ
        ModuleConfig config = new ModuleConfigImpl("");

        // eXgs
        try {
            plugin.init(servlet, config);
            fail();
        } catch (ServletException e) {
            // eXgʊmF
            assertEquals(XmlLoadException.class.getName(), e.getRootCause()
                    .getClass().getName());
            assertEquals("/WEB-INF/blogic-io-rules.xml", UTUtil
                    .getPrivateField(plugin, "digesterRules"));
            assertTrue(LogUTUtil.checkError("", e.getRootCause()));
            // T[ubgReLXgɓo^Ă郊\[X
            // ftHg̃[t@Cł邱ƁB
            BLogicIOPlugIn_MockServletContextStub01 ctx = (BLogicIOPlugIn_MockServletContextStub01) servlet
                    .getServletContext();
            assertEquals("/WEB-INF/blogic-io-rules.xml", ctx
                    .getCalledResources());

        }
    }

    /**
     * testInit02()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() servlet:not null<br>
     *         () config:W[()=""<br>
     *         () rulesiDigester[t@Cj:""(󕶎)<br>
     *         () blogic-ioiƖWbNo͏}bsO`t@Cj:"BLogicIOPlugInTest-blogic-io.xml"<br>
     *         () mapperStriƖWbNo͏񔽉fNXj:null<br>
     *         () digester:null<br>
     *
     * <br>
     * ҒlF(ԕω) O:ServletException<br>
     *                    bvOFXmlLoadException<br>
     *         (ԕω) O:O<br>
     *                    G[OF""<br>
     *                    OFXmlLoadException<br>
     *
     * <br>
     * [t@C󕶎̏ꍇAServletExceptionX[邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testInit02() throws Exception {
        // eXgf[^ݒ
        // W[ݒ
        ModuleConfig config = new ModuleConfigImpl("");
        // BLogic`̃[t@C
        UTUtil.setPrivateField(plugin, "digesterRules", "");
        // BLogic`t@C
        UTUtil.setPrivateField(plugin, "resources", BLogicIOPlugInTest.class
                .getResource("BLogicIOPlugInTest-blogic-io.xml").getPath());
        // }bp[NX
        UTUtil.setPrivateField(plugin, "mapperStr", null);

        // ANVT[ubg쐬
        BLogicIOPlugIn_ActionServletStub01 servlet = new BLogicIOPlugIn_ActionServletStub01();

        // eXgs
        try {
            plugin.init(servlet, config);
            fail();
        } catch (ServletException e) {
            // eXgʊmF
            assertEquals(XmlLoadException.class.getName(), e.getRootCause()
                    .getClass().getName());
            assertTrue(LogUTUtil.checkError("", e.getRootCause()));
        }
    }

    /**
     * testInit03()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() servlet:not null<br>
     *         () config:W[()=""<br>
     *         () rulesiDigester[t@Cj:"/nothing.xml"i݂Ȃ[t@Cj<br>
     *         () blogic-ioiƖWbNo͏}bsO`t@Cj:"BLogicIOPlugInTest-blogic-io.xml"<br>
     *         () mapperStriƖWbNo͏񔽉fNXj:null<br>
     *         () digester:null<br>
     *
     * <br>
     * ҒlF(ԕω) O:ServletException<br>
     *                    bvOFXmlLoadException<br>
     *         (ԕω) O:O<br>
     *                    G[OF""<br>
     *                    OFXmlLoadException<br>
     *
     * <br>
     * ݂Ȃ[t@Cw肳ĂꍇAServletExceptionX[邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testInit03() throws Exception {
        // eXgf[^ݒ
        // W[ݒ
        ModuleConfig config = new ModuleConfigImpl("");
        // BLogic`̃[t@C
        UTUtil.setPrivateField(plugin, "digesterRules", "/nothing.xml");
        // BLogic`t@C
        UTUtil.setPrivateField(plugin, "resources", BLogicIOPlugInTest.class
                .getResource("BLogicIOPlugInTest-blogic-io.xml").getPath());
        // }bp[NX
        UTUtil.setPrivateField(plugin, "mapperStr", null);

        // ANVT[ubg쐬
        BLogicIOPlugIn_ActionServletStub01 servlet = new BLogicIOPlugIn_ActionServletStub01();

        // eXgs
        try {
            plugin.init(servlet, config);
            fail();
        } catch (ServletException e) {
            // eXgʊmF
            assertEquals(XmlLoadException.class.getName(), e.getRootCause()
                    .getClass().getName());
            assertTrue(LogUTUtil.checkError("", e.getRootCause()));
        }
    }

    /**
     * testInit04()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() servlet:not null<br>
     *         () config:W[()=""<br>
     *         () rulesiDigester[t@Cj:"BLogicIOPlugInTest-blogic-io-empty.xml"ip[XG[t@Cj<br>
     *         () blogic-ioiƖWbNo͏}bsO`t@Cj:"BLogicIOPlugInTest-blogic-io.xml"<br>
     *         () mapperStriƖWbNo͏񔽉fNXj:null<br>
     *         () digester:null<br>
     *
     * <br>
     * ҒlF(ԕω) O:ServletException<br>
     *                    bvOFXmlLoadException<br>
     *         (ԕω) O:O<br>
     *                    G[OF""<br>
     *                    OFXmlLoadException<br>
     *
     * <br>
     * p[XG[郋[t@Cw肳ꂽꍇAServletExceptionX[邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testInit04() throws Exception {
        // eXgf[^ݒ
        // W[ݒ
        ModuleConfig config = new ModuleConfigImpl("");

        // p[XG[𔭐t@Cirulesł͂Ȃj
        UTUtil.setPrivateField(plugin, "digesterRules",
                BLogicIOPlugInTest.class.getResource(
                        "BLogicIOPlugInTest-blogic-io-empty.xml").getPath());
        // BLogic`t@C
        UTUtil.setPrivateField(plugin, "resources", BLogicIOPlugInTest.class
                .getResource("BLogicIOPlugInTest-blogic-io.xml").getPath());
        // }bp[NX
        UTUtil.setPrivateField(plugin, "mapperStr", null);

        // ANVT[ubg쐬
        BLogicIOPlugIn_ActionServletStub01 servlet = new BLogicIOPlugIn_ActionServletStub01();

        // eXgs
        try {
            plugin.init(servlet, config);
            fail();
        } catch (ServletException e) {
            // eXgʊmF
            assertEquals(XmlLoadException.class.getName(), e.getRootCause()
                    .getClass().getName());
            assertTrue(LogUTUtil.checkError("", e.getRootCause()));
        }
    }

    /**
     * testInit05()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() servlet:not null<br>
     *         () config:W[()=""<br>
     *         () rulesiDigester[t@Cj:"BLogicIOPlugInTest-blogic-io-rules.xml"<br>
     *         () blogic-ioiƖWbNo͏}bsO`t@Cj:"BLogicIOPlugInTest-blogic-io.xml"<br>
     *         () mapperStriƖWbNo͏񔽉fNXj:null<br>
     *         () digester:parse()\bhIOExceptionX[Digester<br>
     *
     * <br>
     * ҒlF(ԕω) O:ServletException<br>
     *                    bvOFIOException<br>
     *         (ԕω) O:O<br>
     *                    G[OF""<br>
     *                    OFIOException<br>
     *
     * <br>
     * IOExceptionꍇAServletExceptionŃbvăX[邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testInit05() throws Exception {
        // eXgf[^ݒ
        // W[ݒ
        ModuleConfig config = new ModuleConfigImpl("");

        // BLogic`[t@C
        UTUtil.setPrivateField(plugin, "digesterRules",
                BLogicIOPlugInTest.class.getResource(
                        "BLogicIOPlugInTest-blogic-io-rules.xml").getPath());
        // BLogic`t@C
        UTUtil.setPrivateField(plugin, "resources", BLogicIOPlugInTest.class
                .getResource("BLogicIOPlugInTest-blogic-io.xml").getPath());
        // }bp[NX
        UTUtil.setPrivateField(plugin, "mapperStr",
                "jp.terasoluna.fw.web.struts.plugins"
                        + ".BLogicIOPlugIn_BLogicMapperStub01");
        UTUtil.setPrivateField(plugin, "mapperStr", null);

        // ANVT[ubg쐬
        BLogicIOPlugIn_ActionServletStub01 servlet = new BLogicIOPlugIn_ActionServletStub01();

        // Digester쐬iIOExceptionj
        BLogicIOPlugIn_DigesterStub01 digester = new BLogicIOPlugIn_DigesterStub01();
        UTUtil.setPrivateField(BLogicIOPlugIn.class, "digester", digester);

        // eXgs
        try {
            plugin.init(servlet, config);
            fail();
        } catch (ServletException e) {
            // eXgʊmF
            assertEquals(IOException.class.getName(), e.getRootCause()
                    .getClass().getName());
            assertTrue(LogUTUtil.checkError("", e.getRootCause()));
        }
    }

    /**
     * testInit06()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() servlet:not null<br>
     *         () config:W[()=""<br>
     *         () rulesiDigester[t@Cj:"BLogicIOPlugInTest-blogic-io-rules.xml"<br>
     *         () blogic-ioiƖWbNo͏}bsO`t@Cj:"BLogicIOPlugInTest-blogic-io.xml"<br>
     *         () mapperStriƖWbNo͏񔽉fNXj:null<br>
     *         () digester:null<br>
     *
     * <br>
     * ҒlF(ԕω) resources:T[ubgReLXgBLOGIC_RESOURCESL[ɂBLogicResourcesCX^Xi[邱ƁB<br>
     *         (ԕω) mapper:T[ubgReLXgBLOGIC_MAPPERL[ɂBLogicMapperCX^Xi[邱ƁB<br>
     *
     * <br>
     * }bp[NXnull̎AftHg̃}bp[NX"jp.terasoluna.fw.service.thin.BLogicMapper"̃CX^X邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testInit06() throws Exception {
        // eXgf[^ݒ
        // W[ݒ
        ModuleConfig config = new ModuleConfigImpl("");

        // BLogic`[t@C
        UTUtil.setPrivateField(plugin, "digesterRules",
                BLogicIOPlugInTest.class.getResource(
                        "BLogicIOPlugInTest-blogic-io-rules.xml").getPath());
        // BLogic`t@C
        UTUtil.setPrivateField(plugin, "resources", BLogicIOPlugInTest.class
                .getResource("BLogicIOPlugInTest-blogic-io.xml").getPath());
        // }bp[NX
        UTUtil.setPrivateField(plugin, "mapperStr", null);

        // ANVT[ubg쐬
        BLogicIOPlugIn_ActionServletStub01 servlet = new BLogicIOPlugIn_ActionServletStub01();

        // eXgs
        plugin.init(servlet, config);

        // T[ubgReLXg擾
        BLogicIOPlugIn_MockServletContextStub01 ctx = (BLogicIOPlugIn_MockServletContextStub01) servlet
                .getServletContext();

        // T[ubgReLXgɃftHgBLogicMapperCX^X
        // i[Ă邱
        assertEquals("jp.terasoluna.fw.service.thin.BLogicMapper",
                ctx.getAttribute("BLOGIC_MAPPER").getClass().getName());

        // T[ubgReLXgBLogicResourcesCX^X
        // i[Ă邱
        assertTrue(ctx.getAttribute("BLOGIC_RESOURCES") instanceof BLogicResources);

        // T[ubgReLXgɓo^Ă郊\[X
        // w肵[t@Cł邱ƁB
        assertEquals(BLogicIOPlugInTest.class.getResource(
                "BLogicIOPlugInTest-blogic-io-rules.xml").getPath(), ctx
                .getCalledResources());
    }

    /**
     * testInit07()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() servlet:not null<br>
     *         () config:W[()=""<br>
     *         () rulesiDigester[t@Cj:"BLogicIOPlugInTest-blogic-io-rules.xml"<br>
     *         () blogic-ioiƖWbNo͏}bsO`t@Cj:"BLogicIOPlugInTest-blogic-io.xml"<br>
     *         () mapperStriƖWbNo͏񔽉fNXj:BLogicMapperpX^uwF<br>
     *                "jp.terasoluna.fw.web.struts.plugins.BLogicMapperStub"<br>
     *         () digester:null<br>
     *
     * <br>
     * ҒlF(ԕω) resources:T[ubgReLXgBLOGIC_RESOURCESL[ɂBLogicResourcesCX^Xi[邱ƁB<br>
     *         (ԕω) mapper:T[ubgReLXgBLOGIC_MAPPERL[ɂBLogicMapperStubCX^Xi[邱ƁB<br>
     *
     * <br>
     * }bp[NXBLogicMapperpNX̎ÃNX̃CX^XServletContextɓo^Ă邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testInit07() throws Exception {
        // eXgf[^ݒ
        // W[ݒ
        ModuleConfig config = new ModuleConfigImpl("");

        // BLogic`[t@C
        UTUtil.setPrivateField(plugin, "digesterRules",
                BLogicIOPlugInTest.class.getResource(
                        "BLogicIOPlugInTest-blogic-io-rules.xml").getPath());
        // BLogic`t@C
        UTUtil.setPrivateField(plugin, "resources", BLogicIOPlugInTest.class
                .getResource("BLogicIOPlugInTest-blogic-io.xml").getPath());
        // }bp[NX
        UTUtil.setPrivateField(plugin, "mapperStr",
                "jp.terasoluna.fw.web.struts.plugins"
                        + ".BLogicIOPlugIn_BLogicMapperStub01");

        // ANVT[ubg쐬
        BLogicIOPlugIn_ActionServletStub01 servlet = new BLogicIOPlugIn_ActionServletStub01();

        // eXgs
        plugin.init(servlet, config);

        // T[ubgReLXg擾
        BLogicIOPlugIn_MockServletContextStub01 ctx = (BLogicIOPlugIn_MockServletContextStub01) servlet
                .getServletContext();

        // T[ubgReLXgɃvOCŎw肵
        // BLogicMapperpCX^Xi[Ă邱
        assertEquals("jp.terasoluna.fw.web.struts.plugins"
                + ".BLogicIOPlugIn_BLogicMapperStub01", ctx.getAttribute(
                "BLOGIC_MAPPER").getClass().getName());

        // T[ubgReLXgBLogicResourcesCX^X
        // i[Ă邱
        assertTrue(ctx.getAttribute("BLOGIC_RESOURCES") instanceof BLogicResources);

        // T[ubgReLXgɓo^Ă郊\[X
        // w肵[t@Cł邱ƁB
        assertEquals(BLogicIOPlugInTest.class.getResource(
                "BLogicIOPlugInTest-blogic-io-rules.xml").getPath(), ctx
                .getCalledResources());
    }

    /**
     * testInit08()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() servlet:not null<br>
     *         () config:W[()=""<br>
     *         () rulesiDigester[t@Cj:"BLogicIOPlugInTest-blogic-io-rules.xml"<br>
     *         () blogic-ioiƖWbNo͏}bsO`t@Cj:"BLogicIOPlugInTest-blogic-io.xml"<br>
     *         () mapperStriƖWbNo͏񔽉fNXj:BLogicMapperAAbstractBLogicMapperpĂȂNXw<br>
     *         () digester:null<br>
     *
     * <br>
     * ҒlF(ԕω) O:ServletException<br>
     *                    bvOFClassCastException<br>
     *         (ԕω) O:O<br>
     *                    G[OF""<br>
     *                    OFClassCastException<br>
     *
     * <br>
     * }bp[NXBLogicMapperAAbstractBLogicMapperpNXłȂAServletExceptionX[邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testInit08() throws Exception {
        // eXgf[^ݒ
        // W[ݒ
        ModuleConfig config = new ModuleConfigImpl("");

        // BLogic`[t@C
        UTUtil.setPrivateField(plugin, "digesterRules",
                BLogicIOPlugInTest.class.getResource(
                        "BLogicIOPlugInTest-blogic-io-rules.xml").getPath());
        // BLogic`t@C
        UTUtil.setPrivateField(plugin, "resources", BLogicIOPlugInTest.class
                .getResource("BLogicIOPlugInTest-blogic-io.xml").getPath());
        // }bp[NX(BLogicMapperNXł͂Ȃj
        UTUtil.setPrivateField(plugin, "mapperStr",
                "jp.terasoluna.fw.web.struts.plugins."
                        + "BLogicIOPlugIn_BLogicMapperStub02");

        // ANVT[ubg쐬
        BLogicIOPlugIn_ActionServletStub01 servlet = new BLogicIOPlugIn_ActionServletStub01();

        // eXgs
        try {
            plugin.init(servlet, config);
            fail();
        } catch (ServletException e) {
            // eXgʊmF
            assertEquals(ClassCastException.class.getName(), e.getRootCause()
                    .getClass().getName());
            assertTrue(LogUTUtil.checkError("", e.getRootCause()));
        }
    }

    /**
     * testInit09()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() servlet:not null<br>
     *         () config:W[()=""<br>
     *         () rulesiDigester[t@Cj:"BLogicIOPlugInTest-blogic-io-rules.xml"<br>
     *         () blogic-ioiƖWbNo͏}bsO`t@Cj:"BLogicIOPlugInTest-blogic-io.xml"<br>
     *         () mapperStriƖWbNo͏񔽉fNXj:݂ȂNXw<br>
     *         () digester:null<br>
     *
     * <br>
     * ҒlF(ԕω) O:ServletException<br>
     *                    bvOFClassLoadException<br>
     *         (ԕω) O:O<br>
     *                    G[OF""<br>
     *                    OFClassLoadException<br>
     *
     * <br>
     * ݂Ȃ}bp[NXw肵ꍇAServletExceptionX[邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testInit09() throws Exception {
        // eXgf[^ݒ
        // W[ݒ
        ModuleConfig config = new ModuleConfigImpl("");

        // BLogic`[t@C
        UTUtil.setPrivateField(plugin, "digesterRules",
                BLogicIOPlugInTest.class.getResource(
                        "BLogicIOPlugInTest-blogic-io-rules.xml").getPath());
        // BLogic`t@C
        UTUtil.setPrivateField(plugin, "resources", BLogicIOPlugInTest.class
                .getResource("BLogicIOPlugInTest-blogic-io.xml").getPath());
        // }bp[NX(݂ȂNXj
        UTUtil.setPrivateField(plugin, "mapperStr", "nothing.NothingClass");

        // ANVT[ubg쐬
        BLogicIOPlugIn_ActionServletStub01 servlet = new BLogicIOPlugIn_ActionServletStub01();

        // eXgs
        try {
            plugin.init(servlet, config);
            fail();
        } catch (ServletException e) {
            // eXgʊmF
            assertEquals(ClassLoadException.class.getName(), e.getRootCause()
                    .getClass().getName());
            assertTrue(LogUTUtil.checkError("", e.getRootCause()));
        }
    }

    /**
     * testInit10()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() servlet:not null<br>
     *         () config:W[()=""<br>
     *         () rulesiDigester[t@Cj:"BLogicIOPlugInTest-blogic-io-rules.xml"<br>
     *         () blogic-ioiƖWbNo͏}bsO`t@Cj:"BLogicIOPlugInTest-blogic-io.xml"<br>
     *         () mapperStriƖWbNo͏񔽉fNXj:""(󕶎)<br>
     *         () digester:null<br>
     *
     * <br>
     * ҒlF(ԕω) O:ServletException<br>
     *                    bvOFClassLoadException<br>
     *         (ԕω) O:O<br>
     *                    G[OF""<br>
     *                    OFClassLoadException<br>
     *
     * <br>
     * }bp[NX󕶎̎AServletExceptionX[邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testInit10() throws Exception {
        // eXgf[^ݒ
        // W[ݒ
        ModuleConfig config = new ModuleConfigImpl("");

        // BLogic`[t@C
        UTUtil.setPrivateField(plugin, "digesterRules",
                BLogicIOPlugInTest.class.getResource(
                        "BLogicIOPlugInTest-blogic-io-rules.xml").getPath());
        // BLogic`t@C
        UTUtil.setPrivateField(plugin, "resources", BLogicIOPlugInTest.class
                .getResource("BLogicIOPlugInTest-blogic-io.xml").getPath());
        // }bp[NX(󕶎j
        UTUtil.setPrivateField(plugin, "mapperStr", "");

        // ANVT[ubg쐬
        BLogicIOPlugIn_ActionServletStub01 servlet = new BLogicIOPlugIn_ActionServletStub01();

        // eXgs
        try {
            plugin.init(servlet, config);
            fail();
        } catch (ServletException e) {
            // eXgʊmF
            assertEquals(ClassLoadException.class.getName(), e.getRootCause()
                    .getClass().getName());
            assertTrue(LogUTUtil.checkError("", e.getRootCause()));
        }
    }

    /**
     * testInit11()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() servlet:not null<br>
     *         () config:W[()=""<br>
     *         () rulesiDigester[t@Cj:"BLogicIOPlugInTest-blogic-io-rules.xml"<br>
     *         () blogic-ioiƖWbNo͏}bsO`t@Cj:null<br>
     *         () mapperStriƖWbNo͏񔽉fNXj:null<br>
     *         () digester:null<br>
     *
     * <br>
     * ҒlF(ԕω) O:ServletException<br>
     *                    bZ[WF"resources file location is not specified"<br>
     *         (ԕω) O:O<br>
     *                    G[OF"resources file location is not specified"<br>
     *
     * <br>
     * ƖWbNo͏}bsO`t@Cw肳ĂȂꍇAServletExceptionX[邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testInit11() throws Exception {
        // eXgf[^ݒ
        // W[ݒ
        ModuleConfig config = new ModuleConfigImpl("");

        // BLogic`[t@C
        UTUtil.setPrivateField(plugin, "digesterRules",
                BLogicIOPlugInTest.class.getResource(
                        "BLogicIOPlugInTest-blogic-io-rules.xml").getPath());
        // BLogic`t@C(null)
        UTUtil.setPrivateField(plugin, "resources", "");
        // }bp[NX
        UTUtil.setPrivateField(plugin, "mapperStr", null);

        // ANVT[ubg쐬
        BLogicIOPlugIn_ActionServletStub01 servlet = new BLogicIOPlugIn_ActionServletStub01();

        // eXgs
        try {
            plugin.init(servlet, config);
            fail();
        } catch (IllegalArgumentException e) {
            // eXgʊmF
            // bZ[WmF
            assertEquals("errors.resources.file", e
                    .getMessage());
            assertTrue(LogUTUtil
                    .checkError("resources file location is not specified"));
           }
    }

    /**
     * testInit12()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() servlet:not null<br>
     *         () config:W[()=""<br>
     *         () rulesiDigester[t@Cj:"BLogicIOPlugInTest-blogic-io-rules.xml"<br>
     *         () blogic-ioiƖWbNo͏}bsO`t@Cj:"nothing.xml"(݂Ȃt@C)<br>
     *         () mapperStriƖWbNo͏񔽉fNXj:null<br>
     *         () digester:null<br>
     *
     * <br>
     * ҒlF(ԕω) O:ServletException<br>
     *                    bvOFMalformedURLException<br>
     *         (ԕω) O:O<br>
     *                    G[OF""<br>
     *                    OFMalformedURLException<br>
     *
     * <br>
     * ݂ȂƖWbNo͏}bsO`t@Cw肳ĂꍇAServletExceptionX[邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testInit12() throws Exception {
        // eXgf[^ݒ
        // W[ݒ
        ModuleConfig config = new ModuleConfigImpl("");

        // BLogic`[t@C
        UTUtil.setPrivateField(plugin, "digesterRules",
                BLogicIOPlugInTest.class.getResource(
                        "BLogicIOPlugInTest-blogic-io-rules.xml").getPath());
        // BLogic`t@C(݂Ȃt@C)
        UTUtil.setPrivateField(plugin, "resources", "nothing.xml");
        // }bp[NX
        UTUtil.setPrivateField(plugin, "mapperStr", null);

        // ANVT[ubg쐬
        BLogicIOPlugIn_ActionServletStub01 servlet = new BLogicIOPlugIn_ActionServletStub01();

        // eXgs
        try {
            plugin.init(servlet, config);
            fail();
        } catch (ServletException e) {
            // eXgʊmF
            assertEquals(MalformedURLException.class.getName(), e
                    .getRootCause().getClass().getName());
            assertTrue(LogUTUtil.checkError("", e.getRootCause()));
        }
    }

    /**
     * testInit13()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() servlet:not null<br>
     *         () config:W[()=""<br>
     *         () rulesiDigester[t@Cj:"BLogicIOPlugInTest-blogic-io-rules.xml"<br>
     *         () blogic-ioiƖWbNo͏}bsO`t@Cj:""(󕶎)<br>
     *         () mapperStriƖWbNo͏񔽉fNXj:null<br>
     *         () digester:null<br>
     *
     * <br>
     * ҒlF(ԕω) O:ServletException<br>
     *                    bZ[WF"resources file location is not specified"<br>
     *         (ԕω) O:O<br>
     *                    G[OF"resources file location is not specified"<br>
     *
     * <br>
     * ƖWbNo͏}bsO`t@C󕶎̏ꍇAServletExceptionX[邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testInit13() throws Exception {
        // eXgf[^ݒ
        // W[ݒ
        ModuleConfig config = new ModuleConfigImpl("");

        // BLogic`[t@C
        UTUtil.setPrivateField(plugin, "digesterRules",
                BLogicIOPlugInTest.class.getResource(
                        "BLogicIOPlugInTest-blogic-io-rules.xml").getPath());
        // BLogic`t@C(󕶎)
        UTUtil.setPrivateField(plugin, "resources", "");
        // }bp[NX
        UTUtil.setPrivateField(plugin, "mapperStr", null);

        // ANVT[ubg쐬
        BLogicIOPlugIn_ActionServletStub01 servlet = new BLogicIOPlugIn_ActionServletStub01();

        // eXgs
        try {
            plugin.init(servlet, config);
            fail();
        } catch (IllegalArgumentException e) {
            // eXgʊmF
            // bZ[WmF
            assertEquals("errors.resources.file", e
                    .getMessage());
            assertTrue(LogUTUtil
                    .checkError("resources file location is not specified"));
        }
    }

    /**
     * testInit14()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() servlet:not null<br>
     *         () config:W[()=""<br>
     *         () rulesiDigester[t@Cj:"BLogicIOPlugInTest-blogic-io-rules.xml"<br>
     *         () blogic-ioiƖWbNo͏}bsO`t@Cj:"BLogicIOPlugInTest-error-blogic-io.xml"(p[XG[t@C)<br>
     *         () mapperStriƖWbNo͏񔽉fNXj:null<br>
     *         () digester:null<br>
     *
     * <br>
     * ҒlF(ԕω) O:ServletException<br>
     *                    bvOF<br>
     *                    SAXException<br>
     *         (ԕω) O:O<br>
     *                    G[OF""<br>
     *                    OFSAXException<br>
     *
     * <br>
     * p[XG[ƖWbNo͏}bsO`t@Cw肳ꂽꍇAServletExceptionX[邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testInit14() throws Exception {
        // eXgf[^ݒ
        // W[ݒ
        ModuleConfig config = new ModuleConfigImpl("");

        // BLogic`[t@C
        UTUtil.setPrivateField(plugin, "digesterRules",
                BLogicIOPlugInTest.class.getResource(
                        "BLogicIOPlugInTest-blogic-io-rules.xml").getPath());
        // BLogic`t@C(p[XG[j
        UTUtil.setPrivateField(plugin, "resources", BLogicIOPlugInTest.class
                .getResource("BLogicIOPlugInTest-error-blogic-io.xml")
                .getPath());
        // }bp[NX
        UTUtil.setPrivateField(plugin, "mapperStr", null);

        // ANVT[ubg쐬
        BLogicIOPlugIn_ActionServletStub01 servlet = new BLogicIOPlugIn_ActionServletStub01();

        // eXgs
        try {
            plugin.init(servlet, config);
            fail();
        } catch (ServletException e) {
            // eXgʊmF
            // ۂ̏ꍇ́ASAXParseException邪AcatchSAXExceptionȂ̂instanceofŃ`FbN
            assertTrue(e.getRootCause() instanceof SAXException);
            assertTrue(LogUTUtil.checkError("", e.getRootCause()));
        }
    }

    /**
     * testInit15()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() servlet:not null<br>
     *         () config:W[()="/sub1"<br>
     *         () rulesiDigester[t@Cj:"BLogicIOPlugInTest-blogic-io-rules.xml"<br>
     *         () blogic-ioiƖWbNo͏}bsO`t@Cj:"BLogicIOPlugInTest-blogic-io.xml"<br>
     *         () mapperStriƖWbNo͏񔽉fNXj:null<br>
     *         () digester:null<br>
     *
     * <br>
     * ҒlF(ԕω) resources:T[ubgReLXgBLOGIC_RESOURCES/sub1L[ɂBLogicResourcesCX^Xi[邱ƁB<br>
     *         (ԕω) mapper:T[ubgReLXgBLOGIC_MAPPER/sub1L[ɂBLogicMapperStubCX^Xi[邱ƁB<br>
     *
     * <br>
     * W[󕶎ȊO̎AT[ubgReLXgɓo^BLogicResourcesABLogicMapper̃L[ɁAW[ǉĂ邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testInit15() throws Exception {
        // eXgf[^ݒ
        // W[ݒ("/sub1"W[Ɏwj
        ModuleConfig config = new ModuleConfigImpl("/sub1");

        // BLogic`[t@C
        UTUtil.setPrivateField(plugin, "digesterRules",
                BLogicIOPlugInTest.class.getResource(
                        "BLogicIOPlugInTest-blogic-io-rules.xml").getPath());
        // BLogic`t@C
        UTUtil.setPrivateField(plugin, "resources", BLogicIOPlugInTest.class
                .getResource("BLogicIOPlugInTest-blogic-io.xml").getPath());
        // }bp[NX
        UTUtil.setPrivateField(plugin, "mapperStr", null);

        // ANVT[ubg쐬
        BLogicIOPlugIn_ActionServletStub01 servlet = new BLogicIOPlugIn_ActionServletStub01();

        // eXgs
        plugin.init(servlet, config);

        // T[ubgReLXg擾
        BLogicIOPlugIn_MockServletContextStub01 ctx = (BLogicIOPlugIn_MockServletContextStub01) servlet
                .getServletContext();

        // T[ubgReLXgɃftHgBLogicMapperCX^X
        // i[Ă邱Ɓi"/sub1"W[̃L[Łj
        assertEquals("jp.terasoluna.fw.service.thin.BLogicMapper",
                ctx.getAttribute("BLOGIC_MAPPER/sub1").getClass().getName());

        // T[ubgReLXgBLogicResourcesCX^X
        // i[Ă邱Ɓi"/sub1"W[̃L[Łj
        assertTrue(ctx.getAttribute("BLOGIC_RESOURCES/sub1") instanceof BLogicResources);
        assertNull(ctx.getAttribute("BLOGIC_RESOURCES"));

        // T[ubgReLXgɓo^Ă郊\[X
        // w肵[t@Cł邱ƁB
        assertEquals(BLogicIOPlugInTest.class.getResource(
                "BLogicIOPlugInTest-blogic-io-rules.xml").getPath(), ctx
                .getCalledResources());
    }

    /**
     * testInit16()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() servlet:not null<br>
     *         () config:W[()=""<br>
     *         () rulesiDigester[t@Cj:"BLogicIOPlugInTest-blogic-io-rules.xml"<br>
     *         () blogic-ioiƖWbNo͏}bsO`t@Cj:"BLogicIOPlugInTest-blogic-io.xml"A"BLogicIOPlugInTest-blogic-io2.xml"ABLogicIOPlugInTest-blogic-io3.xml"it@Cw莞j<br>
     *         () mapperStriƖWbNo͏񔽉fNXj:null<br>
     *         () digester:null<br>
     *
     * <br>
     * ҒlF(ԕω) resources:T[ubgReLXgBLOGIC_RESOURCESL[ɂBLogicResourcesCX^Xi[邱ƁB<br>
     *         (ԕω) mapper:T[ubgReLXgBLOGIC_MAPPERL[ɂBLogicMapperCX^Xi[邱ƁB<br>
     *
     * <br>
     * blogic-io.xmlt@CRt@CAAꂼꂪBLogicPropertyɕۑĂ邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testInit16() throws Exception {
        // eXgf[^ݒ
        // W[ݒ
        ModuleConfig config = new ModuleConfigImpl("");

        // BLogic`[t@C
        UTUtil.setPrivateField(plugin, "digesterRules",
                BLogicIOPlugInTest.class.getResource(
                        "BLogicIOPlugInTest-blogic-io-rules.xml").getPath());
        // BLogic`t@C
        UTUtil.setPrivateField(plugin, "resources", BLogicIOPlugInTest.class
                .getResource("BLogicIOPlugInTest-blogic-io.xml").getPath()
                + ","
                + BLogicIOPlugInTest.class.getResource(
                        "BLogicIOPlugInTest-blogic-io2.xml").getPath()
                + ","
                + BLogicIOPlugInTest.class.getResource(
                        "BLogicIOPlugInTest-blogic-io3.xml").getPath());
        // }bp[NX
        UTUtil.setPrivateField(plugin, "mapperStr", null);

        // ANVT[ubg쐬
        BLogicIOPlugIn_ActionServletStub01 servlet = new BLogicIOPlugIn_ActionServletStub01();

        // eXgs
        plugin.init(servlet, config);

        // T[ubgReLXg擾
        BLogicIOPlugIn_MockServletContextStub01 ctx = (BLogicIOPlugIn_MockServletContextStub01) servlet
                .getServletContext();

        // T[ubgReLXgɃftHgBLogicMapperCX^X
        // i[Ă邱
        assertEquals("jp.terasoluna.fw.service.thin.BLogicMapper",
                ctx.getAttribute("BLOGIC_MAPPER").getClass().getName());

        // T[ubgReLXgɓo^Ă郊\[X
        // w肵[t@Cł邱ƁB
        assertEquals(BLogicIOPlugInTest.class.getResource(
                "BLogicIOPlugInTest-blogic-io-rules.xml").getPath(), ctx
                .getCalledResources());

        // XMLp[Xʂ擾
        BLogicResources resource = (BLogicResources) ctx
                .getAttribute("BLOGIC_RESOURCES");
        Map map = (Map) UTUtil.getPrivateField(resource, "blogicIO");

        // Pt@Cڂblogic-iot@Cɓǂݍ߂Ă邱
        BLogicIO logonIO = (BLogicIO) map.get("/logon");
        // blogic-params`FbN
        assertEquals("test_bean_name1-1", logonIO.getInputBeanName());
        List<BLogicProperty> logonParamList = logonIO.getBLogicParams();
        assertEquals(1, logonParamList.size());
        BLogicProperty property = logonParamList.get(0);
        assertEquals("test_params_blogic", property.getBLogicProperty());
        assertEquals("test_params_property", property.getProperty());
        assertEquals("form", property.getSource());
        // blogic-result`FbN
        List<BLogicProperty> logonResultList = logonIO.getBLogicResults();
        assertEquals(1, logonResultList.size());
        BLogicProperty result = logonResultList.get(0);
        assertEquals("test_result_blogic", result.getBLogicProperty());
        assertEquals("test_result_property", result.getProperty());
        assertEquals("session", result.getDest());

        BLogicIO dbIO = (BLogicIO) map.get("/db");
        // blogic-params`FbN
        assertEquals("test_bean_name1-2", dbIO.getInputBeanName());
        List dbParamList = dbIO.getBLogicParams();
        assertEquals(0, dbParamList.size());
        // blogic-result`FbN
        List dbResultList = dbIO.getBLogicResults();
        assertEquals(0, dbResultList.size());

        // Qt@Cڂblogic-iot@Cɓǂݍ߂Ă邱
        BLogicIO logon2IO = (BLogicIO) map.get("/logon2");
        // blogic-params`FbN
        assertEquals("test_bean_name2-1", logon2IO.getInputBeanName());
        List<BLogicProperty> logon2ParamList = logon2IO.getBLogicParams();
        assertEquals(2, logon2ParamList.size());
        BLogicProperty property2_1 = logon2ParamList.get(0);
        assertEquals("test_params_blogic2-1", property2_1.getBLogicProperty());
        assertEquals("test_params_property2-1", property2_1.getProperty());
        assertEquals("form", property2_1.getSource());
        BLogicProperty property2_2 = logon2ParamList.get(1);
        assertEquals("test_params_blogic2-2", property2_2.getBLogicProperty());
        assertEquals("test_params_property2-2", property2_2.getProperty());
        assertEquals("form", property2_2.getSource());
        // blogic-result`FbN
        List<BLogicProperty> logon2ResultList = logon2IO.getBLogicResults();
        assertEquals(2, logon2ResultList.size());
        BLogicProperty result2_1 = logon2ResultList.get(0);
        assertEquals("test_result_blogic2-1", result2_1.getBLogicProperty());
        assertEquals("test_result_property2-1", result2_1.getProperty());
        assertEquals("session", result2_1.getDest());
        BLogicProperty result2_2 = logon2ResultList.get(1);
        assertEquals("test_result_blogic2-2", result2_2.getBLogicProperty());
        assertEquals("test_result_property2-2", result2_2.getProperty());
        assertEquals("session", result2_2.getDest());

        BLogicIO db2IO = (BLogicIO) map.get("/db2");
        // blogic-params`FbN
        assertEquals("test_bean_name2-3", db2IO.getInputBeanName());
        List db2ParamList = db2IO.getBLogicParams();
        assertEquals(0, db2ParamList.size());
        // blogic-result`FbN
        List db2ResultList = db2IO.getBLogicResults();
        assertEquals(0, db2ResultList.size());

        // Rt@Cڂblogic-iot@Cɓǂݍ߂Ă邱
        BLogicIO logon3IO = (BLogicIO) map.get("/logon3");
        // blogic-params`FbN
        assertEquals("test_bean_name3-1", logon3IO.getInputBeanName());
        List<BLogicProperty> logon3ParamList = logon3IO.getBLogicParams();
        assertEquals(3, logon3ParamList.size());
        BLogicProperty property3_1 = logon3ParamList.get(0);
        assertEquals("test_params_blogic3-1", property3_1.getBLogicProperty());
        assertEquals("test_params_property3-1", property3_1.getProperty());
        assertEquals("form", property3_1.getSource());
        BLogicProperty property3_2 = logon3ParamList.get(1);
        assertEquals("test_params_blogic3-2", property3_2.getBLogicProperty());
        assertEquals("test_params_property3-2", property3_2.getProperty());
        assertEquals("form", property3_2.getSource());
        BLogicProperty property3_3 = logon3ParamList.get(2);
        assertEquals("test_params_blogic3-3", property3_3.getBLogicProperty());
        assertEquals("test_params_property3-3", property3_3.getProperty());
        assertEquals("form", property3_3.getSource());
        // blogic-result`FbN
        List<BLogicProperty> logon3ResultList = logon3IO.getBLogicResults();
        assertEquals(3, logon3ResultList.size());
        BLogicProperty result3_1 = logon3ResultList.get(0);
        assertEquals("test_result_blogic3-1", result3_1.getBLogicProperty());
        assertEquals("test_result_property3-1", result3_1.getProperty());
        assertEquals("session", result3_1.getDest());
        BLogicProperty result3_2 = logon3ResultList.get(1);
        assertEquals("test_result_blogic3-2", result3_2.getBLogicProperty());
        assertEquals("test_result_property3-2", result3_2.getProperty());
        BLogicProperty result3_3 = logon3ResultList.get(2);
        assertEquals("test_result_blogic3-3", result3_3.getBLogicProperty());
        assertEquals("test_result_property3-3", result3_3.getProperty());
        assertEquals("session", result3_3.getDest());

        // Qt@CڂƂRt@Cڂblogic-iot@CɏdpX݂ꍇA
        // ォݒ肳ꂽt@C̏񂪐ݒ肳Ă邱
        BLogicIO duplicateIO = (BLogicIO) map.get("/duplicate");
        // blogic-params`FbN
        assertEquals("test_bean_name3-2", duplicateIO.getInputBeanName());
        List<BLogicProperty> duplicateParamList = duplicateIO.getBLogicParams();
        assertEquals(1, duplicateParamList.size());
        BLogicProperty duplicate1 = duplicateParamList.get(0);
        assertEquals("duplicate_params_blogic2", duplicate1.getBLogicProperty());
        assertEquals("duplicate_params_property2", duplicate1.getProperty());
        assertEquals("form", duplicate1.getSource());
        // blogic-result`FbN
        List<BLogicProperty> duplicateResultList = duplicateIO
                .getBLogicResults();
        assertEquals(1, duplicateResultList.size());
        BLogicProperty duplicate2 = duplicateResultList.get(0);
        assertEquals("duplicate_result_blogic2", duplicate2.getBLogicProperty());
        assertEquals("duplicate_result_property2", duplicate2.getProperty());
        assertEquals("session", duplicate2.getDest());

        BLogicIO db3IO = (BLogicIO) map.get("/db3");
        // blogic-params`FbN
        assertEquals("test_bean_name3-3", db3IO.getInputBeanName());
        List db3ParamList = db3IO.getBLogicParams();
        assertEquals(0, db3ParamList.size());
        // blogic-result`FbN
        List db3ResultList = db3IO.getBLogicResults();
        assertEquals(0, db3ResultList.size());
    }

    /**
     * testInit17()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() servlet:not null<br>
     *         () config:W[()=""<br>
     *         () rulesiDigester[t@Cj:"BLogicIOPlugInTest-blogic-io-rules.xml"<br>
     *         () blogic-ioiƖWbNo͏}bsO`t@Cj:"BLogicIOPlugInTest-blogic-io4.xml"<br>
     *                bean-name̎wȂB
     *         () mapperStriƖWbNo͏񔽉fNXj:null<br>
     *         () digester:null<br>
     *
     * <br>
     * ҒlF(ԕω) resources:T[ubgReLXgBLOGIC_RESOURCESL[ɂBLogicResourcesCX^Xi[邱ƁB<br>
     *                              BlogicIOCX^XinputBeanNamenullł邱ƁB
     *         (ԕω) mapper:T[ubgReLXgBLOGIC_MAPPERL[ɂBLogicMapperCX^Xi[邱ƁB<br>
     *
     * <br>
     * blogic-io.xmlt@Cbean-namenull̂ƂABLogicIOinputBeanNamenullł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testInit17() throws Exception {
        // eXgf[^ݒ
        // W[ݒ
        ModuleConfig config = new ModuleConfigImpl("");

        // BLogic`[t@C
        UTUtil.setPrivateField(plugin, "digesterRules",
                BLogicIOPlugInTest.class.getResource(
                        "BLogicIOPlugInTest-blogic-io-rules.xml").getPath());
        // BLogic`t@C
        UTUtil.setPrivateField(plugin, "resources", BLogicIOPlugInTest.class
                .getResource("BLogicIOPlugInTest-blogic-io4.xml").getPath());
        // }bp[NX
        UTUtil.setPrivateField(plugin, "mapperStr", null);

        // ANVT[ubg쐬
        BLogicIOPlugIn_ActionServletStub01 servlet = new BLogicIOPlugIn_ActionServletStub01();

        // eXgs
        plugin.init(servlet, config);

        // T[ubgReLXg擾
        BLogicIOPlugIn_MockServletContextStub01 ctx = (BLogicIOPlugIn_MockServletContextStub01) servlet
                .getServletContext();

        // T[ubgReLXgɃftHgBLogicMapperCX^X
        // i[Ă邱
        assertEquals("jp.terasoluna.fw.service.thin.BLogicMapper",
                ctx.getAttribute("BLOGIC_MAPPER").getClass().getName());

        // T[ubgReLXgBLogicResourcesCX^X
        // i[Ă邱
        assertTrue(ctx.getAttribute("BLOGIC_RESOURCES") instanceof BLogicResources);

        BLogicResources resources =
            (BLogicResources) ctx.getAttribute("BLOGIC_RESOURCES");
        BLogicIO io = resources.getBLogicIO("/logon");

        //BLogicIO#inputBeanNamenullł邱ƂmFB
        assertNull(io.getInputBeanName());

        // T[ubgReLXgɓo^Ă郊\[X
        // w肵[t@Cł邱ƁB
        assertEquals(BLogicIOPlugInTest.class.getResource(
                "BLogicIOPlugInTest-blogic-io-rules.xml").getPath(), ctx
                .getCalledResources());
    }

    /**
     * testInit18()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() servlet:not null<br>
     *         () config:W[()=""<br>
     *         () rulesiDigester[t@Cj:"BLogicIOPlugInTest-blogic-io-rules.xml"<br>
     *         () blogic-ioiƖWbNo͏}bsO`t@Cj:"BLogicIOPlugInTest-blogic-io4.xml"<br>
     *                bean-name̎wȂB
     *         () mapperStriƖWbNo͏񔽉fNXj:null<br>
     *         () digester:null<br>
     *
     * <br>
     * ҒlF(ԕω) O:ServletException<br>
     *                    bvOF<br>
     *                    IOException<br>
     *         (ԕω) O:O<br>
     *                    G[OF""<br>
     *                    OFIOException<br>
     *
     * <br>
     * getPublicIdentifier()̖߂肪󔒂ŁAURL̃IuWFNgłȂꍇ
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testInit18() throws Exception {
        // eXgf[^ݒ
        // W[ݒ
        ModuleConfig config = new ModuleConfigImpl("");

        plugin = new BLogicIOPlugIn() {
            @Override
            public String getPublicIdentifier() {
            	return "";
            }
        };

        // BLogic`[t@C
        UTUtil.setPrivateField(plugin, "digesterRules",
                BLogicIOPlugInTest.class.getResource(
                        "BLogicIOPlugInTest-blogic-io-rules.xml").getPath());
        // BLogic`t@C
        UTUtil.setPrivateField(plugin, "resources", BLogicIOPlugInTest.class
                .getResource("BLogicIOPlugInTest-blogic-io4.xml").getPath());
        // }bp[NX
        UTUtil.setPrivateField(plugin, "mapperStr", null);

        // ANVT[ubg쐬
        BLogicIOPlugIn_ActionServletStub01 servlet = new BLogicIOPlugIn_ActionServletStub01();

        // eXgs
        try {
            plugin.init(servlet, config);
            fail("eXgs");
        } catch (ServletException e) {
        	assertTrue(e.getRootCause() instanceof IOException);
            assertTrue(LogUTUtil.checkError("", e.getRootCause()));
        }

    }

    /**
     * testSetDigesterRules01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() digesterRules:"digesterRules"<br>
     *         () digesterRules:null<br>
     *
     * <br>
     * ҒlF(ԕω) digesterRules:"digesterRules"<br>
     *
     * <br>
     * digesterRulesi[邱
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetDigesterRules01() throws Exception {
        // eXg{
        plugin.setDigesterRules("digesterRules");

        // 
        assertEquals("digesterRules", UTUtil.getPrivateField(plugin,
                "digesterRules"));
    }

    /**
     * testSetResources01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() resources:"resources"<br>
     *         () resources:null<br>
     *
     * <br>
     * ҒlF(ԕω) resources:"resources"<br>
     *
     * <br>
     * resourcesi[邱
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetResources01() throws Exception {
        // eXg{
        plugin.setResources("resources");

        // 
        assertEquals("resources", UTUtil.getPrivateField(plugin, "resources"));
    }

    /**
     * testSetMapperClass01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() mapperStr:"mapperStr"<br>
     *         () mapperStr:null<br>
     *
     * <br>
     * ҒlF(ԕω) mapperStr:"mapperStr"<br>
     *
     * <br>
     * mapperStri[邱
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetMapperClass01() throws Exception {
        // eXg{
        plugin.setMapperClass("mapperStr");

        // 
        assertEquals("mapperStr", UTUtil.getPrivateField(plugin, "mapperStr"));
    }

    /**
     * testSetPublicIdentifier01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() publicIdentifier:"publicIdentifier"<br>
     *         () publicIdentifier:not nulliftHglj<br>
     *
     * <br>
     * ҒlF(ԕω) publicIdentifier:"publicIdentifier"<br>
     *
     * <br>
     * publicIdentifieri[邱
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetPublicIdentifier01() throws Exception {
        // eXg{
        plugin.setPublicIdentifier("publicIdentifier");

        // 
        assertEquals("publicIdentifier", UTUtil.getPrivateField(plugin,
                "publicIdentifier"));
    }

    /**
     * testSetDtdUrl01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() dtdUrl:"dtdUrl"<br>
     *         () dtdUrl:not nulliftHglj<br>
     *
     * <br>
     * ҒlF(ԕω) dtdUrl:"dtdUrl"<br>
     *
     * <br>
     * dtdUrli[邱
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetDtdUrl01() throws Exception {
        // eXg{
        plugin.setDtdUrl("dtdUrl");

        // 
        assertEquals("dtdUrl", UTUtil.getPrivateField(plugin, "dtdUrl"));
    }

}
