/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.actions;

import java.io.IOException;
import java.util.Iterator;

import javax.servlet.http.HttpSession;

import jp.terasoluna.fw.web.struts.action.ActionMappingEx;
import jp.terasoluna.fw.web.struts.form.DynaValidatorActionFormEx;
import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.MockHttpServletResponse;
import jp.terasoluna.utlib.MockHttpSession;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

import org.apache.struts.Globals;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.validator.DynaValidatorActionForm;

import com.mockrunner.mock.web.MockActionMapping;

/**
 * {@link jp.terasoluna.fw.web.struts.actions.ActionEx} NX̃ubN{bNXeXgB
 *
 * <p>
 * <h4>yNX̊Tvz</h4>
 * Oo͂gUNVg[N`FbNoANVNX
 * <p>
 *
 * @see jp.terasoluna.fw.web.struts.actions.ActionEx
 */
public class ActionExTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     *
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(ActionExTest.class);
    }

    /**
     * sB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        LogUTUtil.flush();
    }

    /**
     * IsB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     *
     * @param name ̃eXgP[X̖OB
     */
    public ActionExTest(String name) {
        super(name);
    }

    /**
     * testSetTokenCheck01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() tokenCheck:true<br>
     *         () tokenCheck:false<br>
     *
     * <br>
     * ҒlF(ԕω) tokenCheck:true<br>
     *
     * <br>
     * Ɏw肵lActionExtokenCheckɐɊi[邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetTokenCheck01() throws Exception {
        // O
        ActionEx action = new ActionEx_ActionExStub01();

        UTUtil.setPrivateField(action, "tokenCheck", false);

        // eXg{
        action.setTokenCheck(true);

        // 
        boolean tokenCheck =
            ((Boolean) UTUtil.getPrivateField(action, "tokenCheck")).booleanValue();
        assertTrue(tokenCheck);
    }

    /**
     * testIsTokenCheck01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() tokenCheck:true<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * ActionExtokenCheck邱ƂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsTokenCheck01() throws Exception {
        // O
        ActionEx action = new ActionEx_ActionExStub01();

        UTUtil.setPrivateField(action, "tokenCheck", true);

        // eXg{
        boolean b = action.isTokenCheck();

        // 
        assertTrue(b);
    }

    /**
     * testSetSaveToken01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() saveToken:false<br>
     *         () saveToken:true<br>
     *
     * <br>
     * ҒlF(ԕω) saveToken:false<br>
     *
     * <br>
     * Ɏw肵lActionExsaveTokenɐɊi[邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetSaveToken01() throws Exception {
        // O
        ActionEx action = new ActionEx_ActionExStub01();

        UTUtil.setPrivateField(action, "saveToken", false);

        // eXg{
        action.setSaveToken(true);

        // 
        boolean saveToken =
            ((Boolean) UTUtil.getPrivateField(action, "saveToken"))
            .booleanValue();
        assertTrue(saveToken);
    }

    /**
     * testIsSaveToken01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() saveToken:true<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * ActionExsaveToken邱ƂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsSaveToken01() throws Exception {
        // O
        ActionEx action = new ActionEx_ActionExStub01();

        UTUtil.setPrivateField(action, "saveToken", true);

        // eXg{
        boolean b = action.isSaveToken();

        // 
        assertTrue(b);
    }

    /**
     * testExecute01()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() mapping:not null<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () processTokenCheck():false<br>
     *
     * <br>
     * ҒlF(߂l) actionForward:ActionFoward<br>
     *                  (NameF"txtoken-error")<br>
     *         (ԕω) O:O<br>
     *                    CtHOF"Transaction token error."<br>
     * <br>
     * processTokenCheck()falseԂꍇA"txtoken-error"ɑJڂ
     * ActionForwardԂƂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testExecute01() throws Exception {
        // O
        MockActionMapping mapping = new MockActionMapping();

        ActionForm form = new DynaValidatorActionFormEx();

        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();

        // action:processTokenCheck = false
        ActionEx action = new ActionEx_ActionExStub01();
        ActionForward forward = null;

        // eXg{
        forward = action.execute(mapping, form, req, res);

        // 
        assertEquals("txtoken-error", forward.getName());
        assertTrue(LogUTUtil.checkInfo("Transaction token error."));
    }

    /**
     * testExecute02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:not null<br>
     *         () form:null<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () processTokenCheck():true<br>
     *         () doExecute():ActionForwardNameF"success"<br>
     *
     * <br>
     * ҒlF(߂l) actionForward:mappingɐݒ肳ĂActionFoward<br>
     *                  (NameF"success")<br>
     *
     * <br>
     * processTokenCheck()truełAformnullꍇA
     * doExecute()̃^[lԂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testExecute02() throws Exception {
        // O
        MockActionMapping mapping = new MockActionMapping();

        ActionForm form = null;

        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();

        // action:processTokenCheck = true
        ActionEx action = new ActionEx_ActionExStub02();
        ActionForward forward = null;

        // eXg{
        forward = action.execute(mapping, form, req, res);

        // 
        assertEquals("success", forward.getName());
    }

    /**
     * testExecute03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:not null<br>
     *         () form:Form<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () processTokenCheck():true<br>
     *         () doExecute():ActionForwardNameF"success"<br>
     *
     * <br>
     * ҒlF(߂l) actionForward:mappingɐݒ肳ĂActionFoward<br>
     *                  (NameF"success")<br>
     *
     * <br>
     * formFormExłȂꍇAdoExecute()̃^[lԂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testExecute03() throws Exception {
        // O
        MockActionMapping mapping = new MockActionMapping();

        // ActionForm
        ActionForm form = new DynaValidatorActionForm();

        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();

        // action:processTokenCheck = true
        ActionEx action = new ActionEx_ActionExStub02();
        ActionForward forward = null;

        // eXg{
        forward = action.execute(mapping, form, req, res);

        // 
        assertEquals("success", forward.getName());
    }

    /**
     * testExecute04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:not null<br>
     *         () form:FormEx<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () processTokenCheck():true<br>
     *         () doExecute():null<br>
     *         () doExecute()s<br>
     *                form.isModified():false<br>
     *
     * <br>
     * ҒlF(߂l) actionForward:null<br>
     *
     * <br>
     * doExecute()̌ʂnullłAdoExecute()sform.isModified()
     * falseꍇAnullԂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testExecute04() throws Exception {
        // O
        MockActionMapping mapping = new MockActionMapping();

        // FormEx
        DynaValidatorActionFormEx form = new DynaValidatorActionFormEx();

        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();

        // action:processTokenCheck = true
        // formEx.modified = false
        // doExecute = null
        ActionEx action = new ActionEx_ActionExStub06();
        ActionForward forward = null;

        // eXg{
        forward = action.execute(mapping, form, req, res);

        // 
        assertNull(forward);
        assertFalse(form.isModified());
    }

    /**
     * testExecute05()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() mapping:not null<br>
     *         () form:FormEx<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () processTokenCheck():true<br>
     *         () doExecute():Exception<br>
     *
     * <br>
     * ҒlF(ԕω) O:Exception<br>
     *
     * <br>
     * doExecute()ONꍇAException邩mF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testExecute05() throws Exception {
        // O
        MockActionMapping mapping = new MockActionMapping();

        // FormEx
        DynaValidatorActionFormEx form = new DynaValidatorActionFormEx();

        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();

        // action:processTokenCheck = true
        ActionEx action = new ActionEx_ActionExStub03();

        // eXg{
        try {
            action.execute(mapping, form, req, res);
            fail();
        } catch (Exception e) {
            // 
            assertEquals(IOException.class.getName(),
                    e.getCause().getClass().getName());
        }
    }

    /**
     * testExecute06()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:not null<br>
     *         () form:FormEx<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () processTokenCheck():true<br>
     *         () doExecute():ActionForwardNameF"success"<br>
     *         () doExecute()s<br>
     *                form.isModified():false<br>
     *
     * <br>
     * ҒlF(߂l) actionForward:mappingɐݒ肳ĂActionFoward<br>
     *                  (NameF"success")<br>
     *
     * <br>
     * doExecute()ActionForwardԂAform.isModified()falseꍇA
     * doExecute()̃^[lԂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testExecute06() throws Exception {
        // O
        MockActionMapping mapping = new MockActionMapping();

        // FormEx
        DynaValidatorActionFormEx form = new DynaValidatorActionFormEx();

        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();

        // action:processTokenCheck = true
        ActionEx action = new ActionEx_ActionExStub04();

        // form.isModified = false;
        UTUtil.setPrivateField(action, "modified", false);
        ActionForward forward = null;

        // eXg{
        forward = action.execute(mapping, form, req, res);

        // 
        assertEquals("success", forward.getName());
        assertNull(req.getAttribute("SKIP_POPULATE"));
    }

    /**
     * testExecute07()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:not null<br>
     *         () form:FormEx<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () processTokenCheck():true<br>
     *         () doExecute():ActionForwardNameF"success"<br>
     *         () doExecute()s<br>
     *                form.isModified():true<br>
     *         () mapping.getName():"abc"<br>
     *
     * <br>
     * ҒlF(߂l) actionForward:mappingɐݒ肳ĂActionFoward<br>
     *                  (NameF"success")<br>
     *         (ԕω) req.getAttribute("SKIP_POPULATE"):"abc"<br>
     *
     * <br>
     * doExecute()ActionForwardԂAform.isModified()trueꍇA
     * doExecute()̃^[lԂƁAHttpServletRequest擾
     * "SKIP_POPULATE"ɊY鑮mapping.getName()ƈv邩mF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testExecute07() throws Exception {
        // O
        MockActionMapping mapping = new MockActionMapping();
        mapping.setName("abc");

        // FormEx
        DynaValidatorActionFormEx form = new DynaValidatorActionFormEx();

        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();

        // action:processTokenCheck = true
        ActionEx_ActionExStub04 action = new ActionEx_ActionExStub04();

        // form.isModified = true;
        UTUtil.setPrivateField(action, "modified", true);
        ActionForward forward = null;

        // eXg{
        forward = action.execute(mapping, form, req, res);

        // 
        assertEquals("success", forward.getName());
        assertEquals("abc", req.getAttribute("SKIP_POPULATE"));
    }

    /**
     * testProcessTokenCheck01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() mapping:ActionMapping<br>
     *         () req:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * mappingActionMappingExłȂꍇtrueԂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testProcessTokenCheck01() throws Exception {
        // O
        MockActionMapping mapping = new MockActionMapping();
        MockHttpServletRequest req = new MockHttpServletRequest();

        ActionEx_ActionExStub05 action = new ActionEx_ActionExStub05();

        // eXg{
        boolean b = action.processTokenCheck(mapping, req);

        // 
        assertTrue(b);
        assertFalse(action.isSaveToken);
    }

    /**
     * testProcessTokenCheck02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() mapping:ActionMappingEx<br>
     *         () req:not null<br>
     *         () tokenCheck:true<br>
     *         () Action.isTokenValid():false<br>
     *         () saveToken:true<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) Action.saveToken():s<br>
     *
     * <br>
     * tB[htokenChecktruełAAction.isTokenValid()falseAsaveTokentrueꍇAfalseԂƂƂAction.saveToken()ĂяoꂽmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testProcessTokenCheck02() throws Exception {
        // O
        ActionMappingEx mapping = new ActionMappingEx();
        MockHttpServletRequest req = new MockHttpServletRequest();

        ActionEx action = new ActionEx_ActionExStub05();
        UTUtil.setPrivateField(action, "tokenCheck", true);
        UTUtil.setPrivateField(action, "tokenValid", false);
        UTUtil.setPrivateField(action, "saveToken", true);

        // eXg{
        boolean b = action.processTokenCheck(mapping, req);

        // 
        assertFalse(b);
        boolean isSaveToken =
            ((Boolean) UTUtil.getPrivateField(action, "isSaveToken"))
            .booleanValue();
        assertTrue(isSaveToken);
    }

    /**
     * testProcessTokenCheck03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() mapping:ActionMappingEx<br>
     *         () req:not null<br>
     *         () tokenCheck:true<br>
     *         () Action.isTokenValid():true<br>
     *         () saveToken:true<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) Action.saveToken():s<br>
     *
     * <br>
     * tB[htokenChecktruełAAction.isTokenValid()trueAsaveTokentrueꍇAtrueԂƂƂAction.saveToken()ĂяoꂽmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testProcessTokenCheck03() throws Exception {
        // O
        ActionMappingEx mapping = new ActionMappingEx();
        MockHttpServletRequest req = new MockHttpServletRequest();

        ActionEx action = new ActionEx_ActionExStub05();
        UTUtil.setPrivateField(action, "tokenCheck", true);
        UTUtil.setPrivateField(action, "tokenValid", true);
        UTUtil.setPrivateField(action, "saveToken", true);

        // eXg{
        boolean b = action.processTokenCheck(mapping, req);

        // 
        assertTrue(b);
        boolean isSaveToken =
            ((Boolean) UTUtil.getPrivateField(action, "isSaveToken"))
            .booleanValue();
        assertTrue(isSaveToken);
    }

    /**
     * testProcessTokenCheck04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() mapping:ActionMappingEx<br>
     *         () req:not null<br>
     *         () tokenCheck:false<br>
     *         () Action.isTokenValid():true<br>
     *         () saveToken:false<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) Action.saveToken():s<br>
     *
     * <br>
     * tB[htokenCheckfalsełAAction.isTokenValid()trueAsaveTokenfalseꍇAtrueԂƂƂAction.saveToken()ĂяoȂƂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testProcessTokenCheck04() throws Exception {
        // O
        ActionMappingEx mapping = new ActionMappingEx();
        MockHttpServletRequest req = new MockHttpServletRequest();

        ActionEx action = new ActionEx_ActionExStub05();
        UTUtil.setPrivateField(action, "tokenCheck", false);
        UTUtil.setPrivateField(action, "tokenValid", true);
        UTUtil.setPrivateField(action, "saveToken", false);

        // eXg{
        boolean b = action.processTokenCheck(mapping, req);

        // 
        assertTrue(b);
        boolean isSaveToken =
            ((Boolean) UTUtil.getPrivateField(action, "isSaveToken"))
            .booleanValue();
        assertFalse(isSaveToken);
    }

    /**
     * testAddErrors01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() session:null<br>
     *
     * <br>
     *
     * <br>
     * sessionnullꍇA𒆒f邱ƂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testAddErrors01() throws Exception {
        // O
        HttpSession session = null;
        ActionMessages errors = new ActionMessages();
        ActionEx action = new ActionEx_ActionExStub01();

        // eXg{
        action.addErrors(session, errors);
    }

    /**
     * testAddErrors02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() session:not null<br>
     *         () errors:null<br>
     *
     * <br>
     * ҒlF(ԕω) sessioin#getAttribute(<br>
     *                    Globals.ERROR_KEY):null<br>
     *
     * <br>
     * errorsnullꍇA𒆒f邱ƂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testAddErrors02() throws Exception {
        // O
        MockHttpSession session = new MockHttpSession();
        ActionMessages errors = null;
        ActionEx action = new ActionEx_ActionExStub01();

        // eXg{
        action.addErrors(session, errors);

        // 
        ActionMessages msgs =
            (ActionMessages) session.getAttribute(Globals.ERROR_KEY);
        assertNull(msgs);
    }

    /**
     * testAddErrors03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() session:not null<br>
     *         () errors:vf0ActionMessages<br>
     *         () (session#getAttribute(<br>
     *                Globals.ERROR_KEY)).size():null<br>
     *
     * <br>
     * ҒlF(ԕω) sessioin#getAttribute(<br>
     *                    Globals.ERROR_KEY):null<br>
     *
     * <br>
     * sessionGlobals.ERROR_KEYɊY鑮ȂA
     * errors̃TCY0ꍇA𒆒f邱ƂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testAddErrors03() throws Exception {
        // O
        MockHttpSession session = new MockHttpSession();
        ActionMessages errors = new ActionMessages();

        ActionEx action = new ActionEx_ActionExStub01();

        // eXg{
        action.addErrors(session, errors);

        // 
        ActionMessages msgs =
            (ActionMessages) session.getAttribute(Globals.ERROR_KEY);
        assertNull(msgs);
    }

    /**
     * testAddErrors04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() session:not null<br>
     *         () errors:vf1ActionMessagesF<br>
     *                ([key="key01"Avalue="value01"])<br>
     *         () (session#getAttribute(<br>
     *                Globals.ERROR_KEY)).size():null<br>
     *
     * <br>
     * ҒlF(ԕω) sessioin#getAttribute(<br>
     *                    Globals.ERROR_KEY):vf1ActionMessagesF<br>
     *                    ([key="key01"Avalue="value01"])<br>
     *
     * <br>
     * sessionGlobals.ERROR_KEYɊY鑮ȂAerrors̃TCY1ꍇAsesssionGlobals.ERROR_KEYerrors̗vfĂ邱ƂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testAddErrors04() throws Exception {
        // O
        MockHttpSession session = new MockHttpSession();
        ActionMessages errors = new ActionMessages();
        ActionMessage msg = new ActionMessage("key01", "value01");

        errors.add(Globals.ERROR_KEY, msg);

        ActionEx action = new ActionEx_ActionExStub01();

        // eXg{
        action.addErrors(session, errors);

        // 
        ActionMessages msgs =
            (ActionMessages) session.getAttribute(Globals.ERROR_KEY);

        Iterator it = msgs.get(Globals.ERROR_KEY);
        ActionMessage message = (ActionMessage) it.next();
        String key = message.getKey();
        String value = (String) message.getValues()[0];
        assertEquals("key01", key);
        assertEquals("value01", value);
    }

    /**
     * testAddErrors05()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() session:not null<br>
     *         () errors:vf0ActionMessages<br>
     *         () (session#getAttribute(<br>
     *                Globals.ERROR_KEY)).size():vf0ActionMessages<br>
     *
     * <br>
     * ҒlF(ԕω) sessioin#getAttribute(<br>
     *                    Globals.ERROR_KEY):null<br>
     *
     * <br>
     * sessionGlobals.ERROR_KEYɊY鑮̃TCY0łA
     * errors̃TCY0ꍇA𒆒f邱ƂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testAddErrors05() throws Exception {
        // O
        MockHttpSession session = new MockHttpSession();
        ActionMessages errors = new ActionMessages();
        // 0̃G[ǉ
        session.setAttribute(Globals.ERROR_KEY, errors);

        ActionEx action = new ActionEx_ActionExStub01();

        // eXg{
        action.addErrors(session, errors);

        // 
        ActionMessages msgs =
            (ActionMessages) session.getAttribute(Globals.ERROR_KEY);

        assertNull(msgs);
    }

    /**
     * testAddErrors06()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() session:not null<br>
     *         () errors:vf1ActionMessagesF<br>
     *                ([key="key01"Avalue="value01"])<br>
     *         () (session#getAttribute(<br>
     *                Globals.ERROR_KEY)).size():vf0ActionMessages<br>
     *
     * <br>
     * ҒlF(ԕω) sessioin#getAttribute(<br>
     *                    Globals.ERROR_KEY):vf1ActionMessagesF<br>
     *                    ([key="key01"Avalue="value01"])<br>
     *
     * <br>
     * sessionGlobals.ERROR_KEYɊY鑮̃TCY0łA
     * errors̃TCY1ꍇAsesssionGlobals.ERROR_KEY
     * errors̗vfĂ邱ƂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testAddErrors06() throws Exception {
        // O
        // sessionɃZbgvf0ActionMessages
        MockHttpSession session = new MockHttpSession();
        ActionMessages serrors = new ActionMessages();
        session.setAttribute(Globals.ERROR_KEY, serrors);

        // p[^Ƃēnvf1ActionMessages
        ActionMessages errors = new ActionMessages();
        ActionMessage msg = new ActionMessage("key01", "value01");

        errors.add(Globals.ERROR_KEY, msg);

        ActionEx action = new ActionEx_ActionExStub01();

        // eXg{
        action.addErrors(session, errors);

        // 
        ActionMessages msgs =
            (ActionMessages) session.getAttribute(Globals.ERROR_KEY);

        Iterator it = msgs.get(Globals.ERROR_KEY);
        ActionMessage message = (ActionMessage) it.next();
        String key = message.getKey();
        String value = (String) message.getValues()[0];
        assertEquals("key01", key);
        assertEquals("value01", value);
    }

    /**
     * testAddErrors07()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() session:not null<br>
     *         () errors:vf3ActionMessagesF<br>
     *                ([key="key01"Avalue="value01"]A<br>
     *                [key="key02"Avalue="value02"]A<br>
     *                [key="key03"Avalue="value03"])<br>
     *         () (session#getAttribute(<br>
     *                Globals.ERROR_KEY)).size():vf1ActionMessagesF<br>
     *                ([key="key04"Avalue="value04"])<br>
     *
     * <br>
     * ҒlF(ԕω) sessioin#getAttribute(<br>
     *                    Globals.ERROR_KEY):vf4ActionMessagesF<br>
     *                    [key="key04"Avalue="value04"])<br>
     *                    ([key="key01"Avalue="value01"]A<br>
     *                    [key="key02"Avalue="value02"]A<br>
     *                    [key="key03"Avalue="value03"]A<br>
     *
     * <br>
     * sessionGlobals.ERROR_KEYɊY鑮̃TCY1łA
     * errors̃TCY3ꍇAsesssionGlobals.ERROR_KEY
     * errors̗vfsession̗̑vfĂ邱ƂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testAddErrors07() throws Exception {
        // O
        // sessionɃZbgvf1ActionMessages
        MockHttpSession session = new MockHttpSession();
        ActionMessage smsg = new ActionMessage("key04", "value04");

        ActionMessages serrors = new ActionMessages();
        serrors.add(Globals.ERROR_KEY, smsg);

        session.setAttribute(Globals.ERROR_KEY, serrors);


        // p[^Ƃēnvf3ActionMessages
        ActionMessages errors = new ActionMessages();

        ActionMessage msg = new ActionMessage("key01", "value01");
        errors.add(Globals.ERROR_KEY, msg);

        msg = new ActionMessage("key02", "value02");
        errors.add(Globals.ERROR_KEY, msg);

        msg = new ActionMessage("key03", "value03");
        errors.add(Globals.ERROR_KEY, msg);


        ActionEx action = new ActionEx_ActionExStub01();

        // eXg{
        action.addErrors(session, errors);

        // 
        ActionMessages msgs =
            (ActionMessages) session.getAttribute(Globals.ERROR_KEY);

        Iterator it = msgs.get(Globals.ERROR_KEY);
        ActionMessage message = (ActionMessage) it.next();
        String key = message.getKey();
        String value = (String) message.getValues()[0];
        assertEquals("key04", key);
        assertEquals("value04", value);

        message = (ActionMessage) it.next();
        key = message.getKey();
        value = (String) message.getValues()[0];
        assertEquals("key01", key);
        assertEquals("value01", value);

        message = (ActionMessage) it.next();
        key = message.getKey();
        value = (String) message.getValues()[0];
        assertEquals("key02", key);
        assertEquals("value02", value);

        message = (ActionMessage) it.next();
        key = message.getKey();
        value = (String) message.getValues()[0];
        assertEquals("key03", key);
        assertEquals("value03", value);
    }

    /**
     * testAddErrors08()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() session:not null<br>
     *         () errors:vf1ActionMessagesF<br>
     *                ([key="key01"Avalue="value01"])<br>
     *         () (session#getAttribute(<br>
     *                Globals.ERROR_KEY)).size():vf3ActionMessagesF<br>
     *                ([key="key02"Avalue="value02"]A<br>
     *                [key="key03"Avalue="value03"]A<br>
     *                [key="key04"Avalue="value04"])<br>
     *
     * <br>
     * ҒlF(ԕω) sessioin#getAttribute(<br>
     *                    Globals.ERROR_KEY):vf4ActionMessagesF<br>
     *                    ([key="key02"Avalue="value02"]A<br>
     *                    [key="key03"Avalue="value03"]A<br>
     *                    [key="key04"Avalue="value04"]A<br>
     *                    [key="key01"Avalue="value01"])<br>
     *
     * <br>
     * sessionGlobals.ERROR_KEYɊY鑮̃TCY3łA
     * errors̃TCY1ꍇAsesssionGlobals.ERROR_KEY
     * errors̗vfsession̗̑vfĂ邱ƂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testAddErrors08() throws Exception {
        // O
        // sessionɃZbgvf3ActionMessages
        MockHttpSession session = new MockHttpSession();
        ActionMessage smsg = new ActionMessage("key02", "value02");
        ActionMessages serrors = new ActionMessages();
        serrors.add(Globals.ERROR_KEY, smsg);

        smsg = new ActionMessage("key03", "value03");
        serrors.add(Globals.ERROR_KEY, smsg);

        smsg = new ActionMessage("key04", "value04");
        serrors.add(Globals.ERROR_KEY, smsg);

        session.setAttribute(Globals.ERROR_KEY, serrors);


        // p[^Ƃēnvf1ActionMessages
        ActionMessages errors = new ActionMessages();
        ActionMessage msg = new ActionMessage("key01", "value01");
        errors.add(Globals.ERROR_KEY, msg);


        ActionEx action = new ActionEx_ActionExStub01();

        // eXg{
        action.addErrors(session, errors);

        // 
        ActionMessages msgs =
            (ActionMessages) session.getAttribute(Globals.ERROR_KEY);

        Iterator it = msgs.get(Globals.ERROR_KEY);
        ActionMessage message = (ActionMessage) it.next();
        String key = message.getKey();
        String value = (String) message.getValues()[0];
        assertEquals("key02", key);
        assertEquals("value02", value);

        message = (ActionMessage) it.next();
        key = message.getKey();
        value = (String) message.getValues()[0];
        assertEquals("key03", key);
        assertEquals("value03", value);

        message = (ActionMessage) it.next();
        key = message.getKey();
        value = (String) message.getValues()[0];
        assertEquals("key04", key);
        assertEquals("value04", value);

        message = (ActionMessage) it.next();
        key = message.getKey();
        value = (String) message.getValues()[0];
        assertEquals("key01", key);
        assertEquals("value01", value);
    }

    /**
     * testAddMessages01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() session:null<br>
     *
     * <br>
     *
     * <br>
     * sessionnullꍇA𒆒f邱ƂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testAddMessages01() throws Exception {
        // O
        HttpSession session = null;
        ActionMessages errors = new ActionMessages();
        ActionEx action = new ActionEx_ActionExStub01();

        // eXg{
        action.addMessages(session, errors);
    }

    /**
     * testAddMessages02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() session:not null<br>
     *         () messages:null<br>
     *
     * <br>
     * ҒlF(ԕω) sessioin#getAttribute(<br>
     *                    Globals.MESSAGE_KEY):null<br>
     *
     * <br>
     * messagesnullꍇA𒆒f邱ƂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testAddMessages02() throws Exception {
        // O
        MockHttpSession session = new MockHttpSession();
        ActionMessages messages = null;
        ActionEx action = new ActionEx_ActionExStub01();

        // eXg{
        action.addMessages(session, messages);

        // 
        ActionMessages msgs =
            (ActionMessages) session.getAttribute(Globals.MESSAGE_KEY);
        assertNull(msgs);
    }

    /**
     * testAddMessages03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() session:not null<br>
     *         () messages:vf0ActionMessages<br>
     *         () (session#getAttribute(<br>
     *                Globals.MESSAGE_KEY)).size():null<br>
     *
     * <br>
     * ҒlF(ԕω) sessioin#getAttribute(<br>
     *                    Globals.MESSAGE_KEY):null<br>
     *
     * <br>
     * sessionGlobals.MESSAGE_KEYɊY鑮ȂA
     * messages̃TCY0ꍇA𒆒f邱ƂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testAddMessages03() throws Exception {
        // O
        MockHttpSession session = new MockHttpSession();
        ActionMessages messages = new ActionMessages();

        ActionEx action = new ActionEx_ActionExStub01();

        // eXg{
        action.addMessages(session, messages);

        // 
        ActionMessages msgs =
            (ActionMessages) session.getAttribute(Globals.MESSAGE_KEY);
        assertNull(msgs);
    }

    /**
     * testAddMessages04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() session:not null<br>
     *         () messages:vf1ActionMessagesF<br>
     *                ([key="key01"Avalue="value01"])<br>
     *         () (session#getAttribute(<br>
     *                Globals.MESSAGE_KEY)).size():null<br>
     *
     * <br>
     * ҒlF(ԕω) sessioin#getAttribute(<br>
     *                    Globals.MESSAGE_KEY):vf1ActionMessagesF<br>
     *                    ([key="key01"Avalue="value01"])<br>
     *
     * <br>
     * sessionGlobals.MESSAGE_KEYɊY鑮ȂA
     * messages̃TCY1ꍇAsesssionGlobals.MESSAGE_KEY
     * messages̗vfĂ邱ƂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testAddMessages04() throws Exception {
        // O
        MockHttpSession session = new MockHttpSession();
        ActionMessages messages = new ActionMessages();
        ActionMessage msg = new ActionMessage("key01", "value01");

        messages.add(Globals.MESSAGE_KEY, msg);

        ActionEx action = new ActionEx_ActionExStub01();

        // eXg{
        action.addMessages(session, messages);

        // 
        ActionMessages msgs =
            (ActionMessages) session.getAttribute(Globals.MESSAGE_KEY);

        Iterator it = msgs.get(Globals.MESSAGE_KEY);
        ActionMessage message = (ActionMessage) it.next();
        String key = message.getKey();
        String value = (String) message.getValues()[0];
        assertEquals("key01", key);
        assertEquals("value01", value);
    }

    /**
     * testAddMessages05()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() session:not null<br>
     *         () messages:vf0ActionMessages<br>
     *         () (session#getAttribute(<br>
     *                Globals.MESSAGE_KEY)).size():vf0ActionMessages<br>
     *
     * <br>
     * ҒlF(ԕω) sessioin#getAttribute(<br>
     *                    Globals.MESSAGE_KEY):null<br>
     *
     * <br>
     * sessionGlobals.MESSAGE_KEYɊY鑮̃TCY0łA
     * messages̃TCY0ꍇA𒆒f邱ƂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testAddMessages05() throws Exception {
        // O
        MockHttpSession session = new MockHttpSession();
        ActionMessages messages = new ActionMessages();
        session.setAttribute(Globals.MESSAGE_KEY, messages);

        ActionEx action = new ActionEx_ActionExStub01();

        // eXg{
        action.addMessages(session, messages);

        // 
        ActionMessages msgs =
            (ActionMessages) session.getAttribute(Globals.MESSAGE_KEY);

        assertNull(msgs);
    }

    /**
     * testAddMessages06()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() session:not null<br>
     *         () messages:vf1ActionMessagesF<br>
     *                ([key="key01"Avalue="value01"])<br>
     *         () (session#getAttribute(<br>
     *                Globals.MESSAGE_KEY)).size():vf0ActionMessages<br>
     *
     * <br>
     * ҒlF(ԕω) sessioin#getAttribute(<br>
     *                    Globals.MESSAGE_KEY):vf1ActionMessagesF<br>
     *                    ([key="key01"Avalue="value01"])<br>
     *
     * <br>
     * sessionGlobals.MESSAGE_KEYɊY鑮̃TCY0łA
     * messages̃TCY1ꍇAsesssionGlobals.MESSAGE_KEY
     * messages̗vfĂ邱ƂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testAddMessages06() throws Exception {
        // O
        // sessionɃZbgvf0ActionMessages
        MockHttpSession session = new MockHttpSession();
        ActionMessages smessages = new ActionMessages();
        session.setAttribute(Globals.MESSAGE_KEY, smessages);

        // p[^Ƃēnvf1ActionMessages
        ActionMessages messages = new ActionMessages();
        ActionMessage msg = new ActionMessage("key01", "value01");

        messages.add(Globals.MESSAGE_KEY, msg);

        ActionEx action = new ActionEx_ActionExStub01();

        // eXg{
        action.addMessages(session, messages);

        // 
        ActionMessages msgs =
            (ActionMessages) session.getAttribute(Globals.MESSAGE_KEY);

        Iterator it = msgs.get(Globals.MESSAGE_KEY);
        ActionMessage message = (ActionMessage) it.next();
        String key = message.getKey();
        String value = (String) message.getValues()[0];
        assertEquals("key01", key);
        assertEquals("value01", value);
    }

    /**
     * testAddMessages07()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() session:not null<br>
     *         () messages:vf3ActionMessagesF<br>
     *                ([key="key01"Avalue="value01"]A<br>
     *                [key="key02"Avalue="value02"]A<br>
     *                [key="key03"Avalue="value03"])<br>
     *         () (session#getAttribute(<br>
     *                Globals.MESSAGE_KEY)).size():vf1ActionMessagesF<br>
     *                ([key="key04"Avalue="value04"])<br>
     *
     * <br>
     * ҒlF(ԕω) sessioin#getAttribute(<br>
     *                    Globals.MESSAGE_KEY):vf4ActionMessagesF<br>
     *                    ([key="key01"Avalue="value01"]A<br>
     *                    [key="key02"Avalue="value02"]A<br>
     *                    [key="key03"Avalue="value03"]A<br>
     *                    [key="key04"Avalue="value04"])<br>
     *
     * <br>
     * sessionGlobals.MESSAGE_KEYɊY鑮̃TCY1łA
     * messages̃TCY3ꍇAsesssionGlobals.MESSAGE_KEY
     * messages̗vfsession̗̑vfĂ邱ƂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testAddMessages07() throws Exception {
        // O
        // sessionɃZbgvf1ActionMessages
        MockHttpSession session = new MockHttpSession();
        ActionMessage smsg = new ActionMessage("key04", "value04");

        ActionMessages smessages = new ActionMessages();
        smessages.add(Globals.MESSAGE_KEY, smsg);

        session.setAttribute(Globals.MESSAGE_KEY, smessages);


        // p[^Ƃēnvf3ActionMessages
        ActionMessages messages = new ActionMessages();

        ActionMessage msg = new ActionMessage("key01", "value01");
        messages.add(Globals.MESSAGE_KEY, msg);

        msg = new ActionMessage("key02", "value02");
        messages.add(Globals.MESSAGE_KEY, msg);

        msg = new ActionMessage("key03", "value03");
        messages.add(Globals.MESSAGE_KEY, msg);


        ActionEx action = new ActionEx_ActionExStub01();

        // eXg{
        action.addMessages(session, messages);

        // 
        ActionMessages msgs =
            (ActionMessages) session.getAttribute(Globals.MESSAGE_KEY);

        Iterator it = msgs.get(Globals.MESSAGE_KEY);
        ActionMessage message = (ActionMessage) it.next();
        String key = message.getKey();
        String value = (String) message.getValues()[0];
        assertEquals("key04", key);
        assertEquals("value04", value);

        message = (ActionMessage) it.next();
        key = message.getKey();
        value = (String) message.getValues()[0];
        assertEquals("key01", key);
        assertEquals("value01", value);

        message = (ActionMessage) it.next();
        key = message.getKey();
        value = (String) message.getValues()[0];
        assertEquals("key02", key);
        assertEquals("value02", value);

        message = (ActionMessage) it.next();
        key = message.getKey();
        value = (String) message.getValues()[0];
        assertEquals("key03", key);
        assertEquals("value03", value);
    }

    /**
     * testAddMessages08()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() session:not null<br>
     *         () messages:vf1ActionMessagesF<br>
     *                ([key="key01"Avalue="value01"])<br>
     *         () (session#getAttribute(<br>
     *                Globals.MESSAGE_KEY)).size():vf3ActionMessagesF<br>
     *                ([key="key02"Avalue="value02"]A<br>
     *                [key="key03"Avalue="value03"]A<br>
     *                [key="key04"Avalue="value04"])<br>
     *
     * <br>
     * ҒlF(ԕω) sessioin#getAttribute(<br>
     *                    Globals.MESSAGE_KEY):vf4ActionMessagesF<br>
     *                    ([key="key02"Avalue="value02"]A<br>
     *                    [key="key03"Avalue="value03"]A<br>
     *                    [key="key04"Avalue="value04"]A<br>
     *                    [key="key01"Avalue="value01"])<br>
     *
     * <br>
     * sessionGlobals.MESSAGE_KEYɊY鑮̃TCY3łA
     * messages̃TCY1ꍇAsesssionGlobals.MESSAGE_KEY
     * messages̗vfsession̗̑vfĂ邱ƂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testAddMessages08() throws Exception {
        // O
        // sessionɃZbgvf3ActionMessages
        MockHttpSession session = new MockHttpSession();
        ActionMessage smsg = new ActionMessage("key02", "value02");
        ActionMessages smessages = new ActionMessages();
        smessages.add(Globals.MESSAGE_KEY, smsg);

        smsg = new ActionMessage("key03", "value03");
        smessages.add(Globals.MESSAGE_KEY, smsg);

        smsg = new ActionMessage("key04", "value04");
        smessages.add(Globals.MESSAGE_KEY, smsg);

        session.setAttribute(Globals.MESSAGE_KEY, smessages);


        // p[^Ƃēnvf1ActionMessages
        ActionMessages messages = new ActionMessages();
        ActionMessage msg = new ActionMessage("key01", "value01");
        messages.add(Globals.MESSAGE_KEY, msg);


        ActionEx action = new ActionEx_ActionExStub01();

        // eXg{
        action.addMessages(session, messages);

        // 
        ActionMessages msgs =
            (ActionMessages) session.getAttribute(Globals.MESSAGE_KEY);

        Iterator it = msgs.get(Globals.MESSAGE_KEY);
        ActionMessage message = (ActionMessage) it.next();
        String key = message.getKey();
        String value = (String) message.getValues()[0];
        assertEquals("key02", key);
        assertEquals("value02", value);

        message = (ActionMessage) it.next();
        key = message.getKey();
        value = (String) message.getValues()[0];
        assertEquals("key03", key);
        assertEquals("value03", value);

        message = (ActionMessage) it.next();
        key = message.getKey();
        value = (String) message.getValues()[0];
        assertEquals("key04", key);
        assertEquals("value04", value);

        message = (ActionMessage) it.next();
        key = message.getKey();
        value = (String) message.getValues()[0];
        assertEquals("key01", key);
        assertEquals("value01", value);
    }
}
