/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.actions;

import java.util.Iterator;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;

import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.fw.service.thin.AbstractBLogicMapper;
import jp.terasoluna.fw.service.thin.BLogicIO;
import jp.terasoluna.fw.service.thin.BLogicMessage;
import jp.terasoluna.fw.service.thin.BLogicMessages;
import jp.terasoluna.fw.service.thin.BLogicResources;
import jp.terasoluna.fw.service.thin.BLogicResult;
import jp.terasoluna.fw.web.struts.action.ActionMappingEx;
import jp.terasoluna.fw.web.struts.form.DynaValidatorActionFormEx;
import jp.terasoluna.fw.web.struts.plugins.BLogicIOPlugIn;
import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.MockHttpServletResponse;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

import org.apache.struts.Globals;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.impl.ModuleConfigImpl;

import com.mockrunner.mock.web.MockActionMapping;
import com.mockrunner.mock.web.MockServletContext;

/**
 * {@link jp.terasoluna.fw.web.struts.actions.AbstractBLogicAction}
 * NX̃ubN{bNXeXgB
 *
 * <p>
 * <h4>yNX̊Tvz</h4>
 * rWlXWbNNۃNXB
 * <p>
 *
 * @see jp.terasoluna.fw.web.struts.actions.AbstractBLogicAction
 */
public class AbstractBLogicActionTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     *
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(AbstractBLogicActionTest.class);
    }

    /**
     * sB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        LogUTUtil.flush();
    }

    /**
     * IsB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     *
     * @param name ̃eXgP[X̖OB
     */
    public AbstractBLogicActionTest(String name) {
        super(name);
    }

    /**
     * testSetSaveMessageScope01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() saveMessageScope:"request"<br>
     *         () saveMessageScope:null<br>
     *
     * <br>
     * ҒlF(ԕω) saveMessageScope:"request"<br>
     *
     * <br>
     * Ɏw肵lAbstractBLogicActionsaveMessageScopeɐɊi[邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetSaveMessageScope01() throws Exception {
        // O
        AbstractBLogicAction_AbstractBLogicActionStub01 action =
            new AbstractBLogicAction_AbstractBLogicActionStub01();

        UTUtil.setPrivateField(action, "saveMessageScope", null);

        // eXg{
        action.setSaveMessageScope("request");

        // 
        assertEquals("request", UTUtil.getPrivateField(action, "saveMessageScope"));
    }

    /**
     * testDoExecute02()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() mapping:MappingF<br>
     *                ClassCastException<br>
     *         () form:FormEx<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *
     * <br>
     * ҒlF(ԕω) O:SystemExceptionF<br>
     *                    bZ[WL[F<br>
     *                    "error.blogic.mapping"<br>
     *                    bvOF<br>
     *                    ClassCastException<br>
     *         (ԕω) O:O<br>
     *                    G[OF<br>
     *                    "Illegal ActionMapping."<br>
     *
     * <br>
     * mappingActionMappingEx̃CX^XłȂꍇA
     * O邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testDoExecute02() throws Exception {
        // O
        MockActionMapping mapping = new MockActionMapping();

        DynaValidatorActionFormEx form = new DynaValidatorActionFormEx();

        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();

        AbstractBLogicAction_AbstractBLogicActionStub01 action =
            new AbstractBLogicAction_AbstractBLogicActionStub01();

        try {
            // eXg{
            action.doExecute(mapping, form, req, res);
            fail();
        } catch (SystemException e) {
            // 
            assertEquals(ClassCastException.class.getName(),
                    e.getCause().getClass().getName());
            assertTrue(LogUTUtil.checkError("Illegal ActionMapping."));
            assertEquals("errors.blogic.mapping", e.getErrorCode());
        }
    }

    /**
     * testDoExecute03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:MappingEx<br>
     *         () form:ActionForm<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () getBLogic<br>
     *                Params():null<br>
     *         () doExecuteBLogic()<br>
     *                ^[lresult:BLogicResult<br>
     *                ([resultString=<br>
     *                "resultString"])<br>
     *
     * <br>
     * ҒlF(߂l) ActionForward:ActionForward.<br>
     *                  getName()F<br>
     *                  "resultString"<br>
     *         (ԕω) preDoExecute<br>
     *                    BLogic():ĂяomFF<br>
     *                    preDoExecuteBLogic(request, response, null)<br>
     *         (ԕω) doExecute<br>
     *                    BLogic():ĂяomFF<br>
     *                    doExecuteBLogic(null)<br>
     *         (ԕω) postDoExecute<br>
     *                    Blogic():ĂяomFF<br>
     *                    postDoExecuteBLogic(request, response, params, null)<br>
     *         (ԕω) evaluate<br>
     *                    BLogicResult():ĂяomF<br>
     *                    evaluateBLogicResult(result, request, response, mappingEx)<br>
     *
     * <br>
     * AbstractBLogicActiongetBLogicParams()nullԂꍇA<br>
     * Oo͂A<br>
     * preDoExecuteBLogic()AdoExecuteBLogic()ApostDoExecuteBLogic()ĂяoB
     * <br>
     * doExecuteBLogic()̃^[lnullłȂꍇAevaluateBLogicResult()
     * ĂяoActionForwardIuWFNgԂƂmFB<br>
     * ActionFormFormExłȂĂs邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testDoExecute03() throws Exception {
        // O
        ActionMappingEx mapping = new ActionMappingEx();

        // "resultString"̃ANVtH[h̐
        ActionForward forw = new ActionForward();
        forw.setName("resultString");
        // ModuleConfig쐬
        ModuleConfig mConfig = new ModuleConfigImpl("");
        // ԋpActionForwardw
        mConfig.addForwardConfig(forw);
        // W[RtBOforwardw
        mapping.setModuleConfig(mConfig);

        // ActionEx
        ActionForm form = 
        	new ActionForm(){
                private static final long serialVersionUID = 1L;
            };

        // request, response
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();

        // AbstractBLogicAction
        AbstractBLogicAction_AbstractBLogicActionStub01 action =
            new AbstractBLogicAction_AbstractBLogicActionStub01();

        // BLogicParams : null
        Object params = null;
        UTUtil.setPrivateField(action, "params", params);

        // BLogicResult : resultString="resultString"
        BLogicResult result = new BLogicResult();
        result.setResultString("resultString");
        UTUtil.setPrivateField(action, "result", result);

        ActionForward forward = null;

        // eXg{
        forward = action.doExecute(mapping, form, req, res);

        // 
        // forward.getName()
        assertEquals("resultString", forward.getName());

        // ĂяomF:preDoExecuteBLogic()
        assertTrue(action.isPreDoExecuteBLogic);
        assertSame(req, action.requestPre);
        assertSame(res, action.responsePre);
        assertSame(params, action.paramsPre);

        // ĂяomF:doExecuteBLogic()
        assertTrue(action.isDoExecuteBLogic);
        assertSame(params, action.paramDoExecuteBLogic);

        // ĂяomF:postDoExecuteBLogic()
        assertTrue(action.isPostDoExecuteBLogic);
        assertSame(req, action.requestPost);
        assertSame(res, action.responsePost);
        assertSame(params, action.paramsPost);
        assertSame(result, action.resultPost);

        // ĂяomF:evaluateBLogicResult()
        assertTrue(action.isEvaluateBLogicResult);
        assertSame(result, action.resultEvaluateBLogicResult);
        assertSame(req, action.requestEvaluateBLogicResult);
        assertSame(res, action.responseEvaluateBLogicResult);
        assertSame(mapping, action.mappingEvaluateBLogicResult);
    }

    /**
     * testDoExecute04()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() mapping:MappingEx<br>
     *         () form:FormEx<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () getBLogic<br>
     *                Params():IuWFNg<br>
     *         () doExecuteBLogic()<br>
     *                ^[lresult:null<br>
     *
     * <br>
     * ҒlF(ԕω) preDoExecute<br>
     *                    BLogic():ĂяomFF<br>
     *                    preDoExecuteBLogic(request, response, params)<br>
     *         (ԕω) doExecute<br>
     *                    BLogic():ĂяomFF<br>
     *                    doExecuteBLogic(params)<br>
     *         (ԕω) postDoExecute<br>
     *                    Blogic():ĂяomFF<br>
     *                    postDoExecuteBLogic(request, response, params, null)<br>
     *         (ԕω) evaluate<br>
     *                    BLogicResult():ĂяoȂƂmF<br>
     *         (ԕω) O:SystemExceptionF<br>
     *                    bZ[WL[F<br>
     *                    "errors.blogic.result.null"<br>
     *                    bvOF<br>
     *                    NullPointerException<br>
     *         (ԕω) O:O<br>
     *                    G[OF<br>
     *                    "BLogicResult is null."<br>
     *
     * <br>
     * AbstractBLogicActiongetBLogicParams()not nullłAdoExcecute()
     * BLogicResultCX^XԂꍇApreDoExecuteBLogic()A
     * doExecuteBLogic()ApostDoExecuteBLogic()ĂяoB<br>
     * doExecuteBLogic()̃^[lnull̏ꍇAO邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testDoExecute04() throws Exception {
        // O
        ActionMappingEx mapping = new ActionMappingEx();

        // "resultString"̃ANVtH[h̐
        ActionForward forw = new ActionForward();
        forw.setName("resultString");
        // ModuleConfig쐬
        ModuleConfig mConfig = new ModuleConfigImpl("");
        // ԋpActionForwardw
        mConfig.addForwardConfig(forw);
        // W[RtBOforwardw
        mapping.setModuleConfig(mConfig);

        // ActionEx
        DynaValidatorActionFormEx form = new DynaValidatorActionFormEx();

        // request, response
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();

        // AbstractBLogicAction
        AbstractBLogicAction_AbstractBLogicActionStub01 action =
            new AbstractBLogicAction_AbstractBLogicActionStub01();

        // BLogicParams : Object
        Object params = new Object();
        UTUtil.setPrivateField(action, "params", params);

        // BLogicResult : null
        BLogicResult result = null;
        UTUtil.setPrivateField(action, "result", result);


        try {
            // eXg{
            action.doExecute(mapping, form, req, res);
            fail();
        } catch (SystemException e) {
            // 
            assertEquals(NullPointerException.class.getName(),
                    e.getCause().getClass().getName());
            assertTrue(LogUTUtil.checkError("BLogicResult is null."));
            assertEquals("errors.blogic.result.null", e.getErrorCode());

            // ĂяomF:preDoExecuteBLogic()
            assertTrue(action.isPreDoExecuteBLogic);
            assertSame(req, action.requestPre);
            assertSame(res, action.responsePre);
            assertSame(params, action.paramsPre);

            // ĂяomF:doExecuteBLogic()
            assertTrue(action.isDoExecuteBLogic);
            assertSame(params, action.paramDoExecuteBLogic);

            // ĂяomF:postDoExecuteBLogic()
            assertTrue(action.isPostDoExecuteBLogic);
            assertSame(req, action.requestPost);
            assertSame(res, action.responsePost);
            assertSame(params, action.paramsPost);
            assertSame(result, action.resultPost);

            // ĂяomF:evaluateBLogicResult()
            assertFalse(action.isEvaluateBLogicResult);
        }
    }

    /**
     * testDoExecute05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:MappingEx<br>
     *         () form:FormEx<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () getBLogic<br>
     *                Params():IuWFNg<br>
     *         () doExecuteBLogic()<br>
     *                ^[lresult:BLogicResult<br>
     *                ([resultString=<br>
     *                "resultString"])<br>
     *
     * <br>
     * ҒlF(߂l) ActionForward:ActionForward.<br>
     *                  getName()F<br>
     *                  "resultString"<br>
     *         (ԕω) preDoExecute<br>
     *                    BLogic():ĂяomFF<br>
     *                    preDoExecuteBLogic(request, response, params)<br>
     *         (ԕω) doExecute<br>
     *                    BLogic():ĂяomFF<br>
     *                    doExecuteBLogic(params)<br>
     *         (ԕω) postDoExecute<br>
     *                    Blogic():ĂяomFF<br>
     *                    postDoExecuteBLogic(request, response, params, result)<br>
     *         (ԕω) evaluate<br>
     *                    BLogicResult():ĂяomF<br>
     *                    evaluateBLogicResult(result, request, response, mappingEx)<br>
     *
     * <br>
     * AbstractBLogicActiongetBLogicParams()not nullłAdoExcecute()
     * BLogicResultCX^XԂꍇApreDoExecuteBLogic()A
     * doExecuteBLogic()ApostDoExecuteBLogic()ĂяoB<br>
     * doExecuteBLogic()̃^[lnullłȂꍇAevaluateBLogicResult()
     * ĂяoActionForwardIuWFNgԂƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testDoExecute05() throws Exception {
        // O
        ActionMappingEx mapping = new ActionMappingEx();

        // "resultString"̃ANVtH[h̐
        ActionForward forw = new ActionForward();
        forw.setName("resultString");
        // ModuleConfig쐬
        ModuleConfig mConfig = new ModuleConfigImpl("");
        // ԋpActionForwardw
        mConfig.addForwardConfig(forw);
        // W[RtBOforwardw
        mapping.setModuleConfig(mConfig);

        // ActionEx
        DynaValidatorActionFormEx form = new DynaValidatorActionFormEx();

        // request, response
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();

        // AbstractBLogicAction
        AbstractBLogicAction_AbstractBLogicActionStub01 action =
            new AbstractBLogicAction_AbstractBLogicActionStub01();

        // BLogicParams : Object
        Object params = "abc";
        UTUtil.setPrivateField(action, "params", params);

        // BLogicResult : resultString="resultString"
        BLogicResult result = new BLogicResult();
        result.setResultString("resultString");
        UTUtil.setPrivateField(action, "result", result);

        ActionForward forward = null;

        // eXg{
        forward = action.doExecute(mapping, form, req, res);

        // 
        // forward.getName()
        assertEquals("resultString", forward.getName());

        // ĂяomF:preDoExecuteBLogic()
        assertTrue(action.isPreDoExecuteBLogic);
        assertSame(req, action.requestPre);
        assertSame(res, action.responsePre);
        assertSame(params, action.paramsPre);

        // ĂяomF:doExecuteBLogic()
        assertTrue(action.isDoExecuteBLogic);
        assertSame(params, action.paramDoExecuteBLogic);

        // ĂяomF:postDoExecuteBLogic()
        assertTrue(action.isPostDoExecuteBLogic);
        assertSame(req, action.requestPost);
        assertSame(res, action.responsePost);
        assertSame(params, action.paramsPost);
        assertSame(result, action.resultPost);

        // ĂяomF:evaluateBLogicResult()
        assertTrue(action.isEvaluateBLogicResult);
        assertSame(result, action.resultEvaluateBLogicResult);
        assertSame(req, action.requestEvaluateBLogicResult);
        assertSame(res, action.responseEvaluateBLogicResult);
        assertSame(mapping, action.mappingEvaluateBLogicResult);
    }

    /**
     * testGetBLogicParams01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:not null<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () getBLogicIO(<br>
     *                request, response):BLogicIO<br>
     *                ([path="path"])<br>
     *         () getBLogicMapper(<br>
     *                request):AbstractBLogicAction_AbstractBLogicMapperStub01
     *                IuWFNg<br>
     *         () AbstractBLogicMapper.<br>
     *                mapBLogicParams():null<br>
     *
     * <br>
     * ҒlF(߂l) P:null<br>
     *
     * <br>
     * AbstractBLogicMapper.mapBLogicParams()null̏ꍇAnullԂƂ
     * mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetBLogicParams01() throws Exception {
        // O
        // mapping
        ActionMappingEx mapping = new ActionMappingEx();

        // request, response
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();

        // AbstractBLogicAction
        AbstractBLogicAction_AbstractBLogicActionStub03 action =
            new AbstractBLogicAction_AbstractBLogicActionStub03();

        // mapper.mapBLogicParams : null
        AbstractBLogicMapper mapper =
            new AbstractBLogicAction_AbstractBLogicMapperStub01();
        action.mapper = mapper;

        // eXg{
        Object bean = action.getBLogicParams(mapping, req, res);

        // 
        assertNull(bean);
    }

    /**
     * testGetBLogicParams02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:not null<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () getBLogicIO(<br>
     *                request, response):BLogicIO<br>
     *                ([path="path"])<br>
     *         () getBLogicMapper(<br>
     *                request):AbstractBLogicAction_AbstractBLogicMapperStub02
     *                IuWFNg<br>
     *         () AbstractBLogicMapper.<br>
     *                mapBLogicParams():String("abc")<br>
     *
     * <br>
     * ҒlF(߂l) P:String("abc")<br>
     *
     * <br>
     * AbstractBLogicMapper.mapBLogicParams()IuWFNg̏ꍇA
     * ̃IuWFNgԂƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetBLogicParams02() throws Exception {
        // O
        // mapping
        ActionMappingEx mapping = new ActionMappingEx();

        // request, response
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();

        // AbstractBLogicAction
        AbstractBLogicAction_AbstractBLogicActionStub03 action =
            new AbstractBLogicAction_AbstractBLogicActionStub03();

        // mapper.mapBLogicParams : new String("abc")
        AbstractBLogicMapper mapper =
            new AbstractBLogicAction_AbstractBLogicMapperStub02();
        action.mapper = mapper;

        // eXg{
        Object bean = action.getBLogicParams(mapping, req, res);

        // 
        assertEquals("abc", bean);
    }

    /**
     * testConvertMessages01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() blogicMessages:null<br>
     *
     * <br>
     * ҒlF(߂l) ActionMessages:null<br>
     *
     * <br>
     * blogicMessagesnull̏ꍇAnullԂƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testConvertMessages01() throws Exception {
        // O
        BLogicMessages errors = null;

        AbstractBLogicAction_AbstractBLogicActionStub05 action =
            new AbstractBLogicAction_AbstractBLogicActionStub05();

        // eXg{
        ActionMessages messages = action.convertMessages(errors);

        // 
        assertNull(messages);
    }

    /**
     * testConvertMessages02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() blogicMessages:0<br>
     *         () bZ[Wꗗ:list.size()==0<br>
     *         () bZ[W<br>
     *                O[vꗗ:groupList.size()==0<br>
     *
     * <br>
     * ҒlF(߂l) ActionMessages:ActionMessagesF()<br>
     *
     * <br>
     * BLogicMessagesƃbZ[WO[ṽTCY0̏ꍇAActionMessages
     * ԂƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testConvertMessages02() throws Exception {
        // O
        // list size : 0
        BLogicMessages errors = new BLogicMessages();

        AbstractBLogicAction_AbstractBLogicActionStub05 action =
            new AbstractBLogicAction_AbstractBLogicActionStub05();

        // eXg{
        ActionMessages messages = action.convertMessages(errors);

        // 
        assertTrue(messages.isEmpty());
    }

    /**
     * testConvertMessages03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() blogicMessages:not null<br>
     *         () bZ[Wꗗ:listF<br>
     *                (BLogicMessageF<br>
     *                [keyF"error01"AvalueF"value01"]<br>
     *                )<br>
     *         () bZ[W<br>
     *                O[vꗗ:groupListF<br>
     *                ("errors")<br>
     *         () blogicMessage.<br>
     *                isResource():true<br>
     *
     * <br>
     * ҒlF(߂l) ActionMessages:ActionMessagesF<br>
     *                  (<br>
     *                  ["errors"AActionMessage[<br>
     *                  keyF"error01"AvalueF"value01"]]<br>
     *                  )<br>
     *
     * <br>
     * BLogicMessages1BLogicMessagei[ĂAbZ[WO[v
     * 1̃O[vi[ĂAblogicMessage.isResource()true
     * ꍇAÕO[vL[łAOBLogicMessasgẽL[
     * o[ActionMessagei[ꂽActionMessagesԂ邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testConvertMessages03() throws Exception {
        // O
        BLogicMessages errors = new BLogicMessages();
        BLogicMessage error = new BLogicMessage("error01", "value01");
        UTUtil.setPrivateField(error, "resource", true);
        errors.add("errors", error);

        AbstractBLogicAction_AbstractBLogicActionStub05 action =
            new AbstractBLogicAction_AbstractBLogicActionStub05();

        // eXg{
        ActionMessages messages = action.convertMessages(errors);

        // 
        // messages
        // group
        Iterator itProps = messages.properties();
        String prop = (String) itProps.next();
        assertEquals("errors", prop);
        // message
        Iterator itMessages = messages.get(prop);
        ActionMessage resultMessage = (ActionMessage) itMessages.next();
        assertEquals("error01", resultMessage.getKey());
        assertEquals("value01", resultMessage.getValues()[0]);
    }

    /**
     * testConvertMessages04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() blogicMessages:not null<br>
     *         () bZ[Wꗗ:listF<br>
     *                (BLogicMessageF<br>
     *                [keyF"error01"Avalue[0]F"value0"Avalue[1]F"value1"A
     *                value[2]F"value2"]<br>
     *                )<br>
     *         () bZ[W<br>
     *                O[vꗗ:groupListF<br>
     *                ("errors")<br>
     *         () blogicMessage.<br>
     *                isResource():true<br>
     *
     * <br>
     * ҒlF(߂l) ActionMessages:ActionMessagesF<br>
     *                  (<br>
     *                  ["errors"AActionMessage[<br>
     *                  keyF"error01"Avalue[0]F"value0"Avalue[1]F"value1"A
     *                  value[2]F"value2"]]<br>
     *                  )<br>
     *
     * <br>
     * BLogicMessages1BLogicMessagei[ĂAbZ[WO[v
     * 1̃O[vi[ĂAblogicMessage.isResource()true
     * ꍇAÕO[vL[łAOBLogicMessasgẽL[
     * o[ActionMessagei[ꂽActionMessagesԂ邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testConvertMessages04() throws Exception {
        // O
        BLogicMessages errors = new BLogicMessages();
        Object[] values = new Object[3];
        values[0] = "value0";
        values[1] = "value1";
        values[2] = "value2";
        BLogicMessage error = new BLogicMessage("error01", values);
        UTUtil.setPrivateField(error, "resource", true);
        errors.add("errors", error);

        AbstractBLogicAction_AbstractBLogicActionStub05 action =
            new AbstractBLogicAction_AbstractBLogicActionStub05();

        // eXg{
        ActionMessages messages = action.convertMessages(errors);

        // 
        // messages
        // group
        Iterator itProps = messages.properties();
        String prop = (String) itProps.next();
        assertEquals("errors", prop);
        // message
        Iterator itMessages = messages.get(prop);
        ActionMessage resultMessage = (ActionMessage) itMessages.next();
        assertEquals("error01", resultMessage.getKey());
        assertEquals("value0", resultMessage.getValues()[0]);
        assertEquals("value1", resultMessage.getValues()[1]);
        assertEquals("value2", resultMessage.getValues()[2]);
    }

    /**
     * testConvertMessages05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() blogicMessages:not null<br>
     *         () bZ[Wꗗ:listF<br>
     *                (BLogicMessageF<br>
     *                [keyF"error01"AvalueF"value01"]<br>
     *                )<br>
     *         () bZ[W<br>
     *                O[vꗗ:groupListF<br>
     *                ("errors")<br>
     *         () blogicMessage.<br>
     *                isResource():false<br>
     *
     * <br>
     * ҒlF(߂l) ActionMessages:ActionMessagesF<br>
     *                  (<br>
     *                  ["errors"AActionMessage[<br>
     *                  keyF"error01"AvalueFnullAresourceFfalse]]<br>
     *                  )<br>
     *
     * <br>
     * BLogicMessages1BLogicMessagei[ĂAbZ[WO[v
     * 1̃O[vi[ĂAblogicMessage.isResource()true
     * łȂꍇAÕO[vL[łAO
     * BLogicMessasgẽL[BLogicMessage.isResource()̃o[
     * ActionMessagei[ꂽActionMessagesԂ邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testConvertMessages05() throws Exception {
        // O
        BLogicMessages errors = new BLogicMessages();
        BLogicMessage error = new BLogicMessage("error01", "value01");
        UTUtil.setPrivateField(error, "resource", false);
        errors.add("errors", error);

        AbstractBLogicAction_AbstractBLogicActionStub05 action =
            new AbstractBLogicAction_AbstractBLogicActionStub05();

        // eXg{
        ActionMessages messages = action.convertMessages(errors);

        // 
        // messages
        // group
        Iterator itProps = messages.properties();
        String prop = (String) itProps.next();
        assertEquals("errors", prop);
        // message
        Iterator itMessages = messages.get(prop);
        ActionMessage resultMessage = (ActionMessage) itMessages.next();
        assertEquals("error01", resultMessage.getKey());
        assertNull(resultMessage.getValues());
        assertFalse(resultMessage.isResource());
    }

    /**
     * testConvertMessages06()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() blogicMessages:not null<br>
     *         () bZ[Wꗗ:listF<br>
     *                (BLogicMessageF<br>
     *                [keyF"error01"AvalueF"value01"]A<br>
     *                BLogicMessageF<br>
     *                [keyF"error02"AvalueF"value02"]A<br>
     *                BLogicMessageF<br>
     *                [keyF"error03"AvalueF"value03"]<br>
     *                )<br>
     *         () bZ[W<br>
     *                O[vꗗ:groupListF<br>
     *                ("errors)<br>
     *         () blogicMessage.<br>
     *                isResource():list.get(0)Ftrue<br>
     *                list.get(1)Ftrue<br>
     *                list.get(2)Ftrue<br>
     *
     * <br>
     * ҒlF(߂l) ActionMessages:ActionMessagesF<br>
     *                  (<br>
     *                  ["errors"AActionMessage[<br>
     *                  keyF"error01"AvalueF"value01"]]A<br>
     *                  ["errors"AActionMessage[<br>
     *                  keyF"error02"AvalueF"value02"]]A<br>
     *                  ["errors"AActionMessage[<br>
     *                  keyF"error03"AvalueF"value03"]]<br>
     *                  )<br>
     *
     * <br>
     * blogicMessagesɕBLogicMessageƃbZ[WO[vi[Ă
     * ꍇAO[vL[ƂAOBLogicMessagẽL[ƃo[
     * ActionMessageǂɊi[ꂽActionMessagesԂ邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testConvertMessages06() throws Exception {
        // O
        BLogicMessages errors = new BLogicMessages();
        BLogicMessage error = new BLogicMessage("error01", "value01");
        UTUtil.setPrivateField(error, "resource", true);
        errors.add("errors", error);

        error = new BLogicMessage("error02", "value02");
        UTUtil.setPrivateField(error, "resource", true);
        errors.add("errors", error);

        error = new BLogicMessage("error03", "value03");
        UTUtil.setPrivateField(error, "resource", true);
        errors.add("errors", error);

        AbstractBLogicAction_AbstractBLogicActionStub05 action =
            new AbstractBLogicAction_AbstractBLogicActionStub05();

        // eXg{
        ActionMessages messages = action.convertMessages(errors);

        // 
        // messages
        // group
        Iterator itProps = messages.properties();
        String prop = (String) itProps.next();
        assertEquals("errors", prop);

        // message
        Iterator itMessages = messages.get(prop);
        ActionMessage resultMessage = (ActionMessage) itMessages.next();
        assertEquals("error01", resultMessage.getKey());
        assertEquals("value01", resultMessage.getValues()[0]);

        resultMessage = (ActionMessage) itMessages.next();
        assertEquals("error02", resultMessage.getKey());
        assertEquals("value02", resultMessage.getValues()[0]);

        resultMessage = (ActionMessage) itMessages.next();
        assertEquals("error03", resultMessage.getKey());
        assertEquals("value03", resultMessage.getValues()[0]);
    }

    /**
     * testEvaluateBLogicResult01()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() result:null<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () mapping:not null<br>
     *
     * <br>
     * ҒlF(ԕω) O:SystemExceptionF<br>
     *                    bZ[WL[F<br>
     *                    "errors.blogic.result.null"<br>
     *                    bvOF<br>
     *                    NullPointerException<br>
     *         (ԕω) O:O<br>
     *                    G[OF<br>
     *                    "BLogicResult is null."<br>
     *
     * <br>
     * resultnull̏ꍇASystemExceptionB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testEvaluateBLogicResult01() throws Exception {
        // O
        // result : null
        BLogicResult result = null;

        // request, response
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();

        // mapping
        ActionMappingEx mapping = new ActionMappingEx();

        // AbstractBLogicAction
        AbstractBLogicAction_AbstractBLogicActionStub04 action =
            new AbstractBLogicAction_AbstractBLogicActionStub04();

        try {
            // eXg{
            action.evaluateBLogicResult(result, req, res, mapping);
            fail();
        } catch (SystemException e) {
            assertEquals(NullPointerException.class.getName(),
                    e.getCause().getClass().getName());
            assertTrue(LogUTUtil.checkError("BLogicResult is null."));
            assertEquals("errors.blogic.result.null", e.getErrorCode());
        }
    }

    /**
     * testEvaluateBLogicResult02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() result:BLogicResult<br>
     *                IuWFNg<br>
     *                result.getErrors()F<br>
     *                BLogicMessages.list(<br>
     *                  BLogicMessage[key="error01"Avalue="value01"]<br>
     *                )<br>
     *                BLogicMessages.groupList("errors")<br>
     *                <br>
     *                result.getMessages()F<br>
     *                BLogicMessages.list(<br>
     *                  BLogicMessage[key="message01"Avalue="value01"]<br>
     *                )<br>
     *                BLogicMessages.groupList("messages")<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () mapping:not null<br>
     *         () saveMessageSope:null<br>
     *
     * <br>
     * ҒlF(ԕω) request.getAttribute(<br>
     *                    Globals.ERROR_KEY):ActionMessagesF<br>
     *                    (<br>
     *                    ["errors"AActionMessage[<br>
     *                    keyF"error01"AvalueF"value01"]]<br>
     *                    )<br>
     *         (ԕω) request.getAttribute(<br>
     *                    Globals.MESSAGE_KEY):ActionMessagesF<br>
     *                    (<br>
     *                    ["messages"AActionMessage[<br>
     *                    keyF"message01"AvalueF"value01"]]<br>
     *                    )<br>
     *         (ԕω) getBLogicIO(<br>
     *                    mappingEx, request):ĂяoȂƂmF<br>
     *         (ԕω) AbstractBLogicMapper.<br>
     *                    mapBLogicReslut():ĂяoȂƂmF<br>
     *
     * <br>
     * saveMessageScopenull̏ꍇArequestɃG[ƃbZ[W̃Xg
     * i[Ă邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testEvaluateBLogicResult02() throws Exception {
        // O
        // result : not null
        BLogicResult result = new BLogicResult();

        // errors
        BLogicMessages errors = new BLogicMessages();
        BLogicMessage error = new BLogicMessage("error01", "value01");
        errors.add("errors", error);

        // messages
        BLogicMessages messages = new BLogicMessages();
        BLogicMessage message = new BLogicMessage("message01", "value01");
        messages.add("messages", message);

        result.setErrors(errors);
        result.setMessages(messages);

        // request, response
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setAttribute("isMapBLogicResult", "false");
        MockHttpServletResponse res = new MockHttpServletResponse();

        // mapping
        ActionMappingEx mapping = new ActionMappingEx();

        // AbstractBLogicAction
        AbstractBLogicAction_AbstractBLogicActionStub04 action =
            new AbstractBLogicAction_AbstractBLogicActionStub04();

        // saveMessageScope : null
        String saveMessageScope = null;
        UTUtil.setPrivateField(action, "saveMessageScope", saveMessageScope);

        // eXg{
        action.evaluateBLogicResult(result, req, res, mapping);

        // 
        // errors
        ActionMessages resultErrors =
            (ActionMessages) req.getAttribute(Globals.ERROR_KEY);
        // group
        Iterator itProps = resultErrors.properties();
        String prop = (String) itProps.next();
        assertEquals("errors", prop);
        // error
        Iterator itErrors = resultErrors.get(prop);
        ActionMessage resultError = (ActionMessage) itErrors.next();
        assertEquals("error01", resultError.getKey());
        assertEquals("value01", resultError.getValues()[0]);

        // messages
        ActionMessages resultMessages =
            (ActionMessages) req.getAttribute(Globals.MESSAGE_KEY);
        // group
        Iterator itMProps = resultMessages.properties();
        String mprop = (String) itMProps.next();
        assertEquals("messages", mprop);
        // message
        Iterator itMessages = resultMessages.get(mprop);
        ActionMessage resultMessage = (ActionMessage) itMessages.next();
        assertEquals("message01", resultMessage.getKey());
        assertEquals("value01", resultMessage.getValues()[0]);

        // getBLogicIOĂяomF
        assertFalse(action.isGetBLogicIO);

        // mapBLogicResultĂяomF
        assertEquals("false", req.getAttribute("isMapBLogicResult"));
    }

    /**
     * testEvaluateBLogicResult03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() result:BLogicResult<br>
     *                IuWFNg<br>
     *                result.getErrors()F<br>
     *                BLogicMessages.list(<br>
     *                  BLogicMessage[key="error01"Avalue="value01"]<br>
     *                )<br>
     *                BLogicMessages.groupList("errors")<br>
     *                <br>
     *                result.getMessages()F<br>
     *                BLogicMessages.list(<br>
     *                  BLogicMessage[key="message01"Avalue="value01"]<br>
     *                )<br>
     *                BLogicMessages.groupList("messages")<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () mapping:not null<br>
     *         () saveMessageSope:""<br>
     *
     * <br>
     * ҒlF(ԕω) request.getAttribute(<br>
     *                    Globals.ERROR_KEY):ActionMessagesF<br>
     *                    (<br>
     *                    ["errors"AActionMessage[<br>
     *                    keyF"error01"AvalueF"value01"]]<br>
     *                    )<br>
     *         (ԕω) request.getAttribute(<br>
     *                    Globals.MESSAGE_KEY):ActionMessagesF<br>
     *                    (<br>
     *                    ["messages"AActionMessage[<br>
     *                    keyF"message01"AvalueF"value01"]]<br>
     *                    )<br>
     *         (ԕω) getBLogicIO(<br>
     *                    mappingEx, request):ĂяoȂƂmF<br>
     *         (ԕω) AbstractBLogicMapper.<br>
     *                    mapBLogicReslut():ĂяoȂƂmF<br>
     *
     * <br>
     * saveMessageScope"session"łȂꍇArequestɃG[ƃbZ[W
     * Xgi[Ă邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testEvaluateBLogicResult03() throws Exception {
        // O
        // result : not null
        BLogicResult result = new BLogicResult();

        // errors
        BLogicMessages errors = new BLogicMessages();
        BLogicMessage error = new BLogicMessage("error01", "value01");
        errors.add("errors", error);

        // messages
        BLogicMessages messages = new BLogicMessages();
        BLogicMessage message = new BLogicMessage("message01", "value01");
        messages.add("messages", message);

        result.setErrors(errors);
        result.setMessages(messages);

        // request, response
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setAttribute("isMapBLogicResult", "false");
        MockHttpServletResponse res = new MockHttpServletResponse();

        // mapping
        ActionMappingEx mapping = new ActionMappingEx();

        // AbstractBLogicAction
        AbstractBLogicAction_AbstractBLogicActionStub04 action =
            new AbstractBLogicAction_AbstractBLogicActionStub04();

        // saveMessageScope : ""
        String saveMessageScope = "";
        UTUtil.setPrivateField(action, "saveMessageScope", saveMessageScope);

        // eXg{
        action.evaluateBLogicResult(result, req, res, mapping);

        // 
        // errors
        ActionMessages resultErrors =
            (ActionMessages) req.getAttribute(Globals.ERROR_KEY);
        // group
        Iterator itProps = resultErrors.properties();
        String prop = (String) itProps.next();
        assertEquals("errors", prop);
        // error
        Iterator itErrors = resultErrors.get(prop);
        ActionMessage resultError = (ActionMessage) itErrors.next();
        assertEquals("error01", resultError.getKey());
        assertEquals("value01", resultError.getValues()[0]);

        // messages
        ActionMessages resultMessages =
            (ActionMessages) req.getAttribute(Globals.MESSAGE_KEY);
        // group
        Iterator itMProps = resultMessages.properties();
        String mprop = (String) itMProps.next();
        assertEquals("messages", mprop);
        // message
        Iterator itMessages = resultMessages.get(mprop);
        ActionMessage resultMessage = (ActionMessage) itMessages.next();
        assertEquals("message01", resultMessage.getKey());
        assertEquals("value01", resultMessage.getValues()[0]);

        // getBLogicIOĂяomF
        assertFalse(action.isGetBLogicIO);

        // mapBLogicResultĂяomF
        assertEquals("false", req.getAttribute("isMapBLogicResult"));
    }

    /**
     * testEvaluateBLogicResult04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() result:BLogicResult<br>
     *                IuWFNg<br>
     *                result.getErrors()F<br>
     *                BLogicMessages.list(<br>
     *                  BLogicMessage[key="error01"Avalue="value01"]<br>
     *                )<br>
     *                BLogicMessages.groupList("errors")<br>
     *                <br>
     *                result.getMessages()F<br>
     *                BLogicMessages.list(<br>
     *                  BLogicMessage[key="message01"Avalue="value01"]<br>
     *                )<br>
     *                BLogicMessages.groupList("messages")<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () mapping:not null<br>
     *         () saveMessageSope:"session"<br>
     *
     * <br>
     * ҒlF(ԕω) session.getAttribute(<br>
     *                    Globals.ERROR_KEY):ActionMessagesF<br>
     *                    (<br>
     *                    ["errors"AActionMessage[<br>
     *                    keyF"error01"AvalueF"value01"]]<br>
     *                    )<br>
     *         (ԕω) session.getAttribute(<br>
     *                    Globals.MESSAGE_KEY):ActionMessagesF<br>
     *                    (<br>
     *                    ["messages"AActionMessage[<br>
     *                    keyF"message01"AvalueF"value01"]]<br>
     *                    )<br>
     *         (ԕω) getBLogicIO(<br>
     *                    mappingEx, request):ĂяoȂƂmF<br>
     *         (ԕω) AbstractBLogicMapper.<br>
     *                    mapBLogicReslut():ĂяoȂƂmF<br>
     *
     * <br>
     * saveMessageScope"session"ꍇAsessionɃG[ƃbZ[W
     * Xgi[Ă邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testEvaluateBLogicResult04() throws Exception {
        // O
        // result : not null
        BLogicResult result = new BLogicResult();

        // errors
        BLogicMessages errors = new BLogicMessages();
        BLogicMessage error = new BLogicMessage("error01", "value01");
        errors.add("errors", error);

        // messages
        BLogicMessages messages = new BLogicMessages();
        BLogicMessage message = new BLogicMessage("message01", "value01");
        messages.add("messages", message);

        result.setErrors(errors);
        result.setMessages(messages);

        // request, response
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setAttribute("isMapBLogicResult", "false");
        MockHttpServletResponse res = new MockHttpServletResponse();

        // mapping
        ActionMappingEx mapping = new ActionMappingEx();

        // AbstractBLogicAction
        AbstractBLogicAction_AbstractBLogicActionStub04 action =
            new AbstractBLogicAction_AbstractBLogicActionStub04();

        // saveMessageScope : "session"
        String saveMessageScope = "session";
        UTUtil.setPrivateField(action, "saveMessageScope", saveMessageScope);

        // eXg{
        action.evaluateBLogicResult(result, req, res, mapping);

        // 
        // session擾
        HttpSession session = req.getSession();
        // errors
        ActionMessages resultErrors =
            (ActionMessages) session.getAttribute(Globals.ERROR_KEY);
        // group
        Iterator itProps = resultErrors.properties();
        String prop = (String) itProps.next();
        assertEquals("errors", prop);
        // error
        Iterator itErrors = resultErrors.get(prop);
        ActionMessage resultError = (ActionMessage) itErrors.next();
        assertEquals("error01", resultError.getKey());
        assertEquals("value01", resultError.getValues()[0]);

        // messages
        ActionMessages resultMessages =
            (ActionMessages) session.getAttribute(Globals.MESSAGE_KEY);
        // group
        Iterator itMProps = resultMessages.properties();
        String mprop = (String) itMProps.next();
        assertEquals("messages", mprop);
        // message
        Iterator itMessages = resultMessages.get(mprop);
        ActionMessage resultMessage = (ActionMessage) itMessages.next();
        assertEquals("message01", resultMessage.getKey());
        assertEquals("value01", resultMessage.getValues()[0]);

        // getBLogicIOĂяomF
        assertFalse(action.isGetBLogicIO);

        // mapBLogicResultĂяomF
        assertEquals("false", req.getAttribute("isMapBLogicResult"));
    }

    /**
     * testEvaluateBLogicResult05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() result:BLogicResult<br>
     *                IuWFNgF<br>
     *                result.getErrors()Fnull<br>
     *                <br>
     *                result.getMessages()F<br>
     *                BLogicMessages.list(<br>
     *                  BLogicMessage[key="message01"Avalue="value01"]<br>
     *                )<br>
     *                BLogicMessages.groupList("messages")<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () mapping:not null<br>
     *         () saveMessageSope:"SESSION"<br>
     *
     * <br>
     * ҒlF(ԕω) session.getAttribute(<br>
     *                    Globals.ERROR_KEY):null<br>
     *         (ԕω) session.getAttribute(<br>
     *                    Globals.MESSAGE_KEY):ActionMessagesF<br>
     *                    (<br>
     *                    ["messages"AActionMessage[<br>
     *                    keyF"message01"AvalueF"value01"]]<br>
     *                    )<br>
     *         (ԕω) getBLogicIO(<br>
     *                    mappingEx, request):ĂяomFF<br>
     *                    getBLogicIO(<br>
     *                    mappingEx, request)<br>
     *         (ԕω) AbstractBLogicMapper.<br>
     *                    mapBLogicReslut():ĂяomFF<br>
     *                    mapBLogicResult(request, response, blogicIO, result)<br>
     *
     * <br>
     * result.getErrors()nullꍇAAbstractBLogicMapper.<br>
     * mapBLogicReslut()Ăяo邱ƂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testEvaluateBLogicResult05() throws Exception {
        // O
        // result : not null
        BLogicResult result = new BLogicResult();

        // errors : null
        result.setErrors(null);

        // messages
        BLogicMessages messages = new BLogicMessages();
        BLogicMessage message = new BLogicMessage("message01", "value01");
        messages.add("messages", message);

        result.setMessages(messages);

        // request, response
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setAttribute("isMapBLogicResult", "false");
        MockHttpServletResponse res = new MockHttpServletResponse();

        // mapping
        ActionMappingEx mapping = new ActionMappingEx();

        // AbstractBLogicAction
        AbstractBLogicAction_AbstractBLogicActionStub04 action =
            new AbstractBLogicAction_AbstractBLogicActionStub04();

        // saveMessageScope : "SESSION"
        String saveMessageScope = "SESSION";
        UTUtil.setPrivateField(action, "saveMessageScope", saveMessageScope);

        // eXg{
        action.evaluateBLogicResult(result, req, res, mapping);

        // 
        // session擾
        HttpSession session = req.getSession();
        // errors
        ActionMessages resultErrors =
            (ActionMessages) session.getAttribute(Globals.ERROR_KEY);
        assertNull(resultErrors);

        // messages
        ActionMessages resultMessages =
            (ActionMessages) session.getAttribute(Globals.MESSAGE_KEY);
        // group
        Iterator itMProps = resultMessages.properties();
        String mprop = (String) itMProps.next();
        assertEquals("messages", mprop);
        // message
        Iterator itMessages = resultMessages.get(mprop);
        ActionMessage resultMessage = (ActionMessage) itMessages.next();
        assertEquals("message01", resultMessage.getKey());
        assertEquals("value01", resultMessage.getValues()[0]);

        // getBLogicIOĂяomF
        assertTrue(action.isGetBLogicIO);

        // mapBLogicResultĂяomF
        assertEquals("true", req.getAttribute("isMapBLogicResult"));
    }

    /**
     * testIsErrorsEmpty01()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() result:null<br>
     *
     * <br>
     * ҒlF(ԕω) O:SystemExceptionF<br>
     *                    bZ[WL[F<br>
     *                    "errors.blogic.result.null"<br>
     *                    bvOF<br>
     *                    NullPointerException<br>
     *         (ԕω) O:O<br>
     *                    G[OF<br>
     *                    "BLogicResult is null."<br>
     *
     * <br>
     * resultnull̏ꍇAG[邱ƂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsErrorsEmpty01() throws Exception {
        // O
        BLogicResult result = null;

        AbstractBLogicAction_AbstractBLogicActionStub05 action =
            new AbstractBLogicAction_AbstractBLogicActionStub05();

        try {
            // eXg{
            action.isErrorsEmpty(result);
            fail();
        } catch (SystemException e) {
            // 
            assertEquals(NullPointerException.class.getName(),
                    e.getCause().getClass().getName());
            assertTrue(LogUTUtil.checkError("BLogicResult is null."));
            assertEquals("errors.blogic.result.null", e.getErrorCode());
        }
    }

    /**
     * testIsErrorsEmpty02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() result:BLogicResult<br>
     *                IuWFNg<br>
     *         () result.getErrors():null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * result.getErrors()null̏ꍇAtrueԂ邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsErrorsEmpty02() throws Exception {
        // O
        BLogicResult result = new BLogicResult();
        BLogicMessages errors = null;
        result.setErrors(errors);

        AbstractBLogicAction_AbstractBLogicActionStub05 action =
            new AbstractBLogicAction_AbstractBLogicActionStub05();

        // eXg{
        boolean b = action.isErrorsEmpty(result);

        // 
        assertTrue(b);
    }

    /**
     * testIsErrorsEmpty03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() result:BLogicResult<br>
     *                IuWFNg<br>
     *         () result.getErrors():BLogicMessages.listF(new ArrayList())
     *         <br>
     *         () BLogicMessages.<br>
     *                isEmpty():true<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * result.getErrors()list0̃Xg̏ꍇAtrueԂ邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsErrorsEmpty03() throws Exception {
        // O
        BLogicResult result = new BLogicResult();
        BLogicMessages errors = new BLogicMessages();
        result.setErrors(errors);

        AbstractBLogicAction_AbstractBLogicActionStub05 action =
            new AbstractBLogicAction_AbstractBLogicActionStub05();

        // eXg{
        boolean b = action.isErrorsEmpty(result);

        // 
        assertTrue(b);
    }

    /**
     * testIsErrorsEmpty04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() result:BLogicResult<br>
     *                IuWFNg<br>
     *         () result.getErrors():BLogicMessages.listF<br>
     *                ([key="key"Avalue="value"])<br>
     *         () BLogicMessages.<br>
     *                isEmpty():false<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *
     * <br>
     * result.getErrors()list1ȏ̃Xg̏ꍇAfalseԂ邱Ƃ
     * mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsErrorsEmpty04() throws Exception {
        // O
        BLogicResult result = new BLogicResult();
        BLogicMessages errors = new BLogicMessages();
        BLogicMessage error = new BLogicMessage("key", "value");
        errors.add("errors", error);
        result.setErrors(errors);

        AbstractBLogicAction_AbstractBLogicActionStub05 action =
            new AbstractBLogicAction_AbstractBLogicActionStub05();

        // eXg{
        boolean b = action.isErrorsEmpty(result);

        // 
        assertFalse(b);
    }

    /**
     * testGetBLogicMapper01()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() req:not null<br>
     *         () ServletContext.getAttribute("BLOGIC_MAPPER" +
     *         ModuleUtil.getPrefix(req)):null<br>
     *
     * <br>
     * ҒlF(ԕω) O:SystemExceptionF<br>
     *                    bZ[WL[F<br>
     *                    "errors.blogic.mapper.null"<br>
     *                    bvOF<br>
     *                    NullPointerException<br>
     *         (ԕω) O:O<br>
     *                    G[OF<br>
     *                    "BLogicMapper is null."<br>
     *
     * <br>
     * ServletContext擾IuWFNgnull̏ꍇA
     * O邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetBLogicMapper01() throws Exception {
        // O
        // request
        MockHttpServletRequest req = new MockHttpServletRequest();

        // ModuleUtil.getPrefix(req)F"prefix"
        ModuleConfig moduleConfig = new ModuleConfigImpl01();
        req.setAttribute(Globals.MODULE_KEY, moduleConfig);

        // AbstractBLogicAction
        AbstractBLogicAction_AbstractBLogicActionStub02 action =
            new AbstractBLogicAction_AbstractBLogicActionStub02();

        // servlet
        AbstractBLogicAction_ActionServletStub01 servlet =
            new AbstractBLogicAction_ActionServletStub01();

        // ServletContext
        ServletContext context = new MockServletContext();
        context.setAttribute(BLogicIOPlugIn.BLOGIC_MAPPER_KEY + "prefix", null);
        servlet.setServletContext(context);

        UTUtil.setPrivateField(action, "servlet", servlet);

        try {
            // eXg{
            action.getBLogicMapper(req);
            fail();
        } catch (SystemException e) {
            // 
            assertEquals(NullPointerException.class.getName(),
                    e.getCause().getClass().getName());
            assertTrue(LogUTUtil.checkError("BLogicMapper is null."));
            assertEquals("errors.blogic.mapper.null", e.getErrorCode());
        }
    }

    /**
     * testGetBLogicMapper02()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() req:not null<br>
     *         () ServletContext.getAttribute("BLOGIC_MAPPER" +
     *         ModuleUtil.getPrefix(req)):"abc"<br>
     *
     * <br>
     * ҒlF(ԕω) O:SystemExceptionF<br>
     *                    bZ[WL[F<br>
     *                    "errors.blogic.mapping"<br>
     *                    bvOF<br>
     *                    ClassCastException<br>
     *         (ԕω) O:O<br>
     *                    G[OF<br>
     *                    "Cannot cast BLogicMapper : java.lang.String"<br>
     *
     * <br>
     * ServletContext擾IuWFNgAbstractBLogicMapper
     * CX^XȊȌꍇAO邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetBLogicMapper02() throws Exception {
        // O
        // request
        MockHttpServletRequest req = new MockHttpServletRequest();

        // ModuleUtil.getPrefix(req)F"prefix"
        ModuleConfig moduleConfig = new ModuleConfigImpl01();
        req.setAttribute(Globals.MODULE_KEY, moduleConfig);

        // AbstractBLogicAction
        AbstractBLogicAction_AbstractBLogicActionStub02 action =
            new AbstractBLogicAction_AbstractBLogicActionStub02();

        // servlet
        AbstractBLogicAction_ActionServletStub01 servlet =
            new AbstractBLogicAction_ActionServletStub01();

        // ServletContext
        ServletContext context = new MockServletContext();
        context.setAttribute(BLogicIOPlugIn.BLOGIC_MAPPER_KEY + "prefix", "abc");
        servlet.setServletContext(context);

        UTUtil.setPrivateField(action, "servlet", servlet);

        try {
            // eXg{
            action.getBLogicMapper(req);
            fail();
        } catch (SystemException e) {
            // 
            assertEquals(ClassCastException.class.getName(),
                    e.getCause().getClass().getName());
            assertTrue(LogUTUtil.checkError(
                    "Cannot cast BLogicMapper : java.lang.String"));
            assertEquals("errors.blogic.mapping", e.getErrorCode());
        }
    }

    /**
     * testGetBLogicMapper03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() req:not null<br>
     *         () ServletContext.getAttribute("BLOGIC_MAPPER" +
     *         ModuleUtil.getPrefix(req)):AbstractBLogicAction_AbstractBLogicMapperStub01̃IuWFNg<br>
     *
     * <br>
     * ҒlF(߂l) AbstractBLogicMapper:AbstractBLogicAction_AbstractBLogicMapperStub01̃IuWFNg<br>
     *
     * <br>
     * ServletContext擾IuWFNgAbstractBLogicMapperCX^X
     * ̏ꍇAOAbstractBLogicMapper̃CX^XԂƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetBLogicMapper03() throws Exception {
        // O
        // request
        MockHttpServletRequest req = new MockHttpServletRequest();

        // ModuleUtil.getPrefix(req)F"prefix"
        ModuleConfig moduleConfig = new ModuleConfigImpl01();
        req.setAttribute(Globals.MODULE_KEY, moduleConfig);

        // AbstractBLogicAction
        AbstractBLogicAction_AbstractBLogicActionStub02 action =
            new AbstractBLogicAction_AbstractBLogicActionStub02();

        // servlet
        AbstractBLogicAction_ActionServletStub01 servlet =
            new AbstractBLogicAction_ActionServletStub01();

        AbstractBLogicAction_AbstractBLogicMapperStub01 tmapper =
            new AbstractBLogicAction_AbstractBLogicMapperStub01();

        // ServletContext
        ServletContext context = new MockServletContext();
        context.setAttribute(BLogicIOPlugIn.BLOGIC_MAPPER_KEY + "prefix", tmapper);
        servlet.setServletContext(context);

        UTUtil.setPrivateField(action, "servlet", servlet);

        AbstractBLogicMapper mapper = null;
        // eXg{
        mapper = action.getBLogicMapper(req);

        // 
        assertSame(tmapper, mapper);
    }

    /**
     * testGetBLogicIO01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:not null<br>
     *         () req:not null<br>
     *         () ServletContext.getAttribute(<br>
     *                "BLOGIC_RESOURCES" + <br>
     *                ModuleUtil.getPrefix(req)):null<br>
     *
     * <br>
     * ҒlF(߂l) BLogicIO:null<br>
     *
     * <br>
     * ServletContext擾IuWFNgnull̏ꍇA
     * nullԂƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetBLogicIO01() throws Exception {
        // O
        // request, response
        MockHttpServletRequest req = new MockHttpServletRequest();

        // mapping
        ActionMappingEx mapping = new ActionMappingEx();

        // ModuleUtil.getPrefix(req)F"prefix"
        ModuleConfig moduleConfig = new ModuleConfigImpl01();
        req.setAttribute(Globals.MODULE_KEY, moduleConfig);

        // servlet
        AbstractBLogicAction_ActionServletStub01 servlet =
            new AbstractBLogicAction_ActionServletStub01();

        // ServletContext
        ServletContext context = new MockServletContext();
        context.setAttribute(
                BLogicResources.BLOGIC_RESOURCES_KEY + "prefix", null);
        servlet.setServletContext(context);

        // AbstractBLogicAction
        AbstractBLogicAction_AbstractBLogicActionStub02 action =
            new AbstractBLogicAction_AbstractBLogicActionStub02();

        UTUtil.setPrivateField(action, "servlet", servlet);

        BLogicIO io = null;

        // eXg{
        io = action.getBLogicIO(mapping, req);

        // 
        assertNull(io);
    }

    /**
     * testGetBLogicIO02()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() mapping:not null<br>
     *         () req:not null<br>
     *         () ServletContext.getAttribute(<br>
     *                "BLOGIC_RESOURCES" + <br>
     *                ModuleUtil.getPrefix(req)):"abc"<br>
     *
     * <br>
     * ҒlF(ԕω) O:SystemExceptionF<br>
     *                    bZ[WL[F<br>
     *                    "errors.blogic.resources"<br>
     *                    bvOF<br>
     *                    ClassCastException<br>
     *         (ԕω) O:O<br>
     *                    G[OF<br>
     *                    "Cannot cast BLogicResources : java.lang.String"<br>
     *
     * <br>
     * ServletContext擾IuWFNgBLogicResourcesCX^X
     * ȊȌꍇAO邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetBLogicIO02() throws Exception {
        // O
        // request, response
        MockHttpServletRequest req = new MockHttpServletRequest();

        // mapping
        ActionMappingEx mapping = new ActionMappingEx();

        // ModuleUtil.getPrefix(req)F"prefix"
        ModuleConfig moduleConfig = new ModuleConfigImpl01();
        req.setAttribute(Globals.MODULE_KEY, moduleConfig);

        // servlet
        AbstractBLogicAction_ActionServletStub01 servlet =
            new AbstractBLogicAction_ActionServletStub01();

        // ServletContext
        ServletContext context = new MockServletContext();
        context.setAttribute(
                BLogicResources.BLOGIC_RESOURCES_KEY + "prefix", "abc");
        servlet.setServletContext(context);

        // AbstractBLogicAction
        AbstractBLogicAction_AbstractBLogicActionStub02 action =
            new AbstractBLogicAction_AbstractBLogicActionStub02();

        UTUtil.setPrivateField(action, "servlet", servlet);

        BLogicIO io = null;

        try {
            // eXg{
            io = action.getBLogicIO(mapping, req);
            fail();
        } catch (SystemException e) {
            // 
            assertEquals(ClassCastException.class.getName(),
                    e.getCause().getClass().getName());
            assertTrue(LogUTUtil.checkError(
                    "Cannot cast BLogicResources : java.lang.String"));
            assertEquals("errors.blogic.resources", e.getErrorCode());
        }

        // 
        assertNull(io);
    }

    /**
     * testGetBLogicIO03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:not null<br>
     *         () req:not null<br>
     *         () ServletContext.getAttribute(<br>
     *                "BLOGIC_RESOURCES" + <br>
     *                ModuleUtil.getPrefix(req)):BLogicResourcesCX^X<br>
     *         () mapping.getPath():"abc"<br>
     *         () resource.getBLogicIO("abc"):BLogicIO<br>
     *                ([path="abc"])<br>
     *
     * <br>
     * ҒlF(߂l) BLogicIO:Oresource.getBLogicIO("abc")Ɠ
     * BLogicIOCX^X<br>
     *
     * <br>
     * ServletContext擾IuWFNgBLogicResourcesCX^X
     * ꍇAOresource.getBLogicIO("abc")ɊYBLogicIOCX^X
     * ԂƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetBLogicIO03() throws Exception {
        // O
        // request, response
        MockHttpServletRequest req = new MockHttpServletRequest();

        // mapping
        ActionMappingEx mapping = new ActionMappingEx();
        mapping.setPath("abc");

        // ModuleUtil.getPrefix(req)F"prefix"
        ModuleConfig moduleConfig = new ModuleConfigImpl01();
        req.setAttribute(Globals.MODULE_KEY, moduleConfig);

        // servlet
        AbstractBLogicAction_ActionServletStub01 servlet =
            new AbstractBLogicAction_ActionServletStub01();

        // BLogicIO("abc") : path="abc"
        BLogicResources resources = new BLogicResources();
        BLogicIO blogicIO = new BLogicIO();
        blogicIO.setPath("abc");
        resources.setBLogicIO(blogicIO);

        // ServletContext
        ServletContext context = new MockServletContext();
        context.setAttribute(
                BLogicResources.BLOGIC_RESOURCES_KEY + "prefix", resources);
        servlet.setServletContext(context);

        // AbstractBLogicAction
        AbstractBLogicAction_AbstractBLogicActionStub02 action =
            new AbstractBLogicAction_AbstractBLogicActionStub02();

        UTUtil.setPrivateField(action, "servlet", servlet);

        BLogicIO io = null;

        // eXg{
        io = action.getBLogicIO(mapping, req);

        // 
        assertSame(blogicIO, io);
    }

    /**
     * testGetBLogicIO04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:not null<br>
     *         () req:not null<br>
     *         () ServletContext.getAttribute(<br>
     *                "BLOGIC_RESOURCES" + <br>
     *                ModuleUtil.getPrefix(req)):BLogicResourcesCX^X<br>
     *         () mapping.getPath():"abc"<br>
     *         () resource.getBLogicIO("abc"):null<br>
     *
     * <br>
     * ҒlF(߂l) BLogicIO:null<br>
     *
     * <br>
     * Oresource.getBLogicIO("abc")nullԂꍇAnullԂ邱
     * mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetBLogicIO04() throws Exception {
        // O
        // request, response
        MockHttpServletRequest req = new MockHttpServletRequest();

        // mapping
        ActionMappingEx mapping = new ActionMappingEx();
        mapping.setPath("abc");

        // ModuleUtil.getPrefix(req)F"prefix"
        ModuleConfig moduleConfig = new ModuleConfigImpl01();
        req.setAttribute(Globals.MODULE_KEY, moduleConfig);

        // servlet
        AbstractBLogicAction_ActionServletStub01 servlet =
            new AbstractBLogicAction_ActionServletStub01();

        // BLogicIO("abc") : path="abc"
        BLogicResources resources = new BLogicResources();
        BLogicIO blogicIO = new BLogicIO();
        blogicIO.setPath("def");
        resources.setBLogicIO(blogicIO);

        // ServletContext
        ServletContext context = new MockServletContext();
        context.setAttribute(
                BLogicResources.BLOGIC_RESOURCES_KEY + "prefix", resources);
        servlet.setServletContext(context);

        // AbstractBLogicAction
        AbstractBLogicAction_AbstractBLogicActionStub02 action =
            new AbstractBLogicAction_AbstractBLogicActionStub02();

        UTUtil.setPrivateField(action, "servlet", servlet);

        BLogicIO io = null;

        // eXg{
        io = action.getBLogicIO(mapping, req);

        // 
        assertNull(io);
    }
}
