/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.service.thin;

import java.util.ArrayList;
import java.util.Iterator;

import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.service.thin.BLogicMessages} NX
 * ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * bZ[WꗗNXB<br>
 * BLogicMessageCX^Xi[NXB
 * <p>
 * 
 * @see jp.terasoluna.fw.service.thin.BLogicMessages
 */
public class BLogicMessagesTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(BLogicMessagesTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public BLogicMessagesTest(String name) {
        super(name);
    }

    /**
     * testBLogicMessagesBLogicMessages01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() messages:list:bZ[WL[{"message.test01"}BLogicMessageݒ<br>
     *                groupList:O[v{"group.test01"}ݒ<br>
     *         
     * <br>
     * ҒlF(߂l) Ȃ:|<br>
     *         (ԕω) this.list:{"message.test01"}BLogicMessage<br>
     *         (ԕω) this.groupList:{"group.test01"}<br>
     *         
     * <br>
     * ꂽBLogicMessageslistgroupListɈmessagesɊi[ꂽli[邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testBLogicMessagesBLogicMessages01() throws Exception {
        // --------------------------------------------------
        // listݒ
        ArrayList<BLogicMessage> list = new ArrayList<BLogicMessage>();
        list.add(new BLogicMessage("message.test01"));

        // groupListݒ
        ArrayList<String> groupList = new ArrayList<String>();
        groupList.add("group.test01");

        // BLogicMessagesݒ
        BLogicMessages messages = new BLogicMessages();
        UTUtil.setPrivateField(messages, "list", list);
        UTUtil.setPrivateField(messages, "groupList", groupList);
        
        // --------------------------------------------------
        
        // eXg{
        BLogicMessages newMessages = new BLogicMessages(messages);
        
        // 
        assertEquals(1, newMessages.list.size());
        assertEquals("message.test01", list.get(0).getKey());
        assertEquals(1, newMessages.groupList.size());
        assertEquals("group.test01", groupList.get(0));
    }

    /**
     * testClear01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() Ȃ:|<br>
     *         () list:bZ[W{"message.test01"A"message.test02"A"message.test03"}Ԃɐݒ<br>
     *         () groupList:O[v{"group.test01"A"group.test02"A"group.test03"}Ԃɐݒ<br>
     *         
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) list:̃Xg<br>
     *         (ԕω) groupList:̃Xg<br>
     *         
     * <br>
     * bZ[WyуO[ṽXgNA邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testClear01() throws Exception {

        // --------------------------------------------------list
        // key
        String[] keyArray = new String[3];
        keyArray[0] = "message.test01";
        keyArray[1] = "message.test02";
        keyArray[2] = "message.test03";

        // listݒ
        ArrayList<BLogicMessage> list = new ArrayList<BLogicMessage>();
        for (int i = 0; i < keyArray.length; i++) {
            // BLogicMessagei[
            list.add(new BLogicMessage(keyArray[i]));
        }

        // --------------------------------------------------grouplist
        // group
        String[] groupArray = new String[3];
        groupArray[0] = "group.test01";
        groupArray[1] = "group.test02";
        groupArray[2] = "group.test03";
        
        // groupListݒ
        ArrayList<String> groupList = new ArrayList<String>();
        for (int i = 0; i < groupArray.length; i++) {
            groupList.add(groupArray[i]);
        }
        
        // --------------------------------------------------BLogicMessages
        // BLogicMessagesݒ
        BLogicMessages messages = new BLogicMessages();
        UTUtil.setPrivateField(messages, "list", list);
        UTUtil.setPrivateField(messages, "groupList", groupList);
        
        // --------------------------------------------------
        
        // eXg{
        messages.clear();
        
        // 
        assertTrue(messages.list.isEmpty());
        assertTrue(messages.groupList.isEmpty());

    }

    /**
     * testClear02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() Ȃ:|<br>
     *         () list:̃Xg<br>
     *         () groupList:̃Xg<br>
     *         
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) list:̃Xg<br>
     *         (ԕω) groupList:̃Xg<br>
     *         
     * <br>
     * bZ[WyуO[ṽXgNA邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testClear02() throws Exception {

        // --------------------------------------------------list        
        // listݒ
        ArrayList<BLogicMessage> list = new ArrayList<BLogicMessage>();
        
        // --------------------------------------------------groupList
        // groupListݒ
        ArrayList<String> groupList = new ArrayList<String>();
        
        // --------------------------------------------------BLogicMessages
        // BLogicMessagesݒ
        BLogicMessages messages = new BLogicMessages();
        UTUtil.setPrivateField(messages, "list", list);
        UTUtil.setPrivateField(messages, "groupList", groupList);
        
        // --------------------------------------------------
        
        // eXg{
        messages.clear();
        
        // 
        assertTrue(messages.list.isEmpty());
        assertTrue(messages.groupList.isEmpty());
    }

    /**
     * testIsEmpty01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() Ȃ:|<br>
     *         () list:bZ[W{"message.test01"A"message.test02"A"message.test03"}Ԃɐݒ<br>
     *         
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         
     * <br>
     * bZ[WXgɃbZ[Wi[ĂꍇAfalseԋp邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testIsEmpty01() throws Exception {

        // --------------------------------------------------list        
        // key
        String[] keyArray = new String[3];
        keyArray[0] = "message.test01";
        keyArray[1] = "message.test02";
        keyArray[2] = "message.test03";

        // listݒ
        ArrayList<BLogicMessage> list = new ArrayList<BLogicMessage>();
        for (int i = 0; i < keyArray.length; i++) {
            // BLogicMessagei[
            list.add(new BLogicMessage(keyArray[i]));
        }

        // --------------------------------------------------BLogicMessages
        // BLogicMessagesݒ
        BLogicMessages messages = new BLogicMessages();
        UTUtil.setPrivateField(messages, "list", list);
        
        // --------------------------------------------------
        
        // eXg{E
        assertFalse(messages.isEmpty());
        
    }

    /**
     * testIsEmpty02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() Ȃ:|<br>
     *         () list:̃Xg<br>
     *         
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         
     * <br>
     * bZ[WXgɃbZ[Wi[ĂȂꍇAtrueԋp邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testIsEmpty02() throws Exception {

        // --------------------------------------------------list        
        // listݒ
        ArrayList<BLogicMessage> list = new ArrayList<BLogicMessage>();
        
        // --------------------------------------------------BLogicMessages
        // BLogicMessagesݒ
        BLogicMessages messages = new BLogicMessages();
        UTUtil.setPrivateField(messages, "list", list);
        
        // --------------------------------------------------
        
        // eXg{E
        assertTrue(messages.isEmpty());
    }

    /**
     * testGet01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() Ȃ:|<br>
     *         () list:bZ[WL[{"message.test01"A"message.test02"A"message.test03"}BLogicMessageԂɐݒ<br>
     *         
     * <br>
     * ҒlF(߂l) Iterator:ݒ肵ԒʂBLogicMessageoCe[^<br>
     *         
     * <br>
     * bZ[Wݒ肵AԒʂɃbZ[W擾ł邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGet01() throws Exception {

        // --------------------------------------------------list                
        // key
        String[] keyArray = new String[3];
        keyArray[0] = "message.test01";
        keyArray[1] = "message.test02";
        keyArray[2] = "message.test03";
        
        // BLogicMessageݒ
        BLogicMessage[] blogicMessageArray = new BLogicMessage[keyArray.length];
        for (int i = 0; i < keyArray.length; i++) {
            blogicMessageArray[i] = new BLogicMessage(keyArray[i]);
        }
        
        // listݒ
        ArrayList<BLogicMessage> list = new ArrayList<BLogicMessage>();
        for (int i = 0; i < blogicMessageArray.length; i++) {
            list.add(blogicMessageArray[i]);
        }
        
        // --------------------------------------------------BLogicMessages
        // BLogicMessagesݒ
        BLogicMessages messages = new BLogicMessages();
        UTUtil.setPrivateField(messages, "list", list);
        
        // --------------------------------------------------
        
        // eXg{
        Iterator<BLogicMessage> ite = messages.get();
        
        // 
        int j = 0;
        while (ite.hasNext()) {
            BLogicMessage message = ite.next();
            assertEquals(keyArray[j], message.getKey());
            j++;
        }
        assertEquals(j, keyArray.length);

    }

    /**
     * testGet02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() Ȃ:|<br>
     *         () list:bZ[WL[{"message.test01"}BLogicMessageݒ<br>
     *         
     * <br>
     * ҒlF(߂l) Iterator:ݒ肵ԒʂBLogicMessageoCe[^<br>
     *         
     * <br>
     * bZ[W1ݒ肵AԒʂɃbZ[W擾ł邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGet02() throws Exception {

        // --------------------------------------------------list        
        // key
        String[] keyArray = new String[1];
        keyArray[0] = "message.test01";

        // listݒ
        ArrayList<BLogicMessage> list = new ArrayList<BLogicMessage>();
        for (int i = 0; i < keyArray.length; i++) {
            // BLogicMessagei[
            list.add(new BLogicMessage(keyArray[i]));
        }

        // --------------------------------------------------BLogicMessages
        // BLogicMessagesݒ
        BLogicMessages messages = new BLogicMessages();
        UTUtil.setPrivateField(messages, "list", list);
        
        // --------------------------------------------------
        
        // eXg{
        Iterator<BLogicMessage> ite = messages.get();
        
        // 
        int j = 0;
        while (ite.hasNext()) {
            BLogicMessage message = ite.next();
            assertEquals(keyArray[j], message.getKey());
            j++;
        }
        assertEquals(j, keyArray.length);
    }

    /**
     * testGet03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() Ȃ:|<br>
     *         () list:̃Xg<br>
     *         
     * <br>
     * ҒlF(߂l) Iterator:̃bZ[WꗗCe[^<br>
     *         
     * <br>
     * bZ[WXg̃Xg̏ꍇÃbZ[WꗗCe[^擾ł邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGet03() throws Exception {

        // --------------------------------------------------list    
        // listݒ
        ArrayList<BLogicMessage> list = new ArrayList<BLogicMessage>();
        
        // --------------------------------------------------BLogicMessages
        // BLogicMessagesݒ
        BLogicMessages messages = new BLogicMessages();
        UTUtil.setPrivateField(messages, "list", list);
        
        // --------------------------------------------------
        
        // eXg{
        Iterator<BLogicMessage> ite = messages.get();
        
        // 
        assertFalse(ite.hasNext());
    }

    /**
     * testGetGroup01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() Ȃ:|<br>
     *         () groupList:O[v{"group.test01"A"group.test02"A"group.test03"}Ԃɐݒ<br>
     *         
     * <br>
     * ҒlF(߂l) Iterator:ݒ肵ԒʂɃO[viStringjoCe[^<br>
     *         
     * <br>
     * O[vݒ肵AԒʂɃO[v擾ł邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetGroup01() throws Exception {

        // --------------------------------------------------groupList  
        // group
        String[] groupArray = new String[3];
        groupArray[0] = "group.test01";
        groupArray[1] = "group.test02";
        groupArray[2] = "group.test03";
        
        // groupListݒ
        ArrayList<String> groupList = new ArrayList<String>();
        for (int i = 0; i < groupArray.length; i++) {
            groupList.add(groupArray[i]);
        }
        
        // --------------------------------------------------BLogicMessages
        // BLogicMessagesݒ
        BLogicMessages messages = new BLogicMessages();
        UTUtil.setPrivateField(messages, "groupList", groupList);
        
        // --------------------------------------------------
        
        // eXg{
        Iterator<String> ite = messages.getGroup();
        
        // 
        int j = 0;
        while (ite.hasNext()) {
            String group = ite.next();
            assertEquals(groupArray[j], group);
            j++;
        }
        assertEquals(j, groupArray.length);

    }

    /**
     * testGetGroup02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() Ȃ:|<br>
     *         () groupList:O[v{"group.test01"}ݒ<br>
     *         
     * <br>
     * ҒlF(߂l) Iterator:ݒ肵ԒʂɃO[viStringjoCe[^<br>
     *         
     * <br>
     * O[v1ݒ肵AԒʂɃO[v擾ł邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetGroup02() throws Exception {

        // --------------------------------------------------groupList  
        // group
        String[] groupArray = new String[1];
        groupArray[0] = "group.test01";
        
        // groupListݒ
        ArrayList<String> groupList = new ArrayList<String>();
        for (int i = 0; i < groupArray.length; i++) {
            groupList.add(groupArray[i]);
        }
        
        // --------------------------------------------------BLogicMessages
        // BLogicMessagesݒ
        BLogicMessages messages = new BLogicMessages();
        UTUtil.setPrivateField(messages, "groupList", groupList);
        
        // --------------------------------------------------
        
        // eXg{
        Iterator<String> ite = messages.getGroup();
        
        // 
        int j = 0;
        while (ite.hasNext()) {
            String group = ite.next();
            assertEquals(groupArray[j], group);
            j++;
        }
        assertEquals(j, groupArray.length);
    }

    /**
     * testGetGroup03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() Ȃ:|<br>
     *         () groupList:̃Xg<br>
     *         
     * <br>
     * ҒlF(߂l) Iterator:̃O[vꗗCe[^<br>
     *         
     * <br>
     * O[vXg̃Xg̏ꍇÃO[vꗗCe[^擾ł邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetGroup03() throws Exception {

        // --------------------------------------------------groupList  
        // group
        ArrayList<String> groupList = new ArrayList<String>();
        
        // --------------------------------------------------BLogicMessages
        // BLogicMessagesݒ
        BLogicMessages messages = new BLogicMessages();
        UTUtil.setPrivateField(messages, "groupList", groupList);
        
        // --------------------------------------------------
        
        // eXg{
        Iterator<String> ite = messages.getGroup();
        
        // 
        assertFalse(ite.hasNext());
    }

    /**
     * testAddStringBLogicMessage01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() group:"group.test00"<br>
     *         () message:bZ[WL[{"message.test00"}BLogicMessage<br>
     *         () list:bZ[WL[{"message.test01"A"message.test02"A"message.test03"}BLogicMessageԂɐݒ<br>
     *         () groupList:O[v{"group.test01"A"group.test02"A"group.test03"}Ԃɐݒ<br>
     *         
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) list:bZ[WL[{"message.test01"A"message.test02"A"message.test03"A"message.test00"}BLogicMessageԂɊi[ꂽXg<br>
     *         (ԕω) groupList:O[v{"group.test01"A"group.test02"A"group.test03"A"group.test00"}ԂɊi[ꂽXg<br>
     *         
     * <br>
     * bZ[WXgAO[vXgɃbZ[WAO[vɐݒ肳ĂAbZ[WAO[vǉōŌɊi[邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddStringBLogicMessage01() throws Exception {

        // --------------------------------------------------list
        // key
        String[] keyArray = new String[3];
        keyArray[0] = "message.test01";
        keyArray[1] = "message.test02";
        keyArray[2] = "message.test03";
        
        // ɗpkey̔z
        String[] expectedKeyArray = new String[keyArray.length + 1];

        // listݒ
        ArrayList<BLogicMessage> list = new ArrayList<BLogicMessage>();
        for (int i = 0; i < keyArray.length; i++) {
            // BLogicMessagei[
            list.add(new BLogicMessage(keyArray[i]));
            
            // ɗpkey̔zɃRs[
            expectedKeyArray[i] = keyArray[i];
        }

        // --------------------------------------------------groupList
        // group
        String[] groupArray = new String[3];
        groupArray[0] = "group.test01";
        groupArray[1] = "group.test02";
        groupArray[2] = "group.test03";
        
        // ɗpgroup̔z
        String[] expectedGroupArray = new String[groupArray.length + 1];
        
        // groupListݒ
        ArrayList<String> groupList = new ArrayList<String>();
        for (int i = 0; i < groupArray.length; i++) {
            groupList.add(groupArray[i]);
            
            // ɗpgroup̔zɃRs[
            expectedGroupArray[i] = groupArray[i];
        }
        
        // --------------------------------------------------BLogicMessages
        // BLogicMessagesݒ
        BLogicMessages messages = new BLogicMessages();
        UTUtil.setPrivateField(messages, "list", list);
        UTUtil.setPrivateField(messages, "groupList", groupList);
        
        // --------------------------------------------------
        // messageݒ
        String key = "message.test00";
        BLogicMessage message = new BLogicMessage(key);

        // ɗpkey̔zɃRs[
        expectedKeyArray[keyArray.length] = key;
        
        // groupݒ
        String group = "group.test00";
        
        // ɗpgroup̔zɃRs[
        expectedGroupArray[groupArray.length] = group;
        
        // --------------------------------------------------
        
        // eXg{
        messages.add(group, message);
        
        // 
        Iterator<BLogicMessage> resultItr = messages.list.iterator();
        int j = 0;
        while (resultItr.hasNext()) {
            BLogicMessage resultMessage = resultItr.next();
            assertEquals(expectedKeyArray[j], resultMessage.getKey());
            j++;
        }
        assertEquals(j, expectedKeyArray.length);
        
        int k = 0;
        Iterator<String> resultItr2 = messages.groupList.iterator();
        while (resultItr2.hasNext()) {
            String resultGroup = resultItr2.next();
            assertEquals(expectedGroupArray[k], resultGroup);
            k++;
        }
        assertEquals(k, expectedGroupArray.length);
    }

    /**
     * testAddStringBLogicMessage02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() group:"group.test00"<br>
     *         () message:bZ[WL[{"message.test00"}BLogicMessage<br>
     *         () list:̃Xg<br>
     *         () groupList:̃Xg<br>
     *         
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) list:bZ[WL[{"message.test00"}BLogicMessagei[ꂽXg<br>
     *         (ԕω) groupList:O[v{"group.test00"}i[ꂽXg<br>
     *         
     * <br>
     * bZ[WXgAO[vXgɃbZ[WAO[vݒ肳ĂȂAbZ[WAO[vi[邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddStringBLogicMessage02() throws Exception {

        // --------------------------------------------------list
        // listݒ
        ArrayList<BLogicMessage> list = new ArrayList<BLogicMessage>();
        
        // --------------------------------------------------groupList
        // groupListݒ
        ArrayList<String> groupList = new ArrayList<String>();
        
        // --------------------------------------------------BLogicMessages
        // BLogicMessagesݒ
        BLogicMessages messages = new BLogicMessages();
        UTUtil.setPrivateField(messages, "list", list);
        UTUtil.setPrivateField(messages, "groupList", groupList);
        
        // --------------------------------------------------
        // messageݒ
        String key = "message.test00";
        BLogicMessage message = new BLogicMessage(key);
        
        // groupݒ
        String group = "group.test00";
        
        // --------------------------------------------------
        
        // eXg{
        messages.add(group, message);
        
        // 
        assertTrue(messages.list.size() == 1);
        assertEquals(key, messages.list.get(0).getKey());
        assertTrue(messages.groupList.size() == 1);
        assertEquals(group, messages.groupList.get(0));
    }

    /**
     * testAddStringBLogicMessage03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() group:""<br>
     *         () message:bZ[WL[{"message.test00"}BLogicMessage<br>
     *         () list:̃Xg<br>
     *         () groupList:̃Xg<br>
     *         
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) list:bZ[WL[{"message.test00"}BLogicMessagei[ꂽXg<br>
     *         (ԕω) groupList:O[v{""}i[ꂽXg<br>
     *         
     * <br>
     * group󕶎̎AO[vXgɋ󕶎i[邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddStringBLogicMessage03() throws Exception {

        // --------------------------------------------------list
        // listݒ
        ArrayList<BLogicMessage> list = new ArrayList<BLogicMessage>();
        
        // --------------------------------------------------groupList
        // groupListݒ
        ArrayList<String> groupList = new ArrayList<String>();
        
        // --------------------------------------------------BLogicMessages
        // BLogicMessagesݒ
        BLogicMessages messages = new BLogicMessages();
        UTUtil.setPrivateField(messages, "list", list);
        UTUtil.setPrivateField(messages, "groupList", groupList);
        
        // --------------------------------------------------
        // messageݒ
        String key = "message.test00";
        BLogicMessage message = new BLogicMessage(key);
        
        // groupݒ
        String group = "";
        
        // --------------------------------------------------
        
        // eXg{
        messages.add(group, message);

        // 
        assertTrue(messages.list.size() == 1);
        assertEquals(key, messages.list.get(0).getKey());
        assertTrue(messages.groupList.size() == 1);
        assertEquals(group, messages.groupList.get(0));
    }

    /**
     * testAddStringBLogicMessage04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() group:null<br>
     *         () message:null<br>
     *         () list:̃Xg<br>
     *         () groupList:̃Xg<br>
     *         
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) list:nulli[ꂽXg<br>
     *         (ԕω) groupList:O[v{null}i[ꂽXg<br>
     *         
     * <br>
     * groupnullAmessagesnull̎AO[vXgnullAbZ[WXgnulli[邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddStringBLogicMessage04() throws Exception {

        // --------------------------------------------------list
        // listݒ
        ArrayList<BLogicMessage> list = new ArrayList<BLogicMessage>();
        
        // --------------------------------------------------groupList
        // groupListݒ
        ArrayList<String> groupList = new ArrayList<String>();
        
        // --------------------------------------------------BLogicMessages
        // BLogicMessagesݒ
        BLogicMessages messages = new BLogicMessages();
        UTUtil.setPrivateField(messages, "list", list);
        UTUtil.setPrivateField(messages, "groupList", groupList);
        
        // --------------------------------------------------
        // messageݒ
        BLogicMessage message = null;
        
        // groupݒ
        String group = null;
        
        // --------------------------------------------------
        
        // eXg{
        messages.add(group, message);
        
        // 
        assertTrue(messages.list.size() == 1);
        assertNull(messages.list.get(0));
        assertTrue(messages.groupList.size() == 1);
        assertNull(messages.groupList.get(0));
    }

    /**
     * testAddBLogicMessages01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() messages:list:bZ[WL[{"message.test10"A"message.test20"A"message.test30"}BLogicMessageԂɐݒ<br>
     *                groupList:O[v{"group.test10"A"group.test20"A"group.test30"}Ԃɐݒ<br>
     *         () list:bZ[WL[{"message.test01"A"message.test02"A"message.test03"}BLogicMessageԂɐݒ<br>
     *         () groupList:O[v{"group.test01"A"group.test02"A"group.test03"}Ԃɐݒ<br>
     *         
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) list:bZ[WL[{"message.test01"A"message.test02"A"message.test03"A"message.test10"A"message.test20"A"message.test30"}BLogicMessageԂɊi[ꂽXg<br>
     *         (ԕω) groupList:O[v{"group.test01"A"group.test02"A"group.test03"A"group.test10"A"group.test20"A"group.test30"}ԂɊi[ꂽXg<br>
     *         
     * <br>
     * bZ[WXgAO[vXgɃbZ[WAO[vɐݒ肳ĂAbZ[WAO[vǉōŌɊi[邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddBLogicMessages01() throws Exception {

        // --------------------------------------------------list        
        // key
        String[] keyArray = new String[3];
        keyArray[0] = "message.test01";
        keyArray[1] = "message.test02";
        keyArray[2] = "message.test03";
        
        // pkey@Ŏgp
        String[] keyArray2 = new String[3];
        keyArray2[0] = "message.test10";
        keyArray2[1] = "message.test20";
        keyArray2[2] = "message.test30";
        
        // ɗpkey̔z
        String[] expectedKeyArray = new String[keyArray.length
                + keyArray2.length];

        // listݒ
        ArrayList<BLogicMessage> list = new ArrayList<BLogicMessage>();
        for (int i = 0; i < keyArray.length; i++) {
            // BLogicMessagei[
            list.add(new BLogicMessage(keyArray[i]));
            
            // ɗpkey̔zɃRs[
            expectedKeyArray[i] = keyArray[i];
        }

        // --------------------------------------------------groupList
        // group
        String[] groupArray = new String[3];
        groupArray[0] = "group.test01";
        groupArray[1] = "group.test02";
        groupArray[2] = "group.test03";
        
        // pgroup@Ŏgp
        String[] groupArray2 = new String[3];
        groupArray2[0] = "group.test10";
        groupArray2[1] = "group.test20";
        groupArray2[2] = "group.test30";
        
        // ɗpgroup̔z
        String[] expectedGroupArray = new String[groupArray.length
                + groupArray2.length];
        
        // groupListݒ
        ArrayList<String> groupList = new ArrayList<String>();
        for (int i = 0; i < groupArray.length; i++) {
            groupList.add(groupArray[i]);
            
            // ɗpgroup̔zɃRs[
            expectedGroupArray[i] = groupArray[i];
        }
        
        // --------------------------------------------------BLogicMessages
        // BLogicMessagesݒ
        BLogicMessages messages = new BLogicMessages();
        UTUtil.setPrivateField(messages, "list", list);
        UTUtil.setPrivateField(messages, "groupList", groupList);
        
        // --------------------------------------------------
        // listݒ
        ArrayList<BLogicMessage> list2 = new ArrayList<BLogicMessage>();
        for (int i = 0; i < keyArray2.length; i++) {
            // BLogicMessagei[
            list2.add(new BLogicMessage(keyArray2[i]));
            
            // ɗpkey̔zɃRs[
            expectedKeyArray[keyArray.length + i] = keyArray2[i];
        }

        // groupListݒ
        ArrayList<String> groupList2 = new ArrayList<String>();
        for (int i = 0; i < groupArray2.length; i++) {
            groupList2.add(groupArray2[i]);
            
            // ɗpgroup̔zɃRs[
            expectedGroupArray[groupArray.length + i] = groupArray2[i];
        }
        
        // BLogicMessagesݒ
        BLogicMessages messages2 = new BLogicMessages();
        UTUtil.setPrivateField(messages2, "list", list2);
        UTUtil.setPrivateField(messages2, "groupList", groupList2);
        
        // --------------------------------------------------
        
        // eXg{
        messages.add(messages2);
        
        // 
        Iterator<BLogicMessage> resultItr = messages.list.iterator();
        int j = 0;
        while (resultItr.hasNext()) {
            BLogicMessage resultMessage = resultItr.next();
            assertEquals(expectedKeyArray[j], resultMessage.getKey());
            j++;
        }
        assertEquals(j, expectedKeyArray.length);
        
        int k = 0;
        Iterator<String> resultItr2 = messages.groupList.iterator();
        while (resultItr2.hasNext()) {
            String resultGroup = resultItr2.next();
            assertEquals(expectedGroupArray[k], resultGroup);
            k++;
        }
        assertEquals(k, expectedGroupArray.length);
    }

    /**
     * testAddBLogicMessages02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() messages:list:bZ[WL[{"message.test10"}BLogicMessageԂɐݒ<br>
     *                groupList:O[v{"group.test10"}Ԃɐݒ<br>
     *         () list:̃Xg<br>
     *         () groupList:̃Xg<br>
     *         
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) list:bZ[WL[{"message.test10"}BLogicMessagei[ꂽXg<br>
     *         (ԕω) groupList:O[v{"group.test10"}i[ꂽXg<br>
     *         
     * <br>
     * bZ[WXgAO[vXgɃbZ[WAO[vݒ肳ĂȂAbZ[WAO[vi[邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddBLogicMessages02() throws Exception {

        // --------------------------------------------------list
        // listݒ
        ArrayList<BLogicMessage> list = new ArrayList<BLogicMessage>();
        
        // --------------------------------------------------groupList
        // groupListݒ
        ArrayList<String> groupList = new ArrayList<String>();
        
        // --------------------------------------------------BLogicMessages
        // BLogicMessagesݒ
        BLogicMessages messages = new BLogicMessages();
        UTUtil.setPrivateField(messages, "list", list);
        UTUtil.setPrivateField(messages, "groupList", groupList);
        
        // --------------------------------------------------
        // key
        String[] keyArray2 = new String[1];
        keyArray2[0] = "message.test10";
        
        // listݒ
        ArrayList<BLogicMessage> list2 = new ArrayList<BLogicMessage>();
        for (int i = 0; i < keyArray2.length; i++) {
            // BLogicMessagei[
            list2.add(new BLogicMessage(keyArray2[i]));
        }
        
        // group
        String[] groupArray2 = new String[1];
        groupArray2[0] = "group.test10";
        
        // groupListݒ
        ArrayList<String> groupList2 = new ArrayList<String>();
        for (int i = 0; i < groupArray2.length; i++) {
            groupList2.add(groupArray2[i]);
        }
        
        // BLogicMessagesݒ
        BLogicMessages messages2 = new BLogicMessages();
        UTUtil.setPrivateField(messages2, "list", list2);
        UTUtil.setPrivateField(messages2, "groupList", groupList2);
        
        // --------------------------------------------------
        
        // eXg{
        messages.add(messages2);
        
        // 
        assertTrue(messages.list.size() == 1);
        assertEquals(keyArray2[0], messages.list.get(0).getKey());
        assertTrue(messages.groupList.size() == 1);
        assertEquals(groupArray2[0], messages.groupList.get(0));

    }

    /**
     * testAddBLogicMessages03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() messages:null<br>
     *         () list:bZ[WL[{"message.test01"A"message.test02"A"message.test03"}BLogicMessageԂɐݒ<br>
     *         () groupList:O[v{"group.test01"A"group.test02"A"group.test03"}Ԃɐݒ<br>
     *         
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) list:bZ[WL[{"message.test01"A"message.test02"A"message.test03"}BLogicMessageԂɊi[ꂽXg<br>
     *         (ԕω) groupList:O[v{"group.test01"A"group.test02"A"group.test03"}ԂɊi[ꂽXg<br>
     *         
     * <br>
     * messagesnullݒ肵ꍇAɏI邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddBLogicMessages03() throws Exception {

        // --------------------------------------------------list        
        // key
        String[] keyArray = new String[3];
        keyArray[0] = "message.test01";
        keyArray[1] = "message.test02";
        keyArray[2] = "message.test03";

        // listݒ
        ArrayList<BLogicMessage> list = new ArrayList<BLogicMessage>();
        for (int i = 0; i < keyArray.length; i++) {
            // BLogicMessagei[
            list.add(new BLogicMessage(keyArray[i]));
        }

        // --------------------------------------------------groupList
        // group
        String[] groupArray = new String[3];
        groupArray[0] = "group.test01";
        groupArray[1] = "group.test02";
        groupArray[2] = "group.test03";
        
        // groupListݒ
        ArrayList<String> groupList = new ArrayList<String>();
        for (int i = 0; i < groupArray.length; i++) {
            groupList.add(groupArray[i]);
        }
        
        // --------------------------------------------------BLogicMessages
        // BLogicMessagesݒ
        BLogicMessages messages = new BLogicMessages();
        UTUtil.setPrivateField(messages, "list", list);
        UTUtil.setPrivateField(messages, "groupList", groupList);
        
        // --------------------------------------------------
        
        // eXg{
        messages.add(null);
        
        // 
        Iterator<BLogicMessage> resultItr = messages.list.iterator();
        int j = 0;
        while (resultItr.hasNext()) {
            BLogicMessage resultMessage = resultItr.next();
            assertEquals(keyArray[j], resultMessage.getKey());
            j++;
        }
        assertEquals(j, keyArray.length);
        
        int k = 0;
        Iterator<String> resultItr2 = messages.groupList.iterator();
        while (resultItr2.hasNext()) {
            String resultGroup = resultItr2.next();
            assertEquals(groupArray[k], resultGroup);
            k++;
        }
        assertEquals(k, groupArray.length);
    }

}
