/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.thin;

import jp.terasoluna.utlib.MockFilterConfig;
import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.MockHttpServletResponse;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;


/**
 * {@link jp.terasoluna.fw.web.thin.BlockageControlFilter} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * ƖǏԂǂ̃`FbNsB<br>
 * ANZXpXƖǏԂꍇ́A{@link BlockageException} X[B
 * <p>
 * 
 * @see jp.terasoluna.fw.web.thin.BlockageControlFilter
 */
public class BlockageControlFilterTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(BlockageControlFilterTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        UTUtil.setPrivateField(BlockageControlFilter.class, 
                               "controller",
                               null);   
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public BlockageControlFilterTest(String name) {
        super(name);
    }

    /**
     * testInit01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() config:not null<br>
     *         () config:not null<br>
     *         () getController():BlockageControlFilter_BlockageControllerStub01CX^X<br>
     *         () controller:BlockageControlFilter_BlockageControllerStub01CX^X<br>
     *         
     * <br>
     * ҒlF(ԕω) config:ŗ^FilterConfigƓ̃CX^X<br>
     *         (ԕω) getController():ĂяoȂ<br>
     *         (ԕω) controller:OƓ̃CX^X<br>
     *         
     * <br>
     * controllernullŖꍇAconrollŗ^configݒ肳AgetControllerĂяoȂƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInit01() throws Exception {
        // O
    	MockFilterConfig existingConfig = new MockFilterConfig();
    	BlockageController existingController = 
    		new BlockageControlFilter_BlockageControllerStub01();
    	
    	UTUtil.setPrivateField(BlockageControlFilter.class,
				    			"controller",
								existingController);
    	// tB^̗p
    	BlockageControlFilter_BlockageControlFilterStub01 filter = 
    		new BlockageControlFilter_BlockageControlFilterStub01();
    	
    	filter.setConfig(existingConfig);
    	
    	// Vݒ肳RtBO
    	MockFilterConfig newConfig = new MockFilterConfig();
    	
    	BlockageControlFilter_BlockageControllerStub01 newController = 
    		new BlockageControlFilter_BlockageControllerStub01();
    	
    	filter.newController = newController;
    	
        // eXg{
    	filter.init(newConfig);
        // 
    	assertSame(newConfig,UTUtil.getPrivateField(filter,"config"));
    	assertFalse(filter.isCalled);
    	assertSame(existingController,
    				UTUtil.getPrivateField(BlockageControlFilter.class,
    						"controller"));
    }

    /**
     * testInit02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() config:not null<br>
     *         () config:null<br>
     *         () getController():BlockageControlFilter_BlockageControllerStub01CX^X<br>
     *         () controller:null<br>
     *         
     * <br>
     * ҒlF(ԕω) config:ŗ^FilterConfigƓ̃CX^X<br>
     *         (ԕω) getController():Ăяo<br>
     *         (ԕω) controller:getController()瓾CX^XƓ̃CX^X<br>
     *         
     * <br>
     * controllernull̏ꍇAŗ^configݒ肳AgetControllerĂяoAtB[hɐݒ肳邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInit02() throws Exception {
        // O
    	// tB^̗p
    	BlockageControlFilter_BlockageControlFilterStub01 filter =
    		new BlockageControlFilter_BlockageControlFilterStub01();
    	
    	// Vݒ肳RtBO
    	MockFilterConfig newConfig = new MockFilterConfig();
    	
    	BlockageControlFilter_BlockageControllerStub01 newController =
    		new BlockageControlFilter_BlockageControllerStub01();
    	
    	filter.newController = newController;
    	
        // eXg{
    	filter.init(newConfig);
        // 
    	assertSame(newConfig,UTUtil.getPrivateField(filter,"config"));
    	assertTrue(filter.isCalled);
    	assertSame(newController,
	    			UTUtil.getPrivateField(BlockageControlFilter.class,
	    					"controller"));
    }

    /**
     * testGetBlockageController01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() controller:BlockageControlFilter_BlockageControllerStub01CX^X<br>
     *         
     * <br>
     * ҒlF(߂l) BlockageController:OŐݒ肵CX^XƓ̃CX^X<br>
     *         
     * <br>
     * n1̂݃eXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetBlockageController01() throws Exception {
        // O
    	BlockageController existingController = 
    		new BlockageControlFilter_BlockageControllerStub01();
    	
    	UTUtil.setPrivateField(BlockageControlFilter.class,
				    			"controller",
                                existingController);

        // eXg{
        BlockageController actual =
            BlockageControlFilter.getBlockageController();
        
        // 
        assertSame(existingController,actual);
    }

    /**
     * testDoFilter01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() req:not null<br>
     *         () res:not null<br>
     *         () chain:not null<br>
     *         () BLOCKAGE_THRU_KEY:"aaaaa"<br>
     *         () blockageController:BlockageControlFilter_BlockageControllerStub01<br>
     *         
     * <br>
     * ҒlF(ԕω) BLOCKAGE_THRU_KEY:OƓl<br>
     *         (ԕω) chain.doFilter:s<br>
     *         
     * <br>
     * request̑lłBLOCKAGE_THRU_KEYnullłȂꍇAʋƖւ̑Jڃ`FbNs킸ɏI邱ƁB<br>
     * FilterChain#doFilter()\bhs邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoFilter01() throws Exception {
        // O
        BlockageController newController =
            new BlockageControlFilter_BlockageControllerStub01();
        
        BlockageControlFilter filter = new BlockageControlFilter();
        UTUtil.setPrivateField(filter, "controller", newController);
        
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        request.setAttribute("BLOCKAGE_THRU_KEY","aaaaa");
        
        BlockageControlFilter_FilterChainStub01 filterChain =
            new BlockageControlFilter_FilterChainStub01();
        
        // eXg{
        filter.doFilter(request,response,filterChain);
        // 
        assertEquals("aaaaa", request.getAttribute("BLOCKAGE_THRU_KEY"));
        assertTrue(filterChain.isCalled);
    }

    /**
     * testDoFilter02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() req:not null<br>
     *         () res:not null<br>
     *         () chain:not null<br>
     *         () BLOCKAGE_THRU_KEY:null<br>
     *         () blockageController:BlockageControlFilter_BlockageControllerStub01<br>
     *         () .isCheckRequired():false<br>
     *         
     * <br>
     * ҒlF(ԕω) BLOCKAGE_THRU_KEY:"true"<br>
     *         (ԕω) chain.doFilter:s<br>
     *         
     * <br>
     * ʋƖւ̑Jڃ`FbNfalsȅꍇAȍ~̃`FbNs킸Arequest̑lBLOCKAGE_THRU_KEYtrueݒ肵ďI邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoFilter02() throws Exception {
        // O
        BlockageController newController = 
            new BlockageControlFilter_BlockageControllerStub01();
        
        BlockageControlFilter filter = new BlockageControlFilter();
        UTUtil.setPrivateField(filter, "controller", newController);
        
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        
        BlockageControlFilter_FilterChainStub01 filterChain =
            new BlockageControlFilter_FilterChainStub01();
        
        // eXg{
        filter.doFilter(request,response,filterChain);
        // 
        assertEquals("true", request.getAttribute("BLOCKAGE_THRU_KEY"));
        assertTrue(filterChain.isCalled);
    }

    /**
     * testDoFilter03()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() req:not null<br>
     *         () res:not null<br>
     *         () chain:not null<br>
     *         () BLOCKAGE_THRU_KEY:null<br>
     *         () blockageController:BlockageControlFilter_BlockageControllerStub02<br>
     *         () .isCheckRequired():true<br>
     *         () .isBlockaded():true<br>
     *         
     * <br>
     * ҒlF(ԕω) BLOCKAGE_THRU_KEY:"true"<br>
     *         (ԕω) chain.doFilter:sȂ<br>
     *         (ԕω) O:BlockageExceptionF<br>
     *         
     * <br>
     * ʋƖւ̑Jڃ`FbNtureŁAƖǃ`FbNtruȅꍇArequest̑lBLOCKAGE_THRU_KEYݒ肵BlockageException邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoFilter03() throws Exception {
        // O
        BlockageController newController = 
            new BlockageControlFilter_BlockageControllerStub02();
        
        BlockageControlFilter filter = new BlockageControlFilter();
        UTUtil.setPrivateField(filter, "controller", newController);
        
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/test/logon.do");
        request.setContextPath("/test");
        MockHttpServletResponse response = new MockHttpServletResponse();
        
        BlockageControlFilter_FilterChainStub01 filterChain =
            new BlockageControlFilter_FilterChainStub01();
        
        // eXg{
        try {
            filter.doFilter(request, response, filterChain);
            fail();
        } catch (BlockageException ex) {
            // 
            assertEquals("true", request.getAttribute("BLOCKAGE_THRU_KEY"));
            assertFalse(filterChain.isCalled);
        }
    }

    /**
     * testDoFilter04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() req:not null<br>
     *         () res:not null<br>
     *         () chain:not null<br>
     *         () BLOCKAGE_THRU_KEY:null<br>
     *         () blockageController:BlockageControlFilter_BlockageControllerStub03<br>
     *         () .isCheckRequired():true<br>
     *         () .isBlockaded():false<br>
     *         
     * <br>
     * ҒlF(ԕω) BLOCKAGE_THRU_KEY:"true"<br>
     *         (ԕω) chain.doFilter:s<br>
     *         
     * <br>
     * ʋƖւ̑Jڃ`FbNtrueAƖǃ`FbNfalsȅꍇArequest̑lBLOCKAGE_THRU_KEYݒ肵ďI邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoFilter04() throws Exception {
        // O
        BlockageController newController = 
            new BlockageControlFilter_BlockageControllerStub03();
        
        BlockageControlFilter filter = new BlockageControlFilter();
        UTUtil.setPrivateField(filter, "controller", newController);
        
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/test/logon.do");
        request.setContextPath("/test");
        MockHttpServletResponse response = new MockHttpServletResponse();
        
        BlockageControlFilter_FilterChainStub01 filterChain = 
            new BlockageControlFilter_FilterChainStub01();
        
        // eXg{]
        filter.doFilter(request, response, filterChain);
        // 
        assertEquals("true", request.getAttribute("BLOCKAGE_THRU_KEY"));
        assertTrue(filterChain.isCalled);
    }

    /**
     * testDoFilter05()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() req:not null<br>
     *         () res:not null<br>
     *         () chain:not null<br>
     *         () BLOCKAGE_THRU_KEY:null<br>
     *         () blockageController:null<br>
     *         
     * <br>
     * ҒlF(ԕω) chain.doFilter:sȂ<br>
     *         (ԕω) O:NullPointerExceptionF<br>
     *         
     * <br>
     * blockageControllernull̏ꍇANullPointerException邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoFilter05() throws Exception {
        // O
        
        BlockageControlFilter filter = new BlockageControlFilter();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/test/logon.do");
        request.setContextPath("/test");
        MockHttpServletResponse response = new MockHttpServletResponse();
        
        BlockageControlFilter_FilterChainStub01 filterChain = 
            new BlockageControlFilter_FilterChainStub01();
        
        // eXg{
        try {
            filter.doFilter(request, response, filterChain);
            fail();
        } catch (NullPointerException e) {
            // 
            assertFalse(filterChain.isCalled);
        }
    }

    /**
     * testGetControllerClass01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() BLOCKAGE_CONTROLLER_CLASS:BlockageController.class<br>
     *                static final<br>
     *         
     * <br>
     * ҒlF(߂l) Class:OŐݒ肵CX^XƓ̃CX^X<br>
     *         
     * <br>
     * n1̂݃eXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetControllerClass01() throws Exception {
        // O
        BlockageControlFilter filter = new BlockageControlFilter();
        
        // eXg{
        Class actual = filter.getControllerClass();
        
        // 
        assertEquals(BlockageController.class,actual);
    }

    /**
     * testGetErrorCode01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() BLOCKAGE_CONTROLLER_ERROR:"errors.blockage.controller"<br>
     *                static final<br>
     *         
     * <br>
     * ҒlF(߂l) String:"errors.blockage.controller"<br>
     *         
     * <br>
     * n1̂݃eXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetErrorCode01() throws Exception {
        // O
        BlockageControlFilter filter = new BlockageControlFilter();
        
        // eXg{
        String actual = filter.getErrorCode();
        
        // 
        assertEquals("errors.blockage.controller",actual);
    }

    /**
     * testGetDefaultControllerBeanId01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() DEFAULT_BLOCKAGE_BEAN_ID:"blockageController"<br>
     *                static final<br>
     *         
     * <br>
     * ҒlF(߂l) String:"blockageController"<br>
     *         
     * <br>
     * n1̂݃eXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetDefaultControllerBeanId01() throws Exception {
        // O
        BlockageControlFilter filter = new BlockageControlFilter();
        
        // eXg{
        String actual = filter.getDefaultControllerBeanId();
        
        // 
        assertEquals("blockageController",actual);
    }

}
