/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.taglib;

import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;

import jp.terasoluna.fw.web.thin.AuthorizationControlFilter;
import jp.terasoluna.utlib.TagUTUtil;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * IfAuthorizedTag ubN{bNXeXgB<br>
 * O<br>
 * -<br>
 */
public class IfAuthorizedTagTest extends TestCase {

    // eXgΏۃNX
    IfAuthorizedTag tag = null;

    /**
     * RXgN^<br>
     * @param arg0
     */
    public IfAuthorizedTagTest(String arg0) {
        super(arg0);
    }

    /*
     * @see TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        tag = (IfAuthorizedTag) TagUTUtil.create(IfAuthorizedTag.class);
    }

    /*
     * @see TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * testDoStartTag01B<br>
     * 
     * (n)<br>
     * ϓ_FAAF<br>
     * 
     * ͒l
     * blockId=not null<br>
     * isAuthorized=true<br>
     * AccessController= not null<br>
     * 
     * Ғl
     * ߂l:int=EVAL_BODY_INCLUDE<br>
     * pageContextgetAttribute("blockId") = true<br>
     * 
     * EblockIdnot nullAisAuthorizedtruȅꍇA
     * @EVAL_BODY_INCLUDEԂ邱ƂmFB<br>
     * E܂APageContext̃ubNtrueۑĂ<br>
     * EIfAuthorizedTag_AccessControllerStub01̏ꍇA
     *   isAuthorized()ɂtrueԋp<br>
     */
    public void testDoStartTag01() throws Exception {
        // eXgf[^ݒ
        // ubNID̐ݒ
        UTUtil.setPrivateField(tag, "blockId", "blockId");
        // AccessControlFilterAAccessController̐
        IfAuthorizedTag_AccessControllerStub01 ac =
            new IfAuthorizedTag_AccessControllerStub01();
        UTUtil.setPrivateField(AuthorizationControlFilter.class,
                "controller", ac);

        // eXgs
        int result = tag.doStartTag();

        // eXgʊmF
        assertEquals(Tag.EVAL_BODY_INCLUDE, result);

        // PageContext
        PageContext pc = TagUTUtil.getPageContext(tag);
        Boolean bId = (Boolean) pc.getAttribute("blockId");
        assertTrue(bId.booleanValue());
    }

    /**
     * testDoStartTag02B<br>
     * 
     * (n)<br>
     * ϓ_FCAF<br>
     * 
     * ͒l
     * blockId=null<br>
     * isAuthorized=true<br>
     * AccessController= not null<br>
     * 
     * Ғl
     * ߂l:int=EVAL_BODY_INCLUDE<br>
     * pageContextgetAttribute("blockId") = null<br>
     * 
     * EblockIdnullAisAuthorizedtruȅꍇA
     * @EVAL_BODY_INCLUDEԂ邱ƂmFB<br>
     * EIfAuthorizedTag_AccessControllerStub01̏ꍇA
     *   isAuthorized()ɂtrueԋp<br>
     */
    public void testDoStartTag02() throws Exception {
        // eXgf[^ݒ
        // ubNID̐ݒ
        UTUtil.setPrivateField(tag, "blockId", null);
        // AccessControlFilterAAccessController̐
        IfAuthorizedTag_AccessControllerStub01 ac =
            new IfAuthorizedTag_AccessControllerStub01();
        UTUtil.setPrivateField(AuthorizationControlFilter.class,
                "controller", ac);

        // eXgs
        int result = tag.doStartTag();

        // eXgʊmF
        assertEquals(Tag.EVAL_BODY_INCLUDE, result);

        // PageContext
        PageContext pc = TagUTUtil.getPageContext(tag);
        Boolean bId = (Boolean) pc.getAttribute("blockId");
        assertNull(bId);

    }

    /**
     * testDoStartTag03B<br>
     * 
     * (n)<br>
     * ϓ_FAAF<br>
     * 
     * ͒l
     * blockId=not null<br>
     * isAuthorized=false<br>
     * AccessController= not null<br>
     * 
     * Ғl
     * ߂l:int=SKIP_BODY<br>
     * pageContextgetAttribute("blockId") = null<br>
     * 
     * EblockIdnot nullAisAuthorizedfalsȅꍇA
     * @SKIP_BODYԂ邱ƂmFB<br>
     * EIfAuthorizedTag_AccessControllerStub02̏ꍇA
     *   isAuthorized()ɂfalseԋp<br>
     */
    public void testDoStartTag03() throws Exception {
        // eXgf[^ݒ
        // ubNID̐ݒ
        UTUtil.setPrivateField(tag, "blockId", "blockId");
        // AccessControlFilterAAccessController̐
        IfAuthorizedTag_AccessControllerStub02 ac =
            new IfAuthorizedTag_AccessControllerStub02();
        UTUtil.setPrivateField(AuthorizationControlFilter.class,
                "controller", ac);

        // eXgs
        int result = tag.doStartTag();

        // eXgʊmF
        assertEquals(Tag.SKIP_BODY, result);

        // PageContext
        PageContext pc = TagUTUtil.getPageContext(tag);
        Boolean bId = (Boolean) pc.getAttribute("blockId");
        assertNull(bId);

    }

    /**
     * testDoStartTag04B<br>
     * 
     * (ُn)<br>
     * ϓ_FG<br>
     * 
     * ͒l
     * blockId=not null<br>
     * AccessController= null<br>
     * 
     * Ғl
     * ߂l:NullPointerException<br>
     * 
     * EAccessController= null̏ꍇA<br>
     * @NullPointerExceptionԂ邱ƂmFB<br>
     */
    public void testDoStartTag04() throws Exception {
        // eXgf[^ݒ
        // ubNID̐ݒ
        UTUtil.setPrivateField(tag, "blockId", "blockId");
        // AccessControlFilterAAccessController̐
        UTUtil.setPrivateField(AuthorizationControlFilter.class,
                "controller", null);

        // eXgs
        try {
            tag.doStartTag();
            fail();
        } catch (NullPointerException e) {
            return;
        }

    }

    /**
     * testRelease01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * this.path=*<br>
     * this.blockId=*<br>
     * 
     * Ғl
     * ߂l:void<br>
     * this.path=null<br>
     * this.blockId=null<br>
     * 
     * OƂĐݒ肵elAsɊel
     * 邱ƂmF<br>
     */
    public void testRelease01() throws Exception {
        //eXgf[^ݒ
        String path = "";
        String blockId = "";

        UTUtil.setPrivateField(tag, "path", path);
        UTUtil.setPrivateField(tag, "blockId", blockId);

        //eXgs
        tag.release();

        //eXgʊmF

        String path2 = (String) UTUtil.getPrivateField(tag, "path");
        String blockId2 = (String) UTUtil.getPrivateField(tag, "blockId");

        assertNull(path2);
        assertNull(blockId2);

    }

    /**
     * testSetBlockId01()B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lF
     *   F"blockId"
     * 
     * ҒlFɂĐݒ肵l
     *
     * Őݒ肵lݒ肳Ă邱ƂmFB
     *
     * @throws Exception eXgR[h̖{Ƃ̖O
     */
    public void testSetBlockId01() throws Exception {
        //eXgf[^ݒ
        String value = "blockId";

        //eXgs
        tag.setBlockId(value);

        //ʊmF
        String result = (String) UTUtil.getPrivateField(tag, "blockId");
        assertEquals(value, result);
    }

    /**
     * testSetPath01()B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lF
     *   F"path"
     * 
     * ҒlFɂĐݒ肵l
     *
     * Őݒ肵lݒ肳Ă邱ƂmFB
     *
     * @throws Exception eXgR[h̖{Ƃ̖O
     */
    public void testSetPath01() throws Exception {
        //eXgf[^ݒ
        String value = "path";

        //eXgs
        tag.setPath(value);

        //ʊmF
        String result = (String) UTUtil.getPrivateField(tag, "path");
        assertEquals(value, result);
    }
    /**
     * testDoEndTag01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     *   
     * ͒l:Ȃ<br>
     * 
     * Ғl
     * ߂l:int=EVAL_PAGE<br>
     * 
     * EVAL_PAGEԋpB<br>
     */
    public void testDoEndTag01() throws Exception {

        int result = 0;
        //eXgs
        result = tag.doEndTag();

        //eXgʊmF
        assertEquals(Tag.EVAL_PAGE, result);
    }
}
