/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.form;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.PropertyTestCase;

import org.apache.commons.validator.Field;
import org.apache.commons.validator.Msg;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorResources;
import org.apache.commons.validator.Var;
import org.apache.struts.Globals;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

/**
 * {@link jp.terasoluna.fw.web.struts.form.FieldChecksEx}
 * NX̃ubN{bNXeXgB
 *
 * <p>
 * <h4>yNX̊Tvz</h4>
 * Validatorǉ[NXB
 * <p>
 *
 * @see jp.terasoluna.fw.web.struts.form.FieldChecksEx
 */
public class FieldChecksExTest09 extends PropertyTestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     *
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(FieldChecksExTest09.class);
    }

    /**
     * sB
     *
     * @throws Exception ̃\bhŔO
     * @see jp.terasoluna.utlib.spring.PropertyTestCase#setUpData()
     */
    @Override
    protected void setUpData() throws Exception {
        LogUTUtil.flush();
        deleteProperty("validation.hankaku.kana.list");
        deleteProperty("validation.zenkaku.kana.list");
    }

    /**
     * IsB
     *
     * @throws Exception ̃\bhŔO
     * @see jp.terasoluna.utlib.spring.PropertyTestCase#cleanUpData()
     */
    @Override
    protected void cleanUpData() throws Exception {
    }

    /**
     * RXgN^B
     *
     * @param name ̃eXgP[X̖OB
     */
    public FieldChecksExTest09(String name) {
        super(name);
    }

    /**
     * testValidateDateRange01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:null<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *                Locale=JAPANESE<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) O:OxF<br>
     *                    G[<br>
     *                    bZ[WF<br>
     *                    bean is null.<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * beannull̂ƂAG[Oo͂trueԋp邱Ƃ
     * mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateDateRange01() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = null;
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        // ++++ ؃tB[h
        Field field = new Field();
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setLocale(Locale.JAPANESE);
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateDateRange(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());

        // G[OmF
        assertTrue(LogUTUtil.checkError("bean is null."));
    }

    /**
     * testValidateDateRange02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:""<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *                Locale=JAPANESE<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * bean󕶎̂ƂAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateDateRange02() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        // ++++ ؃tB[h
        Field field = new Field();
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setLocale(Locale.JAPANESE);
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateDateRange(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateDateRange03()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"abc"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:datePattern=null<br>
     *                var:datePatternStrict=null<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                ActionMessage("testMessage")<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *                Locale=JAPANESE<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage("testMessage")<br>
     *                    ActionMessage("message")<br>
     *
     * <br>
     * datePatternAdatePatternStrictw肵Ă炸A
     * beanDateɕϊłȂꍇA
     * G[bZ[Wǉfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateDateRange03() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "abc";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("datePattern");
        var.setValue(null);
        field.addVar(var);
        var = new Var();
        var.setName("datePatternStrict");
        var.setValue(null);
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        ActionMessage error = new ActionMessage("testMessage");
        errors.add(Globals.ERROR_KEY, error);
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setLocale(Locale.JAPANESE);
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateDateRange(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[2ł邱ƁB
        assertEquals(2, errors.size());

        // bZ[WIuWFNgmF
        Iterator it = errors.get();
        List<String> list = new ArrayList<String>();
        while (it.hasNext()) {
            ActionMessage message = (ActionMessage) it.next();
            list.add(message.getKey());
        }
        assertTrue(list.contains("message"));
        assertTrue(list.contains("testMessage"));
    }

    /**
     * testValidateDateRange04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"abc"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:datePattern=""<br>
     *                var:datePatternStrict=""<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *                Locale=JAPANESE<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage("message")<br>
     *
     * <br>
     * datePatternAdatePatternStrictɋ󕶎w肳ĂāA
     * beanDateɕϊłȂꍇA
     * G[bZ[Wǉfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateDateRange04() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "abc";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("datePattern");
        var.setValue("");
        field.addVar(var);
        var = new Var();
        var.setName("datePatternStrict");
        var.setValue("");
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setLocale(Locale.JAPANESE);
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateDateRange(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[1ł邱ƁB
        assertEquals(1, errors.size());

        // bZ[WIuWFNgmF
        Iterator it = errors.get();
        ActionMessage message = (ActionMessage) it.next();
        assertEquals("message", message.getKey());
    }

    /**
     * testValidateDateRange05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"abc"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:datePattern=null<br>
     *                var:datePatternStrict="yyyy/MM/dd"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *                Locale=JAPANESE<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage("message")<br>
     *
     * <br>
     * datePatternw肳Ă炸AdatePatternStrictɐȓttH[}bg
     * w肳ĂāAbeanDateɕϊłȂꍇA
     * G[bZ[Wǉfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateDateRange05() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "abc";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("datePattern");
        var.setValue(null);
        field.addVar(var);
        var = new Var();
        var.setName("datePatternStrict");
        var.setValue("yyyy/MM/dd");
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setLocale(Locale.JAPANESE);
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateDateRange(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[1ł邱ƁB
        assertEquals(1, errors.size());

        // bZ[WIuWFNgmF
        Iterator it = errors.get();
        ActionMessage message = (ActionMessage) it.next();
        assertEquals("message", message.getKey());
    }

    /**
     * testValidateDateRange06()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() bean:"2005/10/24"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:datePattern=null<br>
     *                var:datePatternStrict="abc"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *                Locale=JAPANESE<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) O:OxF<br>
     *                    G[<br>
     *                    bZ[WF<br>
     *                    Illegal pattern character 'b'<br>
     *                    OF<br>
     *                    IllegalArgumentException<br>
     *         (ԕω) errors:ActionMessage("message")<br>
     *
     * <br>
     * beanȓt\ŁAdatePatternw肳Ă炸A
     * datePatternStrictɕsȓttH[}bgw肳ĂꍇA
     * G[bZ[Wǉfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateDateRange06() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "2005/10/24";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("datePattern");
        var.setValue(null);
        field.addVar(var);
        var = new Var();
        var.setName("datePatternStrict");
        var.setValue("abc");
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setLocale(Locale.JAPANESE);
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateDateRange(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[1ł邱ƁB
        assertEquals(1, errors.size());

        // bZ[WIuWFNgmF
        Iterator it = errors.get();
        ActionMessage message = (ActionMessage) it.next();
        assertEquals("message", message.getKey());

        // G[O`FbN
        assertTrue(LogUTUtil.checkError("Illegal pattern character 'b'",
                new IllegalArgumentException()));
    }

    /**
     * testValidateDateRange07()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"2005/02/29"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:datePattern=null<br>
     *                var:datePatternStrict="yyyy/MM/dd"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *                Locale=JAPANESE<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage("message")<br>
     *
     * <br>
     * bean݂Ȃt\ŁAdatePatternw肳Ă炸A
     * datePatternStrictɕsȓttH[}bgw肳ĂꍇA
     * G[bZ[Wǉfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateDateRange07() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "2005/02/29";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("datePattern");
        var.setValue(null);
        field.addVar(var);
        var = new Var();
        var.setName("datePatternStrict");
        var.setValue("yyyy/MM/dd");
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setLocale(Locale.JAPANESE);
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateDateRange(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[1ł邱ƁB
        assertEquals(1, errors.size());

        // bZ[WIuWFNgmF
        Iterator it = errors.get();
        ActionMessage message = (ActionMessage) it.next();
        assertEquals("message", message.getKey());
    }

    /**
     * testValidateDateRange08()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"2005/2/28"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:datePattern=null<br>
     *                var:datePatternStrict="yyyy/MM/dd"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *                Locale=JAPANESE<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage("message")<br>
     *
     * <br>
     * beanȓt\ŁAdatePatternw肳Ă炸A
     * datePatternStrictɎw肳ꂽttH[}bgbeañtH[}bg
     * SɈvȂꍇAG[bZ[Wǉfalseԋp邱Ƃ
     * mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateDateRange08() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "2005/2/28";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("datePattern");
        var.setValue(null);
        field.addVar(var);
        var = new Var();
        var.setName("datePatternStrict");
        var.setValue("yyyy/MM/dd");
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setLocale(Locale.JAPANESE);
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateDateRange(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[1ł邱ƁB
        assertEquals(1, errors.size());

        // bZ[WIuWFNgmF
        Iterator it = errors.get();
        ActionMessage message = (ActionMessage) it.next();
        assertEquals("message", message.getKey());
    }

    /**
     * testValidateDateRange09()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"abc"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:datePattern="yyyy/MM/dd"<br>
     *                var:datePatternStrict=null<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *                Locale=JAPANESE<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage("message")<br>
     *
     * <br>
     * datePatternɐȓttH[}bgw肳ĂāA
     * beanDateɕϊłȂꍇAG[bZ[Wǉfalse
     * ԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateDateRange09() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "abc";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("datePattern");
        var.setValue("yyyy/MM/dd");
        field.addVar(var);
        var = new Var();
        var.setName("datePatternStrict");
        var.setValue(null);
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setLocale(Locale.JAPANESE);
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateDateRange(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[1ł邱ƁB
        assertEquals(1, errors.size());

        // bZ[WIuWFNgmF
        Iterator it = errors.get();
        ActionMessage message = (ActionMessage) it.next();
        assertEquals("message", message.getKey());
    }

    /**
     * testValidateDateRange10()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"2005/10/24"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:datePattern="abc"<br>
     *                var:datePatternStrict=null<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *                Locale=JAPANESE<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) O:OxF<br>
     *                    G[<br>
     *                    bZ[WF<br>
     *                    Illegal pattern character 'b'<br>
     *                    OF<br>
     *                    IllegalArgumentException<br>
     *         (ԕω) errors:ActionMessage("message")<br>
     *
     * <br>
     * beanȓt\ŁAdatePatternɕs
     * ttH[}bgw肳ĂꍇAG[bZ[Wǉfalse
     * ԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateDateRange10() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "2005/10/24";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("datePattern");
        var.setValue("abc");
        field.addVar(var);
        var = new Var();
        var.setName("datePatternStrict");
        var.setValue(null);
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setLocale(Locale.JAPANESE);
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateDateRange(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[1ł邱ƁB
        assertEquals(1, errors.size());

        // bZ[WIuWFNgmF
        Iterator it = errors.get();
        ActionMessage message = (ActionMessage) it.next();
        assertEquals("message", message.getKey());

        // G[O`FbN
        assertTrue(LogUTUtil.checkError("Illegal pattern character 'b'",
                new IllegalArgumentException()));
    }

    /**
     * testValidateDateRange11()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"2005/02/29"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:datePattern="yyyy/MM/dd"<br>
     *                var:datePatternStrict=null<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *                Locale=JAPANESE<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage("message")<br>
     *
     * <br>
     * bean݂Ȃt\ŁAdatePatternɕs
     * ttH[}bgw肳ĂꍇAG[bZ[Wǉ
     * falseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateDateRange11() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "2005/02/29";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("datePattern");
        var.setValue("yyyy/MM/dd");
        field.addVar(var);
        var = new Var();
        var.setName("datePatternStrict");
        var.setValue(null);
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setLocale(Locale.JAPANESE);
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateDateRange(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[1ł邱ƁB
        assertEquals(1, errors.size());

        // bZ[WIuWFNgmF
        Iterator it = errors.get();
        ActionMessage message = (ActionMessage) it.next();
        assertEquals("message", message.getKey());
    }

    /**
     * testValidateDateRange12()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"2005/2/28"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:datePattern="yyyy/MM/dd"<br>
     *                var:datePatternStrict="yyyy/MM/dd"<br>
     *                var:startDate=null<br>
     *                var:endDate=null<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *                Locale=JAPANESE<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * datePatterndatePatternStrictw肳ĂꍇA
     * datePatternɎw肵tH[}bgD悳邱ƁA<br>
     * fieldstartDateendDatenull̏ꍇAtrue擾ł邱ƁAmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateDateRange12() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "2005/2/28";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("datePattern");
        var.setValue("yyyy/MM/dd");
        field.addVar(var);
        var = new Var();
        var.setName("datePatternStrict");
        var.setValue("yyyy/MM/dd");
        field.addVar(var);
        var = new Var();
        var.setName("startDate");
        var.setValue(null);
        field.addVar(var);
        var = new Var();
        var.setName("endDate");
        var.setValue(null);
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setLocale(Locale.JAPANESE);
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateDateRange(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateDateRange13()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"2005/2/28"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:datePattern="yyyy/MM/dd"<br>
     *                var:datePatternStrict="yyyy/MM/dd"<br>
     *                var:startDate=""<br>
     *                var:endDate=""<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *                Locale=JAPANESE<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * datePatterndatePatternStrictw肳ĂꍇA
     * datePatternɎw肵tH[}bgD悳邱ƁA<br>
     * fieldstartDateendDate󕶎̏ꍇAtrue擾ł邱ƁA
     * mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateDateRange13() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "2005/2/28";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("datePattern");
        var.setValue("yyyy/MM/dd");
        field.addVar(var);
        var = new Var();
        var.setName("datePatternStrict");
        var.setValue("yyyy/MM/dd");
        field.addVar(var);
        var = new Var();
        var.setName("startDate");
        var.setValue("");
        field.addVar(var);
        var = new Var();
        var.setName("endDate");
        var.setValue("");
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setLocale(Locale.JAPANESE);
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateDateRange(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateDateRange14()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"2005/01/01"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:datePattern=null<br>
     *                var:datePatternStrict=null<br>
     *                var:startDate="abc"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *                Locale=JAPANESE<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage("message")<br>
     *
     * <br>
     * datePatternAdatePatternStrictw肵Ă炸A
     * beanDateɕϊłAfieldstartDatetɕϊłȂꍇA
     * G[bZ[WǉAfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateDateRange14() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "2005/01/01";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("datePattern");
        var.setValue(null);
        field.addVar(var);
        var = new Var();
        var.setName("datePatternStrict");
        var.setValue(null);
        field.addVar(var);
        var = new Var();
        var.setName("startDate");
        var.setValue("abc");
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setLocale(Locale.JAPANESE);
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateDateRange(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[1ł邱ƁB
        assertEquals(1, errors.size());

        // bZ[WIuWFNgmF
        Iterator it = errors.get();
        ActionMessage message = (ActionMessage) it.next();
        assertEquals("message", message.getKey());
    }

    /**
     * testValidateDateRange15()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"2005/01/01"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:datePattern=null<br>
     *                var:datePatternStrict="yyyy/MM/dd"<br>
     *                var:startDate="2005/02/29"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *                Locale=JAPANESE<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage("message")<br>
     *
     * <br>
     * datePatternStrict݂̂ɐȓttH[}bgw肳A
     * beanDateɕϊłAfieldstartDatetɕϊłȂꍇA
     * G[bZ[WǉAfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateDateRange15() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "2005/01/01";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("datePattern");
        var.setValue(null);
        field.addVar(var);
        var = new Var();
        var.setName("datePatternStrict");
        var.setValue("yyyy/MM/dd");
        field.addVar(var);
        var = new Var();
        var.setName("startDate");
        var.setValue("2005/02/29");
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setLocale(Locale.JAPANESE);
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateDateRange(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[1ł邱ƁB
        assertEquals(1, errors.size());

        // bZ[WIuWFNgmF
        Iterator it = errors.get();
        ActionMessage message = (ActionMessage) it.next();
        assertEquals("message", message.getKey());
    }

    /**
     * testValidateDateRange16()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"2005/01/01"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:datePattern=null<br>
     *                var:datePatternStrict="yyyy/MM/dd"<br>
     *                var:startDate="2005/2/28"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *                Locale=JAPANESE<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage("message")<br>
     *
     * <br>
     * datePatternStrict݂̂ɐȓttH[}bgw肳A
     * beanDateɕϊłAfieldstartDatetɕϊłȂꍇA
     * G[bZ[WǉAfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateDateRange16() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "2005/01/01";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("datePattern");
        var.setValue(null);
        field.addVar(var);
        var = new Var();
        var.setName("datePatternStrict");
        var.setValue("yyyy/MM/dd");
        field.addVar(var);
        var = new Var();
        var.setName("startDate");
        var.setValue("2005/2/28");
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setLocale(Locale.JAPANESE);
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateDateRange(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[1ł邱ƁB
        assertEquals(1, errors.size());

        // bZ[WIuWFNgmF
        Iterator it = errors.get();
        ActionMessage message = (ActionMessage) it.next();
        assertEquals("message", message.getKey());
    }

    /**
     * testValidateDateRange17()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"2005/01/01"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:datePattern=null<br>
     *                var:datePatternStrict="yyyy/MM/dd"<br>
     *                var:startDate="abc"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *                Locale=JAPANESE<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage("message")<br>
     *
     * <br>
     * datePatternStrict݂̂ɐȓttH[}bgw肳A
     * beanDateɕϊłAfieldstartDatetɕϊłȂꍇA
     * G[bZ[WǉAfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateDateRange17() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "2005/01/01";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("datePattern");
        var.setValue(null);
        field.addVar(var);
        var = new Var();
        var.setName("datePatternStrict");
        var.setValue("yyyy/MM/dd");
        field.addVar(var);
        var = new Var();
        var.setName("startDate");
        var.setValue("abc");
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setLocale(Locale.JAPANESE);
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateDateRange(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[1ł邱ƁB
        assertEquals(1, errors.size());

        // bZ[WIuWFNgmF
        Iterator it = errors.get();
        ActionMessage message = (ActionMessage) it.next();
        assertEquals("message", message.getKey());
    }

    /**
     * testValidateDateRange18()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"2005/01/01"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:datePattern="yyyy/MM/dd"<br>
     *                var:datePatternStrict="yyyy/MM/dd"<br>
     *                var:startDate="abc"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *                Locale=JAPANESE<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage("message")<br>
     *
     * <br>
     * datePatternAdatePatternStrictɐȓttH[}bgw肳A
     * beanDateɕϊłAfieldstartDatetɕϊłȂꍇA
     * G[bZ[WǉAfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateDateRange18() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "2005/01/01";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("datePattern");
        var.setValue("yyyy/MM/dd");
        field.addVar(var);
        var = new Var();
        var.setName("datePatternStrict");
        var.setValue("yyyy/MM/dd");
        field.addVar(var);
        var = new Var();
        var.setName("startDate");
        var.setValue("abc");
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setLocale(Locale.JAPANESE);
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateDateRange(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[1ł邱ƁB
        assertEquals(1, errors.size());

        // bZ[WIuWFNgmF
        Iterator it = errors.get();
        ActionMessage message = (ActionMessage) it.next();
        assertEquals("message", message.getKey());
    }

    /**
     * testValidateDateRange19()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"2005/01/01"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:datePattern="yyyy/MM/dd"<br>
     *                var:datePatternStrict="yyyy/MM/dd"<br>
     *                var:startDate="2005/1/2"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *                Locale=JAPANESE<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage("message")<br>
     *
     * <br>
     * bean̓tAstartDateŎw肳ꂽtȌꍇA
     * G[bZ[WǉāAfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateDateRange19() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "2005/01/01";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("datePattern");
        var.setValue("yyyy/MM/dd");
        field.addVar(var);
        var = new Var();
        var.setName("datePatternStrict");
        var.setValue("yyyy/MM/dd");
        field.addVar(var);
        var = new Var();
        var.setName("startDate");
        var.setValue("2005/1/2");
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setLocale(Locale.JAPANESE);
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateDateRange(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[1ł邱ƁB
        assertEquals(1, errors.size());

        // bZ[WIuWFNgmF
        Iterator it = errors.get();
        ActionMessage message = (ActionMessage) it.next();
        assertEquals("message", message.getKey());
    }

    /**
     * testValidateDateRange20()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"2005/01/01"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:datePattern=null<br>
     *                var:datePatternStrict=null<br>
     *                var:startDate="2004/01/01"<br>
     *                var.endDate="abc"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *                Locale=JAPANESE<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage("message")<br>
     *
     * <br>
     * datePatternAdatePatternStrictnullendDatetɕϊłȂꍇA
     * G[bZ[Wǉfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateDateRange20() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "2005/01/01";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("datePattern");
        var.setValue(null);
        field.addVar(var);
        var = new Var();
        var.setName("datePatternStrict");
        var.setValue(null);
        field.addVar(var);
        var = new Var();
        var.setName("startDate");
        var.setValue("2004/01/01");
        field.addVar(var);
        var = new Var();
        var.setName("endDate");
        var.setValue("abc");
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setLocale(Locale.JAPANESE);
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateDateRange(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[1ł邱ƁB
        assertEquals(1, errors.size());

        // bZ[WIuWFNgmF
        Iterator it = errors.get();
        ActionMessage message = (ActionMessage) it.next();
        assertEquals("message", message.getKey());
    }

    /**
     * testValidateDateRange21()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"2005/01/01"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:datePattern=null<br>
     *                var:datePatternStrict="yyyy/MM/dd"<br>
     *                var:startDate="2004/01/01"<br>
     *                var:endDate="2005/02/29"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *                Locale=JAPANESE<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage("message")<br>
     *
     * <br>
     * datePatternnullAdatePatternStrictȓttH[}bgŁA
     * endDate݂Ȃt̏ꍇAG[bZ[Wǉfalse
     * ԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateDateRange21() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "2005/01/01";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("datePattern");
        var.setValue(null);
        field.addVar(var);
        var = new Var();
        var.setName("datePatternStrict");
        var.setValue("yyyy/MM/dd");
        field.addVar(var);
        var = new Var();
        var.setName("startDate");
        var.setValue("2004/01/01");
        field.addVar(var);
        var = new Var();
        var.setName("endDate");
        var.setValue("2005/02/29");
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setLocale(Locale.JAPANESE);
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateDateRange(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[1ł邱ƁB
        assertEquals(1, errors.size());

        // bZ[WIuWFNgmF
        Iterator it = errors.get();
        ActionMessage message = (ActionMessage) it.next();
        assertEquals("message", message.getKey());
    }

    /**
     * testValidateDateRange22()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"2005/01/01"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:datePattern=null<br>
     *                var:datePatternStrict="yyyy/MM/dd"<br>
     *                var:startDate="2004/01/01"<br>
     *                var:endDate="2005/2/28"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *                Locale=JAPANESE<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage("message")<br>
     *
     * <br>
     * datePatternnullAdatePatternStrictȓttH[}bgŁA
     * endDate̓ttH[}bgƊSɈvȂꍇA
     * G[bZ[Wǉfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateDateRange22() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "2005/01/01";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("datePattern");
        var.setValue(null);
        field.addVar(var);
        var = new Var();
        var.setName("datePatternStrict");
        var.setValue("yyyy/MM/dd");
        field.addVar(var);
        var = new Var();
        var.setName("startDate");
        var.setValue("2004/01/01");
        field.addVar(var);
        var = new Var();
        var.setName("endDate");
        var.setValue("2005/2/28");
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setLocale(Locale.JAPANESE);
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateDateRange(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[1ł邱ƁB
        assertEquals(1, errors.size());

        // bZ[WIuWFNgmF
        Iterator it = errors.get();
        ActionMessage message = (ActionMessage) it.next();
        assertEquals("message", message.getKey());
    }

    /**
     * testValidateDateRange23()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"2005/01/01"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:datePattern=null<br>
     *                var:datePatternStrict="yyyy/MM/dd"<br>
     *                var:startDate="2004/01/01"<br>
     *                var:endDate="abc"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *                Locale=JAPANESE<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage("message")<br>
     *
     * <br>
     * datePatternnullAdatePatternStrictȓttH[}bgŁA
     * endDatetł͂ȂꍇAG[bZ[Wǉfalseԋp
     * ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateDateRange23() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "2005/01/01";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("datePattern");
        var.setValue(null);
        field.addVar(var);
        var = new Var();
        var.setName("datePatternStrict");
        var.setValue("yyyy/MM/dd");
        field.addVar(var);
        var = new Var();
        var.setName("startDate");
        var.setValue("2004/01/01");
        field.addVar(var);
        var = new Var();
        var.setName("endDate");
        var.setValue("abc");
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setLocale(Locale.JAPANESE);
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateDateRange(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[1ł邱ƁB
        assertEquals(1, errors.size());

        // bZ[WIuWFNgmF
        Iterator it = errors.get();
        ActionMessage message = (ActionMessage) it.next();
        assertEquals("message", message.getKey());
    }

    /**
     * testValidateDateRange24()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"2005/01/01"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:datePattern="yyyy/MM/dd"<br>
     *                var:datePatternStrict="yyyy/MM/dd"<br>
     *                var:startDate="2004/01/01"<br>
     *                var:endDate="abc"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *                Locale=JAPANESE<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage("message")<br>
     *
     * <br>
     * datePatternAdatePatternStrictɐȓttH[}bgw肳A
     * fieldendDatetɕϊłȂꍇAG[bZ[WǉA
     * falseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateDateRange24() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "2005/01/01";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("datePattern");
        var.setValue("yyyy/MM/dd");
        field.addVar(var);
        var = new Var();
        var.setName("datePatternStrict");
        var.setValue("yyyy/MM/dd");
        field.addVar(var);
        var = new Var();
        var.setName("startDate");
        var.setValue("2004/01/01");
        field.addVar(var);
        var = new Var();
        var.setName("endDate");
        var.setValue("abc");
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setLocale(Locale.JAPANESE);
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateDateRange(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[1ł邱ƁB
        assertEquals(1, errors.size());

        // bZ[WIuWFNgmF
        Iterator it = errors.get();
        ActionMessage message = (ActionMessage) it.next();
        assertEquals("message", message.getKey());
    }

    /**
     * testValidateDateRange25()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"2005/01/02"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:datePattern="yyyy/MM/dd"<br>
     *                var:datePatternStrict="yyyy/MM/dd"<br>
     *                var:startDate="2004/01/01"<br>
     *                var:endDate="2005/1/1"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *                Locale=JAPANESE<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage("message")<br>
     *
     * <br>
     * bean̓tAendDateŎw肳ꂽt̏ꍇA
     * G[bZ[WǉāAfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateDateRange25() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "2005/01/02";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("datePattern");
        var.setValue("yyyy/MM/dd");
        field.addVar(var);
        var = new Var();
        var.setName("datePatternStrict");
        var.setValue("yyyy/MM/dd");
        field.addVar(var);
        var = new Var();
        var.setName("startDate");
        var.setValue("2004/01/01");
        field.addVar(var);
        var = new Var();
        var.setName("endDate");
        var.setValue("2005/1/1");
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setLocale(Locale.JAPANESE);
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateDateRange(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[1ł邱ƁB
        assertEquals(1, errors.size());

        // bZ[WIuWFNgmF
        Iterator it = errors.get();
        ActionMessage message = (ActionMessage) it.next();
        assertEquals("message", message.getKey());
    }

    /**
     * testValidateDateRange26()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"2005/01/02"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:datePattern=null<br>
     *                var:datePatternStrict=null<br>
     *                var:startDate="2005/1/1"<br>
     *                var:endDate="2005/1/3"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *                Locale=JAPANESE<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * datePatternAdatePatternStrictnullbean̓tstartDateendDate
     * ԂɂꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateDateRange26() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "2005/01/02";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("datePattern");
        var.setValue(null);
        field.addVar(var);
        var = new Var();
        var.setName("datePatternStrict");
        var.setValue(null);
        field.addVar(var);
        var = new Var();
        var.setName("startDate");
        var.setValue("2005/1/1");
        field.addVar(var);
        var = new Var();
        var.setName("endDate");
        var.setValue("2005/1/3");
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setLocale(Locale.JAPANESE);
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateDateRange(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateDateRange27()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"2005/1/2"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:datePattern="yyyy/MM/dd"<br>
     *                var:datePatternStrict="yyyy.MM.dd"<br>
     *                var:startDate="2005/1/1"<br>
     *                var:endDate="2005/1/3"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *                Locale=JAPANESE<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * datePatternAdatePatternStrictƂɃtH[}bgw肳ĂꍇA
     * datePatterñtH[}bgKp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateDateRange27() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "2005/1/2";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("datePattern");
        var.setValue("yyyy/MM/dd");
        field.addVar(var);
        var = new Var();
        var.setName("datePatternStrict");
        var.setValue("yyyy.MM.dd");
        field.addVar(var);
        var = new Var();
        var.setName("startDate");
        var.setValue("2005/1/1");
        field.addVar(var);
        var = new Var();
        var.setName("endDate");
        var.setValue("2005/1/3");
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setLocale(Locale.JAPANESE);
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateDateRange(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateDateRange28()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"2005/01/02"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:datePattern=null<br>
     *                var:datePatternStrict="yyyy/MM/dd"<br>
     *                var:startDate="2005/01/01"<br>
     *                var:endDate="2005/01/03"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *                Locale=JAPANESE<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * datePatternnullAdatePatternStrictɐȃtH[}bgw肳Ă
     * ꍇŁAbean̓tstartDateendDate̊ԂɂꍇA
     * true擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateDateRange28() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "2005/01/02";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("datePattern");
        var.setValue(null);
        field.addVar(var);
        var = new Var();
        var.setName("datePatternStrict");
        var.setValue("yyyy/MM/dd");
        field.addVar(var);
        var = new Var();
        var.setName("startDate");
        var.setValue("2005/01/01");
        field.addVar(var);
        var = new Var();
        var.setName("endDate");
        var.setValue("2005/01/03");
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setLocale(Locale.JAPANESE);
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateDateRange(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateDateRange29()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"2005/01/01"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:datePattern=null<br>
     *                var:datePatternStrict=null<br>
     *                var:startDate="2005/1/1"<br>
     *                var:end]Date="2005/1/1"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *                Locale=JAPANESE<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * bean̓tƁAstartDateAendDatevꍇA
     * true擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateDateRange29() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "2005/01/01";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("datePattern");
        var.setValue(null);
        field.addVar(var);
        var = new Var();
        var.setName("datePatternStrict");
        var.setValue(null);
        field.addVar(var);
        var = new Var();
        var.setName("startDate");
        var.setValue("2005/1/1");
        field.addVar(var);
        var = new Var();
        var.setName("endDate");
        var.setValue("2005/1/1");
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setLocale(Locale.JAPANESE);
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateDateRange(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateDateRange30()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:Map:<br>
     *                ["field1"=<br>
     *                @"2005/01/02"]<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:datePattern=null<br>
     *                var:datePatternStrict="yyyy/MM/dd"<br>
     *                var:startDate="2005/01/01"<br>
     *                var:endDate="2005/01/03"<br>
     *                Msg("message","message")<br>
     *                property="field1"<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *                Locale=JAPANESE<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * beanString^ł͂ȂꍇAfield擾ÕvpeBɑ΂ă`FbNsƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateDateRange30() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        Map<String, String> bean = new HashMap<String, String>();
        bean.put("field1", "2005/01/02");
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        field.setProperty("field1");
        Var var = new Var();
        var.setName("datePattern");
        var.setValue(null);
        field.addVar(var);
        var = new Var();
        var.setName("datePatternStrict");
        var.setValue("yyyy/MM/dd");
        field.addVar(var);
        var = new Var();
        var.setName("startDate");
        var.setValue("2005/01/01");
        field.addVar(var);
        var = new Var();
        var.setName("endDate");
        var.setValue("2005/01/03");
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setLocale(Locale.JAPANESE);
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateDateRange(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateDateRange31()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:Map:<br>
     *                ["field1"=<br>
     *                @"2005/01/04"]<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:datePattern=null<br>
     *                var:datePatternStrict="yyyy/MM/dd"<br>
     *                var:startDate="2005/01/01"<br>
     *                var:endDate="2005/01/03"<br>
     *                Msg("message","message")<br>
     *                property="field1"<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *                Locale=JAPANESE<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage("message")<br>
     *
     * <br>
     * beanString^ł͂ȂꍇAfield擾ÕvpeBɑ΂ă`FbNsƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateDateRange31() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        Map<String, String> bean = new HashMap<String, String>();
        bean.put("field1", "2005/01/04");
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        field.setProperty("field1");
        Var var = new Var();
        var.setName("datePattern");
        var.setValue(null);
        field.addVar(var);
        var = new Var();
        var.setName("datePatternStrict");
        var.setValue("yyyy/MM/dd");
        field.addVar(var);
        var = new Var();
        var.setName("startDate");
        var.setValue("2005/01/01");
        field.addVar(var);
        var = new Var();
        var.setName("endDate");
        var.setValue("2005/01/03");
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setLocale(Locale.JAPANESE);
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateDateRange(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertFalse(result);
        // G[񂪐ݒ肳Ă邱ƁB
        assertEquals(1, errors.size());

        Iterator it = errors.get();
        ActionMessage message = (ActionMessage) it.next();
        assertEquals("message", message.getKey());
    }

    /**
     * testValidateDateRange32()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:Map:<br>
     *                ["field1"=<br>
     *                @"2005/01/05"]<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:datePattern=null<br>
     *                var:datePatternStrict="yyyy/MM/dd"<br>
     *                var:startDate="2005/01/01"<br>
     *                var:endDate="2005/01/03"<br>
     *                Msg("message","message")<br>
     *                property="field2"<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *                Locale=JAPANESE<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * beanString^ł͂ȂAfield擾ÕvpeB݂ȂꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateDateRange32() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        Map<String, String> bean = new HashMap<String, String>();
        bean.put("field1", "2005/01/05");
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        field.setProperty("field2");
        Var var = new Var();
        var.setName("datePattern");
        var.setValue(null);
        field.addVar(var);
        var = new Var();
        var.setName("datePatternStrict");
        var.setValue("yyyy/MM/dd");
        field.addVar(var);
        var = new Var();
        var.setName("startDate");
        var.setValue("2005/01/01");
        field.addVar(var);
        var = new Var();
        var.setName("endDate");
        var.setValue("2005/01/03");
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setLocale(Locale.JAPANESE);
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateDateRange(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());
    }

}
