/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.form;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import jp.terasoluna.utlib.DynaActionFormCreator;
import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.MockHttpSession;
import junit.framework.TestCase;

import org.apache.struts.Globals;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.config.FormBeanConfig;
import org.apache.struts.config.FormPropertyConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.impl.ModuleConfigImpl;

/**
 * {@link jp.terasoluna.fw.web.struts.form.ActionFormUtil} NX̃ubN{bNXeXgB
 *
 * <p>
 * <h4>yNX̊Tvz</h4>
 * ANVtH[֘Ã[eBeBNXB
 * <p>
 *
 * @see jp.terasoluna.fw.web.struts.form.ActionFormUtil
 */
public class ActionFormUtilTest extends TestCase {

    /**
     * ̃NX̃eXgŎgpDynaValidatorActionFormEx̐ݒt@CB
     */
    private static final String CONFIG_FILE_NAME =
        ActionFormUtil.class.getResource(
                "ActionFormUtilTest.xml").getPath();

    /**
     * DynaValidatorActionFormEx𐶐digester̃[t@CB
     */
    private final static String RULES_FILE_NAME =
        ActionFormUtil.class.getResource(
                "ActionFormUtilTest-rules.xml").getPath();

    /**
     * DynaValidatorActionFormEx𐶐NXB
     */
    private static final DynaActionFormCreator creator
        = new DynaActionFormCreator(RULES_FILE_NAME);

    /**
     * eXgɎgpDynaValidatorActionFormExCX^XB
     */
    private DynaValidatorActionFormEx formEx = null;

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     *
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(ActionFormUtilTest.class);
    }

    /**
     * sB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.formEx =
            (DynaValidatorActionFormEx) creator.create(CONFIG_FILE_NAME);
    }

    /**
     * IsB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     *
     * @param name ̃eXgP[X̖OB
     */
    public ActionFormUtilTest(String name) {
        super(name);
    }

    /**
     * testGetPropertyConfig01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() fieldName:null<br>
     *         () mapping:not null<br>
     *         () mapping.getName:"abc"<br>
     *         () config:not null<br>
     *                {FormPropertyConfig("aaa", "java.lang.String",null,0)}<br>
     *
     * <br>
     * ҒlF(߂l) ^:null<br>
     *
     * <br>
     * config.fingFormPropertyConfig(fieldName)̌ʂ擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetPropertyConfig01() throws Exception {
        //eXgf[^ݒ
        String fieldName = null;
        ActionMapping mapping = new ActionMapping();
        ModuleConfig moduleConfig = new ModuleConfigImpl("");
        FormBeanConfig fBConfig = creator.parse(CONFIG_FILE_NAME);
        mapping.setName("abc");
        mapping.setModuleConfig(moduleConfig);
        moduleConfig.addFormBeanConfig(fBConfig);

        //eXgs
        assertNull(ActionFormUtil.getPropertyConfig(fieldName, mapping));
    }

    /**
     * testGetPropertyConfig02()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FC,G
     * <br><br>
     * ͒lF() fieldName:not null<br>
     *         () mapping:null<br>
     *
     * <br>
     * ҒlF(߂l) ^:NullPointerException<br>
     *
     * <br>
     * mappingnull̏ꍇANullPointerException邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetPropertyConfig02() throws Exception {
        //eXgf[^ݒ
        //mappingnullݒ
        String fieldName = "hoge";
        ActionMapping mapping = new ActionMapping();
        mapping = null;

        try {
            //eXgs
            ActionFormUtil.getPropertyConfig(fieldName, mapping);
            fail();
        } catch (NullPointerException e) {
            //eXg
        }
    }

    /**
     * testGetPropertyConfig03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:not null<br>
     *         () mapping.getName:null<br>
     *
     * <br>
     * ҒlF(߂l) ^:null<br>
     *
     * <br>
     * mappingname擾łȂꍇAnull擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetPropertyConfig03() throws Exception {

        //eXgf[^ݒ
        String fieldName = "field1";
        ActionMapping mapping = new ActionMapping();
        mapping.setName(null);

        //eXgs
        //eXgʊmF
        assertNull(ActionFormUtil.getPropertyConfig(fieldName, mapping));
    }

    /**
     * testGetPropertyConfig04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:not null<br>
     *         () mapping.getName:"abc"<br>
     *         () config:null<br>
     *
     * <br>
     * ҒlF(߂l) ^:null<br>
     *
     * <br>
     * ModuleConfigFormBeanConfig擾łȂꍇAnull擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetPropertyConfig04() throws Exception {

        //eXgf[^ݒ
        String fieldName = "field1";
        ActionMapping mapping = new ActionMapping();
        ModuleConfig moduleConfig = new ModuleConfigImpl("");
        mapping.setName("abc");
        mapping.setModuleConfig(moduleConfig);

        //eXgs
        //eXgʊmF
        assertNull(ActionFormUtil.getPropertyConfig(fieldName, mapping));
    }

    /**
     * testGetPropertyConfig05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() fieldName:"aaa"<br>
     *         () mapping:not null<br>
     *         () mapping.getName:"abc"<br>
     *         () config:not null<br>
     *                {FormPropertyConfig("aaa", "java.lang.String",null,0)}<br>
     *
     * <br>
     * ҒlF(߂l) ^:{FormPropertyConfig(<br>
     *                  "aaa", <br>
     *                  "java.lang.String",<br>
     *                  null,0)}<br>
     *
     * <br>
     * config.fingFormPropertyConfig(fieldName)̌ʂ擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetPropertyConfig05() throws Exception {
        //eXgf[^ݒ
        String fieldName = "aaa";
        ActionMapping mapping = new ActionMapping();
        ModuleConfig moduleConfig = new ModuleConfigImpl("");
        FormBeanConfig fBConfig = creator.parse(CONFIG_FILE_NAME);
        mapping.setName("abc");
        mapping.setModuleConfig(moduleConfig);
        moduleConfig.addFormBeanConfig(fBConfig);

        //eXgs
        FormPropertyConfig result =
            ActionFormUtil.getPropertyConfig(fieldName, mapping);
        assertEquals("aaa", result.getName());
        assertEquals("java.lang.String", result.getType());
        assertEquals("null", result.getInitial());
        assertEquals(0, result.getSize());

    }

    /**
     * testGetPropertyConfig06()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() fieldName:""<br>
     *         () mapping:not null<br>
     *         () mapping.getName:"abc"<br>
     *         () config:not null<br>
     *                {FormPropertyConfig("aaa", "java.lang.String",null,0)}<br>
     *
     * <br>
     * ҒlF(߂l) ^:null<br>
     *
     * <br>
     * config.fingFormPropertyConfig(fieldName)̌ʂ擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetPropertyConfig06() throws Exception {
        //eXgf[^ݒ
        String fieldName = "";
        ActionMapping mapping = new ActionMapping();
        ModuleConfig moduleConfig = new ModuleConfigImpl("");
        FormBeanConfig fBConfig = creator.parse(CONFIG_FILE_NAME);
        mapping.setName("abc");
        mapping.setModuleConfig(moduleConfig);
        moduleConfig.addFormBeanConfig(fBConfig);

        //eXgs
        assertNull(ActionFormUtil.getPropertyConfig(fieldName, mapping));

    }

    /**
     * testInitialize01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() form:null<br>
     *
     * <br>
     * ҒlF
     * <br>
     * sȂ
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testInitialize01() throws Exception {
        //eXgf[^ݒ
        String fieldName = "hoge";
        // ANV}bsO
        ActionMapping mapping = new ActionMapping();
        mapping.setName("name");

        ActionFormUtil.initialize(null, fieldName, mapping);
    }

    /**
     * testInitialize02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() form:not null<br>
     *         () fileldName:null<br>
     *
     * <br>
     * ҒlF
     * <br>
     * sȂ
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testInitialize02() throws Exception {
        //eXgf[^ݒ
        // ANV}bsO
        ActionMapping mapping = new ActionMapping();
        mapping.setName("name");
        String fieldName = null;

        //eXgs
        //eXgʊmF
        //OɐI邱ƂmF
        ActionFormUtil.initialize(
                new DynaValidatorActionFormEx(), fieldName, mapping);
    }

    /**
     * testInitialize03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() form:not null<br>
     *         () fileldName:󕶎<br>
     *
     * <br>
     * ҒlF
     * <br>
     * sȂ
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testInitialize03() throws Exception {
        //eXgf[^ݒ
        // ANV}bsO
        ActionMapping mapping = new ActionMapping();
        mapping.setName("formName");
        String fieldName = "";

        //eXgs
        //eXgʊmF
        //OɐI邱ƂmF
        ActionFormUtil.initialize(
                new DynaValidatorActionFormEx(), fieldName, mapping);
    }

    /**
     * testInitialize04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() form:not null<br>
     *         () fileldName:not null<br>
     *         () mapping:null<br>
     *
     * <br>
     * ҒlF
     * <br>
     * sȂ
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testInitialize04() throws Exception {
        //eXgf[^ݒ
        String fieldName = "field2";

        //eXgs
        ActionFormUtil.initialize(
                new DynaValidatorActionFormEx(), fieldName, null);
    }

    /**
     * testInitialize05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() form:not null<br>
     *         () fileldName:not null<br>
     *         () mapping:not null<br>
     *         () config:null<br>
     *
     * <br>
     * ҒlF
     * <br>
     * sȂ
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testInitialize05() throws Exception {

        //eXgf[^ݒ
        String fieldName = "field2";
        ActionMapping mapping = new ActionMapping();
        ModuleConfig moduleConfig = new ModuleConfigImpl("");
        mapping.setName("abc");
        mapping.setModuleConfig(moduleConfig);

        //eXgs
        ActionFormUtil.initialize(
                new DynaValidatorActionFormEx(), fieldName, mapping);
    }

    /**
     * testInitialize06()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() form:not null<br>
     *                field="AAA"<br>
     *         () fileldName:"field"<br>
     *         () mapping:not null<br>
     *         () config:not null<br>
     *
     * <br>
     * ҒlF(ԕω) fieldNameŎw肵vpeBl:""<br>
     *
     * <br>
     * 2fieldNameŎw肵tB[hl邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testInitialize06() throws Exception {
        //eXgf[^ݒ
        String fieldName = "field";
        ActionMapping mapping = new ActionMapping();
        ModuleConfig moduleConfig = new ModuleConfigImpl("");
        FormBeanConfig fBConfig = creator.parse(CONFIG_FILE_NAME);
        mapping.setName("abc");
        mapping.setModuleConfig(moduleConfig);
        moduleConfig.addFormBeanConfig(fBConfig);
        formEx.set("field", "AAA");

        //eXgs
        ActionFormUtil.initialize(formEx, fieldName, mapping);
        assertEquals("", formEx.get("field"));

    }

    /**
     * testClearActionForm01()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FC,G
     * <br><br>
     * ͒lF() session:null<br>
     *         () exclude:_hoge<br>
     *
     * <br>
     * ҒlF(ԕω) O:NullPointerException<br>
     *
     * <br>
     * sessionnull̏ꍇANullPointerExcpetion邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testClearActionForm01() throws Exception {

        try {
            //eXgs
            ActionFormUtil.clearActionForm(null, "_hoge");
            fail();
        } catch (NullPointerException e) {
            //eXgʊmF
            // NullPointerExceptionX[ꂽꍇ̂݃eXgB
        }
    }

    /**
     * testClearActionForm02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() session:not null<br>
     *                {}<br>
     *         () exclude:_hoge<br>
     *
     * <br>
     * ҒlF
     * <br>
     * sessionɒli[ĂȂꍇ́Aԕω͋N炸AɏI邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testClearActionForm02() throws Exception {
        //eXgf[^ݒ
        // [ZbV
        HttpSession session = new MockHttpSession();

        //eXgs
        ActionFormUtil.clearActionForm(session, "_hoge");

        //eXgʊmF
        if ((session.getAttributeNames()).hasMoreElements()) {
            //vfĂꍇ̓eXgsB
            fail();
        }
    }

    /**
     * testClearActionForm03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() session:not null<br>
     *                {"hoge"= "value"}<br>
     *         () exclude:_hoge<br>
     *
     * <br>
     * ҒlF(ԕω) session:{"hoge"= "value"}<br>
     *
     * <br>
     * sessionActionFormCX^X܂܂ȂꍇAԕωȂƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testClearActionForm03() throws Exception {
        //eXgf[^ݒ
        // [ZbV
        HttpSession session = new MockHttpSession();
        String key = "hoge";
        Object value = "value";
        session.setAttribute(key, value);

        //eXgs
        ActionFormUtil.clearActionForm(session, "_hoge");

        //eXgʊmF
        assertEquals(value, session.getAttribute(key));
    }

    /**
     * testClearActionForm04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() session:not null<br>
     *                {"_hoge"= "value"}<br>
     *         () exclude:_hoge<br>
     *
     * <br>
     * ҒlF(ԕω) session:{"_hoge"="value"}<br>
     *
     * <br>
     * sessionActionFormCX^X܂܂ȂꍇAԕωȂƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testClearActionForm04() throws Exception {
        //eXgf[^ݒ
        // [ZbV
        HttpSession session = new MockHttpSession();
        String key = "_hoge";
        Object value = "value";
        session.setAttribute(key, value);

        //eXgs
        ActionFormUtil.clearActionForm(session, "_hoge");

        //eXgʊmF
        assertEquals(value, session.getAttribute(key));
    }

    /**
     * testClearActionForm05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() session:not null<br>
     *                {"hoge"=ActionFormCX^X}<br>
     *         () exclude:_hoge<br>
     *
     * <br>
     * ҒlF(ԕω) session:{"hoge"=ActionFormCX^X}<br>
     *
     * <br>
     * sessionActionForm܂܂A"_"n܂ȂꍇAԕωȂƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testClearActionForm05() throws Exception {
        //eXgf[^ݒ
        // [ZbV
        HttpSession session = new MockHttpSession();
        String key = "hoge";
        ActionFormUtil_ActionFormStub01 form =
            new ActionFormUtil_ActionFormStub01();
        session.setAttribute(key, form);

        //eXgs
        ActionFormUtil.clearActionForm(session, "_hoge");

        //eXgʊmF
        assertEquals(form, session.getAttribute(key));
    }

    /**
     * testClearActionForm06()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() session:not null<br>
     *                {"_hoge"=ActionFormCX^X}<br>
     *         () exclude:_hoge<br>
     *
     * <br>
     * ҒlF(ԕω) session:{"_hoge"=ActionFormCX^X}<br>
     *
     * <br>
     * sessionɑexcludeƈvActionForm܂܂ꍇAԕωȂƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testClearActionForm06() throws Exception {
        //eXgf[^ݒ
        // [ZbV
        HttpSession session = new MockHttpSession();
        String key = "_hoge";
        ActionFormUtil_ActionFormStub01 form =
            new ActionFormUtil_ActionFormStub01();
        session.setAttribute(key, form);

        //eXgs
        ActionFormUtil.clearActionForm(session, "_hoge");

        //eXgʊmF
        assertEquals(form, session.getAttribute(key));
    }

    /**
     * testClearActionForm07()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() session:not null<br>
     *                {"hoge"=ActionFormCX^X,<br>
     *                 "foo"=ActionFormCX^X,<br>
     *                 "world"=ActionFormCX^X}<br>
     *         () exclude:_hoge<br>
     *
     * <br>
     * ҒlF(ԕω) session:{"hoge"=ActionFormCX^X,<br>
     *                     "foo"=ActionFormCX^X,<br>
     *                     "world"=ActionFormCX^X}<br>
     *
     * <br>
     * sessionɑ"_"n܂ȂActionFormݒ肳ĂꍇAԕωȂƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testClearActionForm07() throws Exception {
        //eXgf[^ݒ
        // [ZbV
        HttpSession session = new MockHttpSession();
        String key1 = "hoge";
        String key2 = "foo";
        String key3 = "world";
        ActionFormUtil_ActionFormStub01 form1 =
            new ActionFormUtil_ActionFormStub01();
        ActionFormUtil_ActionFormStub01 form2 =
            new ActionFormUtil_ActionFormStub01();
        ActionFormUtil_ActionFormStub01 form3 =
            new ActionFormUtil_ActionFormStub01();
        session.setAttribute(key1, form1);
        session.setAttribute(key2, form2);
        session.setAttribute(key3, form3);

        //eXgs
        ActionFormUtil.clearActionForm(session, "_hoge");

        //eXgʊmF
        assertEquals(form1, session.getAttribute(key1));
        assertEquals(form2, session.getAttribute(key2));
        assertEquals(form3, session.getAttribute(key3));
    }

    /**
     * testClearActionForm08()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() session:not null<br>
     *                {"_hoge"=ActionFormCX^X,<br>
     *                 "foo"=ActionFormCX^X,<br>
     *                 "world"=ActionFormCX^X}<br>
     *         () exclude:_hoge<br>
     *
     * <br>
     * ҒlF(ԕω) session:{"_hoge"=ActionFormCX^X,<br>
     *                     "foo"=ActionFormCX^X,<br>
     *                     "world"=ActionFormCX^X}<br>
     *
     * <br>
     * sessionɑexcludeƈvActionForm܂ޕActionForm(AȂ͑"_"n܂Ȃ)݂ꍇAԕωȂƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testClearActionForm08() throws Exception {
        //eXgf[^ݒ
        // [ZbV
        HttpSession session = new MockHttpSession();
        String key1 = "_hoge";
        String key2 = "foo";
        String key3 = "world";
        ActionFormUtil_ActionFormStub01 form1 =
            new ActionFormUtil_ActionFormStub01();
        ActionFormUtil_ActionFormStub01 form2 =
            new ActionFormUtil_ActionFormStub01();
        ActionFormUtil_ActionFormStub01 form3 =
            new ActionFormUtil_ActionFormStub01();
        session.setAttribute(key1, form1);
        session.setAttribute(key2, form2);
        session.setAttribute(key3, form3);

        //eXgs
        ActionFormUtil.clearActionForm(session, "_hoge");

        //eXgʊmF
        assertEquals(form1, session.getAttribute(key1));
        assertEquals(form2, session.getAttribute(key2));
        assertEquals(form3, session.getAttribute(key3));
    }

    /**
     * testClearActionForm09()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() session:not null<br>
     *                {"_hoge"=ActionFormCX^X,<br>
     *                 "_foo"=ActionFormCX^X,<br>
     *                 "_world"=ActionFormCX^X}<br>
     *         () exclude:_hoge<br>
     *
     * <br>
     * ҒlF(ԕω) session:{"_hoge"=ActionFormCX^X}<br>
     *
     * <br>
     * sessionɑ"_"n܂镡ActionForm݂ꍇAexcludeŎw肵lƈvActionForm݂ꍇAexcludeŎw肵ȊOActionForm폜邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testClearActionForm09() throws Exception {
        //eXgf[^ݒ
        // [ZbV
        HttpSession session = new MockHttpSession();
        String key1 = "_hoge";
        String key2 = "_foo";
        String key3 = "_world";
        ActionFormUtil_ActionFormStub01 form1 =
            new ActionFormUtil_ActionFormStub01();
        ActionFormUtil_ActionFormStub01 form2 =
            new ActionFormUtil_ActionFormStub01();
        ActionFormUtil_ActionFormStub01 form3 =
            new ActionFormUtil_ActionFormStub01();
        session.setAttribute(key1, form1);
        session.setAttribute(key2, form2);
        session.setAttribute(key3, form3);

        //eXgs
        ActionFormUtil.clearActionForm(session, "_hoge");

        //eXgʊmF
        assertEquals(form1, session.getAttribute(key1));
        assertNull(session.getAttribute(key2));
        assertNull(session.getAttribute(key3));
    }

    /**
     * testClearActionForm10()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() session:not null<br>
     *                {"_hoge"=ActionFormCX^X,<br>
     *                 "_foo"=ActionFormCX^X,<br>
     *                 "_world"=ActionFormCX^X}<br>
     *         () exclude:null<br>
     *
     * <br>
     * ҒlF(ԕω) session:{}<br>
     *
     * <br>
     * sessionɑ"_"n܂镡ActionForm݂ꍇAexcludenull̏ꍇASĂActionForm폜邱ƂmFB<br>
     * clearActionFrom(HttpSession)̃eXgP[X܂
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testClearActionForm10() throws Exception {
        //eXgf[^ݒ
        // [ZbV
        HttpSession session = new MockHttpSession();
        String key1 = "_hoge";
        String key2 = "_foo";
        String key3 = "_world";
        ActionFormUtil_ActionFormStub01 form1 =
            new ActionFormUtil_ActionFormStub01();
        ActionFormUtil_ActionFormStub01 form2 =
            new ActionFormUtil_ActionFormStub01();
        ActionFormUtil_ActionFormStub01 form3 =
            new ActionFormUtil_ActionFormStub01();
        session.setAttribute(key1, form1);
        session.setAttribute(key2, form2);
        session.setAttribute(key3, form3);

        //eXgs
        ActionFormUtil.clearActionForm(session, null);

        //eXgʊmF
        assertNull(session.getAttribute(key1));
        assertNull(session.getAttribute(key2));
        assertNull(session.getAttribute(key3));
    }

    /**
     * testGetActionFormName01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC,G
     * <br><br>
     * ͒lF() req:null<br>
     *
     * <br>
     * ҒlF(ԕω) O:NullPointerException<br>
     *
     * <br>
     * reqnull̏ꍇANullPointerException邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetActionFormName01() throws Exception {

        try {
            //eXgs
            ActionFormUtil.getActionFormName(null);
            fail();
        } catch (NullPointerException e) {
            //eXgʊmF
            // NullPointerExceptionX[ꂽꍇ̂݃eXgB
        }
    }

    /**
     * testGetActionFormName02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() req:not null<br>
     *         () req.getAttribute(Globals.MAPPING_KEY):null<br>
     *
     * <br>
     * ҒlF(߂l) String:null<br>
     *
     * <br>
     * NGXgActionMappingCX^X擾łȂꍇAnull擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetActionFormName02() throws Exception {
        //eXgf[^ݒ
        // [NGXg
        HttpServletRequest req = new MockHttpServletRequest();
        req.setAttribute("key", "value");

        //eXgs
        //eXgʊmF
        assertNull(ActionFormUtil.getActionFormName(req));    }

    /**
     * testGetActionFormName03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() req:not null<br>
     *         () req.getAttribute(Globals.MAPPING_KEY):not null<br>
     *                name="abc"<br>
     *
     * <br>
     * ҒlF(߂l) String:"abc"<br>
     *
     * <br>
     * AcionMappingname̒l擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetActionFormName03() throws Exception {
        //eXgf[^ݒ
        // [NGXg
        HttpServletRequest req = new MockHttpServletRequest();

        // ANV}bsO
        ActionMapping mapping = new ActionMapping();
        mapping.setName("name");

        req.setAttribute(Globals.MAPPING_KEY, mapping);

        //eXgs
        //eXgʊmF
        assertEquals("name", ActionFormUtil.getActionFormName(req));
    }

}
