/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.taglib;

import java.io.IOException;

import javax.servlet.ServletContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;

import jp.terasoluna.fw.web.codelist.CodeBean;
import jp.terasoluna.fw.web.codelist.CodeListLoader;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/**
 * writeCodeCount ^O̎NXB
 *
 * <p>
 * R[hXg̃TCYԋpB<br>
 * ƂāAT[ubgReLXg
 * iidjŎw肳ꂽ CodeListLoader ToA
 * ̒ɕۑĂR[hXg擾ÃTCYԋpB
 * ȂꍇATCY 0 ԋpB
 * </p>
 *
 * <strong>^OT|[g鑮</strong><br>
 * <p> writeCodeCount ^Oł́Aȉ̑T|[gB</p>
 * <p>
 * <div align="center">
 * <table width="90%" border="1" bgcolor="#FFFFFF">
 *  <tr>
 *   <td> <b></b> </td>
 *   <td> <b>ftHgl</b> </td>
 *   <td> <b>K{</b> </td>
 *   <td> <b>s</b> </td>
 *   <td> <b>Tv</b> </td>
 *  </tr>
 *  <tr>
 *   <td> <code>id</code> </td>
 *   <td> <code>-</code> </td>
 *   <td> <code>true</code> </td>
 *   <td> <code>true</code> </td>
 *   <td align="left">
 *    ̑R[hXgR[hXg[_[B܂
 *    {@link jp.terasoluna.fw.web.codelist.CodeListLoader}
 *     bean ̖Ow肷B
 *    R[hXgȂꍇA0ԋpB
 *   </td>
 *  </tr>
 * </table>
 * </div>
 * </p>
 * <strong>JX^^ÕXNveBOϐ</strong><br>
 * <p>̃^OɂĐݒ肳XNveBOϐ͂܂B</p>
 * <br>
 * <strong>gp@</strong><br>
 * ȉ̗́ACodeListLoader C^tF[XNX bean 
 * &quot;loader1&quot; ƌOŒ`Ďgpꍇ̐ݒłB<br>
 * `̕@
 * {@link jp.terasoluna.fw.web.codelist.DBCodeListLoader}A
 * y
 * {@link jp.terasoluna.fw.web.codelist.MappedCodeListLoader}
 * QƁB
 * </p>
 *
 * <strong>JSPł̋LqB</strong><br>
 * <p>
 * <code><pre>
 *  c
 *  &lt;ts:writeCodeCount id=<Strong>"loader1"</Strong> /&gt;
 *  c
 * </pre></code>
 * R[hXg̎擾ɊւẮA{@link DefineCodeListTag} QƁB<br>
 *
 * </p>
 *
 * @see jp.terasoluna.fw.web.codelist.DBCodeListLoader
 * @see jp.terasoluna.fw.web.codelist.MappedCodeListLoader
 * @see jp.terasoluna.fw.web.taglib.DefineCodeListTag
 *
 */
public class WriteCodeCountTag extends TagSupport {

    /**
	 * VAo[WID
	 */
	private static final long serialVersionUID = -2318799214314166540L;

	/**
     * ONXB
     */
     private static Log log =
         LogFactory.getLog(WriteCodeCountTag.class);

    /**
     * ^O]JnɌĂ΂郁\bhB
     *
     * <p>
     *   T[ubgReLXgR[hXg[_[
     * AR[hXg𔭌ꍇAR[hXg̗vf
     * ԋpB
     * R[hXgłȂꍇA0ʂɏ܂B
     * </p>
     *
     * @return wB <code>EVAL_BODY_INCLUDE</code>
     * @throws JspException <code>JSP</code>O
     */
    @Override
    public int doStartTag() throws JspException {
        if (log.isDebugEnabled()) {
            log.debug("doStartTag() called.");
        }

        JspWriter out = pageContext.getOut();

        try {
            if ("".equals(id)) {
                // id݂Ȃꍇ
                log.error("id is required.");
                throw new JspTagException("id is required.");
            }

            // pageContextAApplicationContext擾B
            ServletContext sc = pageContext.getServletContext();
            ApplicationContext context =
                WebApplicationContextUtils.getRequiredWebApplicationContext(sc);

            CodeListLoader loader = null;

            try {
                loader = (CodeListLoader) context.getBean(id);
            } catch (ClassCastException e) {
                //擾BeanCodeListLoaderł͂ȂOX[
                String errorMessage = "bean id:" + id
                    + " is not instance of CodeListLoader.";
                log.error(errorMessage);
                throw new JspTagException(errorMessage, e);
            }

            CodeBean[] codeBeanList = loader.getCodeBeans();
            if (codeBeanList == null) {
                // codeBeanListnull̏ꍇ0o͂B
                if (log.isWarnEnabled()) {
                    log.warn("Codebean is null. CodeListLoader(bean id:"
                            + id + ")");
                }
                out.print(0);
            } else {
                // Ɏ擾łꍇ̓R[hXg̒o͂B
                out.print(codeBeanList.length);
            }

            return EVAL_BODY_INCLUDE;
        } catch (IOException ioe) {
            log.error("IOException caused.");
            throw new JspTagException(ioe.toString());
        }
    }

    /**
     * ^O]IɌĂ΂郁\bhB
     *
     * @return wB EVAL_PAGE
     * @throws JspException  JSP O
     */
    @Override
    public int doEndTag() throws JspException {
        return EVAL_PAGE;
    }

    /**
     * ^Onh̏B
     */
    @Override
    public void release() {
        super.release();
    }

}
