/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.rich.context;

import jp.terasoluna.fw.web.rich.context.RequestContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RequestContextManager {
    private static Log logger = LogFactory.getLog(RequestContextManager.class);
    private static ThreadLocal<RequestContext> resources = new ThreadLocal();

    public static RequestContext getRequestContext() {
        RequestContext ctx = resources.get();
        if (ctx == null) {
            logger.error((Object)"No RequestContext bound to thread!");
            throw new IllegalStateException("No RequestContext  bound to thread [" + Thread.currentThread().getName() + "]");
        }
        return ctx;
    }

    public static boolean hasRequestContext() {
        return resources.get() != null;
    }

    public static void bindRequestContext(RequestContext ctx) {
        if (ctx == null) {
            logger.error((Object)"RequestContext cannot set null.");
            throw new IllegalArgumentException("RequestContext cannot set null.");
        }
        RequestContext alreadyBoundCtx = resources.get();
        if (alreadyBoundCtx == null) {
            resources.set(ctx);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Bound RequestContext [" + ctx + "] to thread [" + Thread.currentThread().getName() + "]"));
            }
        } else {
            logger.error((Object)"Already RequestContext bound to thread!");
            throw new IllegalStateException("Already RequestContext [" + alreadyBoundCtx + "]" + "   [" + Thread.currentThread().getName() + "]");
        }
    }

    public static void unbindRequestContext() {
        RequestContext ctx = resources.get();
        if (ctx == null) {
            logger.error((Object)"No RequestContext bound to thread!");
            throw new IllegalStateException("No RequestContext  bound to thread [" + Thread.currentThread().getName() + "]");
        }
        resources.remove();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Removed RequestContext [" + ctx + "] from thread [" + Thread.currentThread().getName() + "]"));
        }
    }
}

