/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.commonj.transaction;

import jp.terasoluna.fw.batch.commonj.transaction.JobResultInfoHandler;
import jp.terasoluna.fw.batch.jobmessage.JobMessageInfo;
import jp.terasoluna.fw.dao.UpdateDAO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;

public class JobResultInfoHandlerImpl
implements JobResultInfoHandler {
    private static Log log = LogFactory.getLog(JobResultInfoHandlerImpl.class);
    private UpdateDAO updateDAO = null;
    private PlatformTransactionManager transactionManager = null;
    private static final String INSERT_JOB_RESULT = "jobResult.INSERT_JOB_RESULT";

    public int handle(JobMessageInfo jobMessageInfo) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Job Result Handler [regist] transaction start...");
        }
        int count = 0;
        TransactionStatus transactionStatus = this.transactionManager.getTransaction(null);
        try {
            count = this.updateDAO.execute(INSERT_JOB_RESULT, (Object)jobMessageInfo);
            if (!transactionStatus.isCompleted()) {
                this.transactionManager.commit(transactionStatus);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Job Result Handler [regist] transaction commit.");
                }
            }
        }
        catch (UncategorizedSQLException e) {
            if (!transactionStatus.isCompleted()) {
                this.transactionManager.rollback(transactionStatus);
            }
            log.error((Object)e.getMessage());
        }
        return count;
    }

    public void setUpdateDAO(UpdateDAO updateDAO) {
        this.updateDAO = updateDAO;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }
}

