/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.config;

import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.transaction.config.TxNamespaceUtils;
import org.springframework.transaction.interceptor.NoRollbackRuleAttribute;
import org.springframework.transaction.interceptor.RollbackRuleAttribute;
import org.springframework.transaction.interceptor.RuleBasedTransactionAttribute;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class TxAdviceBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final String ATTRIBUTES = "attributes";
    private static final String TIMEOUT = "timeout";
    private static final String READ_ONLY = "read-only";
    private static final String NAME_MAP = "nameMap";
    private static final String PROPAGATION = "propagation";
    private static final String ISOLATION = "isolation";
    private static final String ROLLBACK_FOR = "rollback-for";
    private static final String NO_ROLLBACK_FOR = "no-rollback-for";
    static /* synthetic */ Class class$org$springframework$transaction$interceptor$TransactionInterceptor;
    static /* synthetic */ Class class$org$springframework$transaction$interceptor$NameMatchTransactionAttributeSource;

    TxAdviceBeanDefinitionParser() {
    }

    protected Class getBeanClass(Element element) {
        return class$org$springframework$transaction$interceptor$TransactionInterceptor == null ? (class$org$springframework$transaction$interceptor$TransactionInterceptor = TxAdviceBeanDefinitionParser.class$("org.springframework.transaction.interceptor.TransactionInterceptor")) : class$org$springframework$transaction$interceptor$TransactionInterceptor;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        builder.addPropertyReference(TxNamespaceUtils.TRANSACTION_MANAGER_PROPERTY, element.getAttribute("transaction-manager"));
        List txAttributes = DomUtils.getChildElementsByTagName(element, ATTRIBUTES);
        if (txAttributes.size() > 1) {
            parserContext.getReaderContext().error("Element <attributes> is allowed at most once inside element <advice>", element);
        } else if (txAttributes.size() == 1) {
            Element attributeSourceElement = (Element)txAttributes.get(0);
            RootBeanDefinition attributeSourceDefinition = this.parseAttributeSource(attributeSourceElement, parserContext);
            builder.addPropertyValue("transactionAttributeSource", attributeSourceDefinition);
        } else {
            Class sourceClass = TxNamespaceUtils.getAnnotationTransactionAttributeSourceClass();
            builder.addPropertyValue("transactionAttributeSource", new RootBeanDefinition(sourceClass));
        }
    }

    private RootBeanDefinition parseAttributeSource(Element attrEle, ParserContext parserContext) {
        List methods = DomUtils.getChildElementsByTagName(attrEle, "method");
        ManagedMap transactionAttributeMap = new ManagedMap(methods.size());
        transactionAttributeMap.setSource(parserContext.extractSource(attrEle));
        for (int i = 0; i < methods.size(); ++i) {
            Element methodEle = (Element)methods.get(i);
            String name = methodEle.getAttribute("name");
            TypedStringValue nameHolder = new TypedStringValue(name);
            nameHolder.setSource(parserContext.extractSource(methodEle));
            RuleBasedTransactionAttribute attribute = new RuleBasedTransactionAttribute();
            String propagation = methodEle.getAttribute(PROPAGATION);
            String isolation = methodEle.getAttribute(ISOLATION);
            String timeout = methodEle.getAttribute(TIMEOUT);
            String readOnly = methodEle.getAttribute(READ_ONLY);
            if (StringUtils.hasText(propagation)) {
                attribute.setPropagationBehaviorName("PROPAGATION_" + propagation);
            }
            if (StringUtils.hasText(isolation)) {
                attribute.setIsolationLevelName("ISOLATION_" + isolation);
            }
            if (StringUtils.hasText(timeout)) {
                try {
                    attribute.setTimeout(Integer.parseInt(timeout));
                }
                catch (NumberFormatException ex) {
                    parserContext.getReaderContext().error("Timeout must be an integer value: [" + timeout + "]", methodEle);
                }
            }
            if (StringUtils.hasText(readOnly)) {
                attribute.setReadOnly(Boolean.valueOf(methodEle.getAttribute(READ_ONLY)));
            }
            LinkedList rollbackRules = new LinkedList();
            if (methodEle.hasAttribute(ROLLBACK_FOR)) {
                String rollbackForValue = methodEle.getAttribute(ROLLBACK_FOR);
                this.addRollbackRuleAttributesTo(rollbackRules, rollbackForValue);
            }
            if (methodEle.hasAttribute(NO_ROLLBACK_FOR)) {
                String noRollbackForValue = methodEle.getAttribute(NO_ROLLBACK_FOR);
                this.addNoRollbackRuleAttributesTo(rollbackRules, noRollbackForValue);
            }
            attribute.setRollbackRules(rollbackRules);
            transactionAttributeMap.put(nameHolder, attribute);
        }
        RootBeanDefinition attributeSourceDefinition = new RootBeanDefinition(class$org$springframework$transaction$interceptor$NameMatchTransactionAttributeSource == null ? (class$org$springframework$transaction$interceptor$NameMatchTransactionAttributeSource = TxAdviceBeanDefinitionParser.class$("org.springframework.transaction.interceptor.NameMatchTransactionAttributeSource")) : class$org$springframework$transaction$interceptor$NameMatchTransactionAttributeSource);
        attributeSourceDefinition.setSource(parserContext.extractSource(attrEle));
        attributeSourceDefinition.getPropertyValues().addPropertyValue(NAME_MAP, transactionAttributeMap);
        return attributeSourceDefinition;
    }

    private void addRollbackRuleAttributesTo(List rollbackRules, String rollbackForValue) {
        String[] exceptionTypeNames = StringUtils.commaDelimitedListToStringArray(rollbackForValue);
        for (int i = 0; i < exceptionTypeNames.length; ++i) {
            rollbackRules.add(new RollbackRuleAttribute(StringUtils.trimWhitespace(exceptionTypeNames[i])));
        }
    }

    private void addNoRollbackRuleAttributesTo(List rollbackRules, String noRollbackForValue) {
        String[] exceptionTypeNames = StringUtils.commaDelimitedListToStringArray(noRollbackForValue);
        for (int i = 0; i < exceptionTypeNames.length; ++i) {
            rollbackRules.add(new NoRollbackRuleAttribute(StringUtils.trimWhitespace(exceptionTypeNames[i])));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

