/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.dao.support;

import java.util.Collection;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.dao.TypeMismatchDataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.NumberUtils;

public abstract class DataAccessUtils {
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Number;

    public static Object singleResult(Collection results) throws IncorrectResultSizeDataAccessException {
        int size;
        int n = size = results != null ? results.size() : 0;
        if (size == 0) {
            return null;
        }
        if (results.size() > 1) {
            throw new IncorrectResultSizeDataAccessException(1, size);
        }
        return results.iterator().next();
    }

    public static Object requiredSingleResult(Collection results) throws IncorrectResultSizeDataAccessException {
        int size;
        int n = size = results != null ? results.size() : 0;
        if (size == 0) {
            throw new EmptyResultDataAccessException(1);
        }
        if (results.size() > 1) {
            throw new IncorrectResultSizeDataAccessException(1, size);
        }
        return results.iterator().next();
    }

    public static Object uniqueResult(Collection results) throws IncorrectResultSizeDataAccessException {
        int size;
        int n = size = results != null ? results.size() : 0;
        if (size == 0) {
            return null;
        }
        if (!CollectionUtils.hasUniqueObject(results)) {
            throw new IncorrectResultSizeDataAccessException(1, size);
        }
        return results.iterator().next();
    }

    public static Object requiredUniqueResult(Collection results) throws IncorrectResultSizeDataAccessException {
        int size;
        int n = size = results != null ? results.size() : 0;
        if (size == 0) {
            throw new EmptyResultDataAccessException(1);
        }
        if (!CollectionUtils.hasUniqueObject(results)) {
            throw new IncorrectResultSizeDataAccessException(1, size);
        }
        return results.iterator().next();
    }

    public static Object objectResult(Collection results, Class requiredType) throws IncorrectResultSizeDataAccessException, TypeMismatchDataAccessException {
        Object result = DataAccessUtils.requiredUniqueResult(results);
        if (requiredType != null && !requiredType.isInstance(result)) {
            if ((class$java$lang$String == null ? (class$java$lang$String = DataAccessUtils.class$("java.lang.String")) : class$java$lang$String).equals(requiredType)) {
                result = result.toString();
            } else if ((class$java$lang$Number == null ? (class$java$lang$Number = DataAccessUtils.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(requiredType) && (class$java$lang$Number == null ? (class$java$lang$Number = DataAccessUtils.class$("java.lang.Number")) : class$java$lang$Number).isInstance(result)) {
                try {
                    result = NumberUtils.convertNumberToTargetClass((Number)result, requiredType);
                }
                catch (IllegalArgumentException ex) {
                    throw new TypeMismatchDataAccessException(ex.getMessage());
                }
            } else {
                throw new TypeMismatchDataAccessException("Result object is of type [" + result.getClass().getName() + "] and could not be converted to required type [" + requiredType.getName() + "]");
            }
        }
        return result;
    }

    public static int intResult(Collection results) throws IncorrectResultSizeDataAccessException, TypeMismatchDataAccessException {
        return ((Number)DataAccessUtils.objectResult(results, class$java$lang$Number == null ? (class$java$lang$Number = DataAccessUtils.class$("java.lang.Number")) : class$java$lang$Number)).intValue();
    }

    public static long longResult(Collection results) throws IncorrectResultSizeDataAccessException, TypeMismatchDataAccessException {
        return ((Number)DataAccessUtils.objectResult(results, class$java$lang$Number == null ? (class$java$lang$Number = DataAccessUtils.class$("java.lang.Number")) : class$java$lang$Number)).longValue();
    }

    public static RuntimeException translateIfNecessary(RuntimeException rawException, PersistenceExceptionTranslator pet) {
        Assert.notNull(pet, "PersistenceExceptionTranslator must not be null");
        DataAccessException dex = pet.translateExceptionIfPossible(rawException);
        return dex != null ? dex : rawException;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

