/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.rich.springmvc.controller;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.terasoluna.fw.util.ClassUtil;
import jp.terasoluna.fw.web.rich.context.support.RequestContextSupport;
import jp.terasoluna.fw.web.rich.springmvc.bind.creator.ServletRequestDataBinderCreator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.validation.BindException;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractCommandController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TerasolunaController<P, R>
extends AbstractCommandController
implements InitializingBean {
    protected Class parameterizedControllerClass = TerasolunaController.class;
    private static Log log = LogFactory.getLog(TerasolunaController.class);
    protected RequestContextSupport ctxSupport = null;
    protected ServletRequestDataBinderCreator dataBinderCreator = null;
    protected String viewName = null;
    protected boolean useRequestNameView = false;

    public void setCtxSupport(RequestContextSupport ctxSupport) {
        this.ctxSupport = ctxSupport;
    }

    public void setDataBinderCreator(ServletRequestDataBinderCreator dataBinderCreator) {
        this.dataBinderCreator = dataBinderCreator;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public void setUseRequestNameView(boolean useRequestNameView) {
        this.useRequestNameView = useRequestNameView;
    }

    public void afterPropertiesSet() {
        if (this.dataBinderCreator == null) {
            log.error((Object)"DataBinderCreator is Null.");
            throw new IllegalStateException("DataBinderCreator is Null.");
        }
        if (this.ctxSupport == null) {
            log.error((Object)"ContextSupport is Null.");
            throw new IllegalStateException("ContextSupport is Null.");
        }
    }

    protected Object getCommand(HttpServletRequest request) throws Exception {
        Type commandType = this.getCommandType();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating new command of class [" + ((Class)commandType).getName() + "]"));
        }
        if (commandType == Object.class) {
            String message = "Cannot get Command type. Controller cannot specify the Object type for parameterized type P.";
            log.error((Object)message);
            throw new IllegalStateException(message);
        }
        try {
            return ClassUtil.create(((Class)commandType).getName());
        }
        catch (Exception e) {
            log.error((Object)"Invalid Command type.", (Throwable)e);
            throw new IllegalStateException("Invalid Command type.");
        }
    }

    protected Type getCommandType() {
        Class<?> childClass = ((Object)((Object)this)).getClass();
        while (childClass.getSuperclass() != this.parameterizedControllerClass) {
            childClass = childClass.getSuperclass();
        }
        Type terasolunaControllerType = childClass.getGenericSuperclass();
        if (!(terasolunaControllerType instanceof ParameterizedType)) {
            log.error((Object)"Controller class must be set ParameterizedType");
            throw new IllegalStateException("Controller class must be set ParameterizedType");
        }
        ParameterizedType pt = (ParameterizedType)terasolunaControllerType;
        return pt.getActualTypeArguments()[0];
    }

    protected ServletRequestDataBinder createBinder(HttpServletRequest request, Object command) throws Exception {
        ServletRequestDataBinder binder = this.dataBinderCreator.create(request, command, this.ctxSupport.getRequestName());
        if (binder == null) {
            log.error((Object)"DataBinder is Null.");
            throw new IllegalStateException("DataBinder is Null.");
        }
        if (this.getMessageCodesResolver() != null) {
            binder.setMessageCodesResolver(this.getMessageCodesResolver());
        }
        if (this.getBindingErrorProcessor() != null) {
            binder.setBindingErrorProcessor(this.getBindingErrorProcessor());
        }
        if (this.getPropertyEditorRegistrars() != null) {
            for (int i = 0; i < this.getPropertyEditorRegistrars().length; ++i) {
                this.getPropertyEditorRegistrars()[i].registerCustomEditors((PropertyEditorRegistry)binder);
            }
        }
        this.initBinder(request, binder);
        return binder;
    }

    protected void onBind(HttpServletRequest request, Object command, BindException errors) throws Exception {
        if (errors.hasErrors()) {
            throw errors;
        }
    }

    protected void onBindAndValidate(HttpServletRequest request, Object command, BindException errors) throws Exception {
        if (errors.hasErrors()) {
            throw errors;
        }
    }

    protected ModelAndView handle(HttpServletRequest request, HttpServletResponse response, Object command, BindException errors) throws Exception {
        R model = this.executeService(request, response, command);
        if (this.viewName != null) {
            return new ModelAndView(this.viewName, "ret", model);
        }
        if (this.useRequestNameView) {
            return new ModelAndView("/" + this.ctxSupport.getRequestName(), "ret", model);
        }
        return new ModelAndView("", "ret", model);
    }

    protected R executeService(HttpServletRequest request, HttpServletResponse response, P command) throws Exception {
        this.preService(request, response, command);
        R model = this.executeService(command);
        this.postService(request, response, command, model);
        return model;
    }

    protected void postService(HttpServletRequest request, HttpServletResponse response, P command, R modelAndView) throws Exception {
    }

    protected void preService(HttpServletRequest request, HttpServletResponse response, P command) throws Exception {
    }

    protected abstract R executeService(P var1) throws Exception;
}

