/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.jpa;

import java.lang.instrument.ClassFileTransformer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import junit.framework.TestCase;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.instrument.classloading.LoadTimeWeaver;
import org.springframework.instrument.classloading.ResourceOverridingShadowingClassLoader;
import org.springframework.instrument.classloading.ShadowingClassLoader;
import org.springframework.orm.jpa.ExtendedEntityManagerCreator;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.SharedEntityManagerCreator;
import org.springframework.orm.jpa.persistenceunit.DefaultPersistenceUnitManager;
import org.springframework.test.annotation.AbstractAnnotationAwareTransactionalTests;
import org.springframework.test.jpa.OrmXmlOverridingShadowingClassLoader;
import org.springframework.util.StringUtils;

public abstract class AbstractJpaTests
extends AbstractAnnotationAwareTransactionalTests {
    private static final String DEFAULT_ORM_XML_LOCATION = "META-INF/orm.xml";
    private static Map<String, Object> contextCache = new HashMap<String, Object>();
    private static Map<String, ClassLoader> classLoaderCache = new HashMap<String, ClassLoader>();
    protected EntityManagerFactory entityManagerFactory;
    private Object shadowParent;
    protected EntityManager sharedEntityManager;

    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
        this.sharedEntityManager = SharedEntityManagerCreator.createSharedEntityManager((EntityManagerFactory)this.entityManagerFactory);
    }

    protected EntityManager createContainerManagedEntityManager() {
        return ExtendedEntityManagerCreator.createContainerManagedEntityManager((EntityManagerFactory)this.entityManagerFactory);
    }

    protected boolean shouldUseShadowLoader() {
        return true;
    }

    public void setDirty() {
        super.setDirty();
        contextCache.remove(this.cacheKeys());
        classLoaderCache.remove(this.cacheKeys());
        if (this.shadowParent != null) {
            try {
                Method m = this.shadowParent.getClass().getMethod("setDirty", null);
                m.invoke(this.shadowParent, (Object[])null);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public void runBare() throws Throwable {
        if (!this.shouldUseShadowLoader()) {
            super.runBare();
            return;
        }
        String combinationOfContextLocationsForThisTestClass = this.cacheKeys();
        ClassLoader classLoaderForThisTestClass = ((Object)((Object)this)).getClass().getClassLoader();
        ClassLoader initialClassLoader = Thread.currentThread().getContextClassLoader();
        if (this.shadowParent != null) {
            Thread.currentThread().setContextClassLoader(classLoaderForThisTestClass);
            super.runBare();
        } else {
            ShadowingClassLoader shadowingClassLoader = (ShadowingClassLoader)classLoaderCache.get(combinationOfContextLocationsForThisTestClass);
            if (shadowingClassLoader == null) {
                shadowingClassLoader = (ShadowingClassLoader)this.createShadowingClassLoader(classLoaderForThisTestClass);
                classLoaderCache.put(combinationOfContextLocationsForThisTestClass, (ClassLoader)shadowingClassLoader);
            }
            try {
                Thread.currentThread().setContextClassLoader((ClassLoader)shadowingClassLoader);
                String[] configLocations = this.getConfigLocations();
                Object cachedContext = contextCache.get(combinationOfContextLocationsForThisTestClass);
                if (cachedContext == null) {
                    Class shadowingLoadTimeWeaverClass = shadowingClassLoader.loadClass(ShadowingLoadTimeWeaver.class.getName());
                    Constructor constructor = shadowingLoadTimeWeaverClass.getConstructor(ClassLoader.class);
                    constructor.setAccessible(true);
                    Object ltw = constructor.newInstance(shadowingClassLoader);
                    Class beanFactoryClass = shadowingClassLoader.loadClass(DefaultListableBeanFactory.class.getName());
                    Object beanFactory = BeanUtils.instantiateClass((Class)beanFactoryClass);
                    Class beanDefinitionReaderClass = shadowingClassLoader.loadClass(XmlBeanDefinitionReader.class.getName());
                    Class beanDefinitionRegistryClass = shadowingClassLoader.loadClass(BeanDefinitionRegistry.class.getName());
                    Object reader = beanDefinitionReaderClass.getConstructor(beanDefinitionRegistryClass).newInstance(beanFactory);
                    Method loadBeanDefinitions = beanDefinitionReaderClass.getMethod("loadBeanDefinitions", String[].class);
                    loadBeanDefinitions.invoke(reader, new Object[]{configLocations});
                    Class loadTimeWeaverInjectingBeanPostProcessorClass = shadowingClassLoader.loadClass(LoadTimeWeaverInjectingBeanPostProcessor.class.getName());
                    Class loadTimeWeaverClass = shadowingClassLoader.loadClass(LoadTimeWeaver.class.getName());
                    Constructor bppConstructor = loadTimeWeaverInjectingBeanPostProcessorClass.getConstructor(loadTimeWeaverClass);
                    bppConstructor.setAccessible(true);
                    Object beanPostProcessor = bppConstructor.newInstance(ltw);
                    Class beanPostProcessorClass = shadowingClassLoader.loadClass(BeanPostProcessor.class.getName());
                    Method addBeanPostProcessor = beanFactoryClass.getMethod("addBeanPostProcessor", beanPostProcessorClass);
                    addBeanPostProcessor.invoke(beanFactory, beanPostProcessor);
                    Class genericApplicationContextClass = shadowingClassLoader.loadClass(GenericApplicationContext.class.getName());
                    Class defaultListableBeanFactoryClass = shadowingClassLoader.loadClass(DefaultListableBeanFactory.class.getName());
                    cachedContext = genericApplicationContextClass.getConstructor(defaultListableBeanFactoryClass).newInstance(beanFactory);
                    genericApplicationContextClass.getMethod("refresh", new Class[0]).invoke(cachedContext, new Object[0]);
                    contextCache.put(combinationOfContextLocationsForThisTestClass, cachedContext);
                }
                Class shadowedTestClass = shadowingClassLoader.loadClass(((Object)((Object)this)).getClass().getName());
                TestCase shadowedTestCase = (TestCase)BeanUtils.instantiateClass((Class)shadowedTestClass);
                Class thisShadowedClass = shadowingClassLoader.loadClass(AbstractJpaTests.class.getName());
                Field shadowed = thisShadowedClass.getDeclaredField("shadowParent");
                shadowed.setAccessible(true);
                shadowed.set(shadowedTestCase, (Object)this);
                Class applicationContextClass = shadowingClassLoader.loadClass(ConfigurableApplicationContext.class.getName());
                Method addContextMethod = shadowedTestClass.getMethod("addContext", Object.class, applicationContextClass);
                addContextMethod.invoke((Object)shadowedTestCase, configLocations, cachedContext);
                shadowedTestCase.setName(this.getName());
                shadowedTestCase.runBare();
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
            finally {
                Thread.currentThread().setContextClassLoader(initialClassLoader);
            }
        }
    }

    protected String cacheKeys() {
        return StringUtils.arrayToCommaDelimitedString((Object[])this.getConfigLocations());
    }

    protected ClassLoader createShadowingClassLoader(ClassLoader classLoader) {
        OrmXmlOverridingShadowingClassLoader orxl = new OrmXmlOverridingShadowingClassLoader(classLoader, this.getActualOrmXmlLocation());
        this.customizeResourceOverridingShadowingClassLoader((ClassLoader)((Object)orxl));
        return orxl;
    }

    protected void customizeResourceOverridingShadowingClassLoader(ClassLoader shadowingClassLoader) {
    }

    protected String getActualOrmXmlLocation() {
        return DEFAULT_ORM_XML_LOCATION;
    }

    private static class ShadowingLoadTimeWeaver
    implements LoadTimeWeaver {
        private final ClassLoader shadowingClassLoader;
        private final Class shadowingClassLoaderClass;

        public ShadowingLoadTimeWeaver(ClassLoader shadowingClassLoader) {
            this.shadowingClassLoader = shadowingClassLoader;
            this.shadowingClassLoaderClass = shadowingClassLoader.getClass();
        }

        public ClassLoader getInstrumentableClassLoader() {
            return this.shadowingClassLoader;
        }

        public ClassLoader getThrowawayClassLoader() {
            ResourceOverridingShadowingClassLoader roscl = new ResourceOverridingShadowingClassLoader(this.getClass().getClassLoader());
            if (this.shadowingClassLoader instanceof ResourceOverridingShadowingClassLoader) {
                roscl.copyOverrides((ResourceOverridingShadowingClassLoader)this.shadowingClassLoader);
            }
            if (this.shadowingClassLoader instanceof ShadowingClassLoader) {
                roscl.copyTransformers((ShadowingClassLoader)this.shadowingClassLoader);
            }
            return roscl;
        }

        public void addTransformer(ClassFileTransformer transformer) {
            try {
                Method addClassFileTransformer = this.shadowingClassLoaderClass.getMethod("addTransformer", ClassFileTransformer.class);
                addClassFileTransformer.setAccessible(true);
                addClassFileTransformer.invoke((Object)this.shadowingClassLoader, transformer);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private static class LoadTimeWeaverInjectingBeanPostProcessor
    extends InstantiationAwareBeanPostProcessorAdapter {
        private final LoadTimeWeaver ltw;

        public LoadTimeWeaverInjectingBeanPostProcessor(LoadTimeWeaver ltw) {
            this.ltw = ltw;
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof LocalContainerEntityManagerFactoryBean) {
                ((LocalContainerEntityManagerFactoryBean)bean).setLoadTimeWeaver(this.ltw);
            }
            if (bean instanceof DefaultPersistenceUnitManager) {
                ((DefaultPersistenceUnitManager)bean).setLoadTimeWeaver(this.ltw);
            }
            return bean;
        }
    }
}

